<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('pt_BR', array (
  'validators' => 
  array (
    'This value should be false.' => 'Este valor deve ser falso.',
    'This value should be true.' => 'Este valor deve ser verdadeiro.',
    'This value should be of type {{ type }}.' => 'Este valor deve ser do tipo {{ type }}.',
    'This value should be blank.' => 'Este valor deve ser vazio.',
    'The value you selected is not a valid choice.' => 'O valor selecionado não é uma opção válida.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Você deve selecionar, no mínimo, {{ limit }} opção.|Você deve selecionar, no mínimo, {{ limit }} opções.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Você deve selecionar, no máximo, {{ limit }} opção.|Você deve selecionar, no máximo, {{ limit }} opções.',
    'One or more of the given values is invalid.' => 'Um ou mais valores informados são inválidos.',
    'This field was not expected.' => 'Este campo não era esperado.',
    'This field is missing.' => 'Este campo está ausente.',
    'This value is not a valid date.' => 'Este valor não é uma data válida.',
    'This value is not a valid datetime.' => 'Este valor não é uma data e hora válida.',
    'This value is not a valid email address.' => 'Este valor não é um endereço de e-mail válido.',
    'The file could not be found.' => 'O arquivo não foi encontrado.',
    'The file is not readable.' => 'O arquivo não pode ser lido.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'O arquivo é muito grande ({{ size }} {{ suffix }}). O tamanho máximo permitido é {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'O tipo mime do arquivo é inválido ({{ type }}). Os tipos mime permitidos são {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Este valor deve ser {{ limit }} ou menos.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Este valor é muito longo. Deve ter {{ limit }} caractere ou menos.|Este valor é muito longo. Deve ter {{ limit }} caracteres ou menos.',
    'This value should be {{ limit }} or more.' => 'Este valor deve ser {{ limit }} ou mais.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Este valor é muito curto. Deve ter {{ limit }} caractere ou mais.|Este valor é muito curto. Deve ter {{ limit }} caracteres ou mais.',
    'This value should not be blank.' => 'Este valor não deve ser vazio.',
    'This value should not be null.' => 'Este valor não deve ser nulo.',
    'This value should be null.' => 'Este valor deve ser nulo.',
    'This value is not valid.' => 'Este valor não é válido.',
    'This value is not a valid time.' => 'Este valor não é uma hora válida.',
    'This value is not a valid URL.' => 'Este valor não é uma URL válida.',
    'The two values should be equal.' => 'Os dois valores devem ser iguais.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'O arquivo é muito grande. O tamanho máximo permitido é de {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'O arquivo é muito grande.',
    'The file could not be uploaded.' => 'O arquivo não pode ser enviado.',
    'This value should be a valid number.' => 'Este valor deve ser um número válido.',
    'This file is not a valid image.' => 'Este arquivo não é uma imagem válida.',
    'This is not a valid IP address.' => 'Este valor não é um endereço IP válido.',
    'This value is not a valid language.' => 'Este valor não é um idioma válido.',
    'This value is not a valid locale.' => 'Este valor não é uma localidade válida.',
    'This value is not a valid country.' => 'Este valor não é um país válido.',
    'This value is already used.' => 'Este valor já está sendo usado.',
    'The size of the image could not be detected.' => 'O tamanho da imagem não pode ser detectado.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'A largura da imagem é muito grande ({{ width }}px). A largura máxima permitida é de {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'A largura da imagem é muito pequena ({{ width }}px). A largura mínima esperada é de {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'A altura da imagem é muito grande ({{ height }}px). A altura máxima permitida é de {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'A altura da imagem é muito pequena ({{ height }}px). A altura mínima esperada é de {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Este valor deve ser a senha atual do usuário.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Este valor deve ter exatamente {{ limit }} caractere.|Este valor deve ter exatamente {{ limit }} caracteres.',
    'The file was only partially uploaded.' => 'O arquivo foi enviado apenas parcialmente.',
    'No file was uploaded.' => 'Nenhum arquivo foi enviado.',
    'No temporary folder was configured in php.ini.' => 'Nenhum diretório temporário foi configurado no php.ini, ou o diretório configurado não existe.',
    'Cannot write temporary file to disk.' => 'Não foi possível escrever o arquivo temporário no disco.',
    'A PHP extension caused the upload to fail.' => 'Uma extensão PHP fez com que o envio falhasse.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Esta coleção deve conter {{ limit }} elemento ou mais.|Esta coleção deve conter {{ limit }} elementos ou mais.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Esta coleção deve conter {{ limit }} elemento ou menos.|Esta coleção deve conter {{ limit }} elementos ou menos.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Esta coleção deve conter exatamente {{ limit }} elemento.|Esta coleção deve conter exatamente {{ limit }} elementos.',
    'Invalid card number.' => 'Número de cartão inválido.',
    'Unsupported card type or invalid card number.' => 'Tipo de cartão não suportado ou número de cartão inválido.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Este valor não é um Número de Conta Bancária Internacional (IBAN) válido.',
    'This value is not a valid ISBN-10.' => 'Este valor não é um ISBN-10 válido.',
    'This value is not a valid ISBN-13.' => 'Este valor não é um ISBN-13 válido.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Este valor não é um ISBN-10 e nem um ISBN-13 válido.',
    'This value is not a valid ISSN.' => 'Este valor não é um ISSN válido.',
    'This value is not a valid currency.' => 'Este não é um valor monetário válido.',
    'This value should be equal to {{ compared_value }}.' => 'Este valor deve ser igual a {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Este valor deve ser maior que {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Este valor deve ser maior ou igual a {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor deve ser idêntico a {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Este valor deve ser menor que {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Este valor deve ser menor ou igual a {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Este valor não deve ser igual a {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor não deve ser idêntico a {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'A proporção da imagem é muito grande ({{ ratio }}). A proporção máxima permitida é {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'A proporção da imagem é muito pequena ({{ ratio }}). A proporção mínima esperada é {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'A imagem está num formato quadrado ({{ width }}x{{ height }}px). Imagens com formato quadrado não são permitidas.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'A imagem está orientada à paisagem ({{ width }}x{{ height }}px). Imagens orientadas à paisagem não são permitidas.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'A imagem está orientada ao retrato ({{ width }}x{{ height }}px). Imagens orientadas ao retrato não são permitidas.',
    'An empty file is not allowed.' => 'Arquivo vazio não é permitido.',
    'The host could not be resolved.' => 'O host não pôde ser resolvido.',
    'This value does not match the expected {{ charset }} charset.' => 'Este valor não corresponde ao charset {{ charset }} esperado.',
    'This is not a valid Business Identifier Code (BIC).' => 'Este valor não é um Código de Identificação de Negócios (BIC) válido.',
    'Error' => 'Erro',
    'This is not a valid UUID.' => 'Este valor não é um UUID válido.',
    'This value should be a multiple of {{ compared_value }}.' => 'Este valor deve ser múltiplo de {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Este Código Identificador Bancário (BIC) não está associado ao IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Este valor deve ser um JSON válido.',
    'This collection should contain only unique elements.' => 'Esta coleção deve conter somente elementos únicos.',
    'This value should be positive.' => 'Este valor deve ser positivo.',
    'This value should be either positive or zero.' => 'Este valor deve ser positivo ou zero.',
    'This value should be negative.' => 'Este valor deve ser negativo.',
    'This value should be either negative or zero.' => 'Este valor deve ser negativo ou zero.',
    'This value is not a valid timezone.' => 'Este valor não representa um fuso horário válido.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Esta senha foi divulgada num vazamento de dados e não deve ser utilizada. Por favor, utilize outra senha.',
    'This value should be between {{ min }} and {{ max }}.' => 'Este valor deve estar entre {{ min }} e {{ max }}.',
    'This value is not a valid hostname.' => 'Este valor não é um nome de host válido.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'O número de elementos desta coleção deve ser um múltiplo de {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Este valor deve satisfazer pelo menos uma das seguintes restrições:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Cada elemento desta coleção deve satisfazer seu próprio grupo de restrições.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Este valor não é um Número de Identificação de Títulos Internacionais (ISIN) válido.',
    'This value should be a valid expression.' => 'Este valor deve ser uma expressão válida.',
    'This value is not a valid CSS color.' => 'Este valor não é uma cor CSS válida.',
    'This value is not a valid CIDR notation.' => 'Este valor não é uma notação CIDR válida.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'O valor da máscara de rede deve estar entre {{ min }} e {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'O nome do arquivo é muito longo. Deve ter {{ filename_max_length }} caractere ou menos.|O nome do arquivo é muito longo. Deve ter {{ filename_max_length }} caracteres ou menos.',
    'The password strength is too low. Please use a stronger password.' => 'A força da senha é muito baixa. Por favor, use uma senha mais forte.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'Este valor contém caracteres que não são permitidos pelo nível de restrição atual.',
    'Using invisible characters is not allowed.' => 'O uso de caracteres invisíveis não é permitido.',
    'Mixing numbers from different scripts is not allowed.' => 'Misturar números de scripts diferentes não é permitido.',
    'Using hidden overlay characters is not allowed.' => 'O uso de caracteres de sobreposição ocultos não é permitido.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'A extensão do arquivo é inválida ({{ extension }}). As extensões permitidas são {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'A codificação de caracteres detectada é inválida ({{ detected }}). As codificações permitidas são {{ encodings }}.',
    'This value is not a valid MAC address.' => 'Este valor não é um endereço MAC válido.',
    'This URL is missing a top-level domain.' => 'Esta URL está faltando o domínio de nível superior.',
    'This form should not contain extra fields.' => 'Este formulário não deve conter campos adicionais.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'O arquivo enviado é muito grande. Por favor, tente enviar um arquivo menor.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'O token CSRF é inválido. Por favor, tente reenviar o formulário.',
    'This value is not a valid HTML5 color.' => 'Este valor não é uma cor HTML5 válida.',
    'Please enter a valid birthdate.' => 'Por favor, informe uma data de nascimento válida.',
    'The selected choice is invalid.' => 'A escolha selecionada é inválida.',
    'The collection is invalid.' => 'A coleção é inválida.',
    'Please select a valid color.' => 'Por favor, selecione uma cor válida.',
    'Please select a valid country.' => 'Por favor, selecione um país válido.',
    'Please select a valid currency.' => 'Por favor, selecione uma moeda válida.',
    'Please choose a valid date interval.' => 'Por favor, escolha um intervalo de datas válido.',
    'Please enter a valid date and time.' => 'Por favor, informe uma data e horário válidos.',
    'Please enter a valid date.' => 'Por favor, informe uma data válida.',
    'Please select a valid file.' => 'Por favor, selecione um arquivo válido.',
    'The hidden field is invalid.' => 'O campo oculto é inválido.',
    'Please enter an integer.' => 'Por favor, informe um número inteiro.',
    'Please select a valid language.' => 'Por favor, selecione um idioma válido.',
    'Please select a valid locale.' => 'Por favor, selecione uma configuração de local válida.',
    'Please enter a valid money amount.' => 'Por favor, informe um valor monetário válido.',
    'Please enter a number.' => 'Por favor, informe um número.',
    'The password is invalid.' => 'A senha é inválida.',
    'Please enter a percentage value.' => 'Por favor, informe um valor percentual.',
    'The values do not match.' => 'Os valores não conferem.',
    'Please enter a valid time.' => 'Por favor, informe um horário válido.',
    'Please select a valid timezone.' => 'Por favor, selecione um fuso horário válido.',
    'Please enter a valid URL.' => 'Por favor, informe uma URL válida.',
    'Please enter a valid search term.' => 'Por favor, informe um termo de busca válido.',
    'Please provide a valid phone number.' => 'Por favor, informe um telefone válido.',
    'The checkbox has an invalid value.' => 'A caixa de seleção possui um valor inválido.',
    'Please enter a valid email address.' => 'Por favor, informe um endereço de e-mail válido.',
    'Please select a valid option.' => 'Por favor, selecione uma opção válida.',
    'Please select a valid range.' => 'Por favor, selecione um intervalo válido.',
    'Please enter a valid week.' => 'Por favor, informe uma semana válida.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Uma exceção ocorreu durante a autenticação.',
    'Authentication credentials could not be found.' => 'As credenciais de autenticação não foram encontradas.',
    'Authentication request could not be processed due to a system problem.' => 'A solicitação de autenticação não pôde ser processada devido a um problema no sistema.',
    'Invalid credentials.' => 'Credenciais inválidas.',
    'Cookie has already been used by someone else.' => 'Este cookie já foi usado por outra pessoa.',
    'Not privileged to request the resource.' => 'Sem privilégio para solicitar o recurso.',
    'Invalid CSRF token.' => 'Token CSRF inválido.',
    'No authentication provider found to support the authentication token.' => 'Nenhum provedor de autenticação encontrado para suportar o token de autenticação.',
    'No session available, it either timed out or cookies are not enabled.' => 'Nenhuma sessão disponível, ela expirou ou os cookies não estão habilitados.',
    'No token could be found.' => 'Nenhum token foi encontrado.',
    'Username could not be found.' => 'Nome de usuário não encontrado.',
    'Account has expired.' => 'A conta está expirada.',
    'Credentials have expired.' => 'As credenciais estão expiradas.',
    'Account is disabled.' => 'Conta desativada.',
    'Account is locked.' => 'A conta está travada.',
    'Too many failed login attempts, please try again later.' => 'Muitas tentativas de login malsucedidas, por favor, tente novamente mais tarde.',
    'Invalid or expired login link.' => 'Link de login inválido ou expirado.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Muitas tentativas de login inválidas, por favor, tente novamente em um minuto.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Muitas tentativas de login sem sucesso, por favor, tente novamente em %minutes% minutos.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Anterior',
    'label_next' => 'Próximo',
    'filter_searchword' => 'Procurar...',
  ),
  'messages' => 
  array (
    'Signed in as' => 'Autenticado como',
    'Your Profile' => 'Seu Perfil',
    'Create Ticket' => 'Criar Chamado',
    'Create Agent' => 'Criar Agente',
    'Create Customer' => 'Criar Cliente',
    'Sign Out' => 'Sair',
    'Default Language (Optional)' => 'Idioma Padrão (Opcional)',
    'Username/Email' => 'Usuário/Email',
    'create new' => 'criar novo',
    'Ticket Information' => 'Informações do Chamado',
    'CC/BCC' => 'CC/BCC',
    'Success! Label created successfully.' => 'Sucesso! Etiqueta criada com sucesso.',
    'Success! Label removed successfully.' => 'Sucesso! Etiqueta removida com sucesso.',
    'Reports' => 'Relatórios',
    'Rating' => 'Avaliação',
    'Kudos Rating' => 'Avaliação de Aplausos',
    'Remove profile picture' => 'Remover foto do perfil',
    'Success ! Profile updated successfully.' => 'Sucesso! Perfil atualizado com sucesso.',
    'Howdy' => 'Olá',
    'Form successfully updated.' => 'Formulário atualizado com sucesso.',
    'NEW FORM' => 'NOVO FORMULÁRIO',
    'Text Box' => 'Caixa de Texto',
    'Text Area' => 'Área de Texto',
    'Select' => 'Selecionar',
    'Radio' => 'Botão de Opção',
    'Checkbox' => 'Caixa de Seleção',
    'Date' => 'Data',
    'Both Date and Time' => 'Data e Hora',
    'Choose a status' => 'Escolha um status',
    'Choose a group' => 'Escolha um grupo',
    'Choose your default timeformat' => 'Escolha o formato de hora padrão',
    'Can manage Group\'s Saved Reply' => 'Pode gerenciar Respostas Salvas do Grupo',
    'Can manage agent activity' => 'Pode gerenciar atividade do agente',
    'Slug is the url identity of this article. We will help you to create valid slug at time of typing.' => 'Slug é a identidade da URL deste artigo. Ajudaremos você a criar um slug válido enquanto digita.',
    'The URL for this article' => 'A URL para este artigo',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A page\'s title tag and meta description are usually shown whenever that page appears in search engine results' => 'As tags de título e as meta descrições são trechos de código HTML no cabeçalho de uma página da web. Elas ajudam os motores de busca a entender o conteúdo de uma página. O título e a descrição meta de uma página geralmente são exibidos sempre que essa página aparece nos resultados de pesquisa.',
    'comma separated (,)' => 'separado por vírgulas (,)',
    'Article Title' => 'Título do Artigo',
    'Start typing few charactors and add set of relevant article from the list' => 'Comece a digitar alguns caracteres e adicione um conjunto de artigos relevantes da lista',
    'Success! Announcement data saved successfully.' => 'Sucesso! Dados do anúncio salvos com sucesso.',
    'Success! Category has been added successfully.' => 'Sucesso! Categoria adicionada com sucesso.',
    'Success ! Agent added successfully.' => 'Sucesso! Agente adicionado com sucesso.',
    'Success! Privilege information saved successfully.' => 'Sucesso! Informações de privilégio salvas com sucesso.',
    'Edit Prepared Response' => 'Editar Resposta Preparada',
    'Success! Type removed successfully.' => 'Sucesso! Tipo removido com sucesso.',
    'No results available' => 'Nenhum resultado disponível',
    'Success ! Prepared Response applied successfully.' => 'Sucesso! Resposta Preparada aplicada com sucesso.',
    'Note added to ticket successfully.' => 'Nota adicionada ao chamado com sucesso.',
    'Ticket status update to Spam' => 'Status do chamado atualizado para Spam',
    'Ticket status update to Closed' => 'Status do chamado atualizado para Fechado',
    'Success! Label updated successfully.' => 'Sucesso! Etiqueta atualizada com sucesso.',
    'Success ! Helpdesk details saved successfully' => 'Sucesso! Detalhes do Helpdesk salvos com sucesso',
    'Can manage marketing announcement' => 'Pode gerenciar anúncios de marketing',
    'User Forgot Password' => 'Usuário Esqueceu a Senha',
    'Agent Deleted' => 'Agente Excluído',
    'Agent Update' => 'Atualização do Agente',
    'Customer Update' => 'Atualização do Cliente',
    'Customer Deleted' => 'Cliente Excluído',
    'Agent Updated' => 'Agente Atualizado',
    'Agent Reply' => 'Resposta do Agente',
    'Collaborator Added' => 'Colaborador Adicionado',
    'Collaborator Reply' => 'Resposta do Colaborador',
    'Customer Reply' => 'Resposta do Cliente',
    'Ticket Deleted' => 'Chamado Excluído',
    'Group Updated' => 'Grupo Atualizado',
    'Note Added' => 'Nota Adicionada',
    'Priority Updated' => 'Prioridade Atualizada',
    'Status Updated' => 'Status Atualizado',
    'Team Updated' => 'Equipe Atualizada',
    'Thread Updated' => 'Thread Atualizada',
    'Type Updated' => 'Tipo Atualizado',
    'From Email' => 'Remetente',
    'To Email' => 'Destinatário',
    'Is Equal To' => 'É Igual A',
    'Is Not Equal To' => 'Não É Igual A',
    'Contains' => 'Contém',
    'Does Not Contain' => 'Não Contém',
    'Starts With' => 'Começa Com',
    'Ends With' => 'Termina Com',
    'Before On' => 'Antes Em',
    'After On' => 'Após',
    'Mail To User' => 'Enviar E-mail ao Usuário',
    'Transfer Tickets' => 'Transferir Chamados',
    'Mail To Customer' => 'Enviar E-mail ao Cliente',
    'Permanently delete from Inbox' => 'Excluir permanentemente da Caixa de Entrada',
    'Agent Activity' => 'Atividade do Agente',
    'Report From' => 'Relatório de',
    'Search Agent' => 'Buscar Agente',
    'Agent Last Reply' => 'Última Resposta do Agente',
    'View analytics and insights to serve a better experience for your customers' => 'Visualize análises e insights para oferecer uma melhor experiência aos seus clientes',
    'Marketing Announcement' => 'Anúncio de Marketing',
    'Advertisment' => 'Publicidade',
    'Announcement' => 'Anúncio',
    'New Announcement' => 'Novo Anúncio',
    'Add Announcement' => 'Adicionar Anúncio',
    'Edit Announcement' => 'Editar Anúncio',
    'Promo Text' => 'Texto Promocional',
    'Promo Tag' => 'Etiqueta Promocional',
    'Choose a promo tag' => 'Escolha uma etiqueta promocional',
    'Tag-Color' => 'Cor da Etiqueta',
    'Tag background color' => 'Cor de fundo da Etiqueta',
    'Link Text' => 'Texto do Link',
    'Link URL' => 'URL do Link',
    'Apps' => 'Aplicativos',
    'Integrate apps as per your needs to get things done faster than ever' => 'Instale novos aplicativos personalizados para aumentar sua produtividade - <a href=\'https://store.webkul.com/UVdesk/UVdesk-Open-Source.html\' style=\'font-weight: bold\' target=\'_blank\'>Explore agora</a>',
    'Explore Apps' => 'Explorar Aplicativos',
    'Form Builder' => 'Construtor de Formulários',
    'Knowledgebase' => 'Base de Conhecimento',
    'Knowledgebase is a source of rigid and complex information which helps Customers to help themselves' => 'A Base de Conhecimento é uma fonte de informações úteis que ajuda os clientes a se ajudarem.',
    'Articles' => 'Artigos',
    'Categories' => 'Categorias',
    'Folders' => 'Pastas',
    'FOLDERS' => 'PASTAS',
    'Productivity' => 'Produtividade',
    'Automate your processes by creating set of rules and presets to respond faster to the tickets' => 'Automatize seus processos criando regras e predefinições para responder mais rapidamente aos chamados.',
    'Prepared Responses' => 'Respostas Preparadas',
    'Saved Replies' => 'Respostas Salvas',
    'Edit Saved Reply' => 'Editar Resposta Salva',
    'Ticket Types' => 'Tipos de Chamados',
    'Workflows' => 'Fluxos de Trabalho',
    'Settings' => 'Configurações',
    'Manage your Brand Identity, Company Information and other details at a glance' => 'Gerencie sua Identidade de Marca, Informações da Empresa e outros detalhes facilmente.',
    'Branding' => 'Branding',
    'Custom Fields' => 'Campos Personalizados',
    'Email Settings' => 'Configurações de E-mail',
    'Email Templates' => 'Modelos de E-mail',
    'Mailbox' => 'Caixa de Correio',
    'Spam Settings' => 'Configurações de Spam',
    'Swift Mailer' => 'Swift Mailer',
    'Tags' => 'Etiquetas',
    'Users' => 'Usuários',
    'Control your Groups, Teams, Agents and Customers' => 'Controle seus Grupos, Equipes, Agentes e Clientes',
    'Agents' => 'Agentes',
    'Customers' => 'Clientes',
    'Groups' => 'Grupos',
    'Privileges' => 'Privilégios',
    'Teams' => 'Equipes',
    'Applications' => 'Aplicativos',
    'ECommerce Order Syncronization' => 'Sincronização de Pedidos de eCommerce',
    'Import ecommerce order details to your support tickets from different available platforms' => 'Importe os detalhes dos pedidos de eCommerce para seus chamados de suporte a partir de diferentes plataformas disponíveis.',
    'Search' => 'Buscar',
    'Sort By' => 'Ordenar Por',
    'Sort By:' => 'Ordenar Por:',
    'Status' => 'Status',
    'Created At' => 'Criado Em',
    'Name' => 'Nome',
    'All' => 'Todos',
    'Published' => 'Publicado',
    'Draft' => 'Rascunho',
    'New Folder' => 'Nova Pasta',
    'Create Knowledgebase Folder' => 'Criar Pasta de Base de Conhecimento',
    'You did not add any folder to your Knowledgebase yet, Create your first Folder and start adding Categories/Articles to make your customers help themselves.' => 'Você ainda não adicionou nenhuma pasta à sua Base de Conhecimento. Crie sua primeira pasta e comece a adicionar categorias/artigos para que seus clientes possam se ajudar.',
    'Clear Filters' => 'Limpar Filtros',
    'Back' => 'Voltar',
    'Open' => 'Aberto',
    'Pending' => 'Pendente',
    'Answered' => 'Respondido',
    'Resolved' => 'Resolvido',
    'Closed' => 'Fechado',
    'Spam' => 'Spam',
    'New' => 'Novo',
    'UnAssigned' => 'Não Atribuído',
    'UnAnswered' => 'Não Respondido',
    'My Tickets' => 'Meus Chamados',
    'Starred' => 'Com Estrela',
    'Trashed' => 'Na Lixeira',
    'New Label' => 'Nova Etiqueta',
    'Tickets' => 'Chamados',
    'Ticket Id' => 'ID do Chamado',
    'Last Replied' => 'Última Resposta',
    'Assign To' => 'Atribuir A',
    'After Reply' => 'Após Resposta',
    'Customer Email' => 'E-mail do Cliente',
    'Customer Name' => 'Nome do Cliente',
    'Assets Visibility' => 'Visibilidade dos Recursos',
    'Channel/Source' => 'Canal/Fonte',
    'Channel' => 'Canal',
    'Website' => 'Website',
    'Timestamp' => 'Carimbo de Data/Hora',
    'TimeStamp' => 'Carimbo de Data/Hora',
    'Team' => 'Equipe',
    'Type' => 'Tipo',
    'Replies' => 'Respostas',
    'Agent' => 'Agente',
    'ID' => 'ID',
    'Subject' => 'Assunto',
    'Last Reply' => 'Última Resposta',
    'Filter View' => 'Visualizar Filtros',
    'Please select CAPTCHA' => 'Por favor, selecione o CAPTCHA',
    'Warning ! Please select correct CAPTCHA !' => 'Falha no CAPTCHA, tente novamente',
    'reCAPTCHA Setting' => 'Configuração do reCAPTCHA',
    'reCAPTCHA Site Key' => 'Chave do Site do reCAPTCHA',
    'reCAPTCHA Secret key' => 'Chave Secreta do reCAPTCHA',
    'reCAPTCHA Status' => 'Status do reCAPTCHA',
    'reCAPTCHA is Active' => 'reCAPTCHA está Ativo',
    'Save set of filters as a preset to stay more productive' => 'Salve um conjunto de filtros como predefinição para aumentar sua produtividade.',
    'Saved Filters' => 'Filtros Salvos',
    'No saved filter created' => 'Nenhum filtro salvo criado',
    'Customer' => 'Cliente',
    'Priority' => 'Prioridade',
    'Tag' => 'Etiqueta',
    'Source' => 'Fonte',
    'Before' => 'Antes',
    'After' => 'Depois',
    'Replies less than' => 'Respostas menos que',
    'Replies more than' => 'Respostas mais que',
    'Clear All' => 'Limpar Tudo',
    'Account' => 'Conta',
    'Profile' => 'Perfil',
    'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format' => 'Carregar uma Imagem de Perfil (100px x 100px)<br> em Formato PNG ou JPG',
    'First Name' => 'Nome',
    'Last Name' => 'Sobrenome',
    'Email' => 'Email',
    'Contact Number' => 'Número de Contato',
    'Timezone' => 'Fuso Horário',
    'Africa/Abidjan' => 'Africa/Abidjan',
    'Africa/Accra' => 'Africa/Accra',
    'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
    'Africa/Algiers' => 'Africa/Algiers',
    'Africa/Asmara' => 'Africa/Asmara',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Bangui' => 'Africa/Bangui',
    'Africa/Banjul' => 'Africa/Banjul',
    'Africa/Bissau' => 'Africa/Bissau',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Brazzaville' => 'Africa/Brazzaville',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Cairo' => 'Africa/Cairo',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Africa/Conakry' => 'Africa/Conakry',
    'Africa/Dakar' => 'Africa/Dakar',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Djibouti' => 'Africa/Djibouti',
    'Africa/Douala' => 'Africa/Douala',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Gaborone' => 'Africa/Gaborone',
    'Africa/Harare' => 'Africa/Harare',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Juba' => 'Africa/Juba',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Kigali' => 'Africa/Kigali',
    'Africa/Kinshasa' => 'Africa/Kinshasa',
    'Africa/Lagos' => 'Africa/Lagos',
    'Africa/Libreville' => 'Africa/Libreville',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Luanda' => 'Africa/Luanda',
    'Africa/Lubumbashi' => 'Africa/Lubumbashi',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Malabo' => 'Africa/Malabo',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Ndjamena' => 'Africa/Ndjamena',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Porto-Novo' => 'Africa/Porto-Novo',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'America/Adak' => 'America/Adak',
    'America/Anchorage' => 'America/Anchorage',
    'America/Anguilla' => 'America/Anguilla',
    'America/Antigua' => 'America/Antigua',
    'America/Araguaina' => 'America/Araguaina',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Salta' => 'America/Argentina/Salta',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/San_Luis' => 'America/Argentina/San_Luis',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/Asuncion' => 'America/Asuncion',
    'America/Atikokan' => 'America/Atikokan',
    'America/Bahia' => 'America/Bahia',
    'America/Bahia_Banderas' => 'America/Bahia_Banderas',
    'America/Barbados' => 'America/Barbados',
    'America/Belem' => 'America/Belem',
    'America/Belize' => 'America/Belize',
    'America/Blanc-Sablon' => 'America/Blanc-Sablon',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Bogota' => 'America/Bogota',
    'America/Boise' => 'America/Boise',
    'America/Cambridge_Bay' => 'America/Cambridge_Bay',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cancun' => 'America/Cancun',
    'America/Caracas' => 'America/Caracas',
    'America/Cayenne' => 'America/Cayenne',
    'America/Cayman' => 'America/Cayman',
    'America/Chicago' => 'America/Chicago',
    'America/Chihuahua' => 'America/Chihuahua',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Creston' => 'America/Creston',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Curacao' => 'America/Curacao',
    'America/Danmarkshavn' => 'America/Danmarkshavn',
    'America/Dawson' => 'America/Dawson',
    'America/Dawson_Creek' => 'America/Dawson_Creek',
    'America/Denver' => 'America/Denver',
    'America/Detroit' => 'America/Detroit',
    'America/Dominica' => 'America/Dominica',
    'America/Edmonton' => 'America/Edmonton',
    'America/Eirunepe' => 'America/Eirunepe',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Fort_Nelson' => 'America/Fort_Nelson',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Glace_Bay' => 'America/Glace_Bay',
    'America/Godthab' => 'America/Godthab',
    'America/Goose_Bay' => 'America/Goose_Bay',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Guayaquil' => 'America/Guayaquil',
    'America/Guyana' => 'America/Guyana',
    'America/Halifax' => 'America/Halifax',
    'America/Havana' => 'America/Havana',
    'America/Hermosillo' => 'America/Hermosillo',
    'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
    'America/Indiana/Knox' => 'America/Indiana/Knox',
    'America/Indiana/Marengo' => 'America/Indiana/Marengo',
    'America/Indiana/Petersburg' => 'America/Indiana/Petersburg',
    'America/Indiana/Tell_City' => 'America/Indiana/Tell_City',
    'America/Indiana/Vevay' => 'America/Indiana/Vevay',
    'America/Indiana/Vincennes' => 'America/Indiana/Vincennes',
    'America/Indiana/Winamac' => 'America/Indiana/Winamac',
    'America/Inuvik' => 'America/Inuvik',
    'America/Iqaluit' => 'America/Iqaluit',
    'America/Jamaica' => 'America/Jamaica',
    'America/Juneau' => 'America/Juneau',
    'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
    'America/Kralendijk' => 'America/Kralendijk',
    'America/La_Paz' => 'America/La_Paz',
    'America/Lima' => 'America/Lima',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Lower_Princes' => 'America/Lower_Princes',
    'America/Maceio' => 'America/Maceio',
    'America/Managua' => 'America/Managua',
    'America/Manaus' => 'America/Manaus',
    'America/Marigot' => 'America/Marigot',
    'America/Martinique' => 'America/Martinique',
    'America/Matamoros' => 'America/Matamoros',
    'America/Mazatlan' => 'America/Mazatlan',
    'America/Menominee' => 'America/Menominee',
    'America/Merida' => 'America/Merida',
    'America/Metlakatla' => 'America/Metlakatla',
    'America/Mexico_City' => 'America/Mexico_City',
    'America/Miquelon' => 'America/Miquelon',
    'America/Moncton' => 'America/Moncton',
    'America/Monterrey' => 'America/Monterrey',
    'America/Montevideo' => 'America/Montevideo',
    'America/Montserrat' => 'America/Montserrat',
    'America/Nassau' => 'America/Nassau',
    'America/New_York' => 'America/New_York',
    'America/Nipigon' => 'America/Nipigon',
    'America/Nome' => 'America/Nome',
    'America/Noronha' => 'America/Noronha',
    'America/North_Dakota/Beulah' => 'America/North_Dakota/Beulah',
    'America/North_Dakota' => 'America/North_Dakota',
    'America/Ojinaga' => 'America/Ojinaga',
    'America/Panama' => 'America/Panama',
    'America/Pangnirtung' => 'America/Pangnirtung',
    'America/Paramaribo' => 'America/Paramaribo',
    'America/Phoenix' => 'America/Phoenix',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Port_of_Spain' => 'America/Port_of_Spain',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/Punta_Arenas' => 'America/Punta_Arenas',
    'America/Rainy_River' => 'America/Rainy_River',
    'America/Rankin_Inlet' => 'America/Rankin_Inlet',
    'America/Recife' => 'America/Recife',
    'America/Regina' => 'America/Regina',
    'America/Resolute' => 'America/Resolute',
    'America/Rio_Branco' => 'America/Rio_Branco',
    'America/Santarem' => 'America/Santarem',
    'America/Santiago' => 'America/Santiago',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Scoresbysund' => 'America/Scoresbysund',
    'America/Sitka' => 'America/Sitka',
    'America/St_Barthelemy' => 'America/St_Barthelemy',
    'America/St_Johns' => 'America/St_Johns',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Swift_Current' => 'America/Swift_Current',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Thule' => 'America/Thule',
    'America/Thunder_Bay' => 'America/Thunder_Bay',
    'America/Tijuana' => 'America/Tijuana',
    'America/Toronto' => 'America/Toronto',
    'America/Tortola' => 'America/Tortola',
    'America/Vancouver' => 'America/Vancouver',
    'America/Whitehorse' => 'America/Whitehorse',
    'America/Winnipeg' => 'America/Winnipeg',
    'America/Yakutat' => 'America/Yakutat',
    'America/Yellowknife' => 'America/Yellowknife',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Macquarie' => 'Antarctica/Macquarie',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Troll' => 'Antarctica/Troll',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Arctic/Longyearbyen' => 'Arctic/Longyearbyen',
    'Asia/Aden' => 'Asia/Aden',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Atyrau' => 'Asia/Atyrau',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Barnaul' => 'Asia/Barnaul',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Chita' => 'Asia/Chita',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Famagusta' => 'Asia/Famagusta',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Hebron' => 'Asia/Hebron',
    'Asia/Ho_Chi_Minh' => 'Asia/Ho_Chi_Minh',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Jerusalem' => 'Asia/Jerusalem',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Kathmandu' => 'Asia/Kathmandu',
    'Asia/Khandyga' => 'Asia/Khandyga',
    'Asia/Kolkata' => 'Asia/Kolkata',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Novokuznetsk' => 'Asia/Novokuznetsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Qostanay' => 'Asia/Qostanay',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Srednekolymsk' => 'Asia/Srednekolymsk',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Tomsk' => 'Asia/Tomsk',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Ust-Nera' => 'Asia/Ust-Nera',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Yangon' => 'Asia/Yangon',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Atlantic/Faroe' => 'Atlantic/Faroe',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Eucla' => 'Australia/Eucla',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Lord_Howe' => 'Australia/Lord_Howe',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Sydney' => 'Australia/Sydney',
    'Europe/Amsterdam' => 'Europe/Amsterdam',
    'Europe/Andorra' => 'Europe/Andorra',
    'Europe/Astrakhan' => 'Europe/Astrakhan',
    'Europe/Athens' => 'Europe/Athens',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Berlin' => 'Europe/Berlin',
    'Europe/Bratislava' => 'Europe/Bratislava',
    'Europe/Brussels' => 'Europe/Brussels',
    'Europe/Bucharest' => 'Europe/Bucharest',
    'Europe/Budapest' => 'Europe/Budapest',
    'Europe/Busingen' => 'Europe/Busingen',
    'Europe/Chisinau' => 'Europe/Chisinau',
    'Europe/Copenhagen' => 'Europe/Copenhagen',
    'Europe/Dublin' => 'Europe/Dublin',
    'Europe/Gibraltar' => 'Europe/Gibraltar',
    'Europe/Guernsey' => 'Europe/Guernsey',
    'Europe/Helsinki' => 'Europe/Helsinki',
    'Europe/Isle_of_Man' => 'Europe/Isle_of_Man',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Jersey' => 'Europe/Jersey',
    'Europe/Kaliningrad' => 'Europe/Kaliningrad',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Kirov' => 'Europe/Kirov',
    'Europe/Lisbon' => 'Europe/Lisbon',
    'Europe/Ljubljana' => 'Europe/Ljubljana',
    'Europe/London' => 'Europe/London',
    'Europe/Luxembourg' => 'Europe/Luxembourg',
    'Europe/Madrid' => 'Europe/Madrid',
    'Europe/Malta' => 'Europe/Malta',
    'Europe/Mariehamn' => 'Europe/Mariehamn',
    'Europe/Minsk' => 'Europe/Minsk',
    'Europe/Monaco' => 'Europe/Monaco',
    'Europe/Moscow' => 'Europe/Moscow',
    'Europe/Oslo' => 'Europe/Oslo',
    'Europe/Paris' => 'Europe/Paris',
    'Europe/Podgorica' => 'Europe/Podgorica',
    'Europe/Prague' => 'Europe/Prague',
    'Europe/Riga' => 'Europe/Riga',
    'Europe/Rome' => 'Europe/Rome',
    'Europe/Samara' => 'Europe/Samara',
    'Europe/San_Marino' => 'Europe/San_Marino',
    'Europe/Sarajevo' => 'Europe/Sarajevo',
    'Europe/Saratov' => 'Europe/Saratov',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'Europe/Skopje' => 'Europe/Skopje',
    'Europe/Sofia' => 'Europe/Sofia',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Tallinn' => 'Europe/Tallinn',
    'Europe/Tirane' => 'Europe/Tirane',
    'Europe/Ulyanovsk' => 'Europe/Ulyanovsk',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Vaduz' => 'Europe/Vaduz',
    'Europe/Vatican' => 'Europe/Vatican',
    'Europe/Vienna' => 'Europe/Vienna',
    'Europe/Vilnius' => 'Europe/Vilnius',
    'Europe/Volgograd' => 'Europe/Volgograd',
    'Europe/Warsaw' => 'Europe/Warsaw',
    'Europe/Zagreb' => 'Europe/Zagreb',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Zurich' => 'Europe/Zurich',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Indian/Chagos' => 'Indian/Chagos',
    'Indian/Christmas' => 'Indian/Christmas',
    'Indian/Cocos' => 'Indian/Cocos',
    'Indian/Comoro' => 'Indian/Comoro',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Indian/Mahe' => 'Indian/Mahe',
    'Indian/Maldives' => 'Indian/Maldives',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Indian/Reunion' => 'Indian/Reunion',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Bougainville' => 'Pacific/Bougainville',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Chuuk' => 'Pacific/Chuuk',
    'Pacific/Easter' => 'Pacific/Easter',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pohnpei' => 'Pacific/Pohnpei',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'UTC' => 'UTC',
    'Time Format' => 'Formato de Hora',
    'Choose your default timezone' => 'Escolha seu fuso horário padrão',
    'Signature' => 'Assinatura',
    'User signature will be append at the bottom of ticket reply box' => 'Sua assinatura será adicionada ao final de cada resposta de chamado que você criar.',
    'Password' => 'Senha',
    'Password will remain same if you are not entering something in this field' => 'Senha não alterada!',
    'Confirm Password' => 'Confirmar Senha',
    'Password must contain minimum 8 character length, at least two letters (not case sensitive), one number, one special character(space is not allowed).' => 'A senha deve ter no mínimo 8 caracteres, incluir pelo menos duas letras (não diferencia maiúsculas de minúsculas), um número e um caractere especial (espaços não são permitidos).',
    'Save Changes' => 'Salvar Alterações',
    'SAVE CHANGES' => 'SALVAR ALTERAÇÕES',
    'CREATE TICKET' => 'CRIAR CHAMADO',
    'Customer full name' => 'Nome completo do cliente',
    'Customer email address' => 'Endereço de e-mail do cliente',
    'Select Type' => 'Selecionar Tipo',
    'Support' => 'Suporte',
    'Choose ticket type' => 'Escolha o tipo de chamado',
    'Ticket subject' => 'Assunto do chamado',
    'Message' => 'Mensagem',
    'Query Message' => 'Mensagem de Consulta',
    'Add Attachment' => 'Adicionar Anexo',
    'This field is mandatory' => 'Este campo é obrigatório',
    'General' => 'Geral',
    'Designation' => 'Cargo',
    'Contant Number' => 'Número de Contato',
    'User signature will be append in the bottom of ticket reply box' => 'Sua assinatura será adicionada ao final de cada resposta de chamado que você criar.',
    'Account Status' => 'Status da Conta',
    'Account is Active' => 'Conta está Ativa',
    'Assigning group(s) to user to view tickets regardless assignment.' => 'Adicione o usuário a um grupo para visualizar chamados independentemente do proprietário.',
    'Default' => 'Padrão',
    'Select All' => 'Selecionar Todos',
    'Remove All' => 'Remover Todos',
    'Assigning team(s) to user to view tickets regardless assignment.' => 'Adicione o usuário a uma equipe para visualizar chamados independentemente do proprietário.',
    'No Team added !' => 'Nenhuma equipe adicionada!',
    'Permission' => 'Permissão',
    'Role' => 'Função',
    'Administrator' => 'Administrador',
    'Select agent role' => 'Selecionar função do agente',
    'Add Customer' => 'Adicionar Cliente',
    'Action' => 'Ação',
    'Account Owner' => 'Proprietário da Conta',
    'Active' => 'Ativo',
    'Edit' => 'Editar',
    'Delete' => 'Excluir',
    'Disabled' => 'Desativado',
    'New Group' => 'Novo Grupo',
    'Default Privileges' => 'Privilégios Padrão',
    'New Privileges' => 'Novos Privilégios',
    'NEW PRIVILEGE' => 'NOVO PRIVILÉGIO',
    'New Privilege' => 'Novo Privilégio',
    'New Team' => 'Nova Equipe',
    'No Record Found' => 'Nenhum Registro Encontrado',
    'Order Synchronization' => 'Sincronização de Pedidos',
    'Easily integrate different ecommerce platforms with your helpdesk which can then be later used to swiftly integrate ecommerce order details with your support tickets.' => 'Integre facilmente diferentes plataformas de eCommerce ao seu helpdesk para exibir os detalhes dos pedidos nos chamados de suporte.',
    'BigCommerce' => 'BigCommerce',
    'No channels have been added.' => 'Nenhum canal foi adicionado.',
    'Add BigCommerce Store' => 'Adicionar Loja BigCommerce',
    'ADD BIGCOMMERCE STORE' => 'ADICIONAR LOJA BIGCOMMERCE',
    'Mangento' => 'Magento',
    'Add Magento Store' => 'Adicionar Loja Magento',
    'OpenCart' => 'OpenCart',
    'Add OpenCart Store' => 'Adicionar Loja OpenCart',
    'ADD OPENCART STORE' => 'ADICIONAR LOJA OPENCART',
    'Shopify' => 'Shopify',
    'Add Shopify Store' => 'Adicionar Loja Shopify',
    'ADD SHOPIFY STORE' => 'ADICIONAR LOJA SHOPIFY',
    'Integrate a new BigCommerce store' => 'Integrar uma nova loja BigCommerce',
    'Your BigCommerce Store Name' => 'Nome da sua Loja BigCommerce',
    'Your BigCommerce Store Hash' => 'Hash da sua Loja BigCommerce',
    'Your BigCommerce Api Token' => 'Token API da sua Loja BigCommerce',
    'Your BigCommerce Api Client ID' => 'ID do Cliente API da sua Loja BigCommerce',
    'Enable Channel' => 'Ativar Canal',
    'Add Store' => 'Adicionar Loja',
    'ADD STORE' => 'ADICIONAR LOJA',
    'Integrate a new Magento store' => 'Integrar uma nova loja Magento',
    'Your Magento Api Username' => 'Nome de usuário API da sua Loja Magento',
    'Your Magento Api Password' => 'Senha API da sua Loja Magento',
    'Integrate a new OpenCart store' => 'Integrar uma nova loja OpenCart',
    'Your OpenCart Api Key' => 'Chave API da sua Loja OpenCart',
    'Your Shopify Store Name' => 'Nome da sua Loja Shopify',
    'Your Shopify Api Key' => 'Chave API da sua Loja Shopify',
    'Your Shopify Api Password' => 'Senha API da sua Loja Shopify',
    'Easily embed custom form to help generate helpdesk tickets.' => 'Incorpore formulários personalizados facilmente para criar chamados no helpdesk.',
    'Form-Builder' => 'Construtor de Formulários',
    'Add Formbuilder' => 'Adicionar Construtor de Formulários',
    'ADD FORMBUILDER' => 'ADICIONAR CONSTRUTOR DE FORMULÁRIOS',
    'No FormBuilder have been added.' => 'Nenhum Construtor de Formulários foi adicionado.',
    'Create a New Custom Form Below' => 'Crie um novo formulário personalizado abaixo',
    'Form Name' => 'Nome do Formulário',
    'It will be shown in the list of created forms' => 'Será exibido na lista de formulários criados',
    'MANDATORY FIELDS' => 'CAMPOS OBRIGATÓRIOS',
    'These fields will be visible in form and cant be edited' => 'Esses campos serão visíveis no formulário e não podem ser editados',
    'Reply' => 'Resposta',
    'OPTIONAL FIELDS' => 'CAMPOS OPCIONAIS',
    'Select These Fields to Add in your Form' => 'Selecione campos para adicionar',
    'GDPR' => 'GDPR',
    'Order' => 'Pedido',
    'Categorybuilder' => 'Construtor de Categorias',
    'File' => 'Arquivo',
    'Add Form' => 'Adicionar Formulário',
    'ADD FORM' => 'ADICIONAR FORMULÁRIO',
    'UPDATE FORM' => 'ATUALIZAR FORMULÁRIO',
    'Update Form' => 'Atualizar Formulário',
    'Embed' => 'Incorporar',
    'EMBED' => 'INCORPORAR',
    'EMBED FORMBUILDER' => 'INCORPORAR CONSTRUTOR DE FORMULÁRIOS',
    'Embed Formbuilder' => 'Incorporar Construtor de Formulários',
    'Visit' => 'Visitar',
    'VISIT' => 'VISITAR',
    'Code' => 'Código',
    'Total Ticket(s)' => 'Total de Chamados',
    'Ticket Count' => 'Quantidade de Chamados',
    'SwiftMailer Configurations' => 'Configurações do SwiftMailer',
    'No swiftmailer configurations found' => 'Nenhuma configuração do SwiftMailer encontrada',
    'CREATE CONFIGURATION' => 'CRIAR CONFIGURAÇÃO',
    'Add configuration' => 'Adicionar configuração',
    'Update configuration' => 'Atualizar configuração',
    'Mailer ID' => 'ID do Mailer',
    'Mailer ID - Leave blank to automatically create id' => 'ID do Mailer - Deixe em branco para criar automaticamente',
    'Transport Type' => 'Tipo de Transporte',
    'SMTP' => 'SMTP',
    'Enable Delivery' => 'Ativar Entrega',
    'Server' => 'Servidor',
    'Port' => 'Porta',
    'Encryption Mode' => 'Modo de Criptografia',
    'ssl' => 'ssl',
    'tsl' => 'tsl',
    'None' => 'Nenhum',
    'Authentication Mode' => 'Modo de Autenticação',
    'login' => 'login',
    'Plain' => 'Simples',
    'CRAM-MD5' => 'CRAM-MD5',
    'Sender Address' => 'Endereço do Remetente',
    'Delivery Address' => 'Endereço de Entrega',
    'Block Spam' => 'Bloquear Spam',
    'Black list' => 'Lista Negra',
    'Comma (,) separated values (Eg. support@example.com, @example.com, 68.98.31.226)' => 'Valores separados por vírgula (Ex.: suporte@exemplo.com, @exemplo.com, 68.98.31.226)',
    'White list' => 'Lista Branca',
    'Mailbox Settings' => 'Configurações da Caixa de Correio',
    'No mailbox configurations found' => 'Nenhuma configuração de caixa de correio encontrada',
    'NEW MAILBOX' => 'NOVA CAIXA DE CORREIO',
    'New Mailbox' => 'Nova Caixa de Correio',
    'Update Mailbox' => 'Atualizar Caixa de Correio',
    'Add Mailbox' => 'Adicionar Caixa de Correio',
    'Mailbox ID - Leave blank to automatically create id' => 'ID da Caixa de Correio - Deixe em branco para criar automaticamente',
    'Mailbox Name' => 'Nome da Caixa de Correio',
    'Enable Mailbox' => 'Ativar Caixa de Correio',
    'Incoming Mail (IMAP) Server' => 'Servidor de Entrada (IMAP)',
    'Configure your imap settings which will be used to fetch emails from your mailbox.' => 'Configure as definições do IMAP para buscar e-mails da sua caixa de correio.',
    'Transport' => 'Transporte',
    'IMAP' => 'IMAP',
    'Gmail' => 'Gmail',
    'Yahoo' => 'Yahoo',
    'Host' => 'Host',
    'IMAP Host' => 'Host IMAP',
    'Email address' => 'Endereço de E-mail',
    'Associated Password' => 'Senha Associada',
    'Outgoing Mail (SMTP) Server' => 'Servidor de Saída (SMTP)',
    'Select a valid Swift Mailer configuration which will be used to send emails through your mailbox.' => 'Selecione uma configuração SwiftMailer válida para enviar e-mails através da sua caixa de correio.',
    'Swift Mailer ID' => 'ID do Swift Mailer',
    'None Selected' => 'Nenhum Selecionado',
    'Create Mailbox' => 'Criar Caixa de Correio',
    'CREATE MAILBOX' => 'CRIAR CAIXA DE CORREIO',
    'New Template' => 'Novo Template',
    'NEW TEMPLATE' => 'NOVO TEMPLATE',
    'Customer Forgot Password' => 'Cliente Esqueceu a Senha',
    'Customer Account Created' => 'Conta do Cliente Criada',
    'Ticket generated success mail to customer' => 'Chamado gerado com sucesso enviado ao cliente',
    'Customer Reply To The Agent' => 'Resposta do Cliente ao Agente',
    'Ticket Assign' => 'Atribuição de Chamado',
    'Agent Forgot Password' => 'Agente Esqueceu a Senha',
    'Agent Account Created' => 'Conta do Agente Criada',
    'Ticket generated by customer' => 'Chamado gerado pelo cliente',
    'Agent Reply To The Customers ticket' => 'Resposta do Agente ao Chamado do Cliente',
    'Email template name' => 'Nome do Template de E-mail',
    'Email template subject' => 'Assunto do Template de E-mail',
    'Template For' => 'Template Para',
    'Nothing Selected' => 'Nada Selecionado',
    'email template will be used for work related with selected option' => 'o template de e-mail será usado para o trabalho relacionado à opção selecionada',
    'Email template body' => 'Corpo do Template de E-mail',
    'Body' => 'Corpo',
    'placeholders' => 'marcadores',
    'Ticket Subject' => 'Assunto do Chamado',
    'Ticket Message' => 'Mensagem do Chamado',
    'Ticket Attachments' => 'Anexos do Chamado',
    'Ticket Tags' => 'Tags do Chamado',
    'Ticket Source' => 'Fonte do Chamado',
    'Ticket Status' => 'Status do Chamado',
    'Ticket Priority' => 'Prioridade do Chamado',
    'Ticket Group' => 'Grupo do Chamado',
    'Ticket Team' => 'Equipe do Chamado',
    'Ticket Thread Message' => 'Mensagem do Fio do Chamado',
    'Ticket Customer Name' => 'Nome do Cliente do Chamado',
    'Ticket Customer Email' => 'E-mail do Cliente do Chamado',
    'Ticket Agent Name' => 'Nome do Agente do Chamado',
    'Ticket Agent Email' => 'E-mail do Agente do Chamado',
    'Ticket Agent Link' => 'Link do Agente do Chamado',
    'Ticket Customer Link' => 'Link do Cliente do Chamado',
    'Last Collaborator Name' => 'Nome do Último Colaborador',
    'Last Collaborator Email' => 'E-mail do Último Colaborador',
    'Agent/ Customer Name' => 'Nome do Agente/Cliente',
    'Account Validation Link' => 'Link de Validação da Conta',
    'Password Forgot Link' => 'Link de Recuperação de Senha',
    'Company Name' => 'Nome da Empresa',
    'Company Logo' => 'Logo da Empresa',
    'Company URL' => 'URL da Empresa',
    'Swiftmailer id (Select from drop down)' => 'ID do SwiftMailer (Selecione da lista)',
    'PROCEED' => 'CONTINUAR',
    'Proceed' => 'Continuar',
    'Theme Color' => 'Cor do Tema',
    'Customer Created' => 'Cliente Criado',
    'Agent Created' => 'Agente Criado',
    'Ticket Created' => 'Chamado Criado',
    'Agent Replied on Ticket' => 'Agente Respondeu ao Chamado',
    'Customer Replied on Ticket' => 'Cliente Respondeu ao Chamado',
    'Workflow Status' => 'Status do Fluxo de Trabalho',
    'Workflow is Active' => 'O Fluxo de Trabalho está Ativo',
    'Events' => 'Eventos',
    'An event automatically triggers to check conditions and perform a respective pre-defined set of actions' => 'Um evento é disparado automaticamente para verificar condições e executar um conjunto de ações predefinidas',
    'Select an Event' => 'Selecione um Evento',
    'Add More' => 'Adicionar Mais',
    'Conditions' => 'Condições',
    'Conditions are set of rules which checks for specific scenarios and are triggered on specific occasions' => 'Condições são um conjunto de regras que verificam cenários específicos e são acionadas em ocasiões específicas.',
    'Subject or Description' => 'Assunto ou descrição',
    'Actions' => 'Ações',
    'An action not only reduces the workload but also makes it quite easier for ticket automation' => 'Uma ação não apenas reduz a carga de trabalho, mas também facilita a automação de tickets.',
    'Select an Action' => 'Selecionar uma ação',
    'Add Note' => 'Adicionar nota',
    'Mail to agent' => 'Enviar e-mail para agente',
    'Mail to customer' => 'Enviar e-mail para cliente',
    'Mail to group' => 'Enviar e-mail para grupo',
    'Mail to last collaborator' => 'Enviar e-mail para o último colaborador',
    'Mail to team' => 'Enviar e-mail para equipe',
    'Mark Spam' => 'Marcar como spam',
    'Assign to agent' => 'Atribuir a agente',
    'Assign to group' => 'Atribuir a grupo',
    'Set Priority As' => 'Definir prioridade como',
    'Set Status As' => 'Definir status como',
    'Set Tag As' => 'Definir tag como',
    'Set Label As' => 'Definir rótulo como',
    'Assign to team' => 'Atribuir a equipe',
    'Set Type As' => 'Definir tipo como',
    'Add Workflow' => 'Adicionar fluxo de trabalho',
    'ADD WORKFLOW' => 'ADICIONAR FLUXO DE TRABALHO',
    'Ticket Type code' => 'Código do tipo de ticket',
    'Ticket Type description' => 'Descrição do tipo de ticket',
    'Type Status' => 'Status do tipo',
    'Type is Active' => 'Tipo está ativo',
    'Add Save Reply' => 'Adicionar resposta salva',
    'Saved reply name' => 'Nome da resposta salva',
    'Share saved reply with user(s) in these group(s)' => 'Compartilhar resposta salva com usuário(s) destes grupo(s)',
    'Share saved reply with user(s) in these teams(s)' => 'Compartilhar resposta salva com usuário(s) destas equipes(s)',
    'Saved reply Body' => 'Corpo da resposta salva',
    'New Prepared Response' => 'Nova resposta preparada',
    'Prepared Response Status' => 'Status da resposta preparada',
    'Prepared Response is Active' => 'Resposta preparada está ativa',
    'Share prepared response with user(s) in these group(s)' => 'Compartilhar resposta preparada com usuário(s) destes grupo(s)',
    'Share prepared response with user(s) in these teams(s)' => 'Compartilhar resposta preparada com usuário(s) destas equipes(s)',
    'ADD PREPARED RESPONSE' => 'ADICIONAR RESPOSTA PREPARADA',
    'Add Prepared Response' => 'Adicionar resposta preparada',
    'Folder Name is shown upfront at Knowledge Base' => 'O nome da pasta aparece na base de conhecimento',
    'A small text about the folder helps user to navigate more easily' => 'Um texto breve sobre a pasta ajuda o usuário a navegar mais facilmente.',
    'Publish' => 'Publicar',
    'Choose appropriate status' => 'Escolha o status apropriado',
    'Folder Image' => 'Imagem da pasta',
    'An image is worth a thousands words and makes folder more accessible' => 'Uma imagem vale mais que mil palavras e torna a pasta mais acessível.',
    'Add Category' => 'Adicionar categoria',
    'Category Name is shown upfront at Knowledge Base' => 'O nome da categoria aparece na base de conhecimento',
    'A small text about the category helps user to navigate more easily' => 'Um texto breve sobre a categoria ajuda o usuário a navegar mais facilmente.',
    'Using Category Order, you can decide which category should display first' => 'Com a ordem da categoria, você pode decidir qual categoria deve ser exibida primeiro.',
    'Sorting' => 'Ordenação',
    'Ascending Order (A-Z)' => 'Ordem ascendente (A-Z)',
    'Descending Order (Z-A)' => 'Ordem descendente (Z-A)',
    'Based on Popularity' => 'Com base na popularidade',
    'Article of this category will display according to selected option' => 'Artigos desta categoria serão exibidos de acordo com a opção selecionada.',
    'Article' => 'Artigo',
    'Title' => 'Título',
    'View' => 'Visualizar',
    'Make as Starred' => 'Marcar como destacado',
    'Yes' => 'Sim',
    'No' => 'Não',
    'Stared' => 'Destacado',
    'Revisions' => 'Revisões',
    'Related Articles' => 'Artigos relacionados',
    'Delete Article' => 'Excluir artigo',
    'Content' => 'Conteúdo',
    'Slug' => 'Slug',
    'Slug is the url identity of this article.' => 'Slug é a identidade da URL deste artigo.',
    'Meta Title' => 'Título Meta',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'As tags de título e as descrições meta são pedaços de código HTML no cabeçalho de uma página web. Elas ajudam os motores de busca a entender o conteúdo de uma página. O título e a descrição meta geralmente aparecem nos resultados de busca.',
    'Meta Keywords' => 'Palavras-chave Meta',
    'Meta Description' => 'Descrição Meta',
    'Description' => 'Descrição',
    'Team Status' => 'Status da equipe',
    'Team is Active' => 'Equipe está ativa',
    'Edit Privilege' => 'Editar privilégio',
    'Can create ticket' => 'Pode criar ticket',
    'Can edit ticket' => 'Pode editar ticket',
    'Can delete ticket' => 'Pode excluir ticket',
    'Can restore trashed ticket' => 'Pode restaurar ticket excluído',
    'Can assign ticket' => 'Pode atribuir ticket',
    'Can assign ticket group' => 'Pode atribuir grupo de ticket',
    'Can update ticket status' => 'Pode atualizar status do ticket',
    'Can update ticket priority' => 'Pode atualizar a prioridade do ticket',
    'Can update ticket type' => 'Pode atualizar o tipo de ticket',
    'Can add internal notes to ticket' => 'Pode adicionar notas internas ao ticket',
    'Can edit thread/notes' => 'Pode editar threads/notas',
    'Can lock/unlock thread' => 'Pode bloquear/desbloquear threads',
    'Can add collaborator to ticket' => 'Pode adicionar colaboradores ao ticket',
    'Can delete collaborator from ticket' => 'Pode remover colaboradores do ticket',
    'Can delete thread/notes' => 'Pode excluir threads/notas',
    'Can apply prepared response on ticket' => 'Pode aplicar respostas prontas ao ticket',
    'Can add ticket tags' => 'Pode adicionar tags ao ticket',
    'Can delete ticket tags' => 'Pode remover tags do ticket',
    'Can kick other ticket users' => 'Pode remover outros usuários do ticket',
    'Can manage email templates' => 'Pode gerenciar modelos de e-mail',
    'Can manage groups' => 'Pode gerenciar grupos',
    'Can manage Sub-Groups/ Teams' => 'Pode gerenciar subgrupos/equipes',
    'Can manage agents' => 'Pode gerenciar agentes',
    'Can manage agent privileges' => 'Pode gerenciar privilégios de agentes',
    'Can manage ticket types' => 'Pode gerenciar tipos de tickets',
    'Can manage ticket custom fields' => 'Pode gerenciar campos personalizados de tickets',
    'Can manage customers' => 'Pode gerenciar clientes',
    'Can manage Prepared Responses' => 'Pode gerenciar respostas prontas',
    'Can manage Automatic workflow' => 'Pode gerenciar fluxos de trabalho automáticos',
    'Can manage tags' => 'Pode gerenciar tags',
    'Can manage knowledgebase' => 'Pode gerenciar a base de conhecimento',
    'Can manage Groups Saved Reply' => 'Pode gerenciar respostas salvas em grupos',
    'Add Privilege' => 'Adicionar privilégio',
    'Choose set of privileges which will be available to the agent.' => 'Escolha os privilégios disponíveis para o agente.',
    'Advanced' => 'Avançado',
    'Privilege Name must have characters only' => 'O nome do privilégio deve conter apenas caracteres',
    'Maximum character length is 50' => 'O comprimento máximo de caracteres é 50',
    'Open Tickets' => 'Tickets abertos',
    'New Customer' => 'Novo cliente',
    'New Agent' => 'Novo agente',
    'Total Article(s)' => 'Total de artigos',
    'Please specify a valid email address' => 'Por favor, informe um endereço de e-mail válido',
    'Please enter the password associated with your email address' => 'Insira a senha associada ao seu endereço de e-mail',
    'Please enter your server host address' => 'Insira o endereço do host do seu servidor',
    'Please specify a port number to connect with your mail server' => 'Informe o número da porta para conectar ao seu servidor de e-mail',
    'Success ! Branding details saved successfully.' => 'Sucesso! Detalhes de marca salvos com sucesso.',
    'Success ! Time details saved successfully.' => 'Sucesso! Detalhes de tempo salvos com sucesso.',
    'Spam setting saved successfully.' => 'Configuração de spam salva com sucesso.',
    'Please specify a valid name for your mailbox.' => 'Informe um nome válido para sua caixa de entrada.',
    'Please select a valid swift-mailer configuration.' => 'Selecione uma configuração swift-mailer válida.',
    'Please specify a valid host address.' => 'Informe um endereço de host válido.',
    'Please specify a valid email address.' => 'Informe um endereço de e-mail válido.',
    'Please enter the associated account password.' => 'Insira a senha da conta associada.',
    'New Saved Reply' => 'Nova resposta salva',
    'New Category' => 'Nova categoria',
    'Folder' => 'Pasta',
    'Category' => 'Categoria',
    'Created' => 'Criado',
    'All Articles' => 'Todos os artigos',
    'Viewed' => 'Visualizado',
    'New Article' => 'Novo artigo',
    'Thank you for your feedback!' => 'Obrigado pelo seu feedback!',
    'Was this article helpful?' => 'Este artigo foi útil?',
    'Helpdesk' => 'Central de ajuda',
    'Support Center' => 'Centro de suporte',
    'Mailboxes' => 'Caixas de entrada',
    'By' => 'Por',
    'Search Tickets' => 'Buscar tickets',
    'Customer Information' => 'Informações do cliente',
    'Total Replies' => 'Total de respostas',
    'Filter With' => 'Filtrar com',
    'Type email to add' => 'Digite o e-mail para adicionar',
    'Collaborators' => 'Colaboradores',
    'Labels' => 'Rótulos',
    'Group' => 'Grupo',
    'group' => 'grupo',
    'Contact Team' => 'Equipe de contato',
    'Stay on ticket' => 'Permanecer no ticket',
    'Redirect to list' => 'Redirecionar para a lista',
    'Nothing interesting here...' => 'Nada de interessante aqui...',
    'Previous Ticket' => 'Ticket anterior',
    'Next Ticket' => 'Próximo ticket',
    'Forward' => 'Encaminhar',
    'Note' => 'Nota',
    'Write a reply' => 'Escrever uma resposta',
    'Created Ticket' => 'Ticket criado',
    'All Threads' => 'Todos os tópicos',
    'Forwards' => 'Encaminhamentos',
    'Notes' => 'Notas',
    'Pinned' => 'Fixado',
    'Edit Ticket' => 'Editar ticket',
    'Print Ticket' => 'Imprimir ticket',
    'Mark as Spam' => 'Marcar como spam',
    'Mark as Closed' => 'Marcar como fechado',
    'Delete Ticket' => 'Excluir ticket',
    'View order details from different eCommerce channels' => 'Visualizar detalhes de pedidos de diferentes canais de e-commerce',
    'ECOMMERCE CHANNELS' => 'CANAIS DE E-COMMERCE',
    'Select channel' => 'Selecionar canal',
    'Order Id' => 'ID do pedido',
    'Fetch Order' => 'Buscar pedido',
    'No orders have been integrated to this ticket yet.' => 'Nenhum pedido foi associado a este ticket ainda.',
    'Enter your credentials below to gain access to your helpdesk account.' => 'Insira suas credenciais abaixo para acessar sua conta da central de ajuda.',
    'Keep me logged in' => 'Manter-me conectado',
    'Forgot Password?' => 'Esqueceu a senha?',
    'Log in to your' => 'Faça login no seu',
    'Sign In' => 'Entrar',
    'Edit Customer' => 'Editar cliente',
    'Update' => 'Atualizar',
    'Discard' => 'Descartar',
    'Cancel' => 'Cancelar',
    'Not Assigned' => 'Não atribuído',
    'Submit' => 'Enviar',
    'Submit And Open' => 'Enviar e abrir',
    'Submit And Pending' => 'Enviar e pendente',
    'Submit And Answered' => 'Enviar e respondido',
    'Submit And Resolved' => 'Enviar e resolvido',
    'Submit And Closed' => 'Enviar e fechado',
    'Choose a Color' => 'Escolha uma cor',
    'Create' => 'Criar',
    'Edit Label' => 'Editar rótulo',
    'Add Label' => 'Adicionar rótulo',
    'To' => 'Para',
    'Ticket' => 'Ticket',
    'Your browser does not support JavaScript or You disabled JavaScript, Please enable those !' => 'Seu navegador não suporta JavaScript ou você desativou o JavaScript. Por favor, ative!',
    'Confirm Action' => 'Confirmar ação',
    'Confirm' => 'Confirmar',
    'No result found' => 'Nenhum resultado encontrado',
    'ticket delivery status' => 'status de entrega do ticket',
    'Warning! Select valid image file.' => 'Aviso! Selecione um arquivo de imagem válido.',
    'Error' => 'Erro',
    'Save' => 'Salvar',
    'SEO' => 'SEO',
    'Edit Saved Filter' => 'Editar Filtro Salvo',
    'Type atleast 2 letters' => 'Digite pelo menos 2 letras',
    'Remove Label' => 'Remover Rótulo',
    'New Saved Filter' => 'Novo Filtro Salvo',
    'Is Default' => 'É Padrão',
    'Remove Saved Filter' => 'Remover Filtro Salvo',
    'Ticket Info' => 'Informações do Ticket',
    'Last Replied Agent' => 'Último Agente que Respondeu',
    'created Ticket' => 'ticket criado',
    'Uploaded Files' => 'Arquivos Enviados',
    'Download (as .zip)' => 'Baixar (como .zip)',
    'made last reply' => 'fez a última resposta',
    'N/A' => 'N/D',
    'Unassigned' => 'Não Atribuído',
    'Label' => 'Rótulo',
    'Assigned to me' => 'Atribuído a mim',
    'Search Query' => 'Consulta de Busca',
    'Searching' => 'Pesquisando',
    'Saved Filter' => 'Filtro Salvo',
    'No Label Created' => 'Nenhum Rótulo Criado',
    'Label with same name already exist.' => 'Um rótulo com o mesmo nome já existe.',
    'Create New' => 'Criar Novo',
    'Mail status' => 'Status do Email',
    'replied' => 'respondeu',
    'added note' => 'adicionou nota',
    'forwarded' => 'encaminhado',
    'TO' => 'PARA',
    'CC' => 'CC',
    'BCC' => 'BCC',
    'Locked' => 'Bloqueado',
    'Edit Thread' => 'Editar Tópico',
    'Delete Thread' => 'Excluir Tópico',
    'Unpin Thread' => 'Desafixar Tópico',
    'Pin Thread' => 'Fixar Tópico',
    'Unlock Thread' => 'Desbloquear Tópico',
    'Lock Thread' => 'Bloquear Tópico',
    'Translate Thread' => 'Traduzir Tópico',
    'Language' => 'Idioma',
    'English' => 'Inglês',
    'French' => 'Francês',
    'Italian' => 'Italiano',
    'Arabic' => 'Árabe',
    'German' => 'Alemão',
    'Spanish' => 'Espanhol',
    'Turkish' => 'Turco',
    'Danish' => 'Dinamarquês',
    'Chinese' => 'Chinês',
    'Polish' => 'Polonês',
    'Portuguese' => 'Português',
    'System' => 'Sistema',
    'Open in Files' => 'Abrir nos Arquivos',
    'Email address is invalid' => 'Endereço de email inválido',
    'Tag with same name already exist' => 'Etiqueta com o mesmo nome já existe',
    'Text length should be less than 20 charactors' => 'O comprimento do texto deve ser inferior a 20 caracteres',
    'Label with same name already exist' => 'Rótulo com o mesmo nome já existe',
    'Agent Name' => 'Nome do Agente',
    'Agent Email' => 'Email do Agente',
    'open' => 'aberto',
    'Currently active agents on ticket' => 'Agentes atualmente ativos no ticket',
    'Edit Customer Information' => 'Editar Informações do Cliente',
    'Restore' => 'Restaurar',
    'Delete Forever' => 'Excluir para Sempre',
    'Add Team' => 'Adicionar Equipe',
    'delete' => 'excluir',
    'You didnt have any folder for current filter(s).' => 'Você não possui nenhuma pasta para o(s) filtro(s) atual(is).',
    'Add Folder' => 'Adicionar Pasta',
    'This field must have valid characters only' => 'Este campo deve conter apenas caracteres válidos',
    'Can edit task' => 'Pode editar tarefa',
    'Can create task' => 'Pode criar tarefa',
    'Can delete task' => 'Pode excluir tarefa',
    'Can add member to task' => 'Pode adicionar membro à tarefa',
    'Can remove member from task' => 'Pode remover membro da tarefa',
    'Agent Privileges' => 'Privilégios do Agente',
    'Agent Privilege represents overall permissions in System.' => 'Os privilégios do agente representam permissões gerais no sistema.',
    'Ticket View' => 'Visualização do Ticket',
    'User can view tickets based on selected scope.' => 'O usuário pode visualizar tickets com base no escopo selecionado.',
    'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) he belongs to and so on' => 'Se acesso individual, o usuário pode visualizar apenas os tickets atribuídos a ele. Se acesso de equipe, ele pode visualizar todos os tickets das equipes a que pertence, e assim por diante.',
    'Global Access' => 'Acesso Global',
    'Group Access' => 'Acesso ao Grupo',
    'Team Access' => 'Acesso à Equipe',
    'Individual Access' => 'Acesso Individual',
    'This field must have characters only' => 'Este campo deve conter apenas caracteres',
    'Maximum character length is 40' => 'O comprimento máximo é de 40 caracteres',
    'This is not a valid email address' => 'Este não é um endereço de email válido',
    'Password must contains 8 Characters' => 'A senha deve conter 8 caracteres',
    'The passwords does not match' => 'As senhas não coincidem',
    'Enabled' => 'Ativado',
    'Create Configuration' => 'Criar Configuração',
    'Swift Mailer Settings' => 'Configurações do Swift Mailer',
    'Username' => 'Nome de Usuário',
    'Please select a swiftmailer id' => 'Por favor, selecione um ID do swiftmailer',
    'Please enter a valid e-mail id' => 'Por favor, insira um email válido',
    'Please enter a mailer id' => 'Por favor, insira um ID do mailer',
    'Email Id' => 'ID de Email',
    'Are you sure? You want to perform this action.' => 'Tem certeza de que deseja executar esta ação?',
    'Reorder' => 'Reordenar',
    'New Workflow' => 'Novo Fluxo de Trabalho',
    'OR' => 'OU',
    'AND' => 'E',
    'Please enter a valid name.' => 'Por favor, insira um nome válido.',
    'Please select a value.' => 'Por favor, selecione um valor.',
    'Please add a value.' => 'Por favor, adicione um valor.',
    'This field is required' => 'Este campo é obrigatório',
    'or' => 'ou',
    'and' => 'e',
    'Select a Condition' => 'Selecione uma Condição',
    'Loading...' => 'Carregando...',
    'Select Option' => 'Selecione uma Opção',
    'Inactive' => 'Inativo',
    'New Type' => 'Novo Tipo',
    'Placeholders' => 'Marcadores',
    'Ticket Link' => 'Link do Ticket',
    'Id' => 'ID',
    'Preview' => 'Pré-visualização',
    'Sort Order' => 'Ordem de Classificação',
    'This field must be a number' => 'Este campo deve ser um número',
    'User' => 'Usuário',
    'Edit Group' => 'Editar Grupo',
    'Group Status' => 'Status do Grupo',
    'Group is Active' => 'Grupo está Ativo',
    'Add Group' => 'Adicionar Grupo',
    'Contact number is invalid' => 'Número de contato inválido',
    'Edit Agent' => 'Editar Agente',
    'No Privilege added, Please add Privilege(s) first !' => 'Nenhum privilégio adicionado, por favor, adicione privilégio(s) primeiro!',
    'Edit Email Template' => 'Editar Template de Email',
    'Edit Workflow' => 'Editar Fluxo de Trabalho',
    'Save Workflow' => 'Salvar Fluxo de Trabalho',
    'Edit Ticket Type' => 'Editar Tipo de Ticket',
    'Add Ticket Type' => 'Adicionar Tipo de Ticket',
    'Date Released' => 'Data de Lançamento',
    'Free' => 'Gratuito',
    'Premium' => 'Premium',
    'Installed' => 'Instalado',
    'Installed Applications' => 'Aplicativos Instalados',
    'Apps Dashboard' => 'Painel de Aplicativos',
    'Dashboard' => 'Painel',
    'Nothing Interesting here' => 'Nada interessante aqui',
    'No Categories Added' => 'Nenhuma Categoria Adicionada',
    'Error : Something went wrong, please try again later' => 'Erro: Algo deu errado, tente novamente mais tarde',
    'ticket' => 'ticket',
    'Add Email Template' => 'Adicionar Template de Email',
    'This field contain 100 characters only' => 'Máximo de 100 caracteres',
    'This field contain characters only' => 'Este campo pode conter apenas caracteres',
    'Name length must not be greater than 200 !!' => 'O comprimento do nome não deve exceder 200!',
    'Warning! Correct all field values first!' => 'Aviso! Corrija todos os valores dos campos primeiro!',
    'Warning ! This is not a valid request' => 'Aviso! Esta não é uma solicitação válida',
    'Success ! Tag removed successfully.' => 'Sucesso! Etiqueta removida com sucesso.',
    'Success ! Tags Saved successfully.' => 'Sucesso! Etiquetas salvas com sucesso.',
    'Success ! Revision restored successfully.' => 'Sucesso! Revisão restaurada com sucesso.',
    'Success ! Categories updated successfully.' => 'Sucesso! Categorias atualizadas com sucesso.',
    'Success ! Article Related removed successfully.' => 'Sucesso! Artigo relacionado removido com sucesso.',
    'Success ! Article Related is already added.' => 'Sucesso! Artigo relacionado já adicionado.',
    'Success ! Cannot add self as relative article.' => 'Sucesso! Não é possível adicionar a si mesmo como artigo relacionado.',
    'Success ! Article Related updated successfully.' => 'Sucesso! Artigo relacionado atualizado com sucesso.',
    'Success ! Articles removed successfully.' => 'Sucesso! Artigos removidos com sucesso.',
    'Success ! Article status updated successfully.' => 'Sucesso! Status do artigo atualizado com sucesso.',
    'Success ! Article star updated successfully.' => 'Sucesso! Estrela do artigo atualizada com sucesso.',
    'Success! Article updated successfully' => 'Sucesso! Artigo atualizado com sucesso',
    'Success ! Category sort order updated successfully.' => 'Sucesso! Ordem de classificação da categoria atualizada com sucesso.',
    'Success ! Category status updated successfully.' => 'Sucesso! Status da categoria atualizado com sucesso.',
    'Success ! Folders updated successfully.' => 'Sucesso! Pastas atualizadas com sucesso.',
    'Success ! Categories removed successfully.' => 'Sucesso! Categorias removidas com sucesso.',
    'Success ! Category updated successfully.' => 'Sucesso! Categoria atualizada com sucesso.',
    'Error ! Category is not exist.' => 'Erro! Categoria não existe.',
    'Warning ! Customer Login disabled by admin.' => 'Aviso! Login de cliente desativado pelo administrador.',
    'This Email is not registered with us.' => 'Este email não está registrado conosco.',
    'Your password has been updated successfully.' => 'Sua senha foi atualizada com sucesso.',
    'Password dont match.' => 'As senhas não coincidem.',
    'Error ! Profile image is not valid, please upload a valid format' => 'Erro! A imagem de perfil não é válida, por favor, faça o upload em um formato válido.',
    'Warning! Provide valid image file. (Recommened' => 'Aviso! Forneça um arquivo de imagem válido. (Recomendado: PNG, JPG ou GIF)',
    'Success! Folder has been added successfully.' => 'Sucesso! A pasta foi adicionada com sucesso.',
    'Folder updated successfully.' => 'Pasta atualizada com sucesso.',
    'Success ! Folder status updated successfully.' => 'Sucesso! O status da pasta foi atualizado com sucesso.',
    'Error ! Folder is not exist.' => 'Erro! A pasta não existe.',
    'Success ! Folder updated successfully.' => 'Sucesso! A pasta foi atualizada com sucesso.',
    'Error ! Folder does not exist.' => 'Erro! A pasta não existe.',
    'Success ! Folder deleted successfully.' => 'Sucesso! A pasta foi excluída com sucesso.',
    'Warning ! Folder doesnt exists!' => 'Aviso! A pasta não existe!',
    'Warning ! Cannot create ticket, given email is blocked by admin.' => 'Aviso! Não é possível criar o ticket, o email fornecido está bloqueado pelo administrador.',
    'Success ! Ticket has been created successfully.' => 'Sucesso! O ticket foi criado com sucesso.',
    'Warning ! Can not create ticket, invalid details.' => 'Aviso! Não é possível criar o ticket, detalhes inválidos.',
    'Warning ! Post size can not exceed 25MB' => 'Aviso! O tamanho do anexo não pode exceder 25MB.',
    'Create Ticket Request' => 'Criar Solicitação de Ticket',
    'Success ! Reply added successfully.' => 'Sucesso! Resposta adicionada com sucesso.',
    'Warning ! Reply field can not be blank.' => 'Aviso! O campo de resposta não pode estar vazio.',
    'Success ! Rating has been successfully added.' => 'Sucesso! A avaliação foi adicionada com sucesso.',
    'Warning ! Invalid rating.' => 'Aviso! Avaliação inválida.',
    'Error ! Can not add customer as a collaborator.' => 'Erro! Não é possível adicionar o cliente como colaborador.',
    'Success ! Collaborator added successfully.' => 'Sucesso! Colaborador adicionado com sucesso.',
    'Error ! Collaborator is already added.' => 'Erro! Colaborador já adicionado.',
    'Success ! Collaborator removed successfully.' => 'Sucesso! Colaborador removido com sucesso.',
    'Error ! Invalid Collaborator.' => 'Erro! Colaborador inválido.',
    'An unexpected error occurred. Please try again later.' => 'Ocorreu um erro inesperado. Por favor, tente novamente mais tarde.',
    'Feedback saved successfully.' => 'Feedback salvo com sucesso.',
    'Feedback updated successfully.' => 'Feedback atualizado com sucesso.',
    'Invalid feedback provided.' => 'Feedback inválido fornecido.',
    'Article not found.' => 'Artigo não encontrado.',
    'You need to login to your account before can perform this action.' => 'Você precisa fazer login em sua conta antes de realizar esta ação.',
    'Warning! Please add valid Actions!' => 'Aviso! Por favor, adicione ações válidas!',
    'Warning! In Free Plan you can not change Events!' => 'Aviso! No plano gratuito, você não pode alterar eventos!',
    'Success! Prepared Response has been updated successfully.' => 'Sucesso! A resposta preparada foi atualizada com sucesso.',
    'Success! Prepared Response has been added successfully.' => 'Sucesso! A resposta preparada foi adicionada com sucesso.',
    'Warning  This is not a valid request' => 'Aviso! Esta não é uma solicitação válida.',
    'Use Default Colors' => 'Usar Cores Padrão',
    'Masonry' => 'Masonry',
    'Popular Article' => 'Artigo Popular',
    'Manage Ticket Custom Fields' => 'Gerenciar Campos Personalizados do Ticket',
    'Mail status:' => 'Status do e-mail:',
    'You dont have premission to edit this Prepared response' => 'Você não tem permissão para editar esta resposta preparada.',
    'Save Prepared Response' => 'Salvar resposta preparada',
    'Success ! Prepared response removed successfully.' => 'Sucesso! Resposta preparada removida com sucesso.',
    'Warning! You are not allowed to perform this action.' => 'Aviso! Você não tem permissão para realizar esta ação.',
    'Success! Workflow has been updated successfully.' => 'Sucesso! O fluxo de trabalho foi atualizado com sucesso.',
    'Success! Workflow has been added successfully.' => 'Sucesso! O fluxo de trabalho foi adicionado com sucesso.',
    'Success! Order has been updated successfully.' => 'Sucesso! O pedido foi atualizado com sucesso.',
    'Success! Workflow has been removed successfully.' => 'Sucesso! O fluxo de trabalho foi removido com sucesso.',
    'Mailbox successfully created.' => 'Caixa de correio criada com sucesso.',
    'Mailbox successfully updated.' => 'Caixa de correio atualizada com sucesso.',
    'Warning ! Bad request !' => 'Aviso! Solicitação inválida!',
    'Error! Given current password is incorrect.' => 'Erro! A senha atual fornecida está incorreta.',
    'Success ! Profile update successfully.' => 'Sucesso! Perfil atualizado com sucesso.',
    'Error ! User with same email is already exist.' => 'Erro! Já existe um usuário com o mesmo e-mail.',
    'Success ! Agent updated successfully.' => 'Sucesso! Agente atualizado com sucesso.',
    'Success ! Agent removed successfully.' => 'Sucesso! Agente removido com sucesso.',
    'Warning ! You are allowed to remove account owners account.' => 'Aviso! Você pode remover a conta do proprietário da conta.',
    'Error ! Invalid user id.' => 'Erro! ID de usuário inválido.',
    'Success ! Filter has been saved successfully.' => 'Sucesso! Filtro salvo com sucesso.',
    'Success ! Filter has been updated successfully.' => 'Sucesso! Filtro atualizado com sucesso.',
    'Success ! Filter has been removed successfully.' => 'Sucesso! Filtro removido com sucesso.',
    'Please check your mail for password update.' => 'Por favor, verifique seu e-mail para atualização da senha.',
    'This Email address is not registered with us.' => 'Este endereço de e-mail não está registrado conosco.',
    'Success ! Customer saved successfully.' => 'Sucesso! Cliente salvo com sucesso.',
    'Error ! User with same email already exist.' => 'Erro! Usuário com o mesmo e-mail já existe.',
    'Success ! Customer information updated successfully.' => 'Sucesso! Informações do cliente atualizadas com sucesso.',
    'Success ! Customer updated successfully.' => 'Sucesso! Cliente atualizado com sucesso.',
    'Error ! Customer with same email already exist.' => 'Erro! Cliente com o mesmo e-mail já existe.',
    'unstarred Action Completed successfully' => 'Ação não marcada concluída com sucesso',
    'starred Action Completed successfully' => 'Ação marcada concluída com sucesso',
    'Success ! Customer removed successfully.' => 'Sucesso! Cliente removido com sucesso.',
    'Error ! Invalid customer id.' => 'Erro! ID de cliente inválido.',
    'Success! Template has been updated successfully.' => 'Sucesso! O modelo foi atualizado com sucesso.',
    'Success! Template has been added successfully.' => 'Sucesso! O modelo foi adicionado com sucesso.',
    'Success! Template has been deleted successfully.' => 'Sucesso! O modelo foi excluído com sucesso.',
    'Warning! resource not found.' => 'Aviso! Recurso não encontrado.',
    'Warning! You can not remove predefined email template which is being used in workflow(s).' => 'Aviso! Você não pode remover um modelo de e-mail pré-definido que está sendo usado em fluxo(s) de trabalho.',
    'Success ! Email settings are updated successfully.' => 'Sucesso! As configurações de e-mail foram atualizadas com sucesso.',
    'Success ! Group information updated successfully.' => 'Sucesso! Informações do grupo atualizadas com sucesso.',
    'Success ! Group information saved successfully.' => 'Sucesso! Informações do grupo salvas com sucesso.',
    'Support Group removed successfully.' => 'Grupo de Suporte removido com sucesso.',
    'Success ! Privilege information saved successfully.' => 'Sucesso! Informações de privilégio salvas com sucesso.',
    'Privilege updated successfully.' => 'Privilégio atualizado com sucesso.',
    'Support Privilege removed successfully.' => 'Privilégio de Suporte removido com sucesso.',
    'Success! Reply has been updated successfully.' => 'Sucesso! A resposta foi atualizada com sucesso.',
    'Success! Reply has been added successfully.' => 'Sucesso! A resposta foi adicionada com sucesso.',
    'Success! Saved Reply has been deleted successfully' => 'Sucesso! Resposta salva foi excluída com sucesso.',
    'SwiftMailer configuration updated successfully.' => 'Configuração do SwiftMailer atualizada com sucesso.',
    'Swiftmailer configuration removed successfully.' => 'Configuração do SwiftMailer removida com sucesso.',
    'Success ! Team information saved successfully.' => 'Sucesso! Informações da equipe salvas com sucesso.',
    'Success ! Team information updated successfully.' => 'Sucesso! Informações da equipe atualizadas com sucesso.',
    'Support Team removed successfully.' => 'Equipe de suporte removida com sucesso.',
    'Success! Reply has been added successfully' => 'Sucesso! Resposta adicionada com sucesso.',
    'Success ! Thread updated successfully.' => 'Sucesso! Tópico atualizado com sucesso.',
    'Error ! Reply field can not be blank.' => 'Erro! O campo de resposta não pode estar vazio.',
    'Success ! Thread removed successfully.' => 'Sucesso! Tópico removido com sucesso.',
    'Success ! Thread locked successfully' => 'Sucesso! Tópico bloqueado com sucesso.',
    'Success ! Thread unlocked successfully' => 'Sucesso! Tópico desbloqueado com sucesso.',
    'Success ! Thread pinned successfully' => 'Sucesso! Tópico fixado com sucesso.',
    'Error ! Invalid thread.' => 'Erro! Tópico inválido.',
    'Could not create ticket, invalid details.' => 'Não foi possível criar o ticket, detalhes inválidos.',
    'Success ! Tag updated successfully.' => 'Sucesso! Etiqueta atualizada com sucesso.',
    'Error ! Customer can not be added as collaborator.' => 'Erro! O cliente não pode ser adicionado como colaborador.',
    'Success ! Tag unassigned successfully.' => 'Sucesso! Etiqueta desatribuída com sucesso.',
    'Success ! Tag added successfully.' => 'Sucesso! Etiqueta adicionada com sucesso.',
    'Please enter tag name.' => 'Por favor, insira o nome da etiqueta.',
    'Error ! Invalid tag.' => 'Erro! Etiqueta inválida.',
    'Success ! Type removed successfully.' => 'Sucesso! Tipo removido com sucesso.',
    'Success ! Ticket to label removed successfully.' => 'Sucesso! Etiqueta do ticket removida com sucesso.',
    'Unable to retrieve support team details' => 'Não foi possível recuperar os detalhes da equipe de suporte.',
    'Ticket support group updated successfully' => 'Grupo de suporte do ticket atualizado com sucesso.',
    'Unable to retrieve status details' => 'Não foi possível recuperar os detalhes do status.',
    'Insufficient details provided.' => 'Detalhes insuficientes fornecidos.',
    'Error! Subject field is mandatory' => 'Erro! O campo de assunto é obrigatório.',
    'Error! Reply field is mandatory' => 'Erro! O campo de resposta é obrigatório.',
    'Success ! Ticket has been updated successfully.' => 'Sucesso! Ticket atualizado com sucesso.',
    'Success ! Label updated successfully.' => 'Sucesso! Rótulo atualizado com sucesso.',
    'Error ! Invalid label id.' => 'Erro! ID de rótulo inválido.',
    'Success ! Label removed successfully.' => 'Sucesso! Rótulo removido com sucesso.',
    'Success ! Label created successfully.' => 'Sucesso! Rótulo criado com sucesso.',
    'Error ! Label name can not be blank.' => 'Erro! O nome do rótulo não pode estar vazio.',
    'Success ! Ticket moved to trash successfully.' => 'Sucesso! Ticket movido para a lixeira com sucesso.',
    'Success! Ticket type saved successfully.' => 'Sucesso! Tipo de ticket salvo com sucesso.',
    'Success! Ticket type updated successfully.' => 'Sucesso! Tipo de ticket atualizado com sucesso.',
    'Error! Ticket type with same name already exist' => 'Erro! Já existe um tipo de ticket com o mesmo nome.',
    'SAVE' => 'SALVAR',
    'Howdy!' => 'Olá!',
    'New Ticket Request' => 'Nova Solicitação de Ticket',
    'Ticket Requests' => 'Solicitações de Ticket',
    'Tickets have been updated successfully' => 'Tickets atualizados com sucesso.',
    'Please check your mail for password update' => 'Por favor, verifique seu e-mail para atualização da senha.',
    'This email address is not registered with us' => 'Este endereço de e-mail não está registrado conosco.',
    'You have already update password using this link if you wish to change password again click on forget password link here from login page' => 'Você já atualizou a senha usando este link. Se desejar alterar a senha novamente, clique no link de esqueci a senha na página de login.',
    'Your password has been successfully updated. Login using updated password' => 'Sua senha foi atualizada com sucesso. Faça login usando a senha atualizada.',
    'Please try again, The passwords do not match' => 'Por favor, tente novamente. As senhas não coincidem.',
    'Support Privilege removed successfully' => 'Privilégio de suporte removido com sucesso.',
    'Success! Saved Reply has been deleted successfully.' => 'Sucesso! Resposta salva foi excluída com sucesso.',
    'SwiftMailer configuration created successfully.' => 'Configuração do SwiftMailer criada com sucesso.',
    'No swiftmailer configurations found for mailer id:' => 'Nenhuma configuração do SwiftMailer encontrada para o ID do mailer:',
    'Reply content cannot be left blank.' => 'O conteúdo da resposta não pode estar vazio.',
    'Reply added to the ticket and forwarded successfully.' => 'Resposta adicionada ao ticket e encaminhada com sucesso.',
    'Success ! Thread pinned successfully.' => 'Sucesso! Tópico fixado com sucesso.',
    'Success ! unpinned removed successfully.' => 'Sucesso! Tópico desafixado com sucesso.',
    'Unable to retrieve priority details' => 'Não foi possível recuperar os detalhes da prioridade.',
    'Ticket support team updated successfully' => 'Equipe de suporte do ticket atualizada com sucesso.',
    'Ticket assigned to support group ' => 'Ticket atribuído ao grupo de suporte.',
    'Mailbox configuration removed successfully.' => 'Configuração da caixa de correio removida com sucesso.',
    'visit our website' => 'visite nosso site',
    'Cookie Usage Policy' => 'Política de Uso de Cookies',
    'cookie' => 'cookie',
    'cookies' => 'cookies',
    'HELP' => 'AJUDA',
    'Home' => 'Início',
    'Cookie Policy' => 'Política de Cookies',
    'Prev' => 'Anterior',
    'Ticket query message' => 'Conteúdo do Ticket',
    'Select type' => 'Selecionar tipo',
    'Search KnowledgeBase' => 'Buscar na Base de Conhecimento',
    'You cant merge an account with itself.' => 'Você não pode mesclar uma conta consigo mesma.',
    'Edit Profile' => 'Editar Perfil',
    'Customer Login' => 'Login do Cliente',
    'Contact Us' => 'Contate-Nos',
    'If you have ever contacted our support previously, your account would have already been created.' => 'Se você já entrou em contato com nosso suporte anteriormente, sua conta já deve ter sido criada.',
    'support' => 'suporte',
    'HelpDesk' => 'Central de Ajuda',
    'Enter search keyword' => 'Digite a palavra-chave de busca',
    'Browse via Folders' => 'Explorar a base de conhecimento',
    'Looking for something that is queried generally? Choose a relevant folder from below to explore possible solutions' => 'Procurando algo que geralmente é questionado? Escolha uma pasta relevante abaixo para explorar possíveis soluções.',
    'Unable to find an answer?' => 'Contate Nossa Equipe',
    'Looking for anything specific article which resides in general queries? Just browse the various relevant folders and categories and then you will find the desired article.' => 'Procurando um artigo específico que reside em consultas gerais? Basta navegar pelas várias pastas e categorias relevantes e você encontrará o artigo desejado.',
    'Popular Articles' => 'Artigos Populares',
    'Here are some of the most popular articles, which helped number of users to get their queries and questions resolved.' => 'Aqui estão alguns dos artigos mais populares, que ajudaram vários usuários a resolver suas dúvidas e perguntas.',
    'Browse via Categories' => 'Navegar por Categorias',
    'Looking for something specific? Choose a relevant category from below to explore possible solutions' => 'Procurando algo específico? Escolha uma categoria relevante abaixo para explorar possíveis soluções.',
    'No Categories Found!' => 'Nenhuma Categoria Encontrada!',
    'Powered by' => 'Desenvolvido por',
    'Forgot Password' => 'Esqueceu a Senha',
    'Enter your email address and we will send you an email with instructions to update your login credentials.' => 'Digite seu endereço de e-mail e enviaremos um e-mail com instruções para atualizar suas credenciais de login.',
    'Send Mail' => 'Enviar E-mail',
    'Sign In to %websitename%' => 'Entrar no %websitename%',
    'Enter your name' => 'Digite seu nome',
    'Enter your email' => 'Digite seu e-mail',
    'Learn more about %deliveryStatus%.' => 'Saiba mais sobre %deliveryStatus%.',
    'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.' => 'Algumas páginas do nosso site utilizam %cookies% e outras tecnologias de rastreamento. Um %cookie% é um pequeno arquivo de texto que pode ser usado, por exemplo, para coletar informações sobre a atividade do site. Alguns cookies e outras tecnologias podem servir para lembrar informações pessoais previamente indicadas por um usuário do site. Você pode bloquear cookies ou excluir cookies existentes ajustando a configuração apropriada no seu navegador. Consulte o menu %help% do seu navegador para saber como fazer isso. Se você bloquear ou excluir %cookies%, poderá achar a utilidade do nosso site prejudicada.',
    'To know more about how our privacy policy works, please %websiteLink%.' => 'Para saber mais sobre como nossa política de privacidade funciona, por favor %websiteLink%.',
    'This field contain maximum 40 charectures.' => 'Este campo contém no máximo 40 caracteres.',
    'This field contain maximum 50 charectures.' => 'Este campo contém no máximo 50 caracteres.',
    'Time' => 'Tempo',
    'Links' => 'Links',
    'Broadcast Message' => 'Mensagem de Transmissão',
    'Wide Logo' => 'Logo Largo',
    'Upload an Image (200px x 48px) in</br> PNG or JPG Format' => 'Carregar uma Imagem (200px x 48px) em</br> Formato PNG ou JPG',
    'It will be shown as Logo on Knowledgebase and Helpdesk' => 'Será exibido como Logo na Base de Conhecimento e Helpdesk',
    'Website Status' => 'Status do Site',
    'Enable front end website and knowledgebase for customer(s)' => 'Ativar site e base de conhecimento para cliente(s)',
    'Brand Color' => 'Cor da Marca',
    'Page Background Color' => 'Cor de Fundo da Página',
    'Header Background Color' => 'Cor de Fundo do Cabeçalho',
    'Banner Background Color' => 'Cor de Fundo do Banner',
    'Page Link Color' => 'Cor do Link da Página',
    'Page Link Hover Color' => 'Cor do Link ao Passar o Mouse',
    'Article Text Color' => 'Cor do Texto do Artigo',
    'Tag Line' => 'Linha de Tag',
    'Hi! how can we help?' => 'Oi! Como podemos ajudar?',
    'Layout' => 'Layout',
    'Ticket Create Option' => 'Opção de Criação de Ticket',
    'Login Required To Create Tickets' => 'Login Necessário para Criar Tickets',
    'Remove Customer Login/Signin Button' => 'Remover Botão de Login/Entrar do Cliente',
    'Disable Customer Login' => 'Desativar Login do Cliente',
    'Meta Description (Recommended)' => 'Meta Descrição (Recomendado)',
    'Meta Keywords (Recommended)' => 'Meta Palavras-chave (Recomendado)',
    'Header Link' => 'Link do Cabeçalho',
    'URL (with http":/"/ or https":/"/)' => 'URL (com http":/"/ ou https":/"/)',
    'Footer Link' => 'Link do Rodapé',
    'Custom CSS (Optional)' => 'CSS Personalizado (Opcional)',
    'It will be add to the frontend knowledgebase only' => 'Exibido apenas na base de conhecimento do frontend',
    'Custom Javascript (Optional)' => 'Javascript Personalizado (Opcional)',
    'Broadcast message content to show on helpdesk' => 'Conteúdo da mensagem de transmissão para exibir no helpdesk',
    'From' => 'De',
    'Time duration between which message will be displayed(if applicable)' => 'Por quanto tempo a mensagem deve ser exibida?',
    'Broadcasting Status' => 'Status da Transmissão',
    'Broadcasting is Active' => 'Transmissão está Ativa',
    'Choose a default company timezone' => 'Escolha o fuso horário padrão da empresa',
    'Date Time Format' => 'Formato de Data e Hora',
    'Choose a format to convert date to specified date time format' => 'Escolha um formato para converter a data para o formato de data e hora especificado',
    'An empty file is not allowed.' => 'Um arquivo vazio não é permitido.',
    'File size must not be greater than 200KB !!' => 'O tamanho do arquivo não deve ser maior que 200KB!',
    'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!' => 'Por favor, envie um arquivo de imagem válido (apenas JPEG, JPG, PNG permitidos)!',
    'Provide a valid url(with protocol)' => 'Forneça uma URL válida (com protocolo)',
    'ticket.message.placeHolders.info' => 'ticket.message.placeHolders.info',
    'ticket.attachments.placeHolders.info' => '	ticket.attachments.placeHolders.info',
    'ticket.threadMessage.placeHolders.info' => 'ticket.threadMessage.placeHolders.info',
    'ticket.tags.placeHolders.info' => 'ticket.tags.placeHolders.info',
    'ticket.source.placeHolders.info' => 'ticket.source.placeHolders.info',
    'ticket.collaborator.name.placeHolders.info' => 'ticket.collaborator.name.placeHolders.info',
    'ticket.collaborator.email.placeHolders.info' => 'ticket.collaborator.email.placeHolders.info',
    'user.name.info' => 'user.name.info',
    'user.email.info' => 'user.email.info',
    'user.account.validate.link.info' => 'user.account.validate.link.info',
    'user.password.forgot.link.info' => 'user.password.forgot.link.info',
    'global.companyName' => 'global.companyName',
    'global.companyLogo' => 'global.companyLogo',
    'global.companyUrl' => 'global.companyUrl',
    'ticket.priority.placeHolders.info' => '	ticket.priority.placeHolders.info',
    'ticket.group.placeHolders.info' => 'ticket.group.placeHolders.info',
    'ticket.team.placeHolders.info' => 'ticket.team.placeHolders.info',
    'ticket.customerName.placeHolders.info' => '	ticket.customerName.placeHolders.info',
    'ticket.customerEmail.placeHolders.info' => '	ticket.customerEmail.placeHolders.info',
    'ticket.agentName.placeHolders.info' => 'ticket.agentName.placeHolders.info',
    'ticket.agentEmail.placeHolders.info' => 'ticket.agentEmail.placeHolders.info',
    'ticket.link.placeHolders.info' => '	ticket.link.placeHolders.info ',
    'ticket.id.placeHolders.info' => 'ticket.id.placeHolders.info',
    'ticket.subject.placeHolders.info' => '	ticket.subject.placeHolders.info',
    'ticket.status.placeHolders.info' => 'ticket.status.placeHolders.info',
    'comma "," separated' => 'separado por vírgula (,)',
    'Low' => 'Baixo',
    'Medium' => 'Médio',
    'High' => 'Alto',
    'Urgent' => 'Urgente',
    'Reset Password' => 'Redefinir Senha',
    'Enter your new password below to update your login credentials' => 'Digite sua nova senha abaixo para atualizar suas credenciais de login',
    'Save Password' => 'Salvar Senha',
    'Rate Support' => 'Avaliar Suporte',
    'I am very Sad' => 'Estou muito decepcionado',
    'I am Sad' => 'Estou decepcionado',
    'I am Neutral' => 'Estou satisfeito',
    'I am Happy' => 'Estou feliz',
    'I am Very Happy' => 'Estou muito feliz',
    'Kudos' => 'Aplausos',
    'kudos' => 'Aplausos',
    'Very Sad' => 'Muito decepcionado',
    'Sad' => 'Decepcionado',
    'Neutral' => 'Satisfeito',
    'Happy' => 'Feliz',
    'Very Happy' => 'Muito feliz',
    'Star(s)' => 'Estrela(s)',
    'Warning ! Swiftmailer not working. An error has occurred while sending emails!' => 'Aviso! Swiftmailer não está funcionando. Ocorreu um erro ao enviar e-mails!',
    'Invalid credentials.' => 'Credenciais inválidas.',
    'Success ! Project cache cleared successfully.' => 'Sucesso! Cache do projeto limpo com sucesso.',
    'clear cache' => 'limpar cache',
    'Last Updated' => 'Última Atualização',
    'Error! Something went wrong.' => 'Erro! Algo deu errado.',
    'We were not able to find the page you are looking for.' => 'Não conseguimos encontrar a página que você está procurando.',
    'Page not found' => 'Página não encontrada',
    'Forbidden' => 'Proibido',
    'You don’t have the necessary permissions to access this Web page :(' => 'Você não tem as permissões necessárias para acessar esta página da Web :(',
    'Internal server error' => 'Erro interno do servidor',
    'Our system has goofed up for a while, but good part is it won\'t last long' => 'Nosso sistema falhou por um tempo, mas a boa notícia é que não vai durar muito',
    'Unknown Error' => 'Erro Desconhecido',
    'We are quite confused about how did you land here:/' => 'Estamos bastante confusos sobre como você chegou aqui :/',
    'Few of the links which may help you to get back on the track -' => 'Alguns links que podem ajudá-lo a voltar ao caminho certo -',
  ),
));

$cataloguePt = new MessageCatalogue('pt', array (
  'validators' => 
  array (
    'This value should be false.' => 'Este valor deveria ser falso.',
    'This value should be true.' => 'Este valor deveria ser verdadeiro.',
    'This value should be of type {{ type }}.' => 'Este valor deveria ser do tipo {{ type }}.',
    'This value should be blank.' => 'Este valor deveria ser vazio.',
    'The value you selected is not a valid choice.' => 'O valor selecionado não é uma opção válida.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Você deveria selecionar {{ limit }} opção no mínimo.|Você deveria selecionar {{ limit }} opções no mínimo.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Você deve selecionar, no máximo {{ limit }} opção.|Você deve selecionar, no máximo {{ limit }} opções.',
    'One or more of the given values is invalid.' => 'Um ou mais dos valores introduzidos não são válidos.',
    'This field was not expected.' => 'Este campo não era esperado.',
    'This field is missing.' => 'Este campo está faltando.',
    'This value is not a valid date.' => 'Este valor não é uma data válida.',
    'This value is not a valid datetime.' => 'Este valor não é uma data-hora válida.',
    'This value is not a valid email address.' => 'Este valor não é um endereço de e-mail válido.',
    'The file could not be found.' => 'O arquivo não pôde ser encontrado.',
    'The file is not readable.' => 'O arquivo não pôde ser lido.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'O arquivo é muito grande ({{ size }} {{ suffix }}). O tamanho máximo permitido é de {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'O tipo mime do arquivo é inválido ({{ type }}). Os tipos mime permitidos são {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Este valor deveria ser {{ limit }} ou menor.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'O valor é muito longo. Deveria ter {{ limit }} caracteres ou menos.',
    'This value should be {{ limit }} or more.' => 'Este valor deveria ser {{ limit }} ou mais.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'O valor é muito curto. Deveria de ter {{ limit }} caractere ou mais.|O valor é muito curto. Deveria de ter {{ limit }} caracteres ou mais.',
    'This value should not be blank.' => 'Este valor não deveria ser vazio.',
    'This value should not be null.' => 'Este valor não deveria ser nulo.',
    'This value should be null.' => 'Este valor deveria ser nulo.',
    'This value is not valid.' => 'Este valor não é válido.',
    'This value is not a valid time.' => 'Este valor não é uma hora válida.',
    'This value is not a valid URL.' => 'Este valor não é uma URL válida.',
    'The two values should be equal.' => 'Os dois valores deveriam ser iguais.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'O arquivo é muito grande. O tamanho máximo permitido é de {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'O arquivo é muito grande.',
    'The file could not be uploaded.' => 'Não foi possível enviar o arquivo.',
    'This value should be a valid number.' => 'Este valor deveria ser um número válido.',
    'This file is not a valid image.' => 'Este arquivo não é uma imagem.',
    'This is not a valid IP address.' => 'Este valor não é um endereço IP válido.',
    'This value is not a valid language.' => 'Este valor não é uma linguagem válida.',
    'This value is not a valid locale.' => 'Este valor não é uma localidade válida.',
    'This value is not a valid country.' => 'Este valor não é um país válido.',
    'This value is already used.' => 'Este valor já está a ser usado.',
    'The size of the image could not be detected.' => 'O tamanho da imagem não foi detectado.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'A largura da imagem ({{ width }}px) é muito grande. A largura máxima da imagem é: {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'A largura da imagem ({{ width }}px) é muito pequena. A largura mínima da imagem é de: {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'A altura da imagem ({{ height }}px) é muito grande. A altura máxima da imagem é de: {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'A altura da imagem ({{ height }}px) é muito pequena. A altura mínima da imagem é de: {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Este valor deveria ser a senha atual do usuário.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Este valor deve possuir exatamente {{ limit }} caractere.|Este valor deve possuir exatamente {{ limit }} caracteres.',
    'The file was only partially uploaded.' => 'Só foi enviada uma parte do arquivo.',
    'No file was uploaded.' => 'Nenhum arquivo foi enviado.',
    'No temporary folder was configured in php.ini.' => 'Nenhuma pasta temporária foi configurada no php.ini, ou a pasta configurada não existe.',
    'Cannot write temporary file to disk.' => 'Não foi possível escrever os arquivos temporários no disco.',
    'A PHP extension caused the upload to fail.' => 'Uma extensão PHP causou a falha no envio.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Esta coleção deve conter {{ limit }} elemento ou mais.|Esta coleção deve conter {{ limit }} elementos ou mais.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Esta coleção deve conter {{ limit }} elemento ou menos.|Esta coleção deve conter {{ limit }} elementos ou menos.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Esta coleção deve conter exatamente {{ limit }} elemento.|Esta coleção deve conter exatamente {{ limit }} elementos.',
    'Invalid card number.' => 'Número de cartão inválido.',
    'Unsupported card type or invalid card number.' => 'Tipo de cartão não suportado ou número de cartão inválido.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Este valor não é um Número de Conta Bancária Internacional (IBAN) válido.',
    'This value is not a valid ISBN-10.' => 'Este valor não é um ISBN-10 válido.',
    'This value is not a valid ISBN-13.' => 'Este valor não é um ISBN-13 válido.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Este valor não é um ISBN-10 ou ISBN-13 válido.',
    'This value is not a valid ISSN.' => 'Este valor não é um ISSN válido.',
    'This value is not a valid currency.' => 'Este não é um valor monetário válido.',
    'This value should be equal to {{ compared_value }}.' => 'Este valor deve ser igual a {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Este valor deve ser superior a {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Este valor deve ser igual ou superior a {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor deve ser idêntico a {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Este valor deve ser inferior a {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Este valor deve ser igual ou inferior a {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Este valor não deve ser igual a {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Este valor não deve ser idêntico a {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'O formato da imagem é muito grande ({{ ratio }}). O formato máximo é {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'O formato da imagem é muito pequeno ({{ ratio }}). O formato mínimo esperado é {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'A imagem é um quadrado ({{ width }}x{{ height }}px). Imagens quadradas não são permitidas.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'A imagem está em orientação de paisagem ({{ width }}x{{ height }}px). Imagens orientadas em paisagem não são permitidas.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'A imagem está em orientação de retrato ({{ width }}x{{ height }}px). Imagens orientadas em retrato não são permitidas.',
    'An empty file is not allowed.' => 'Um arquivo vazio não é permitido.',
    'The host could not be resolved.' => 'O host não pode ser resolvido.',
    'This value does not match the expected {{ charset }} charset.' => 'Este valor não corresponde ao conjunto de caracteres {{ charset }} esperado.',
    'This is not a valid Business Identifier Code (BIC).' => 'Este valor não é um Código de Identificação de Negócio (BIC) válido.',
    'Error' => 'Erro',
    'This is not a valid UUID.' => 'Este valor não é um UUID válido.',
    'This value should be a multiple of {{ compared_value }}.' => 'Este valor deve ser um múltiplo de {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'O Código de Identificação de Empresa (BIC) não está associado ao IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Este valor deve ser um JSON válido.',
    'This collection should contain only unique elements.' => 'Esta coleção deve conter só elementos únicos.',
    'This value should be positive.' => 'Este valor deve ser positivo.',
    'This value should be either positive or zero.' => 'Este valor deve ser superior ou igual a zero.',
    'This value should be negative.' => 'Este valor deve ser negativo.',
    'This value should be either negative or zero.' => 'Este valor deve ser inferior ou igual a zero.',
    'This value is not a valid timezone.' => 'Este valor não é um fuso horário válido.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Esta senha foi divulgada durante um vazamento de dados, não deve ser usada de novamente. Por favor usar uma senha outra.',
    'This value should be between {{ min }} and {{ max }}.' => 'Este valor deve estar entre {{ min }} e {{ max }}.',
    'This value is not a valid hostname.' => 'Este valor não é um nome de host válido.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'O número de elementos desta coleção deve ser um múltiplo de {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Este valor deve satisfazer pelo menos uma das seguintes restrições:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Cada elemento desta coleção deve satisfazer o seu próprio conjunto de restrições.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Este valor não é um Número Internacional de Identificação de Segurança (ISIN) válido.',
    'This value should be a valid expression.' => 'Este valor deve ser uma expressão válida.',
    'This value is not a valid CSS color.' => 'Este valor não é uma cor de CSS válida.',
    'This value is not a valid CIDR notation.' => 'Este valor não é uma notação CIDR válida.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'O valor da máscara de rede deve estar entre {{ min }} e {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'O nome do arquivo é muito grande. Deveria ter {{ filename_max_length }} caractere ou menos.|O nome do arquivo é muito grande. Deveria ter {{ filename_max_length }} caracteres ou menos.',
    'The password strength is too low. Please use a stronger password.' => 'A força da senha é muito baixa. Por favor utilize uma senha mais forte.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'Este valor contém caracteres que não são permitidos pelo nível de restrição atual.',
    'Using invisible characters is not allowed.' => 'Não é permitido usar caracteres invisíveis.',
    'Mixing numbers from different scripts is not allowed.' => 'Não é permitido misturar números de scripts diferentes.',
    'Using hidden overlay characters is not allowed.' => 'Não é permitido usar caracteres de sobreposição ocultos.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'A extensão do arquivo é inválida ({{ extension }}). As extensões permitidas são {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'A codificação de carateres detectada é inválida ({{ detected }}). As codificações permitidas são {{ encodings }}.',
    'This value is not a valid MAC address.' => 'Este valor não é um endereço MAC válido.',
    'This URL is missing a top-level domain.' => 'Esta URL está faltando o domínio de nível superior.',
    'This form should not contain extra fields.' => 'Este formulário não deveria possuir mais campos.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'O ficheiro enviado é muito grande. Por favor, tente enviar um ficheiro menor.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'O token CSRF está inválido. Por favor, tente enviar o formulário novamente.',
    'This value is not a valid HTML5 color.' => 'Este valor não é uma cor HTML5 válida.',
    'Please enter a valid birthdate.' => 'Por favor, informe uma data de nascimento válida.',
    'The selected choice is invalid.' => 'A escolha seleccionada é inválida.',
    'The collection is invalid.' => 'A coleção é inválida.',
    'Please select a valid color.' => 'Por favor, selecione uma cor válida.',
    'Please select a valid country.' => 'Por favor, selecione um país válido.',
    'Please select a valid currency.' => 'Por favor, selecione uma moeda válida.',
    'Please choose a valid date interval.' => 'Por favor, escolha um intervalo de datas válido.',
    'Please enter a valid date and time.' => 'Por favor, informe uma data e horário válidos.',
    'Please enter a valid date.' => 'Por favor, informe uma data válida.',
    'Please select a valid file.' => 'Por favor, selecione um ficheiro válido.',
    'The hidden field is invalid.' => 'O campo oculto é inválido.',
    'Please enter an integer.' => 'Por favor, informe um inteiro.',
    'Please select a valid language.' => 'Por favor selecione um idioma válido.',
    'Please select a valid locale.' => 'Por favor, selecione um locale válido.',
    'Please enter a valid money amount.' => 'Por favor, informe um valor monetário válido.',
    'Please enter a number.' => 'Por favor, informe um número.',
    'The password is invalid.' => 'A palavra-passe é inválida.',
    'Please enter a percentage value.' => 'Por favor, informe um valor percentual.',
    'The values do not match.' => 'Os valores não correspondem.',
    'Please enter a valid time.' => 'Por favor, informe uma hora válida.',
    'Please select a valid timezone.' => 'Por favor, selecione um fuso horário válido.',
    'Please enter a valid URL.' => 'Por favor, informe uma URL válida.',
    'Please enter a valid search term.' => 'Por favor, informe um termo de busca válido.',
    'Please provide a valid phone number.' => 'Por favor, infome um número de telefone válido.',
    'The checkbox has an invalid value.' => 'O checkbox possui um valor inválido.',
    'Please enter a valid email address.' => 'Por favor, informe um endereço de email válido.',
    'Please select a valid option.' => 'Por favor, selecione uma opção válida.',
    'Please select a valid range.' => 'Por favor, selecione um intervalo válido.',
    'Please enter a valid week.' => 'Por favor, selecione uma semana válida.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Ocorreu uma exceção durante a autenticação.',
    'Authentication credentials could not be found.' => 'As credenciais de autenticação não foram encontradas.',
    'Authentication request could not be processed due to a system problem.' => 'A autenticação não foi concluída devido a um problema no sistema.',
    'Invalid credentials.' => 'Credenciais inválidas.',
    'Cookie has already been used by someone else.' => 'Este cookie já está em uso.',
    'Not privileged to request the resource.' => 'Sem privilégios para solicitar este recurso.',
    'Invalid CSRF token.' => 'Token CSRF inválido.',
    'No authentication provider found to support the authentication token.' => 'Nenhum fornecedor de autenticação encontrado para suportar o token de autenticação.',
    'No session available, it either timed out or cookies are not enabled.' => 'Nenhuma sessão disponível, esta expirou ou os cookies estão desativados.',
    'No token could be found.' => 'O token não foi encontrado.',
    'Username could not be found.' => 'Nome de usuário não encontrado.',
    'Account has expired.' => 'A conta expirou.',
    'Credentials have expired.' => 'As credenciais expiraram.',
    'Account is disabled.' => 'Conta desativada.',
    'Account is locked.' => 'A conta está bloqueada.',
    'Too many failed login attempts, please try again later.' => 'Muitas tentativas de login sem sucesso, por favor, tente mais tarde.',
    'Invalid or expired login link.' => 'Ligação de login inválida ou expirada.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Muitas tentativas de login sem sucesso, por favor, tente novamente novamente em 1 minuto.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Muitas tentativas de login sem sucesso, por favor, tente novamente em %minutes% minutos.',
  ),
));
$catalogue->addFallbackCatalogue($cataloguePt);
$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This value is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This value is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This value is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This value is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This value should be a valid expression.' => 'This value should be a valid expression.',
    'This value is not a valid CSS color.' => 'This value is not a valid CSS color.',
    'This value is not a valid CIDR notation.' => 'This value is not a valid CIDR notation.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'The value of the netmask should be between {{ min }} and {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.',
    'The password strength is too low. Please use a stronger password.' => 'The password strength is too low. Please use a stronger password.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'This value contains characters that are not allowed by the current restriction-level.',
    'Using invisible characters is not allowed.' => 'Using invisible characters is not allowed.',
    'Mixing numbers from different scripts is not allowed.' => 'Mixing numbers from different scripts is not allowed.',
    'Using hidden overlay characters is not allowed.' => 'Using hidden overlay characters is not allowed.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.',
    'This value is not a valid MAC address.' => 'This value is not a valid MAC address.',
    'This URL is missing a top-level domain.' => 'This URL is missing a top-level domain.',
    'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.' => 'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.',
    'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.' => 'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.',
    'This value does not represent a valid week in the ISO 8601 format.' => 'This value does not represent a valid week in the ISO 8601 format.',
    'This value is not a valid week.' => 'This value is not a valid week.',
    'This value should not be before week "{{ min }}".' => 'This value should not be before week "{{ min }}".',
    'This value should not be after week "{{ max }}".' => 'This value should not be after week "{{ max }}".',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Too many failed login attempts, please try again in %minutes% minute.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Too many failed login attempts, please try again in %minutes% minutes.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Previous',
    'label_next' => 'Next',
    'filter_searchword' => 'Searchword...',
  ),
  'messages' => 
  array (
    'Signed in as' => 'Signed in as',
    'Your Profile' => 'Your Profile',
    'Create Ticket' => 'Create Ticket',
    'Create Agent' => 'Create Agent',
    'Create Customer' => 'Create Customer',
    'Sign Out' => 'Sign Out',
    'Default Language (Optional)' => 'Default Language (Optional)',
    'Username/Email' => 'Username/Email',
    'create new' => 'create new',
    'Ticket Information' => 'Ticket Information',
    'CC/BCC' => 'CC/BCC',
    'Success! Label created successfully.' => 'Success! Label created successfully.',
    'Success! Label removed successfully.' => 'Success! Label removed successfully.',
    'Reports' => 'Reports',
    'Rating' => 'Rating',
    'Kudos Rating' => 'Kudos Rating',
    'Remove profile picture' => 'Remove profile picture',
    'Success ! Profile updated successfully.' => 'Success ! Profile updated successfully.',
    'Howdy' => 'Howdy',
    'Form successfully updated.' => 'Form successfully updated.',
    'NEW FORM' => 'NEW FORM',
    'Text Box' => 'Text Box',
    'Text Area' => 'Text Area',
    'Select' => 'Select',
    'Radio' => 'Radio',
    'Checkbox' => 'Checkbox',
    'Date' => 'Date',
    'Both Date and Time' => 'Both Date and Time',
    'Choose a status' => 'Choose a status',
    'Choose a group' => 'Choose a group',
    'Choose your default timeformat' => 'Choose your default timeformat',
    'Can manage Group\'s Saved Reply' => 'Can manage Group\'s Saved Reply',
    'Can manage agent activity' => 'Can manage agent activity',
    'Slug is the url identity of this article. We will help you to create valid slug at time of typing.' => 'Slug is the url identity of this article. We will help you to create valid slug at time of typing.',
    'The URL for this article' => 'The URL for this article',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A page\'s title tag and meta description are usually shown whenever that page appears in search engine results' => 'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A page\'s title tag and meta description are usually shown whenever that page appears in search engine results',
    'comma separated (,)' => 'comma separated (,)',
    'Article Title' => 'Article Title',
    'Start typing few charactors and add set of relevant article from the list' => 'Start typing few charactors and add set of relevant article from the list',
    'Success! Announcement data saved successfully.' => 'Success! Announcement data saved successfully.',
    'Success! Category has been added successfully.' => 'Success! Category has been added successfully.',
    'Success ! Agent added successfully.' => 'Success ! Agent added successfully.',
    'Success! Privilege information saved successfully.' => 'Success! Privilege information saved successfully.',
    'Edit Prepared Response' => 'Edit Prepared Response',
    'Success! Type removed successfully.' => 'Success! Type removed successfully.',
    'No results available' => 'No results available',
    'Success ! Prepared Response applied successfully.' => 'Success ! Prepared Response applied successfully.',
    'Note added to ticket successfully.' => 'Note added to ticket successfully.',
    'Ticket status update to Spam' => 'Ticket status update to Spam',
    'Ticket status update to Closed' => 'Ticket status update to Closed',
    'Success! Label updated successfully.' => 'Success! Label updated successfully.',
    'Success ! Helpdesk details saved successfully' => 'Success ! Helpdesk details saved successfully',
    'Can manage marketing announcement' => 'Can manage marketing announcement',
    'User Forgot Password' => 'User Forgot Password',
    'Agent Deleted' => 'Agent Deleted',
    'Agent Update' => 'Agent Update',
    'Customer Update' => 'Customer Update',
    'Customer Deleted' => 'Customer Deleted',
    'Agent Updated' => 'Agent Updated',
    'Agent Reply' => 'Agent Reply',
    'Collaborator Added' => 'Collaborator Added',
    'Collaborator Reply' => 'Collaborator Reply',
    'Customer Reply' => 'Customer Reply',
    'Ticket Deleted' => 'Ticket Deleted',
    'Group Updated' => 'Group Updated',
    'Note Added' => 'Note Added',
    'Priority Updated' => 'Priority Updated',
    'Status Updated' => 'Status Updated',
    'Team Updated' => 'Team Updated',
    'Thread Updated' => 'Thread Updated',
    'Type Updated' => 'Type Updated',
    'From Email' => 'From Email',
    'To Email' => 'To Email',
    'Is Equal To' => 'Is Equal To',
    'Is Not Equal To' => 'Is Not Equal To',
    'Contains' => 'Contains',
    'Does Not Contain' => 'Does Not Contain',
    'Starts With' => 'Starts With',
    'Ends With' => 'Ends With',
    'Before On' => 'Before On',
    'After On' => 'After On',
    'Mail To User' => 'Mail To User',
    'Transfer Tickets' => 'Transfer Tickets',
    'Mail To Customer' => 'Mail To Customer',
    'Permanently delete from Inbox' => 'Permanently delete from Inbox',
    'Agent Activity' => 'Agent Activity',
    'Report From' => 'Report From',
    'Search Agent' => 'Search Agent',
    'Agent Last Reply' => 'Agent Last Reply',
    'View analytics and insights to serve a better experience for your customers' => 'Analytics and insight regarding your workflow',
    'Marketing Announcement' => 'Marketing Announcement',
    'Advertisement' => 'Advertisement',
    'Announcement' => 'Announcement',
    'New Announcement' => 'New Announcement',
    'Add Announcement' => 'Add Announcement',
    'Edit Announcement' => 'Edit Announcement',
    'Promo Text' => 'Promo Text',
    'Promo Tag' => 'Promo Tag',
    'Choose a promo tag' => 'Choose a promo tag',
    'Tag-Color' => 'Tag-Color',
    'Tag background color' => 'Tag background color',
    'Link Text' => 'Link Text',
    'Link URL' => 'Link URL',
    'Apps' => 'Apps',
    'Integrate apps as per your needs to get things done faster than ever' => 'Install new custom apps to boost your productivity - <a href=\'https://store.webkul.com/UVdesk/UVdesk-Open-Source.html\' style=\'font-weight: bold\' target=\'_blank\'>Explore Now</a>',
    'Explore Apps' => 'Explore Apps',
    'Form Builder' => 'Form Builder',
    'Knowledgebase' => 'Knowledgebase',
    'Knowledgebase is a source of rigid and complex information which helps Customers to help themselves' => 'Help your customers help themselves! Save time on support by building your knowledge base.',
    'Articles' => 'Articles',
    'Categories' => 'Categories',
    'Folders' => 'Folders',
    'FOLDERS' => 'FOLDERS',
    'Productivity' => 'Productivity',
    'Automate your processes by creating set of rules and presets to respond faster to the tickets' => 'Create automation rules to speed up your workflow.',
    'Prepared Responses' => 'Prepared Responses',
    'Saved Replies' => 'Saved Replies',
    'Edit Saved Reply' => 'Edit Saved Reply',
    'Ticket Types' => 'Ticket Types',
    'Workflows' => 'Workflows',
    'Settings' => 'Settings',
    'Manage your Brand Identity, Company Information and other details at a glance' => 'Manage your Brand Identity, Company Information and other details at a glance',
    'Branding' => 'Branding',
    'Custom Fields' => 'Custom Fields',
    'Email Settings' => 'Email Settings',
    'Email Templates' => 'Email Templates',
    'Mailbox' => 'Mailbox',
    'Spam Settings' => 'Spam Settings',
    'Swift Mailer' => 'Swift Mailer',
    'Tags' => 'Tags',
    'Users' => 'Users',
    'Control your Groups, Teams, Agents and Customers' => 'Manage your Groups, Teams, Agents and Customers',
    'Agents' => 'Agents',
    'Customers' => 'Customers',
    'Groups' => 'Groups',
    'Privileges' => 'Privileges',
    'Teams' => 'Teams',
    'Applications' => 'Applications',
    'ECommerce Order Syncronization' => 'eCommerce Order Syncronization',
    'Import ecommerce order details to your support tickets from different available platforms' => 'Import eCommerce order details to your support tickets from different available platforms',
    'Search' => 'Search',
    'Sort By' => 'Sort By',
    'Sort By:' => 'Sort By:',
    'Status' => 'Status',
    'Created At' => 'Created At',
    'Name' => 'Name',
    'All' => 'All',
    'Published' => 'Published',
    'Draft' => 'Draft',
    'New Folder' => 'New Folder',
    'Create Knowledgebase Folder' => 'Create Knowledgebase Folder',
    'You did not add any folder to your Knowledgebase yet, Create your first Folder and start adding Categories/Articles to make your customers help themselves.' => 'You don\'t have any folders yet! Create your first folder and start adding articles.',
    'Clear Filters' => 'Clear Filters',
    'Back' => 'Back',
    'Open' => 'Open',
    'Pending' => 'Pending',
    'Answered' => 'Answered',
    'Resolved' => 'Resolved',
    'Closed' => 'Closed',
    'Spam' => 'Spam',
    'New' => 'New',
    'UnAssigned' => 'Unassigned',
    'UnAnswered' => 'Unanswered',
    'My Tickets' => 'My Tickets',
    'Starred' => 'Starred',
    'Trashed' => 'Trashed',
    'New Label' => 'New Label',
    'Tickets' => 'Tickets',
    'Ticket Id' => 'Ticket Id',
    'Last Replied' => 'Last Replied',
    'Assign To' => 'Assign To',
    'After Reply' => 'After Reply',
    'Customer Email' => 'Customer Email',
    'Customer Name' => 'Customer Name',
    'Assets Visibility' => 'Assets Visibility',
    'Channel/Source' => 'Channel/Source',
    'Channel' => 'Channel',
    'Website' => 'Website',
    'Timestamp' => 'Timestamp',
    'TimeStamp' => 'TimeStamp',
    'Team' => 'Team',
    'Type' => 'Type',
    'Replies' => 'Replies',
    'Agent' => 'Agent',
    'ID' => 'ID',
    'Subject' => 'Subject',
    'Last Reply' => 'Last Reply',
    'Filter View' => 'Filter View',
    'Please select CAPTCHA' => 'Please select CAPTCHA',
    'Warning ! Please select correct CAPTCHA !' => 'CAPTCHA Failed, please try again',
    'reCAPTCHA Setting' => 'reCAPTCHA Setting',
    'reCAPTCHA Site Key' => 'reCAPTCHA Site Key',
    'reCAPTCHA Secret key' => 'reCAPTCHA Secret key',
    'reCAPTCHA Status' => 'reCAPTCHA Status',
    'reCAPTCHA is Active' => 'reCAPTCHA is Active',
    'Save set of filters as a preset to stay more productive' => 'Save filters as preset',
    'Saved Filters' => 'Saved Filters',
    'No saved filter created' => 'No saved filter created',
    'Customer' => 'Customer',
    'Priority' => 'Priority',
    'Tag' => 'Tag',
    'Source' => 'Source',
    'Before' => 'Before',
    'After' => 'After',
    'Replies less than' => 'Replies less than',
    'Replies more than' => 'Replies more than',
    'Clear All' => 'Clear All',
    'Account' => 'Account',
    'Profile' => 'Profile',
    'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format' => 'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format',
    'First Name' => 'First Name',
    'Last Name' => 'Last Name',
    'Email' => 'Email',
    'Contact Number' => 'Contact Number',
    'Timezone' => 'Timezone',
    'Africa/Abidjan' => 'Africa/Abidjan',
    'Africa/Accra' => 'Africa/Accra',
    'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
    'Africa/Algiers' => 'Africa/Algiers',
    'Africa/Asmara' => 'Africa/Asmara',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Bangui' => 'Africa/Bangui',
    'Africa/Banjul' => 'Africa/Banjul',
    'Africa/Bissau' => 'Africa/Bissau',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Brazzaville' => 'Africa/Brazzaville',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Cairo' => 'Africa/Cairo',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Africa/Conakry' => 'Africa/Conakry',
    'Africa/Dakar' => 'Africa/Dakar',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Djibouti' => 'Africa/Djibouti',
    'Africa/Douala' => 'Africa/Douala',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Gaborone' => 'Africa/Gaborone',
    'Africa/Harare' => 'Africa/Harare',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Juba' => 'Africa/Juba',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Kigali' => 'Africa/Kigali',
    'Africa/Kinshasa' => 'Africa/Kinshasa',
    'Africa/Lagos' => 'Africa/Lagos',
    'Africa/Libreville' => 'Africa/Libreville',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Luanda' => 'Africa/Luanda',
    'Africa/Lubumbashi' => 'Africa/Lubumbashi',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Malabo' => 'Africa/Malabo',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Ndjamena' => 'Africa/Ndjamena',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Porto-Novo' => 'Africa/Porto-Novo',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'America/Adak' => 'America/Adak',
    'America/Anchorage' => 'America/Anchorage',
    'America/Anguilla' => 'America/Anguilla',
    'America/Antigua' => 'America/Antigua',
    'America/Araguaina' => 'America/Araguaina',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Salta' => 'America/Argentina/Salta',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/San_Luis' => 'America/Argentina/San_Luis',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/Asuncion' => 'America/Asuncion',
    'America/Atikokan' => 'America/Atikokan',
    'America/Bahia' => 'America/Bahia',
    'America/Bahia_Banderas' => 'America/Bahia_Banderas',
    'America/Barbados' => 'America/Barbados',
    'America/Belem' => 'America/Belem',
    'America/Belize' => 'America/Belize',
    'America/Blanc-Sablon' => 'America/Blanc-Sablon',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Bogota' => 'America/Bogota',
    'America/Boise' => 'America/Boise',
    'America/Cambridge_Bay' => 'America/Cambridge_Bay',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cancun' => 'America/Cancun',
    'America/Caracas' => 'America/Caracas',
    'America/Cayenne' => 'America/Cayenne',
    'America/Cayman' => 'America/Cayman',
    'America/Chicago' => 'America/Chicago',
    'America/Chihuahua' => 'America/Chihuahua',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Creston' => 'America/Creston',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Curacao' => 'America/Curacao',
    'America/Danmarkshavn' => 'America/Danmarkshavn',
    'America/Dawson' => 'America/Dawson',
    'America/Dawson_Creek' => 'America/Dawson_Creek',
    'America/Denver' => 'America/Denver',
    'America/Detroit' => 'America/Detroit',
    'America/Dominica' => 'America/Dominica',
    'America/Edmonton' => 'America/Edmonton',
    'America/Eirunepe' => 'America/Eirunepe',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Fort_Nelson' => 'America/Fort_Nelson',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Glace_Bay' => 'America/Glace_Bay',
    'America/Godthab' => 'America/Godthab',
    'America/Goose_Bay' => 'America/Goose_Bay',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Guayaquil' => 'America/Guayaquil',
    'America/Guyana' => 'America/Guyana',
    'America/Halifax' => 'America/Halifax',
    'America/Havana' => 'America/Havana',
    'America/Hermosillo' => 'America/Hermosillo',
    'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
    'America/Indiana/Knox' => 'America/Indiana/Knox',
    'America/Indiana/Marengo' => 'America/Indiana/Marengo',
    'America/Indiana/Petersburg' => 'America/Indiana/Petersburg',
    'America/Indiana/Tell_City' => 'America/Indiana/Tell_City',
    'America/Indiana/Vevay' => 'America/Indiana/Vevay',
    'America/Indiana/Vincennes' => 'America/Indiana/Vincennes',
    'America/Indiana/Winamac' => 'America/Indiana/Winamac',
    'America/Inuvik' => 'America/Inuvik',
    'America/Iqaluit' => 'America/Iqaluit',
    'America/Jamaica' => 'America/Jamaica',
    'America/Juneau' => 'America/Juneau',
    'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
    'America/Kralendijk' => 'America/Kralendijk',
    'America/La_Paz' => 'America/La_Paz',
    'America/Lima' => 'America/Lima',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Lower_Princes' => 'America/Lower_Princes',
    'America/Maceio' => 'America/Maceio',
    'America/Managua' => 'America/Managua',
    'America/Manaus' => 'America/Manaus',
    'America/Marigot' => 'America/Marigot',
    'America/Martinique' => 'America/Martinique',
    'America/Matamoros' => 'America/Matamoros',
    'America/Mazatlan' => 'America/Mazatlan',
    'America/Menominee' => 'America/Menominee',
    'America/Merida' => 'America/Merida',
    'America/Metlakatla' => 'America/Metlakatla',
    'America/Mexico_City' => 'America/Mexico_City',
    'America/Miquelon' => 'America/Miquelon',
    'America/Moncton' => 'America/Moncton',
    'America/Monterrey' => 'America/Monterrey',
    'America/Montevideo' => 'America/Montevideo',
    'America/Montserrat' => 'America/Montserrat',
    'America/Nassau' => 'America/Nassau',
    'America/New_York' => 'America/New_York',
    'America/Nipigon' => 'America/Nipigon',
    'America/Nome' => 'America/Nome',
    'America/Noronha' => 'America/Noronha',
    'America/North_Dakota/Beulah' => 'America/North_Dakota/Beulah',
    'America/North_Dakota' => 'America/North_Dakota',
    'America/Ojinaga' => 'America/Ojinaga',
    'America/Panama' => 'America/Panama',
    'America/Pangnirtung' => 'America/Pangnirtung',
    'America/Paramaribo' => 'America/Paramaribo',
    'America/Phoenix' => 'America/Phoenix',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Port_of_Spain' => 'America/Port_of_Spain',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/Punta_Arenas' => 'America/Punta_Arenas',
    'America/Rainy_River' => 'America/Rainy_River',
    'America/Rankin_Inlet' => 'America/Rankin_Inlet',
    'America/Recife' => 'America/Recife',
    'America/Regina' => 'America/Regina',
    'America/Resolute' => 'America/Resolute',
    'America/Rio_Branco' => 'America/Rio_Branco',
    'America/Santarem' => 'America/Santarem',
    'America/Santiago' => 'America/Santiago',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Scoresbysund' => 'America/Scoresbysund',
    'America/Sitka' => 'America/Sitka',
    'America/St_Barthelemy' => 'America/St_Barthelemy',
    'America/St_Johns' => 'America/St_Johns',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Swift_Current' => 'America/Swift_Current',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Thule' => 'America/Thule',
    'America/Thunder_Bay' => 'America/Thunder_Bay',
    'America/Tijuana' => 'America/Tijuana',
    'America/Toronto' => 'America/Toronto',
    'America/Tortola' => 'America/Tortola',
    'America/Vancouver' => 'America/Vancouver',
    'America/Whitehorse' => 'America/Whitehorse',
    'America/Winnipeg' => 'America/Winnipeg',
    'America/Yakutat' => 'America/Yakutat',
    'America/Yellowknife' => 'America/Yellowknife',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Macquarie' => 'Antarctica/Macquarie',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Troll' => 'Antarctica/Troll',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Arctic/Longyearbyen' => 'Arctic/Longyearbyen',
    'Asia/Aden' => 'Asia/Aden',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Atyrau' => 'Asia/Atyrau',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Barnaul' => 'Asia/Barnaul',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Chita' => 'Asia/Chita',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Famagusta' => 'Asia/Famagusta',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Hebron' => 'Asia/Hebron',
    'Asia/Ho_Chi_Minh' => 'Asia/Ho_Chi_Minh',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Jerusalem' => 'Asia/Jerusalem',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Kathmandu' => 'Asia/Kathmandu',
    'Asia/Khandyga' => 'Asia/Khandyga',
    'Asia/Kolkata' => 'Asia/Kolkata',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Novokuznetsk' => 'Asia/Novokuznetsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Qostanay' => 'Asia/Qostanay',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Srednekolymsk' => 'Asia/Srednekolymsk',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Tomsk' => 'Asia/Tomsk',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Ust-Nera' => 'Asia/Ust-Nera',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Yangon' => 'Asia/Yangon',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Atlantic/Faroe' => 'Atlantic/Faroe',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Eucla' => 'Australia/Eucla',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Lord_Howe' => 'Australia/Lord_Howe',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Sydney' => 'Australia/Sydney',
    'Europe/Amsterdam' => 'Europe/Amsterdam',
    'Europe/Andorra' => 'Europe/Andorra',
    'Europe/Astrakhan' => 'Europe/Astrakhan',
    'Europe/Athens' => 'Europe/Athens',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Berlin' => 'Europe/Berlin',
    'Europe/Bratislava' => 'Europe/Bratislava',
    'Europe/Brussels' => 'Europe/Brussels',
    'Europe/Bucharest' => 'Europe/Bucharest',
    'Europe/Budapest' => 'Europe/Budapest',
    'Europe/Busingen' => 'Europe/Busingen',
    'Europe/Chisinau' => 'Europe/Chisinau',
    'Europe/Copenhagen' => 'Europe/Copenhagen',
    'Europe/Dublin' => 'Europe/Dublin',
    'Europe/Gibraltar' => 'Europe/Gibraltar',
    'Europe/Guernsey' => 'Europe/Guernsey',
    'Europe/Helsinki' => 'Europe/Helsinki',
    'Europe/Isle_of_Man' => 'Europe/Isle_of_Man',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Jersey' => 'Europe/Jersey',
    'Europe/Kaliningrad' => 'Europe/Kaliningrad',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Kirov' => 'Europe/Kirov',
    'Europe/Lisbon' => 'Europe/Lisbon',
    'Europe/Ljubljana' => 'Europe/Ljubljana',
    'Europe/London' => 'Europe/London',
    'Europe/Luxembourg' => 'Europe/Luxembourg',
    'Europe/Madrid' => 'Europe/Madrid',
    'Europe/Malta' => 'Europe/Malta',
    'Europe/Mariehamn' => 'Europe/Mariehamn',
    'Europe/Minsk' => 'Europe/Minsk',
    'Europe/Monaco' => 'Europe/Monaco',
    'Europe/Moscow' => 'Europe/Moscow',
    'Europe/Oslo' => 'Europe/Oslo',
    'Europe/Paris' => 'Europe/Paris',
    'Europe/Podgorica' => 'Europe/Podgorica',
    'Europe/Prague' => 'Europe/Prague',
    'Europe/Riga' => 'Europe/Riga',
    'Europe/Rome' => 'Europe/Rome',
    'Europe/Samara' => 'Europe/Samara',
    'Europe/San_Marino' => 'Europe/San_Marino',
    'Europe/Sarajevo' => 'Europe/Sarajevo',
    'Europe/Saratov' => 'Europe/Saratov',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'Europe/Skopje' => 'Europe/Skopje',
    'Europe/Sofia' => 'Europe/Sofia',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Tallinn' => 'Europe/Tallinn',
    'Europe/Tirane' => 'Europe/Tirane',
    'Europe/Ulyanovsk' => 'Europe/Ulyanovsk',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Vaduz' => 'Europe/Vaduz',
    'Europe/Vatican' => 'Europe/Vatican',
    'Europe/Vienna' => 'Europe/Vienna',
    'Europe/Vilnius' => 'Europe/Vilnius',
    'Europe/Volgograd' => 'Europe/Volgograd',
    'Europe/Warsaw' => 'Europe/Warsaw',
    'Europe/Zagreb' => 'Europe/Zagreb',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Zurich' => 'Europe/Zurich',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Indian/Chagos' => 'Indian/Chagos',
    'Indian/Christmas' => 'Indian/Christmas',
    'Indian/Cocos' => 'Indian/Cocos',
    'Indian/Comoro' => 'Indian/Comoro',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Indian/Mahe' => 'Indian/Mahe',
    'Indian/Maldives' => 'Indian/Maldives',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Indian/Reunion' => 'Indian/Reunion',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Bougainville' => 'Pacific/Bougainville',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Chuuk' => 'Pacific/Chuuk',
    'Pacific/Easter' => 'Pacific/Easter',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pohnpei' => 'Pacific/Pohnpei',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'UTC' => 'UTC',
    'Time Format' => 'Time Format',
    'Choose your default timezone' => 'Choose your default timezone',
    'Signature' => 'Signature',
    'User signature will be append at the bottom of ticket reply box' => 'Your signature will be appended to the bottom of every ticket reply you create.',
    'Password' => 'Password',
    'Password will remain same if you are not entering something in this field' => 'Password not changed!',
    'Confirm Password' => 'Confirm Password',
    'Password must contain minimum 8 character length, at least two letters (not case sensitive), one number, one special character(space is not allowed).' => 'Password must be at least 8 characters, two letters (not case-sensitive), one number, and one special character (space is not allowed).',
    'Save Changes' => 'Save Changes',
    'SAVE CHANGES' => 'SAVE CHANGES',
    'CREATE TICKET' => 'CREATE TICKET',
    'Customer full name' => 'Customer full name',
    'Customer email address' => 'Customer email address',
    'Select Type' => 'Select Type',
    'Support' => 'Support',
    'Choose ticket type' => 'Choose ticket type',
    'Ticket subject' => 'Ticket subject',
    'Message' => 'Message',
    'Query Message' => 'Query Message',
    'Add Attachment' => 'Add Attachment',
    'This field is mandatory' => 'This field is mandatory',
    'General' => 'General',
    'Designation' => 'Designation',
    'Contant Number' => 'Content Number',
    'User signature will be append in the bottom of ticket reply box' => 'Your signature will be appended to the bottom of every ticket reply you create.',
    'Account Status' => 'Account Status',
    'Account is Active' => 'Account is Active',
    'Assigning group(s) to user to view tickets regardless assignment.' => 'Add user to group to view tickets regardless of owner.',
    'Default' => 'Default',
    'Select All' => 'Select All',
    'Remove All' => 'Remove All',
    'Assigning team(s) to user to view tickets regardless assignment.' => 'Add user to team to view tickets regardless of owner.',
    'No Team added !' => 'No Team added!',
    'Permission' => 'Permission',
    'Role' => 'Role',
    'Administrator' => 'Administrator',
    'Select agent role' => 'Select agent role',
    'Add Customer' => 'Add Customer',
    'Action' => 'Action',
    'Account Owner' => 'Account Owner',
    'Active' => 'Active',
    'Edit' => 'Edit',
    'Delete' => 'Delete',
    'Disabled' => 'Disabled',
    'New Group' => 'New Group',
    'Default Privileges' => 'Default Privileges',
    'New Privileges' => 'New Privileges',
    'NEW PRIVILEGE' => 'NEW PRIVILEGE',
    'New Privilege' => 'New Privilege',
    'New Team' => 'New Team',
    'No Record Found' => 'No Record Found',
    'Order Synchronization' => 'Order Synchronization',
    'Easily integrate different ecommerce platforms with your helpdesk which can then be later used to swiftly integrate ecommerce order details with your support tickets.' => 'Easily integrate different eCommerce platforms with your helpdesk to show order details within support tickets.',
    'BigCommerce' => 'BigCommerce',
    'No channels have been added.' => 'No channels have been added.',
    'Add BigCommerce Store' => 'Add BigCommerce Store',
    'ADD BIGCOMMERCE STORE' => 'ADD BIGCOMMERCE STORE',
    'Mangento' => 'Mangento',
    'Add Magento Store' => 'Add Magento Store',
    'OpenCart' => 'OpenCart',
    'Add OpenCart Store' => 'Add OpenCart Store',
    'ADD OPENCART STORE' => 'ADD OPENCART STORE',
    'Shopify' => 'Shopify',
    'Add Shopify Store' => 'Add Shopify Store',
    'ADD SHOPIFY STORE' => 'ADD SHOPIFY STORE',
    'Integrate a new BigCommerce store' => 'Integrate a new BigCommerce store',
    'Your BigCommerce Store Name' => 'Your BigCommerce Store Name',
    'Your BigCommerce Store Hash' => 'Your BigCommerce Store Hash',
    'Your BigCommerce Api Token' => 'Your BigCommerce Api Token',
    'Your BigCommerce Api Client ID' => 'Your BigCommerce Api Client ID',
    'Enable Channel' => 'Enable Channel',
    'Add Store' => 'Add Store',
    'ADD STORE' => 'ADD STORE',
    'Integrate a new Magento store' => 'Integrate a new Magento store',
    'Your Magento Api Username' => 'Your Magento Api Username',
    'Your Magento Api Password' => 'Your Magento Api Password',
    'Integrate a new OpenCart store' => 'Integrate a new OpenCart store',
    'Your OpenCart Api Key' => 'Your OpenCart Api Key',
    'Your Shopify Store Name' => 'Your Shopify Store Name',
    'Your Shopify Api Key' => 'Your Shopify Api Key',
    'Your Shopify Api Password' => 'Your Shopify Api Password',
    'Easily embed custom form to help generate helpdesk tickets.' => 'Easily embed custom forms for creating helpdesk tickets.',
    'Form-Builder' => 'Form-Builder',
    'Add Formbuilder' => 'Add Formbuilder',
    'ADD FORMBUILDER' => 'ADD FORMBUILDER',
    'No FormBuilder have been added.' => 'No FormBuilder was added.',
    'Create a New Custom Form Below' => 'Create a New Custom Form Below',
    'Form Name' => 'Form Name',
    'It will be shown in the list of created forms' => 'Displayed in the list of created forms',
    'MANDATORY FIELDS' => 'MANDATORY FIELDS',
    'These fields will be visible in form and cant be edited' => 'These fields will be visible in this form and can\'t be edited',
    'Reply' => 'Reply',
    'OPTIONAL FIELDS' => 'OPTIONAL FIELDS',
    'Select These Fields to Add in your Form' => 'Select fields to add',
    'GDPR' => 'GDPR',
    'Order' => 'Order',
    'Categorybuilder' => 'Categorybuilder',
    'File' => 'File',
    'Add Form' => 'Add Form',
    'ADD FORM' => 'ADD FORM',
    'UPDATE FORM' => 'UPDATE FORM',
    'Update Form' => 'Update Form',
    'Embed' => 'Embed',
    'EMBED' => 'EMBED',
    'EMBED FORMBUILDER' => 'EMBED FORMBUILDER',
    'Embed Formbuilder' => 'Embed Formbuilder',
    'Visit' => 'Visit',
    'VISIT' => 'VISIT',
    'Code' => 'Code',
    'Total Ticket(s)' => 'Total Ticket(s)',
    'Ticket Count' => 'Ticket Count',
    'SwiftMailer Configurations' => 'SwiftMailer Configurations',
    'No swiftmailer configurations found' => 'No SwiftMailer configurations found',
    'CREATE CONFIGURATION' => 'CREATE CONFIGURATION',
    'Add configuration' => 'Add configuration',
    'Update configuration' => 'Update configuration',
    'Mailer ID' => 'Mailer ID',
    'Mailer ID - Leave blank to automatically create id' => 'Mailer ID - Leave blank to automatically create id',
    'Transport Type' => 'Transport Type',
    'SMTP' => 'SMTP',
    'Enable Delivery' => 'Enable Delivery',
    'Server' => 'Server',
    'Port' => 'Port',
    'Encryption Mode' => 'Encryption Mode',
    'ssl' => 'ssl',
    'tsl' => 'tsl',
    'None' => 'None',
    'Authentication Mode' => 'Authentication Mode',
    'login' => 'login',
    'API' => 'API',
    'Plain' => 'Plain',
    'CRAM-MD5' => 'CRAM-MD5',
    'Sender Address' => 'Sender Address',
    'Delivery Address' => 'Delivery Address',
    'Block Spam' => 'Block Spam',
    'Black list' => 'Black list',
    'Comma (,) separated values (Eg. support@example.com, @example.com, 68.98.31.226)' => 'Comma separated values (Eg. support@example.com, @example.com, 68.98.31.226)',
    'White list' => 'White list',
    'Mailbox Settings' => 'Mailbox Settings',
    'No mailbox configurations found' => 'No mailbox configurations found',
    'NEW MAILBOX' => 'NEW MAILBOX',
    'New Mailbox' => 'New Mailbox',
    'Update Mailbox' => 'Update Mailbox',
    'Add Mailbox' => 'Add Mailbox',
    'Mailbox ID - Leave blank to automatically create id' => 'Mailbox ID - Leave blank to automatically create id',
    'Mailbox Name' => 'Mailbox Name',
    'Enable Mailbox' => 'Enable Mailbox',
    'Incoming Mail (IMAP) Server' => 'Incoming Mail (IMAP) Server',
    'Configure your imap settings which will be used to fetch emails from your mailbox.' => 'Configure your imap settings in order to fetch new mail from your inbox.',
    'Transport' => 'Transport',
    'IMAP' => 'IMAP',
    'Gmail' => 'Gmail',
    'Yahoo' => 'Yahoo',
    'Host' => 'Host',
    'IMAP Host' => 'IMAP Host',
    'Email address' => 'Email address',
    'Associated Password' => 'Associated Password',
    'Outgoing Mail (SMTP) Server' => 'Outgoing Mail (SMTP) Server',
    'Select a valid Swift Mailer configuration which will be used to send emails through your mailbox.' => 'Select the SwiftMailer config to use for sending emails through your account.',
    'Swift Mailer ID' => 'Swift Mailer ID',
    'None Selected' => 'None Selected',
    'Create Mailbox' => 'Create Mailbox',
    'CREATE MAILBOX' => 'CREATE MAILBOX',
    'New Template' => 'New Template',
    'NEW TEMPLATE' => 'NEW TEMPLATE',
    'Customer Forgot Password' => 'Customer Forgot Password',
    'Customer Account Created' => 'Customer Account Created',
    'Ticket generated success mail to customer' => 'Ticket successfully generated and sent to customer',
    'Customer Reply To The Agent' => 'Customer reply',
    'Ticket Assign' => 'Ticket Assign',
    'Agent Forgot Password' => 'Agent Forgot Password',
    'Agent Account Created' => 'Agent Account Created',
    'Ticket generated by customer' => 'Ticket generated by customer',
    'Agent Reply To The Customers ticket' => 'Agent reply',
    'Email template name' => 'Email template name',
    'Email template subject' => 'Email template subject',
    'Template For' => 'Template For',
    'Nothing Selected' => 'Nothing Selected',
    'email template will be used for work related with selected option' => 'email template will be used for selected option',
    'Email template body' => 'Email template body',
    'Body' => 'Body',
    'placeholders' => 'placeholders',
    'Ticket Subject' => 'Ticket Subject',
    'Ticket Message' => 'Ticket Message',
    'Ticket Attachments' => 'Ticket Attachments',
    'Ticket Tags' => 'Ticket Tags',
    'Ticket Source' => 'Ticket Source',
    'Ticket Status' => 'Ticket Status',
    'Ticket Priority' => 'Ticket Priority',
    'Ticket Group' => 'Ticket Group',
    'Ticket Team' => 'Ticket Team',
    'Ticket Thread Message' => 'Ticket Thread Message',
    'Ticket Customer Name' => 'Ticket Customer Name',
    'Ticket Customer Email' => 'Ticket Customer Email',
    'Ticket Agent Name' => 'Ticket Agent Name',
    'Ticket Agent Email' => 'Ticket Agent Email',
    'Ticket Agent Link' => 'Ticket Agent Link',
    'Ticket Customer Link' => 'Ticket Customer Link',
    'Last Collaborator Name' => 'Last Collaborator Name',
    'Last Collaborator Email' => 'Last Collaborator Email',
    'Agent/ Customer Name' => 'Agent/ Customer Name',
    'Account Validation Link' => 'Account Validation Link',
    'Password Forgot Link' => 'Password Forgot Link',
    'Company Name' => 'Company Name',
    'Company Logo' => 'Company Logo',
    'Company URL' => 'Company URL',
    'Swiftmailer id (Select from drop down)' => 'Swiftmailer id (Select from drop down)',
    'SwiftMailer' => 'SwiftMailer',
    'PROCEED' => 'PROCEED',
    'Proceed' => 'Proceed',
    'Theme Color' => 'Theme Color',
    'Customer Created' => 'Customer Created',
    'Agent Created' => 'Agent Created',
    'Ticket Created' => 'Ticket Created',
    'Agent Replied on Ticket' => 'Agent replied to ticket',
    'Customer Replied on Ticket' => 'Customer replied to ticket',
    'Workflow Status' => 'Workflow status',
    'Workflow is Active' => 'Workflow is active',
    'Events' => 'Events',
    'An event automatically triggers to check conditions and perform a respective pre-defined set of actions' => 'An event automatically triggers to check conditions and perform a set of pre-defined actions',
    'Select an Event' => 'Select an Event',
    'Add More' => 'Add More',
    'Conditions' => 'Conditions',
    'Conditions are set of rules which checks for specific scenarios and are triggered on specific occasions' => 'Conditions are sets of rules which check for specific scenarios.',
    'Subject or Description' => 'Subject or description',
    'Actions' => 'Actions',
    'An action not only reduces the workload but also makes it quite easier for ticket automation' => 'Actions help you automate tickets',
    'Select an Action' => 'Select an action',
    'Add Note' => 'Add note',
    'Mail to agent' => 'Mail to agent',
    'Mail to customer' => 'Mail to customer',
    'Mail to group' => 'Mail to group',
    'Mail to last collaborator' => 'Mail to last collaborator',
    'Mail to team' => 'Mail to team',
    'Mark Spam' => 'Mark spam',
    'Assign to agent' => 'Assign to agent',
    'Assign to group' => 'Assign to group',
    'Set Priority As' => 'Set Priority As',
    'Set Status As' => 'Set Status As',
    'Set Tag As' => 'Set Tag As',
    'Set Label As' => 'Set Label As',
    'Assign to team' => 'Assign to team',
    'Set Type As' => 'Set Type As',
    'Add Workflow' => 'Add Workflow',
    'ADD WORKFLOW' => 'ADD WORKFLOW',
    'Ticket Type code' => 'Ticket Type code',
    'Ticket Type description' => 'Ticket Type description',
    'Type Status' => 'Type Status',
    'Type is Active' => 'Type is Active',
    'Add Save Reply' => 'Add Save Reply',
    'Saved reply name' => 'Saved reply name',
    'Share saved reply with user(s) in these group(s)' => 'Share saved reply with user(s) in these group(s)',
    'Share saved reply with user(s) in these teams(s)' => 'Share saved reply with user(s) in these teams(s)',
    'Saved reply Body' => 'Saved reply body',
    'New Prepared Response' => 'New Prepared Response',
    'Prepared Response Status' => 'Prepared Response Status',
    'Prepared Response is Active' => 'Prepared Response is Active',
    'Share prepared response with user(s) in these group(s)' => 'Share prepared response with user(s) in these group(s)',
    'Share prepared response with user(s) in these teams(s)' => 'Share prepared response with user(s) in these teams(s)',
    'ADD PREPARED RESPONSE' => 'ADD PREPARED RESPONSE',
    'Add Prepared Response' => 'Add Prepared Response',
    'Folder Name is shown upfront at Knowledge Base' => 'The folder name to show in the knowledge base',
    'A small text about the folder helps user to navigate more easily' => 'A bit more info about this folder',
    'Publish' => 'Publish',
    'Choose appropriate status' => 'Choose appropriate status',
    'Folder Image' => 'Folder Image',
    'An image is worth a thousands words and makes folder more accessible' => 'Help users identify the proper folder with a recognizable image.',
    'Add Category' => 'Add Category',
    'Category Name is shown upfront at Knowledge Base' => 'The category name to show in the knowledge base',
    'A small text about the category helps user to navigate more easily' => 'A bit more info about this category',
    'Using Category Order, you can decide which category should display first' => 'Using Category Order, you can decide which category should display first',
    'Sorting' => 'Sorting',
    'Ascending Order (A-Z)' => 'Ascending Order (A-Z)',
    'Descending Order (Z-A)' => 'Descending Order (Z-A)',
    'Based on Popularity' => 'Based on Popularity',
    'Article of this category will display according to selected option' => 'Articles in this category will display depending on selected option',
    'Article' => 'Article',
    'Title' => 'Title',
    'View' => 'View',
    'Make as Starred' => 'Mark as Starred',
    'Yes' => 'Yes',
    'No' => 'No',
    'Stared' => 'Stared',
    'Revisions' => 'Revisions',
    'Related Articles' => 'Related Articles',
    'Delete Article' => 'Delete Article',
    'Content' => 'Content',
    'Slug' => 'Slug',
    'Slug is the url identity of this article.' => 'The URL for this article',
    'Meta Title' => 'Meta Title',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. The title tag and meta description are usually shown in search engine results for the page.',
    'Meta Keywords' => 'Meta Keywords',
    'Meta Description' => 'Meta Description',
    'Description' => 'Description',
    'Team Status' => 'Team Status',
    'Team is Active' => 'Team is Active',
    'Edit Privilege' => 'Edit Privilege',
    'Can create ticket' => 'Can create ticket',
    'Can edit ticket' => 'Can edit ticket',
    'Can delete ticket' => 'Can delete ticket',
    'Can restore trashed ticket' => 'Can restore trashed ticket',
    'Can assign ticket' => 'Can assign ticket',
    'Can assign ticket group' => 'Can assign ticket group',
    'Can update ticket status' => 'Can update ticket status',
    'Can update ticket priority' => 'Can update ticket priority',
    'Can update ticket type' => 'Can update ticket type',
    'Can add internal notes to ticket' => 'Can add internal notes to ticket',
    'Can edit thread/notes' => 'Can edit thread/notes',
    'Can lock/unlock thread' => 'Can lock/unlock thread',
    'Can add collaborator to ticket' => 'Can add collaborator to ticket',
    'Can delete collaborator from ticket' => 'Can delete collaborator from ticket',
    'Can delete thread/notes' => 'Can delete thread/notes',
    'Can apply prepared response on ticket' => 'Can apply prepared response on ticket',
    'Can add ticket tags' => 'Can add ticket tags',
    'Can delete ticket tags' => 'Can delete ticket tags',
    'Can kick other ticket users' => 'Can kick other ticket users',
    'Can manage email templates' => 'Can manage email templates',
    'Can manage groups' => 'Can manage groups',
    'Can manage Sub-Groups/ Teams' => 'Can manage Sub-Groups/ Teams',
    'Can manage agents' => 'Can manage agents',
    'Can manage agent privileges' => 'Can manage agent privileges',
    'Can manage ticket types' => 'Can manage ticket types',
    'Can manage ticket custom fields' => 'Can manage ticket custom fields',
    'Can manage customers' => 'Can manage customers',
    'Can manage Prepared Responses' => 'Can manage Prepared Responses',
    'Can manage Automatic workflow' => 'Can manage Automatic workflow',
    'Can manage tags' => 'Can manage tags',
    'Can manage knowledgebase' => 'Can manage knowledgebase',
    'Can manage Groups Saved Reply' => 'Can manage Groups Saved Reply',
    'Add Privilege' => 'Add Privilege',
    'Choose set of privileges which will be available to the agent.' => 'Choose set of privileges which will be available to the agent.',
    'Advanced' => 'Advanced',
    'Privilege Name must have characters only' => 'Privilege Name must have characters only',
    'Maximum character length is 50' => 'Maximum character length is 50',
    'Open Tickets' => 'Open Tickets',
    'New Customer' => 'New Customer',
    'New Agent' => 'New Agent',
    'Total Article(s)' => 'Total Article(s)',
    'Please specify a valid email address' => 'Please specify a valid email address',
    'Please enter the password associated with your email address' => 'Please enter the password associated with your email address',
    'Please enter your server host address' => 'Please enter your server host address',
    'Please specify a port number to connect with your mail server' => 'Please specify the port number for your mail server',
    'Success ! Branding details saved successfully.' => 'Success! Branding details saved successfully.',
    'Success ! Time details saved successfully.' => 'Success! Time details saved successfully.',
    'Spam setting saved successfully.' => 'Spam setting saved successfully.',
    'Please specify a valid name for your mailbox.' => 'Please specify a valid name for your mailbox.',
    'Please select a valid swift-mailer configuration.' => 'Please select a valid swift-mailer configuration.',
    'Please specify a valid host address.' => 'Please specify a valid host address.',
    'Please specify a valid email address.' => 'Please specify a valid email address.',
    'Please enter the associated account password.' => 'Please enter the associated account password.',
    'New Saved Reply' => 'New Saved Reply',
    'New Category' => 'New Category',
    'Folder' => 'Folder',
    'Category' => 'Category',
    'Created' => 'Created',
    'All Articles' => 'All Articles',
    'Viewed' => 'Viewed',
    'New Article' => 'New Article',
    'Thank you for your feedback!' => 'Thank you for your feedback!',
    'Was this article helpful?' => 'Was this article helpful?',
    'Helpdesk' => 'Helpdesk',
    'Support Center' => 'Support Center',
    'Mailboxes' => 'Mailboxes',
    'By' => 'By',
    'Search Tickets' => 'Search Tickets',
    'Customer Information' => 'Customer Information',
    'Total Replies' => 'Total Replies',
    'Filter With' => 'Filter With',
    'Type email to add' => 'Type email to add',
    'Collaborators' => 'Collaborators',
    'Labels' => 'Labels',
    'Group' => 'Group',
    'group' => 'group',
    'Contact Team' => 'Contact Team',
    'Stay on ticket' => 'Stay on ticket',
    'Redirect to list' => 'Redirect to list',
    'Nothing interesting here...' => 'Nothing interesting here',
    'Previous Ticket' => 'Previous Ticket',
    'Next Ticket' => 'Next Ticket',
    'Forward' => 'Forward',
    'Note' => 'Note',
    'Write a reply' => 'Write a reply',
    'Created Ticket' => 'Created Ticket',
    'All Threads' => 'All Threads',
    'Forwards' => 'Forwards',
    'Notes' => 'Notes',
    'Pinned' => 'Pinned',
    'Edit Ticket' => 'Edit Ticket',
    'Print Ticket' => 'Print Ticket',
    'Mark as Spam' => 'Mark as Spam',
    'Mark as Closed' => 'Mark as Closed',
    'Delete Ticket' => 'Delete Ticket',
    'View order details from different eCommerce channels' => 'View order details from different eCommerce channels',
    'ECOMMERCE CHANNELS' => 'ECOMMERCE CHANNELS',
    'Select channel' => 'Select channel',
    'Order Id' => 'Order Id',
    'Fetch Order' => 'Fetch Order',
    'No orders have been integrated to this ticket yet.' => 'No orders have been associated with this ticket yet.',
    'Enter your credentials below to gain access to your helpdesk account.' => 'Enter your credentials below to sign in',
    'Keep me logged in' => 'Keep me logged in',
    'Forgot Password?' => 'Forgot Password?',
    'Log in to your' => 'Log in to your',
    'Sign In' => 'Sign In',
    'Edit Customer' => 'Edit Customer',
    'Update' => 'Update',
    'Discard' => 'Discard',
    'Cancel' => 'Cancel',
    'Not Assigned' => 'Not Assigned',
    'Submit' => 'Submit',
    'Submit And Open' => 'Submit And Open',
    'Submit And Pending' => 'Submit And Pending',
    'Submit And Answered' => 'Submit And Answered',
    'Submit And Resolved' => 'Submit And Resolved',
    'Submit And Closed' => 'Submit And Closed',
    'Choose a Color' => 'Choose a Color',
    'Create' => 'Create',
    'Edit Label' => 'Edit Label',
    'Add Label' => 'Add Label',
    'To' => 'To',
    'Ticket' => 'Ticket',
    'Your browser does not support JavaScript or You disabled JavaScript, Please enable those !' => 'Your browser does not support Javascript or Javascript is disabled. Please correct this!',
    'Confirm Action' => 'Confirm Action',
    'Confirm' => 'Confirm',
    'No result found' => 'No result found',
    'ticket delivery status' => 'ticket delivery status',
    'Warning! Select valid image file.' => 'Warning! Select valid image file.',
    'Error' => 'Error',
    'Save' => 'Save',
    'SEO' => 'SEO',
    'Edit Saved Filter' => 'Edit Saved Filter',
    'Type atleast 2 letters' => 'Type at least 2 letters',
    'Remove Label' => 'Remove Label',
    'New Saved Filter' => 'New Saved Filter',
    'Is Default' => 'Is Default',
    'Remove Saved Filter' => 'Remove Saved Filter',
    'Ticket Info' => 'Ticket Info',
    'Last Replied Agent' => 'Last Replied Agent',
    'created Ticket' => 'created Ticket',
    'Uploaded Files' => 'Uploaded Files',
    'Download (as .zip)' => 'Download ( as .zip)',
    'made last reply' => 'last reply',
    'N/A' => 'N/A',
    'Unassigned' => 'Unassigned',
    'Label' => 'Label',
    'Assigned to me' => 'Assigned to me',
    'Search Query' => 'Search Query',
    'Searching' => 'Searching',
    'Saved Filter' => 'Saved Filter',
    'No Label Created' => 'No Label Created',
    'Label with same name already exist.' => 'Label with same name already exists',
    'Create New' => 'Create New',
    'Mail status' => 'Mail status',
    'replied' => 'replied',
    'added note' => 'added note',
    'forwarded' => 'forwarded',
    'TO' => 'TO',
    'CC' => 'CC',
    'BCC' => 'BCC',
    'Locked' => 'Locked',
    'Edit Thread' => 'Edit Thread',
    'Delete Thread' => 'Delete Thread',
    'Unpin Thread' => 'Unpin Thread',
    'Pin Thread' => 'Pin Thread',
    'Unlock Thread' => 'Unlock Thread',
    'Lock Thread' => 'Lock Thread',
    'Translate Thread' => 'Translate Thread',
    'Language' => 'Language',
    'English' => 'English',
    'French' => 'French',
    'Italian' => 'Italian',
    'Arabic' => 'Arabic',
    'German' => 'German',
    'Spanish' => 'Spanish',
    'Turkish' => 'Turkish',
    'Danish' => 'Danish',
    'Chinese' => 'Chinese',
    'Polish' => 'Polish',
    'Hebrew' => 'Hebrew',
    'Portuguese' => 'Portuguese',
    'System' => 'System',
    'Open in Files' => 'Open in Files',
    'Email address is invalid' => 'Email address is invalid',
    'Tag with same name already exist' => 'Tag with this name already exist',
    'Text length should be less than 20 charactors' => 'Must be less than 20 characters',
    'Label with same name already exist' => 'Label with same name already exist',
    'Agent Name' => 'Agent Name',
    'Agent Email' => 'Agent Email',
    'open' => 'open',
    'Currently active agents on ticket' => 'Currently active agents on ticket',
    'Edit Customer Information' => 'Edit Customer Information',
    'Restore' => 'Restore',
    'Delete Forever' => 'Delete Forever',
    'Add Team' => 'Add Team',
    'delete' => 'delete',
    'You didnt have any folder for current filter(s).' => 'No folders match current filter(s).',
    'Add Folder' => 'Add Folder',
    'This field must have valid characters only' => 'This field must have valid characters only',
    'Can edit task' => 'Can edit task',
    'Can create task' => 'Can create task',
    'Can delete task' => 'Can delete task',
    'Can add member to task' => 'Can add member to task',
    'Can remove member from task' => 'Can remove member from task',
    'Agent Privileges' => 'Agent Privileges',
    'Agent Privilege represents overall permissions in System.' => 'Agent privilege represents overall permissions in your helpdesk.',
    'Ticket View' => 'Ticket View',
    'User can view tickets based on selected scope.' => 'User can view tickets based on selected scope.',
    'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) he belongs to and so on' => 'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) they belongs to, etc.',
    'Global Access' => 'Global Access',
    'Group Access' => 'Group Access',
    'Team Access' => 'Team Access',
    'Individual Access' => 'Individual Access',
    'This field must have characters only' => 'This field must have characters only',
    'Maximum character length is 40' => 'Maximum character length is 40',
    'This is not a valid email address' => 'This is not a valid email address',
    'Password must contains 8 Characters' => 'Password must contains 8 Characters',
    'The passwords does not match' => 'The passwords do not match',
    'Enabled' => 'Enabled',
    'Create Configuration' => 'Create Configuration',
    'Swift Mailer Settings' => 'Swift Mailer Settings',
    'Username' => 'Username',
    'Please select a swiftmailer id' => 'Please select a swiftmailer id',
    'Please enter a valid e-mail id' => 'Please enter a valid e-mail id',
    'Please enter a mailer id' => 'Please enter a mailer id',
    'Email Id' => 'Email Id',
    'Are you sure? You want to perform this action.' => 'Are you sure you want to perform this action?',
    'Reorder' => 'Reorder',
    'New Workflow' => 'New Workflow',
    'OR' => 'OR',
    'AND' => 'AND',
    'Please enter a valid name.' => 'Please enter a valid name.',
    'Please select a value.' => 'Please select a value.',
    'Please add a value.' => 'Please add a value.',
    'This field is required' => 'This field is required',
    'or' => 'or',
    'and' => 'and',
    'Select a Condition' => 'Select a Condition',
    'Loading...' => 'Loading...',
    'Select Option' => 'Select Option',
    'Inactive' => 'Inactive',
    'New Type' => 'New Type',
    'Placeholders' => 'Placeholders',
    'Ticket Link' => 'Ticket Link',
    'Id' => 'Id',
    'Preview' => 'Preview',
    'Sort Order' => 'Sort Order',
    'This field must be a number' => 'This field must be a number',
    'User' => 'User',
    'Edit Group' => 'Edit Group',
    'Group Status' => 'Group Status',
    'Group is Active' => 'Group is Active',
    'Add Group' => 'Add Group',
    'Contact number is invalid' => 'Contact number is invalid',
    'Edit Agent' => 'Edit Agent',
    'No Privilege added, Please add Privilege(s) first !' => 'No privilege added, please add privilege(s) first!',
    'Edit Email Template' => 'Edit Email Template',
    'Edit Workflow' => 'Edit Workflow',
    'Save Workflow' => 'Save Workflow',
    'Edit Ticket Type' => 'Edit Ticket Type',
    'Add Ticket Type' => 'Add Ticket Type',
    'Date Released' => '	Date Released',
    'Free' => 'Free',
    'Premium' => 'Premium',
    'Installed' => 'Installed',
    'Installed Applications' => 'Installed Applications',
    'Apps Dashboard' => 'Apps Dashboard',
    'Dashboard' => 'Dashboard',
    'Nothing Interesting here' => 'Nothing interesting here',
    'No Categories Added' => 'No Categories Added',
    'Error : Something went wrong, please try again later' => 'Error: Something went wrong, please try again later',
    'ticket' => 'ticket',
    'Add Email Template' => 'Add Email Template',
    'This field contain 100 characters only' => 'Max 100 characters',
    'This field contain characters only' => 'This field may contain characters only',
    'Name length must not be greater than 200 !!' => 'Name length must not be greater than 200!',
    'Warning! Correct all field values first!' => 'Warning! Correct all field values first!',
    'Warning ! This is not a valid request' => 'Warning! This is not a valid request',
    'Success ! Tag removed successfully.' => 'Success! Tag removed successfully.',
    'Success ! Tags Saved successfully.' => 'Success! Tags Saved successfully.',
    'Success ! Revision restored successfully.' => 'Success! Revision restored successfully.',
    'Success ! Categories updated successfully.' => 'Success! Categories updated successfully.',
    'Success ! Article Related removed successfully.' => 'Success! Related article removed successfully.',
    'Success ! Article Related is already added.' => 'Success! Related article added.',
    'Success ! Cannot add self as relative article.' => 'Success! Cannot add self as relative article.',
    'Success ! Article Related updated successfully.' => 'Success! Related article updated successfully.',
    'Success ! Articles removed successfully.' => 'Success! Articles removed successfully.',
    'Success ! Article status updated successfully.' => 'Success! Article status updated successfully.',
    'Success ! Article star updated successfully.' => 'Success! Article star updated successfully.',
    'Success! Article updated successfully' => 'Success! Article updated successfully',
    'Success ! Category sort  order updated successfully.' => 'Success! Category sort order updated successfully.',
    'Success ! Category status updated successfully.' => 'Success! Category status updated successfully.',
    'Success ! Folders updated successfully.' => 'Success! Folders updated successfully.',
    'Success ! Categories removed successfully.' => 'Success! Categories removed successfully.',
    'Success ! Category updated successfully.' => 'Success! Category updated successfully.',
    'Error ! Category is not exist.' => 'Error! Category does not exist.',
    'Warning ! Customer Login disabled by admin.' => 'Warning! Customer Login disabled by admin.',
    'This Email is not registered with us.' => 'This email is not registered with us.',
    'Your password has been updated successfully.' => 'Your password has been updated successfully.',
    'Password dont match.' => 'Password doesn\'t match.',
    'Error ! Profile image is not valid, please upload a valid format' => 'Error! Profile image is not valid, please upload a valid format',
    'Warning! Provide valid image file. (Recommened": "PNG, JPG or GIF Format).' => 'Warning! invalid image file. (Recommened": "PNG, JPG or GIF Format).',
    'Success! Folder has been added successfully.' => 'Success! Folder has been added successfully.',
    'Folder updated successfully.' => 'Folder updated successfully.',
    'Success ! Folder status updated successfully.' => 'Success! Folder status updated successfully.',
    'Error ! Folder is not exist.' => 'Error! Folder does not exist.',
    'Success ! Folder updated successfully.' => 'Success! Folder updated successfully.',
    'Error ! Folder does not exist.' => 'Error! Folder does not exist.',
    'Success ! Folder deleted successfully.' => 'Success! Folder deleted successfully.',
    'Warning ! Folder doesnt exists!' => 'Warning! Folder doesn\'t exists!',
    'Warning ! Cannot create ticket, given email is blocked by admin.' => 'Warning! Can\'t create ticket, given email is blocked by admin.',
    'Success ! Ticket has been created successfully.' => 'Success! Ticket has been created successfully.',
    'Warning ! Can not create ticket, invalid details.' => 'Warning! Can not create ticket, invalid details.',
    'Warning ! Post size can not exceed 25MB' => 'Warning! attachmment size can not exceed 25MB',
    'Create Ticket Request' => 'Create Ticket Request',
    'Success ! Reply added successfully.' => 'Success! Reply added successfully.',
    'Warning ! Reply field can not be blank.' => 'Warning! Reply field can not be blank.',
    'Success ! Rating has been successfully added.' => 'Success! Rating has been successfully added.',
    'Warning ! Invalid rating.' => 'Warning! Invalid rating.',
    'Error ! Can not add customer as a collaborator.' => 'Error! Can not add customer as a collaborator.',
    'Success ! Collaborator added successfully.' => 'Success! Collaborator added successfully.',
    'Error ! Collaborator is already added.' => 'Error! Collaborator is already added.',
    'Success ! Collaborator removed successfully.' => 'Success! Collaborator removed successfully.',
    'Error ! Invalid Collaborator.' => 'Error! Invalid Collaborator.',
    'An unexpected error occurred. Please try again later.' => 'An unexpected error occurred. Please try again later.',
    'Feedback saved successfully.' => 'Feedback saved successfully.',
    'Feedback updated successfully.' => 'Feedback updated successfully.',
    'Invalid feedback provided.' => 'Invalid feedback provided.',
    'Article not found.' => 'Article not found.',
    'You need to login to your account before can perform this action.' => 'You need to log in to your account before can perform this action.',
    'Warning! Please add valid Actions!' => 'Warning! Please add valid actions!',
    'Warning! In Free Plan you can not change Events!' => 'Warning! In free plan you can not change events!',
    'Success! Prepared Response has been updated successfully.' => 'Success! Prepared response has been updated successfully.',
    'Success! Prepared Response has been added successfully.' => 'Success! Prepared response has been added successfully.',
    'Warning  This is not a valid request' => 'Warning! This is not a valid request',
    'Use Default Colors' => 'Use Default Colors',
    'Masonry' => 'Masonry',
    'Popular Article' => 'Popular Article',
    'Manage Ticket Custom Fields' => 'Manage Ticket Custom Fields',
    'Mail status:' => 'Mail status:',
    'You dont have premission to edit this Prepared response' => 'You don\'t have premission to edit this prepared response',
    'Save Prepared Response' => 'Save prepared response',
    'Success ! Prepared response removed successfully.' => 'Success! Prepared response removed successfully.',
    'Warning! You are not allowed to perform this action.' => 'Warning! You are not allowed to perform this action.',
    'Success! Workflow has been updated successfully.' => 'Success! Workflow has been updated successfully.',
    'Success! Workflow has been added successfully.' => 'Success! Workflow has been added successfully.',
    'Success! Order has been updated successfully.' => 'Success! Order has been updated successfully.',
    'Success! Workflow has been removed successfully.' => 'Success! Workflow has been removed successfully.',
    'Mailbox successfully created.' => 'Mailbox successfully created.',
    'Mailbox successfully updated.' => 'Mailbox successfully updated.',
    'Warning ! Bad request !' => 'Warning! Bad request!',
    'Error! Given current password is incorrect.' => 'Error! Password is incorrect.',
    'Success ! Profile update successfully.' => 'Success! Profile update successfully.',
    'Error ! User with same email is already exist.' => 'Error! User with same email already exists.',
    'Success ! Agent updated successfully.' => 'Success! Agent updated successfully.',
    'Success ! Agent removed successfully.' => 'Success! Agent removed successfully.',
    'Warning ! You are allowed to remove account owners account.' => 'Warning! You are allowed to remove this account.',
    'Error ! Invalid user id.' => 'Error! Invalid user id.',
    'Success ! Filter has been saved successfully.' => 'Success! Filter has been saved successfully.',
    'Success ! Filter has been updated successfully.' => 'Success! Filter has been updated successfully.',
    'Success ! Filter has been removed successfully.' => 'Success! Filter has been removed successfully.',
    'Please check your mail for password update.' => 'Please check your inbox for a new password.',
    'This Email address is not registered with us.' => 'This email address is not registered with us.',
    'Success ! Customer saved successfully.' => 'Success! Customer saved successfully.',
    'Error ! User with same email already exist.' => 'Error! User with same email already exists.',
    'Success ! Customer information updated successfully.' => 'Success! Customer information updated successfully.',
    'Success ! Customer updated successfully.' => 'Success! Customer updated successfully.',
    'Error ! Customer with same email already exist.' => 'Error! Customer with same email already exists.',
    'unstarred Action Completed successfully' => 'unstarred action completed successfully',
    'starred Action Completed successfully' => 'starred action completed successfully',
    'Success ! Customer removed successfully.' => 'Success! Customer removed successfully.',
    'Error ! Invalid customer id.' => 'Error! Invalid customer id.',
    'Success! Template has been updated successfully.' => 'Success! Template has been updated successfully.',
    'Success! Template has been added successfully.' => 'Success! Template has been added successfully.',
    'Success! Template has been deleted successfully.' => 'Success! Template has been deleted successfully.',
    'Warning! resource not found.' => 'Warning! resource not found.',
    'Warning! You can not remove predefined email template which is being used in workflow(s).' => 'Warning! You can not remove an email template which is being used in workflow(s).',
    'Success ! Email settings are updated successfully.' => 'Success! Email settings successfully updated.',
    'Success ! Group information updated successfully.' => 'Success! Group information updated successfully.',
    'Success ! Group information saved successfully.' => 'Success! Group information saved successfully.',
    'Support Group removed successfully.' => 'Support Group removed successfully.',
    'Success ! Privilege information saved successfully.' => 'Success! Privilege information saved successfully.',
    'Privilege updated successfully.' => 'Privilege updated successfully.',
    'Support Privilege removed successfully.' => 'Support privilege removed successfully.',
    'Success! Reply has been updated successfully.' => 'Success! Reply has been updated successfully.',
    'Success! Reply has been added successfully.' => 'Success! Reply has been added successfully.',
    'Success! Saved Reply has been deleted successfully' => 'Success! Saved Reply has been deleted successfully',
    'SwiftMailer configuration updated successfully.' => 'SwiftMailer configuration updated successfully.',
    'Swiftmailer configuration removed successfully.' => 'Swiftmailer configuration removed successfully.',
    'Success ! Team information saved successfully.' => 'Success! Team information saved successfully.',
    'Success ! Team information updated successfully.' => 'Success! Team information updated successfully.',
    'Support Team removed successfully.' => 'Support Team removed successfully.',
    'Success! Reply has been added successfully' => 'Success! Reply has been added successfully',
    'Success ! Thread updated successfully.' => 'Success! Thread updated successfully.',
    'Error ! Reply field can not be blank.' => 'Error  Reply field can not be blank.',
    'Success ! Thread removed successfully.' => 'Success! Thread removed successfully.',
    'Success ! Thread locked successfully' => 'Success! Thread locked successfully',
    'Success ! Thread unlocked successfully' => 'Success! Thread unlocked successfully',
    'Success ! Thread pinned successfully' => 'Success! Thread unpinned successfully',
    'Error ! Invalid thread.' => 'Error! Invalid thread.',
    'Could not create ticket, invalid details.' => 'Could not create ticket, invalid details.',
    'Success ! Tag updated successfully.' => 'Success! Tag updated successfully.',
    'Error ! Customer can not be added as collaborator.' => 'Error! Customer can not be added as collaborator.',
    'Success ! Tag unassigned successfully.' => 'Success! Tag unassigned successfully.',
    'Success ! Tag added successfully.' => 'Success! Tag added successfully.',
    'Please enter tag name.' => 'Please enter tag name.',
    'Error ! Invalid tag.' => 'Error! Invalid tag.',
    'Success ! Type removed successfully.' => 'Success! Type removed successfully.',
    'Success ! Ticket to label removed successfully.' => 'Success! Ticket label removed successfully.',
    'Unable to retrieve support team details' => 'Unable to retrieve support team details',
    'Ticket support group updated successfully' => 'Ticket support group updated successfully',
    'Unable to retrieve status details' => 'Unable to retrieve status details',
    'Insufficient details provided.' => 'Insufficient details provided.',
    'Error! Subject field is mandatory' => 'Error! Subject field is mandatory',
    'Error! Reply field is mandatory' => 'Error! Reply field is mandatory',
    'Success ! Ticket has been updated successfully.' => 'Success! Ticket has been updated successfully.',
    'Success ! Label updated successfully.' => 'Success! Label updated successfully.',
    'Error ! Invalid label id.' => 'Error! Invalid label id.',
    'Success ! Label removed successfully.' => 'Success! Label removed successfully.',
    'Success ! Label created successfully.' => 'Success! Label created successfully.',
    'Error ! Label name can not be blank.' => 'Error! Label name can not be blank.',
    'Success ! Ticket moved to trash successfully.' => 'Success! Ticket moved to trash successfully.',
    'Success! Ticket type saved successfully.' => 'Success! Ticket type saved successfully.',
    'Success! Ticket type updated successfully.' => 'Success! Ticket type updated successfully.',
    'Error! Ticket type with same name already exist' => 'Error! Ticket type with same name already exist',
    'SAVE' => 'SAVE',
    'Ticket is already assigned to agent' => 'Ticket is already assigned to agent',
    'Success ! Agent assigned successfully.' => 'Success ! Agent assigned successfully.',
    'Ticket status is already set' => 'Ticket status is already set',
    'Success ! Tickets status updated successfully.' => 'Success ! Tickets status updated successfully.',
    'Ticket priority is already set' => 'Ticket priority is already set',
    'Success ! Tickets priority updated successfully.' => 'Success ! Tickets priority updated successfully.',
    'Ticket group is updated successfully' => 'Ticket group is updated successfully',
    'Ticket is already assigned to group' => 'Ticket is already assigned to group',
    'Success ! Tickets group updated successfully.' => 'Success ! Tickets group updated successfully.',
    'Ticket team is updated successfully' => 'Ticket team is updated successfully',
    'Ticket is already assigned to team' => 'Ticket is already assigned to team',
    'Success ! Tickets team updated successfully.' => 'Success ! Tickets team updated successfully.',
    'Ticket type is already set' => 'Ticket type is already set',
    'Success ! Tickets type updated successfully.' => 'Success ! Tickets type updated successfully.',
    'Success ! Tickets label updated successfully.' => 'Success ! Tickets label updated successfully.',
    'Success ! Tickets added to label successfully.' => 'Success ! Tickets added to label successfully.',
    'Success ! Tickets moved to trashed successfully.' => 'Success ! Tickets moved to trashed successfully.',
    'Success ! Tickets removed successfully.' => 'Success ! Tickets removed successfully.',
    'Success ! Tickets restored successfully.' => 'Success ! Tickets restored successfully.',
    'Unable to retrieve group details' => 'Unable to retrieve group details',
    'Unable to retrieve team details' => 'Unable to retrieve team details',
    'Tickets details have been updated successfully' => 'Tickets details have been updated successfully',
    'Label added to ticket successfully' => 'Label added to ticket successfully',
    'Label already added to ticket' => 'Label already added to ticket',
    'Howdy!' => 'Howdy!',
    'New Ticket Request' => 'New Ticket Request',
    'Ticket Requests' => 'Ticket Requests',
    'Tickets have been updated successfully' => 'Tickets have been updated successfully',
    'Please check your mail for password update' => 'Please check your inbox for a new password',
    'This email address is not registered with us' => 'This email address is not registered with us',
    'You have already update password using this link if you wish to change password again click on forget password link here from login page' => 'You have already updated your password using this link. If you wish to change your password again click on the forget password link on the login page.',
    'Your password has been successfully updated. Login using updated password' => 'Your password has been successfully updated. Please log in using your new password.',
    'Please try again, The passwords do not match' => 'Please try again, The passwords do not match',
    'Support Privilege removed successfully' => 'Support Privilege removed successfully',
    'Success! Saved Reply has been deleted successfully.' => 'Success! Saved Reply has been deleted successfully.',
    'SwiftMailer configuration created successfully.' => 'SwiftMailer configuration created successfully.',
    'No swiftmailer configurations found for mailer id:' => 'No swiftmailer configurations found for mailer id:',
    'Reply content cannot be left blank.' => 'Reply content cannot be left blank.',
    'Reply added to the ticket and forwarded successfully.' => 'Reply added to the ticket and forwarded successfully.',
    'Success ! Thread pinned successfully.' => 'Success! Thread pinned successfully.',
    'Success ! unpinned removed successfully.' => 'Success! Thread unpinned successfully.',
    'Unable to retrieve priority details' => 'Unable to retrieve priority details',
    'Ticket support team updated successfully' => 'Ticket support team updated successfully',
    'Ticket assigned to support group ' => 'Ticket assigned to support group ',
    'Mailbox configuration removed successfully.' => 'Mailbox configuration removed successfully.',
    'visit our website' => 'visit our website',
    'Cookie Usage Policy' => 'Cookie Usage Policy',
    'cookie' => 'cookie',
    'cookies' => 'cookies',
    'HELP' => 'HELP',
    'Home' => 'Home',
    'Cookie Policy' => 'Cookie Policy',
    'Prev' => 'Prev',
    'Ticket query message' => 'Ticket content',
    'Select type' => 'Select type',
    'Search KnowledgeBase' => 'Search KnowledgeBase',
    'You cant merge an account with itself.' => 'You can\'t merge an account with itself.',
    'Edit Profile' => 'Edit Profile',
    'Customer Login' => 'Customer Login',
    'Contact Us' => 'Contact Us',
    'If you have ever contacted our support previously, your account would have already been created.' => 'If you have ever contacted us previously, your account is more than likely already created.',
    'support' => 'support',
    'HelpDesk' => 'HelpDesk',
    'Enter search keyword' => 'Enter search keyword',
    'Browse via Folders' => 'Explore the knowledge base',
    'Looking for something that is queried generally? Choose a relevant folder from below to explore possible solutions' => 'Check out our knowledge base to see if your question has already been answered.',
    'Unable to find an answer?' => 'Contact Our Team',
    'Looking for anything specific article which resides in general queries? Just browse the various relevant folders and categories and then you will find the desired article.' => 'If you still can\'t find an answer to what you\'re looking for, or you have a specific question, open a new ticket and we\'d be happy to help!',
    'Popular Articles' => 'Popular Articles',
    'Here are some of the most popular articles, which helped number of users to get their queries and questions resolved.' => 'Some of the more popular articles in our knowledge base that have helped other customers.',
    'Browse via Categories' => 'Browse via Categories',
    'Looking for something specific? Choose a relevant category from below to explore possible solutions' => 'Choose a category from the list below to view articles.',
    'No Categories Found!' => 'No Categories Found!',
    'Powered by' => 'Powered by',
    'Powered by %uvdesk%, an open-source project by %webkul%.' => 'Powered by %uvdesk%, an open-source project by %webkul%.',
    'Forgot Password' => 'Forgot Password',
    'Enter your email address and we will send you an email with instructions to update your login credentials.' => 'Enter your email address and we will send you a message to update your login credentials.',
    'Send Mail' => 'Send Mail',
    'Sign In to %websitename%' => 'Sign In to %websitename%',
    'Enter your name' => 'Enter your name',
    'Enter your email' => 'Enter your email',
    'Learn more about %deliveryStatus%.' => 'Learn more about %deliveryStatus%.',
    'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.' => 'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.',
    'To know more about how our privacy policy works, please %websiteLink%.' => 'To know more about our privacy policy, please visit %websiteLink%.',
    'This field contain maximum 40 charectures.' => 'This field contain maximum 40 charectures.',
    'This field contain maximum 50 charectures.' => 'This field contain maximum 50 charectures.',
    'Time' => 'Time',
    'Links' => 'Links',
    'Broadcast Message' => 'Broadcast Message',
    'Wide Logo' => 'Wide Logo',
    'Upload an Image (200px x 48px) in</br> PNG or JPG Format' => 'Upload an Image (200px x 48px) in</br> PNG or JPG Format',
    'It will be shown as Logo on Knowledgebase and Helpdesk' => 'Your knowledge base / helpdesk logo',
    'Website Status' => 'Website Status',
    'Enable front end website and knowledgebase for customer(s)' => 'Enable front end website and knowledgebase for customer(s)',
    'Brand Color' => 'Brand Color',
    'Page Background Color' => 'Page Background Color',
    'Header Background Color' => 'Header Background Color',
    'Banner Background Color' => 'Banner Background Color',
    'Page Link Color' => 'Page Link Color',
    'Page Link Hover Color' => 'Page Link Hover Color',
    'Article Text Color' => 'Article Text Color',
    'Tag Line' => 'Tag Line',
    'Hi! how can we help?' => 'Hi! how can we help?',
    'Layout' => 'Layout',
    'Ticket Create Option' => 'Ticket Create Option',
    'Login Required To Create Tickets' => 'Login required To create tickets',
    'Remove Customer Login/Signin Button' => 'Remove customer log in / sign in button',
    'Disable Customer Login' => 'Disable Customer Login',
    'Meta Description (Recommended)' => 'Meta Description (Recommended)',
    'Meta Keywords (Recommended)' => 'Meta Keywords (Recommended)',
    'Header Link' => 'Header Link',
    'URL (with http":/"/ or https":/"/)' => 'URL (with http":/"/ or https":/"/)',
    'Footer Link' => 'Footer Link',
    'Custom CSS (Optional)' => 'Custom CSS (Optional)',
    'It will be add to the frontend knowledgebase only' => 'Displayed only in front end knowledge base',
    'Custom Javascript (Optional)' => 'Custom Javascript (Optional)',
    'Broadcast message content to show on helpdesk' => 'Broadcast message content to show on helpdesk',
    'From' => 'From',
    'Time duration between which message will be displayed(if applicable)' => 'How long should the message be displayed?',
    'Broadcasting Status' => 'Broadcasting Status',
    'Broadcasting is Active' => 'Broadcasting is Active',
    'Choose a default company timezone' => 'Choose a default companys timezone',
    'Date Time Format' => 'Date Time Format',
    'Choose a format to convert date to specified date time format' => 'Choose a format to convert date to specified date time format',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'File size must not be greater than 200KB !!' => 'File size must not be greater than 200KB!',
    'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!' => 'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!',
    'Provide a valid url(with protocol)' => 'Provide a valid url (with protocol)',
    'ticket.message.placeHolders.info' => 'ticket.message.placeHolders.info',
    'ticket.attachments.placeHolders.info' => '	ticket.attachments.placeHolders.info',
    'ticket.threadMessage.placeHolders.info' => 'ticket.threadMessage.placeHolders.info',
    'ticket.tags.placeHolders.info' => 'ticket.tags.placeHolders.info',
    'ticket.source.placeHolders.info' => 'ticket.source.placeHolders.info',
    'ticket.collaborator.name.placeHolders.info' => 'ticket.collaborator.name.placeHolders.info',
    'ticket.collaborator.email.placeHolders.info' => 'ticket.collaborator.email.placeHolders.info',
    'user.name.info' => 'user.name.info',
    'user.email.info' => 'user.email.info',
    'user.account.validate.link.info' => 'user.account.validate.link.info',
    'user.password.forgot.link.info' => 'user.password.forgot.link.info',
    'global.companyName' => 'global.companyName',
    'global.companyLogo' => 'global.companyLogo',
    'global.companyUrl' => 'global.companyUrl',
    'ticket.priority.placeHolders.info' => '	ticket.priority.placeHolders.info',
    'ticket.group.placeHolders.info' => 'ticket.group.placeHolders.info',
    'ticket.team.placeHolders.info' => 'ticket.team.placeHolders.info',
    'ticket.customerName.placeHolders.info' => '	ticket.customerName.placeHolders.info',
    'ticket.customerEmail.placeHolders.info' => '	ticket.customerEmail.placeHolders.info',
    'ticket.agentName.placeHolders.info' => 'ticket.agentName.placeHolders.info',
    'ticket.agentEmail.placeHolders.info' => 'ticket.agentEmail.placeHolders.info',
    'ticket.link.placeHolders.info' => '	ticket.link.placeHolders.info ',
    'ticket.id.placeHolders.info' => 'ticket.id.placeHolders.info',
    'ticket.subject.placeHolders.info' => '	ticket.subject.placeHolders.info',
    'ticket.status.placeHolders.info' => 'ticket.status.placeHolders.info',
    'comma "," separated' => 'comma separated (,)',
    'Low' => 'Low',
    'Medium' => 'Medium',
    'High' => 'High',
    'Urgent' => 'Urgent',
    'Reset Password' => 'Reset Password',
    'Enter your new password below to update your login credentials' => 'Enter your new password below to update your login credentials',
    'Save Password' => 'Save Password',
    'Rate Support' => 'Rate Support',
    'I am very Sad' => 'I am very disappointed',
    'I am Sad' => 'I am disappointed',
    'I am Neutral' => 'I am satisfied',
    'I am Happy' => 'I am happy',
    'I am Very Happy' => 'I am very happy',
    'Kudos' => 'Kudos',
    'kudos' => 'Kudos',
    'Very Sad' => 'Very disappointed',
    'Sad' => 'Disappointed',
    'Neutral' => 'Satisfied',
    'Happy' => 'Happy',
    'Very Happy' => 'Very Happy',
    'Star(s)' => 'Star(s)',
    'Warning ! Swiftmailer not working. An error has occurred while sending emails!' => 'Warning ! Swiftmailer not working. An error has occurred while sending emails!',
    'Invalid credentials.' => 'Invalid credentials',
    'Success ! Project cache cleared successfully.' => 'Success! Project cache cleared successfully.',
    'clear cache' => 'clear cache',
    'Last Updated' => 'Last Updated',
    'Error! Something went wrong.' => 'Error! Something went wrong.',
    'We were not able to find the page you are looking for.' => 'We were not able to find the page you are looking for.',
    'Page not found' => 'Page not found',
    'Forbidden' => 'Forbidden',
    'You don’t have the necessary permissions to access this Web page :(' => 'You don’t have the necessary permissions to access this Web page :(',
    'Internal server error' => 'Internal server error',
    'Our system has goofed up for a while, but good part is it won\'t last long' => 'Our system has goofed up for a while, but good part is it won\'t last long',
    'Unknown Error' => 'Unknown Error',
    'We are quite confused about how did you land here:/' => 'We are quite confused about how did you land here :/',
    'Few of the links which may help you to get back on the track -' => 'Few of the links which may help you to get back on the track -',
    'Microsoft Apps' => 'Microsoft Apps',
    'Add a Microsoft app' => 'Add a Microsoft app',
    'Enable' => 'Enable',
    'App Name' => 'App Name',
    'Tenant Id' => 'Tenant Id',
    'Client Id' => 'Client Id',
    'Client Secret' => 'Client Secret',
    'NEW APP:' => 'NEW APP:',
    'UPDATE APP' => 'UPDATE APP',
    'Guide on creating a new app in Azure Active Directory:' => 'Guide on creating a new app in Azure Active Directory:',
    'To add a new Microsoft App to your azure active directory, follow the steps as given below:' => 'To add a new Microsoft App to your azure active directory, follow the steps as given below:',
    'Go to Azure Active Directory -> App registerations' => 'Go to Azure Active Directory -> App registerations',
    'Disable' => 'Disable',
    'Please enter a valid name for your app.' => 'Please enter a valid name for your app.',
    'Please enter a valid tenant id.' => 'Please enter a valid tenant id.',
    'Please enter a valid client id.' => 'Please enter a valid client id.',
    'Please enter a valid client secret.' => 'Please enter a valid client secret.',
    'Microsoft app settings' => 'Microsoft app settings',
    'Unverified' => 'Unverified',
    'Microsoft app has been updated successfully.' => 'Microsoft app has been updated successfully.',
    'No microsoft apps found' => 'No microsoft apps found',
    'Microsoft app settings could not be verifired successfully. Please check your settings and try again later.' => 'Microsoft app settings could not be verifired successfully. Please check your settings and try again later.',
    'Microsoft app has been integrated successfully.' => 'Microsoft app has been integrated successfully.',
    'Microsoft app has been deleted successfully.' => 'Microsoft app has been deleted successfully.',
    'Verified' => 'Verified',
    'Create a New Registration' => 'Create a New Registration',
    'Enter your app details as following:' => 'Enter your app details as following:',
    'App Name: Enter an app name to easily help you identify its purpose' => 'App Name: Enter an app name to easily help you identify its purpose',
    'Supported Account Types: Select whichever option works the best for you (Recommended: Accounts in any organizational directory and personal Microsoft accounts)' => 'Supported Account Types: Select whichever option works the best for you (Recommended: Accounts in any organizational directory and personal Microsoft accounts)',
    'Redirect URI:' => 'Redirect URI:',
    'Select Platform: Web' => 'Select Platform: Web',
    'Enter the following redirect uri:' => 'Enter the following redirect uri:',
    'Proceed to create your application' => 'Proceed to create your application',
    'Once your app has been created, in your app overview section, continue with adding a client credential by clicking on "Add a certificate or secret"' => 'Once your app has been created, in your app overview section, continue with adding a client credential by clicking on "Add a certificate or secret"',
    'Create a new client secret' => 'Create a new client secret',
    'Enter a description as per your preference to help identify the purpose of this client secret' => 'Enter a description as per your preference to help identify the purpose of this client secret',
    'Choose an expiration time as per your preference' => 'Choose an expiration time as per your preference',
    'Proceed to add your client secret' => 'Proceed to add your client secret',
    'Copy the client secret value which will be needed later and cannot be viewed again' => 'Copy the client secret value which will be needed later and cannot be viewed again',
    'Navigate to API permissions' => 'Navigate to API permissions',
    'Click on "Add a permission" to add a new api permission. Add the following delegated permissions by selecting Microsoft APIs > Microsoft Graph > Delegate Permissions' => 'Click on "Add a permission" to add a new api permission. Add the following delegated permissions by selecting Microsoft APIs > Microsoft Graph > Delegate Permissions',
    'Navigate to your app overview section' => 'Navigate to your app overview section',
    'Copy the Application (Client) Id' => 'Copy the Application (Client) Id',
    'Copy the Directory (Tenant) Id' => 'Copy the Directory (Tenant) Id',
    'Enter your client id, tenant id, and client secret in settings above as required.' => 'Enter your client id, tenant id, and client secret in settings above as required.',
    'offline_access' => 'offline_access',
    'openid' => 'openid',
    'profile' => 'profile',
    'User.Read' => 'User.Read',
    'IMAP.AccessAsUser.All' => 'IMAP.AccessAsUser.All',
    'SMTP.Send' => 'SMTP.Send',
    'POP.AccessAsUser.All' => 'POP.AccessAsUser.All',
    'Mail.Read' => 'Mail.Read',
    'Mail.ReadBasic' => 'Mail.ReadBasic',
    'Mail.Send' => 'Mail.Send',
    'Mail.Send.Shared' => 'Mail.Send.Shared',
    'Add App' => 'Add App',
    'New App' => 'New App',
    'Disable email delivery' => 'Disable email delivery',
    'Use as default mailbox for sending emails' => 'Use as default mailbox for sending emails',
    'Inbound Emails' => 'Inbound Emails',
    'Manage how you wish to retrieve and process emails from your mailbox.' => 'Manage how you wish to retrieve and process emails from your mailbox.',
    'Outbound Emails' => 'Outbound Emails',
    'Manage how you wish to send emails from your mailbox.' => 'Manage how you wish to send emails from your mailbox.',
    'Marketing Modules' => 'Marketing Modules',
    'New Marketing Module' => 'New Marketing Module',
    'Marketing Module' => 'Marketing Module',
    'Status:' => 'Status:',
  ),
));
$cataloguePt->addFallbackCatalogue($catalogueEn);

return $catalogue;
