<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('fr', array (
  'validators' => 
  array (
    'This value should be false.' => 'Cette valeur doit être fausse.',
    'This value should be true.' => 'Cette valeur doit être vraie.',
    'This value should be of type {{ type }}.' => 'Cette valeur doit être de type {{ type }}.',
    'This value should be blank.' => 'Cette valeur doit être vide.',
    'The value you selected is not a valid choice.' => 'Cette valeur doit être l\'un des choix proposés.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Vous devez sélectionner au moins {{ limit }} choix.|Vous devez sélectionner au moins {{ limit }} choix.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Vous devez sélectionner au maximum {{ limit }} choix.|Vous devez sélectionner au maximum {{ limit }} choix.',
    'One or more of the given values is invalid.' => 'Une ou plusieurs des valeurs soumises sont invalides.',
    'This field was not expected.' => 'Ce champ n\'a pas été prévu.',
    'This field is missing.' => 'Ce champ est manquant.',
    'This value is not a valid date.' => 'Cette valeur n\'est pas une date valide.',
    'This value is not a valid datetime.' => 'Cette valeur n\'est pas une date valide.',
    'This value is not a valid email address.' => 'Cette valeur n\'est pas une adresse email valide.',
    'The file could not be found.' => 'Le fichier n\'a pas été trouvé.',
    'The file is not readable.' => 'Le fichier n\'est pas lisible.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Le fichier est trop volumineux ({{ size }} {{ suffix }}). Sa taille ne doit pas dépasser {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'Le type du fichier est invalide ({{ type }}). Les types autorisés sont {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Cette valeur doit être inférieure ou égale à {{ limit }}.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Cette chaîne est trop longue. Elle doit avoir au maximum {{ limit }} caractère.|Cette chaîne est trop longue. Elle doit avoir au maximum {{ limit }} caractères.',
    'This value should be {{ limit }} or more.' => 'Cette valeur doit être supérieure ou égale à {{ limit }}.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Cette chaîne est trop courte. Elle doit avoir au minimum {{ limit }} caractère.|Cette chaîne est trop courte. Elle doit avoir au minimum {{ limit }} caractères.',
    'This value should not be blank.' => 'Cette valeur ne doit pas être vide.',
    'This value should not be null.' => 'Cette valeur ne doit pas être nulle.',
    'This value should be null.' => 'Cette valeur doit être nulle.',
    'This value is not valid.' => 'Cette valeur n\'est pas valide.',
    'This value is not a valid time.' => 'Cette valeur n\'est pas une heure valide.',
    'This value is not a valid URL.' => 'Cette valeur n\'est pas une URL valide.',
    'The two values should be equal.' => 'Les deux valeurs doivent être identiques.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Le fichier est trop volumineux. Sa taille ne doit pas dépasser {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Le fichier est trop volumineux.',
    'The file could not be uploaded.' => 'Le téléchargement de ce fichier est impossible.',
    'This value should be a valid number.' => 'Cette valeur doit être un nombre.',
    'This file is not a valid image.' => 'Ce fichier n\'est pas une image valide.',
    'This is not a valid IP address.' => 'Cette valeur n\'est pas une adresse IP valide.',
    'This value is not a valid language.' => 'Cette langue n\'est pas valide.',
    'This value is not a valid locale.' => 'Ce paramètre régional n\'est pas valide.',
    'This value is not a valid country.' => 'Ce pays n\'est pas valide.',
    'This value is already used.' => 'Cette valeur est déjà utilisée.',
    'The size of the image could not be detected.' => 'La taille de l\'image n\'a pas pu être détectée.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'La largeur de l\'image est trop grande ({{ width }}px). La largeur maximale autorisée est de {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'La largeur de l\'image est trop petite ({{ width }}px). La largeur minimale attendue est de {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'La hauteur de l\'image est trop grande ({{ height }}px). La hauteur maximale autorisée est de {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'La hauteur de l\'image est trop petite ({{ height }}px). La hauteur minimale attendue est de {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Cette valeur doit être le mot de passe actuel de l\'utilisateur.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Cette chaîne doit avoir exactement {{ limit }} caractère.|Cette chaîne doit avoir exactement {{ limit }} caractères.',
    'The file was only partially uploaded.' => 'Le fichier a été partiellement transféré.',
    'No file was uploaded.' => 'Aucun fichier n\'a été transféré.',
    'No temporary folder was configured in php.ini.' => 'Aucun répertoire temporaire n\'a été configuré dans le php.ini, ou le répertoire configuré n\'existe pas.',
    'Cannot write temporary file to disk.' => 'Impossible d\'écrire le fichier temporaire sur le disque.',
    'A PHP extension caused the upload to fail.' => 'Une extension PHP a empêché le transfert du fichier.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Cette collection doit contenir {{ limit }} élément ou plus.|Cette collection doit contenir {{ limit }} éléments ou plus.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Cette collection doit contenir {{ limit }} élément ou moins.|Cette collection doit contenir {{ limit }} éléments ou moins.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Cette collection doit contenir exactement {{ limit }} élément.|Cette collection doit contenir exactement {{ limit }} éléments.',
    'Invalid card number.' => 'Numéro de carte invalide.',
    'Unsupported card type or invalid card number.' => 'Type de carte non supporté ou numéro invalide.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Cette valeur n\'est pas un Numéro de Compte Bancaire International (IBAN) valide.',
    'This value is not a valid ISBN-10.' => 'Cette valeur n\'est pas un code ISBN-10 valide.',
    'This value is not a valid ISBN-13.' => 'Cette valeur n\'est pas un code ISBN-13 valide.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Cette valeur n\'est ni un code ISBN-10, ni un code ISBN-13 valide.',
    'This value is not a valid ISSN.' => 'Cette valeur n\'est pas un code ISSN valide.',
    'This value is not a valid currency.' => 'Cette valeur n\'est pas une devise valide.',
    'This value should be equal to {{ compared_value }}.' => 'Cette valeur doit être égale à {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Cette valeur doit être supérieure à {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Cette valeur doit être supérieure ou égale à {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Cette valeur doit être identique à {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Cette valeur doit être inférieure à {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Cette valeur doit être inférieure ou égale à {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Cette valeur ne doit pas être égale à {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Cette valeur ne doit pas être identique à {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Le rapport largeur/hauteur de l\'image est trop grand ({{ ratio }}). Le rapport maximal autorisé est {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Le rapport largeur/hauteur de l\'image est trop petit ({{ ratio }}). Le rapport minimal attendu est {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'L\'image est carrée ({{ width }}x{{ height }}px). Les images carrées ne sont pas autorisées.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'L\'image est au format paysage ({{ width }}x{{ height }}px). Les images au format paysage ne sont pas autorisées.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'L\'image est au format portrait ({{ width }}x{{ height }}px). Les images au format portrait ne sont pas autorisées.',
    'An empty file is not allowed.' => 'Un fichier vide n\'est pas autorisé.',
    'The host could not be resolved.' => 'Le nom de domaine n\'a pas pu être résolu.',
    'This value does not match the expected {{ charset }} charset.' => 'Cette valeur ne correspond pas au jeu de caractères {{ charset }} attendu.',
    'This is not a valid Business Identifier Code (BIC).' => 'Cette valeur n\'est pas un Code Identifiant de Business (BIC) valide.',
    'Error' => 'Erreur',
    'This is not a valid UUID.' => 'Cette valeur n\'est pas un UUID valide.',
    'This value should be a multiple of {{ compared_value }}.' => 'Cette valeur doit être un multiple de {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Ce code d\'identification d\'entreprise (BIC) n\'est pas associé à l\'IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'Cette valeur doit être un JSON valide.',
    'This collection should contain only unique elements.' => 'Cette collection ne doit pas comporter de doublons.',
    'This value should be positive.' => 'Cette valeur doit être strictement positive.',
    'This value should be either positive or zero.' => 'Cette valeur doit être supérieure ou égale à zéro.',
    'This value should be negative.' => 'Cette valeur doit être strictement négative.',
    'This value should be either negative or zero.' => 'Cette valeur doit être inférieure ou égale à zéro.',
    'This value is not a valid timezone.' => 'Cette valeur n\'est pas un fuseau horaire valide.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Ce mot de passe a été divulgué lors d\'une fuite de données, il ne doit plus être utilisé. Veuillez utiliser un autre mot de passe.',
    'This value should be between {{ min }} and {{ max }}.' => 'Cette valeur doit être comprise entre {{ min }} et {{ max }}.',
    'This value is not a valid hostname.' => 'Cette valeur n\'est pas un nom d\'hôte valide.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Le nombre d\'éléments de cette collection doit être un multiple de {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Cette valeur doit satisfaire à au moins une des contraintes suivantes :',
    'Each element of this collection should satisfy its own set of constraints.' => 'Chaque élément de cette collection doit satisfaire à son propre jeu de contraintes.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Cette valeur n\'est pas un code international de sécurité valide (ISIN).',
    'This value should be a valid expression.' => 'Cette valeur doit être une expression valide.',
    'This value is not a valid CSS color.' => 'Cette valeur n\'est pas une couleur CSS valide.',
    'This value is not a valid CIDR notation.' => 'Cette valeur n\'est pas une notation CIDR valide.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'La valeur du masque de réseau doit être comprise entre {{ min }} et {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'Le nom du fichier est trop long. Il doit contenir au maximum {{ filename_max_length }} caractère.|Le nom de fichier est trop long. Il doit contenir au maximum {{ filename_max_length }} caractères.',
    'The password strength is too low. Please use a stronger password.' => 'La force du mot de passe est trop faible. Veuillez utiliser un mot de passe plus fort.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'Cette valeur contient des caractères qui ne sont pas autorisés par le niveau de restriction actuel.',
    'Using invisible characters is not allowed.' => 'Utiliser des caractères invisibles n\'est pas autorisé.',
    'Mixing numbers from different scripts is not allowed.' => 'Mélanger des chiffres provenant de différents scripts n\'est pas autorisé.',
    'Using hidden overlay characters is not allowed.' => 'Utiliser des caractères de superposition cachés n\'est pas autorisé.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'L\'extension du fichier est invalide ({{ extension }}). Les extensions autorisées sont {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'L\'encodage de caractères détecté est invalide ({{ detected }}). Les encodages autorisés sont {{ encodings }}.',
    'This value is not a valid MAC address.' => 'Cette valeur n\'est pas une adresse MAC valide.',
    'This URL is missing a top-level domain.' => 'Cette URL doit contenir un domaine de premier niveau.',
    'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.' => 'Cette valeur est trop courte. Elle doit contenir au moins un mot.|Cette valeur est trop courte. Elle doit contenir au moins {{ min }} mots.',
    'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.' => 'Cette valeur est trop longue. Elle doit contenir au maximum un mot.|Cette valeur est trop longue. Elle doit contenir au maximum {{ max }} mots.',
    'This value does not represent a valid week in the ISO 8601 format.' => 'Cette valeur ne représente pas une semaine valide au format ISO 8601.',
    'This value is not a valid week.' => 'Cette valeur n\'est pas une semaine valide.',
    'This value should not be before week "{{ min }}".' => 'Cette valeur ne doit pas être antérieure à la semaine "{{ min }}".',
    'This value should not be after week "{{ max }}".' => 'Cette valeur ne doit pas être postérieure à la semaine "{{ max }}".',
    'This form should not contain extra fields.' => 'Ce formulaire ne doit pas contenir de champs supplémentaires.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Le fichier téléchargé est trop volumineux. Merci d\'essayer d\'envoyer un fichier plus petit.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'Le jeton CSRF est invalide. Veuillez renvoyer le formulaire.',
    'This value is not a valid HTML5 color.' => 'Cette valeur n\'est pas une couleur HTML5 valide.',
    'Please enter a valid birthdate.' => 'Veuillez entrer une date de naissance valide.',
    'The selected choice is invalid.' => 'Le choix sélectionné est invalide.',
    'The collection is invalid.' => 'La collection est invalide.',
    'Please select a valid color.' => 'Veuillez sélectionner une couleur valide.',
    'Please select a valid country.' => 'Veuillez sélectionner un pays valide.',
    'Please select a valid currency.' => 'Veuillez sélectionner une devise valide.',
    'Please choose a valid date interval.' => 'Veuillez choisir un intervalle de dates valide.',
    'Please enter a valid date and time.' => 'Veuillez saisir une date et une heure valides.',
    'Please enter a valid date.' => 'Veuillez entrer une date valide.',
    'Please select a valid file.' => 'Veuillez sélectionner un fichier valide.',
    'The hidden field is invalid.' => 'Le champ masqué n\'est pas valide.',
    'Please enter an integer.' => 'Veuillez saisir un entier.',
    'Please select a valid language.' => 'Veuillez sélectionner une langue valide.',
    'Please select a valid locale.' => 'Veuillez sélectionner une langue valide.',
    'Please enter a valid money amount.' => 'Veuillez saisir un montant valide.',
    'Please enter a number.' => 'Veuillez saisir un nombre.',
    'The password is invalid.' => 'Le mot de passe est invalide.',
    'Please enter a percentage value.' => 'Veuillez saisir un pourcentage valide.',
    'The values do not match.' => 'Les valeurs ne correspondent pas.',
    'Please enter a valid time.' => 'Veuillez saisir une heure valide.',
    'Please select a valid timezone.' => 'Veuillez sélectionner un fuseau horaire valide.',
    'Please enter a valid URL.' => 'Veuillez saisir une URL valide.',
    'Please enter a valid search term.' => 'Veuillez saisir un terme de recherche valide.',
    'Please provide a valid phone number.' => 'Veuillez fournir un numéro de téléphone valide.',
    'The checkbox has an invalid value.' => 'La case à cocher a une valeur non valide.',
    'Please enter a valid email address.' => 'Veuillez saisir une adresse email valide.',
    'Please select a valid option.' => 'Veuillez sélectionner une option valide.',
    'Please select a valid range.' => 'Veuillez sélectionner une plage valide.',
    'Please enter a valid week.' => 'Veuillez entrer une semaine valide.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Une exception d\'authentification s\'est produite.',
    'Authentication credentials could not be found.' => 'Les identifiants d\'authentification n\'ont pas pu être trouvés.',
    'Authentication request could not be processed due to a system problem.' => 'La requête d\'authentification n\'a pas pu être executée à cause d\'un problème système.',
    'Invalid credentials.' => 'Identifiants invalides.',
    'Cookie has already been used by someone else.' => 'Le cookie a déjà été utilisé par quelqu\'un d\'autre.',
    'Not privileged to request the resource.' => 'Privilèges insuffisants pour accéder à la ressource.',
    'Invalid CSRF token.' => 'Jeton CSRF invalide.',
    'No authentication provider found to support the authentication token.' => 'Aucun fournisseur d\'authentification n\'a été trouvé pour supporter le jeton d\'authentification.',
    'No session available, it either timed out or cookies are not enabled.' => 'Aucune session disponible, celle-ci a expiré ou les cookies ne sont pas activés.',
    'No token could be found.' => 'Aucun jeton n\'a pu être trouvé.',
    'Username could not be found.' => 'Le nom d\'utilisateur n\'a pas pu être trouvé.',
    'Account has expired.' => 'Le compte a expiré.',
    'Credentials have expired.' => 'Les identifiants ont expiré.',
    'Account is disabled.' => 'Le compte est désactivé.',
    'Account is locked.' => 'Le compte est bloqué.',
    'Too many failed login attempts, please try again later.' => 'Plusieurs tentatives de connexion ont échoué, veuillez réessayer plus tard.',
    'Invalid or expired login link.' => 'Lien de connexion invalide ou expiré.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Plusieurs tentatives de connexion ont échoué, veuillez réessayer dans %minutes% minute.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Trop de tentatives de connexion échouées, veuillez réessayer dans %minutes% minutes.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Précédent',
    'label_next' => 'Suivant',
    'filter_searchword' => 'Recherche...',
  ),
  'messages' => 
  array (
    'Signed in as' => 'Connecté en tant que',
    'Your Profile' => 'Votre profil',
    'Create Ticket' => 'Créer un ticket',
    'Create Agent' => 'Créer un agent',
    'Create Customer' => 'Créer un client',
    'Sign Out' => 'Déconnexion',
    'Default Language (Optional)' => 'Langue par défaut (facultatif)',
    'Swift Mailer ID' => 'ID d\'expéditeur rapide',
    'Username/Email' => 'Nom d\'utilisateur/Email',
    'create new' => 'créer un nouveau',
    'Howdy!' => 'Salut!',
    'Ticket Information' => 'Informations sur les tickets',
    'CC/BCC' => 'CC/BCC',
    'Success! Label created successfully.' => 'Étiquette créée avec succès.',
    'Success! Label removed successfully.' => ' Étiquette supprimée avec succès.',
    'Reports' => 'Rapports',
    'Rating' => 'Évaluation',
    'Kudos Rating' => 'Évaluation des appréciations',
    'Choose your default timeformat' => 'Choisissez votre format d\'heure par défaut',
    'Remove profile picture' => 'Supprimer la photo de profil',
    'Success ! Profile updated successfully.' => 'Succès ! Mise à jour du profil réussie.',
    'Howdy' => 'Salut',
    'Form successfully updated.' => 'Formulaire mis à jour avec succès.',
    'NEW FORM' => 'NOUVEAU FORMULAIRE',
    'Text Box' => 'Zone de texte',
    'Text Area' => 'Zone de texte',
    'Select' => 'Sélectionner',
    'Radio' => 'Radio',
    'Checkbox' => 'Case à cocher',
    'Date' => 'Date',
    'Both Date and Time' => 'Date et heure',
    'Choose a status' => 'Choisissez un statut',
    'Choose a group' => 'Choisissez un groupe',
    'Can manage Group\'s Saved Reply' => 'Peut gérer la réponse enregistrée du groupe',
    'Can manage agent activity' => 'Peut gérer l\'activité des agents',
    'Slug is the url identity of this article. We will help you to create valid slug at time of typing.' => 'Slug est l\'identité URL de cet article. Nous vous aiderons à créer un slug valide au moment de la saisie.',
    'The URL for this article' => 'L\'URL de cet article',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A page\'s title tag and meta description are usually shown whenever that page appears in search engine results' => 'Les balises de titre et les méta descriptions sont des morceaux de code HTML dans l\'en-tête d\'une page Web. Ils aident les moteurs de recherche à comprendre le contenu d\'une page. La balise de titre et la méta description d\'une page sont généralement affichées chaque fois que cette page apparaît dans les résultats des moteurs de recherche.',
    'comma separated (,)' => 'séparées par des virgules (,)',
    'Article Title' => 'Le titre de l\'article',
    'Start typing few charactors and add set of relevant article from the list' => 'Commencez à taper quelques caractères et ajoutez un ensemble d\'articles pertinents dans la liste',
    'Success! Announcement data saved successfully.' => 'Succès! Les données d\'annonce ont été enregistrées avec succès.',
    'Success! Category has been added successfully.' => 'Succès! La catégorie a été ajoutée avec succès.',
    'Success ! Agent added successfully.' => 'Succès ! Agent ajouté avec succès.',
    'Success! Privilege information saved successfully.' => 'Succès! Les informations de privilège ont été enregistrées avec succès.',
    'Edit Prepared Response' => 'Modifier la réponse préparée',
    'Success! Type removed successfully.' => 'Succès! Type supprimé avec succès.',
    'No results available' => 'Aucun résultat disponible',
    'Success ! Prepared Response applied successfully.' => 'Succès ! Réponse préparée appliquée avec succès.',
    'Note added to ticket successfully.' => 'Remarque ajoutée au ticket avec succès.',
    'Ticket status update to Spam' => 'Mise à jour du statut du ticket vers le spam',
    'Ticket status update to Closed' => 'Mise à jour du statut du ticket sur Fermé',
    'Success! Label updated successfully.' => 'Succès! Libellé mis à jour avec succès.',
    'Success ! Helpdesk details saved successfully' => 'Succès ! Détails du service d\'assistance enregistrés avec succès',
    'Can manage marketing announcement' => 'Peut gérer l\'annonce marketing',
    'User Forgot Password' => 'L\'utilisateur a oublié le mot de passe',
    'Agent Deleted' => 'Agent supprimé',
    'Agent Update' => 'Mise à jour des agents',
    'Customer Update' => 'Mise à jour client',
    'Customer Deleted' => 'Client supprimé',
    'Agent Updated' => 'Agent mis à jour',
    'Agent Reply' => 'Réponse de l\'agent',
    'Collaborator Added' => 'Collaborateur ajouté',
    'Collaborator Reply' => 'Réponse du collaborateur',
    'Customer Reply' => 'Réponse du client',
    'Ticket Deleted' => 'Ticket supprimé',
    'Group Updated' => 'Groupe mis à jour',
    'Note Added' => 'Remarque ajoutée',
    'Priority Updated' => 'Priorité mise à jour',
    'Status Updated' => 'Statut mis à jour',
    'Team Updated' => 'Équipe mise à jour',
    'Thread Updated' => 'Sujet mis à jour',
    'Type Updated' => 'Type mis à jour',
    'From Email' => 'De l\'email',
    'To Email' => 'Envoyer un email',
    'Is Equal To' => 'Est égal à',
    'Is Not Equal To' => 'n\'est pas égal à',
    'Contains' => 'Contient',
    'Does Not Contain' => 'Ne contient pas',
    'Starts With' => 'Commence avec',
    'Ends With' => 'Se termine par',
    'Before On' => 'Avant le',
    'After On' => 'Après le',
    'Mail To User' => 'Courrier à l\'utilisateur',
    'Permanently delete from Inbox' => 'Supprimer définitivement de la boîte de réception',
    'Transfer Tickets' => 'Tickets de transfert',
    'Agent Activity' => 'Activité de l\'agent',
    'Report From' => 'Rapport de',
    'Search Agent' => 'Agent de recherche',
    'Agent Last Reply' => 'Dernière réponse de l\'agent',
    'View analytics and insights to serve a better experience for your customers' => 'Affichez des analyses et des informations pour offrir une meilleure expérience à vos clients',
    'Marketing Announcement' => 'Annonce marketing',
    'Advertisement' => 'Publicité',
    'Announcement' => 'Annonce',
    'New Announcement' => 'Nouvelle annonce',
    'Add Announcement' => 'Ajouter une annonce',
    'Edit Announcement' => 'Modifier l\'annonce',
    'Promo Text' => 'Texte promotionnel',
    'Promo Tag' => 'Balise promotionnelle',
    'Choose a promo tag' => 'Choisissez un tag promotionnel',
    'Tag-Color' => 'Couleur de l\'étiquette',
    'Tag background color' => 'Couleur d\'arrière-plan de l\'étiquette',
    'Link Text' => 'Texte du lien',
    'Link URL' => 'URL du lien',
    'Apps' => 'Applications',
    'Integrate apps as per your needs to get things done faster than ever' => ' Installez de nouvelles applications personnalisées pour booster votre productivité – <a href=\'https://store.webkul.com/UVdesk/UVdesk-Open-Source.html\' style=\'font-weight: bold\' target=\'_blank\'>Explorer maintenant</a>',
    'Explore Apps' => 'Explorer les applications',
    'Form Builder' => 'Générateur de formulaires',
    'Knowledgebase' => 'Base de connaissances',
    'Knowledgebase is a source of rigid and complex information which helps Customers to help themselves' => 'La base de connaissances est une source d\'informations rigides et complexes qui aide les clients à s\'aider eux-mêmes',
    'Articles' => 'Articles',
    'Categories' => 'Catégories',
    'Folders' => 'Dossiers',
    'FOLDERS' => 'DOSSIERS',
    'Productivity' => 'Productivité',
    'Automate your processes by creating set of rules and presets to respond faster to the tickets' => 'Automatisez vos processus en créant un ensemble de règles et de préréglages pour répondre plus rapidement aux tickets',
    'Prepared Responses' => 'Réponses préparées',
    'Saved Replies' => 'Réponses enregistrées',
    'Edit Saved Reply' => 'Modifier la réponse enregistrée',
    'Ticket Types' => 'Types de tickets',
    'Workflows' => 'Flux de travail',
    'Settings' => 'Paramètres',
    'Manage your Brand Identity, Company Information and other details at a glance' => 'Gérez l\'identité de votre marque, les informations sur votre entreprise et d\'autres détails en un coup d\'œil',
    'Branding' => 'Image de marque',
    'Custom Fields' => 'Les champs personnalisés',
    'Email Settings' => 'Paramètres de messagerie',
    'Email Templates' => 'Modèles de courrier électronique',
    'Mailbox' => 'Boites aux lettres',
    'Spam Settings' => 'Paramètres de spam',
    'Swift Mailer' => 'Swift Mailer',
    'Tags' => 'Mots clés',
    'Users' => 'Utilisateurs',
    'Control your Groups, Teams, Agents and Customers' => 'Contrôlez vos groupes, équipes, agents et clients',
    'Agents' => 'Agents',
    'Customers' => 'Les clients',
    'Groups' => 'Groupes',
    'Privileges' => 'Privilèges',
    'Teams' => 'Equipes',
    'Applications' => 'Applications',
    'ECommerce Order Syncronization' => 'Synchronisation des commandes de commerce électronique',
    'Import ecommerce order details to your support tickets from different available platforms' => 'Importer les détails de la commande de commerce électronique sur vos tickets de support depuis différentes plates-formes disponibles',
    'Search' => 'Rechercher',
    'Sort By' => 'Trier par',
    'Sort By:' => 'Trier par:',
    'Status' => 'Statut',
    'Created At' => 'Créé à',
    'Name' => 'Nom',
    'All' => 'Tout',
    'Published' => 'Publié',
    'Draft' => 'Brouillon',
    'New Folder' => 'Nouveau dossier',
    'Create Knowledgebase Folder' => 'Créer un dossier de base de connaissances',
    'You did not add any folder to your Knowledgebase yet, Create your first Folder and start adding Categories/Articles to make your customers help themselves.' => 'Vous navez pas encore ajouté de dossier à votre base de connaissances. Créez votre premier dossier et commencez à ajouter des catégories / articles pour que vos clients se servent eux-mêmes.',
    'Clear Filters' => 'Effacer les filtres',
    'Back' => 'Retour',
    'Open' => 'Ouvert',
    'Pending' => 'En attente',
    'Answered' => 'Répondu',
    'Resolved' => 'Résolu',
    'Closed' => 'Fermé',
    'Spam' => 'Spam',
    'New' => 'Nouveau',
    'UnAssigned' => 'Non attribué',
    'UnAnswered' => 'Sans réponse',
    'My Tickets' => 'Mes tickets',
    'Starred' => 'Favoris',
    'Trashed' => 'Corbeille',
    'New Label' => 'Nouvelle étiquette',
    'Tickets' => 'Tickets',
    'Ticket Id' => 'ID de tickets',
    'Last Replied' => 'Dernière réponse',
    'Assign To' => 'Affectation',
    'After Reply' => 'Après réponse',
    'Customer Email' => 'Email client',
    'Customer Name' => 'Nom du client',
    'Assets Visibility' => 'Afficher',
    'Channel/Source' => 'Canal / Origine',
    'Channel' => 'Canal',
    'Website' => 'Site Internet',
    'Timestamp' => 'Horodatage',
    'TimeStamp' => 'Horodatage',
    'Team' => 'Équipe',
    'Type' => 'Type',
    'Replies' => 'Réponses',
    'Agent' => 'Agent',
    'ID' => 'ID',
    'Subject' => 'Sujet',
    'Last Reply' => 'Dernière réponse',
    'Filter View' => 'Filtres',
    'Please select CAPTCHA' => 'Veuillez sélectionner CAPTCHA',
    'Warning ! Please select correct CAPTCHA !' => 'Avertissement! Veuillez sélectionner le bon CAPTCHA!',
    'reCAPTCHA Setting' => 'Réglage reCAPTCHA',
    'reCAPTCHA Site Key' => 'reCAPTCHA Site Key',
    'reCAPTCHA Secret key' => 'Clé secrète reCAPTCHA',
    'reCAPTCHA Status' => 'Statut de reCAPTCHA',
    'reCAPTCHA is Active' => 'reCAPTCHA est actif',
    'Save set of filters as a preset to stay more productive' => 'Enregistrer un ensemble de filtres en tant que préréglage pour rester plus productif',
    'Saved Filters' => 'Filtres enregistrés',
    'No saved filter created' => 'Aucun filtre enregistré créé',
    'Customer' => 'Client',
    'Priority' => 'Priorité',
    'Tag' => 'Étiquette',
    'Source' => 'Origine',
    'Before' => 'Avant',
    'After' => 'Après',
    'Replies less than' => 'Réponses inférieures à',
    'Replies more than' => 'Réponses supérieures à',
    'Clear All' => 'Tout effacer',
    'Account' => 'Compte',
    'Profile' => 'Profil',
    'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format' => 'Télécharger une image de profil (100px x 100px) <br> au format PNG ou JPG',
    'First Name' => 'Prénom',
    'Last Name' => 'Nom',
    'Email' => 'Email',
    'Contact Number' => 'Téléphone',
    'Timezone' => 'Fuseau horaire',
    'Africa/Abidjan' => 'Africa / Abidjan',
    'Africa/Accra' => 'Afrique / Accra',
    'Africa/Addis_Ababa' => 'Africa / Addis_Ababa',
    'Africa/Algiers' => 'Afrique / Alger',
    'Africa/Asmara' => 'Africa / Asmara',
    'Africa/Bamako' => 'Afrique / Bamako',
    'Africa/Bangui' => 'Africa / Bangui',
    'Africa/Banjul' => 'Africa / Banjul',
    'Africa/Bissau' => 'Afrique / Bissau',
    'Africa/Blantyre' => 'Africa / Blantyre',
    'Africa/Brazzaville' => 'Africa / Brazzaville',
    'Africa/Bujumbura' => 'Africa / Bujumbura',
    'Africa/Cairo' => 'Afrique / Caire',
    'Africa/Casablanca' => 'Afrique / Casablanca',
    'Africa/Ceuta' => 'Africa / Ceuta',
    'Africa/Conakry' => 'Africa / Conakry',
    'Africa/Dakar' => 'Afrique / Dakar',
    'Africa/Dar_es_Salaam' => 'Africa / Dar_es_Salaam',
    'Africa/Djibouti' => 'Afrique / Djibouti',
    'Africa/Douala' => 'Africa / Douala',
    'Africa/El_Aaiun' => 'Africa / El_Aaiun',
    'Africa/Freetown' => 'Africa / Freetown',
    'Africa/Gaborone' => 'Africa / Gaborone',
    'Africa/Harare' => 'Afrique / Harare',
    'Africa/Johannesburg' => 'Afrique / Johannesburg',
    'Africa/Juba' => 'Africa / Juba',
    'Africa/Kampala' => 'Africa / Kampala',
    'Africa/Khartoum' => 'Africa / Khartoum',
    'Africa/Kigali' => 'Africa / Kigali',
    'Africa/Kinshasa' => 'Africa / Kinshasa',
    'Africa/Lagos' => 'Africa / Lagos',
    'Africa/Libreville' => 'Africa / Libreville',
    'Africa/Lome' => 'Afrique / Lomé',
    'Africa/Luanda' => 'Africa / Luanda',
    'Africa/Lubumbashi' => 'Africa / Lubumbashi',
    'Africa/Lusaka' => 'Africa / Lusaka',
    'Africa/Malabo' => 'Africa / Malabo',
    'Africa/Maputo' => 'Africa / Maputo',
    'Africa/Maseru' => 'Africa / Maseru',
    'Africa/Mbabane' => 'Africa / Mbabane',
    'Africa/Mogadishu' => 'Africa / Mogadishu',
    'Africa/Monrovia' => 'Africa / Monrovia',
    'Africa/Nairobi' => 'Africa / Nairobi',
    'Africa/Ndjamena' => 'Africa / Ndjamena',
    'Africa/Niamey' => 'Africa / Niamey',
    'Africa/Nouakchott' => 'Africa / Nouakchott',
    'Africa/Ouagadougou' => 'Africa / Ouagadougou',
    'Africa/Porto-Novo' => 'Africa / Porto-Novo',
    'Africa/Sao_Tome' => 'Africa / Sao_Tome',
    'Africa/Tripoli' => 'Africa / Tripoli',
    'Africa/Tunis' => 'Afrique / Tunis',
    'Africa/Windhoek' => 'Africa / Windhoek',
    'America/Adak' => 'America / Adak',
    'America/Anchorage' => 'America / Anchorage',
    'America/Anguilla' => 'America / Anguilla',
    'America/Antigua' => 'America / Antigua',
    'America/Araguaina' => 'America / Araguaina',
    'America/Argentina/Buenos_Aires' => 'Amérique / Argentine / Buenos_Aires',
    'America/Argentina/Catamarca' => 'Amérique / Argentine / Catamarca',
    'America/Argentina/Cordoba' => 'Amérique / Argentine / Cordoba',
    'America/Argentina/Jujuy' => 'Amérique / Argentine / Jujuy',
    'America/Argentina/La_Rioja' => 'America / Argentina / La_Rioja',
    'America/Argentina/Mendoza' => 'Amérique / Argentine / Mendoza',
    'America/Argentina/Rio_Gallegos' => 'Amérique / Argentine / Rio_Gallegos',
    'America/Argentina/Salta' => 'Amérique / Argentine / Salta',
    'America/Argentina/San_Juan' => 'Amérique / Argentine / San Juan',
    'America/Argentina/San_Luis' => 'Amérique / Argentine / San_Luis',
    'America/Argentina/Tucuman' => 'Amérique / Argentine / Tucuman',
    'America/Argentina/Ushuaia' => 'Amérique / Argentine / Ushuaia',
    'America/Aruba' => 'America / Aruba',
    'America/Asuncion' => 'America / Asuncion',
    'America/Atikokan' => 'America / Atikokan',
    'America/Bahia' => 'America / Bahia',
    'America/Bahia_Banderas' => 'America / Bahia_Banderas',
    'America/Barbados' => 'Amérique / Barbade',
    'America/Belem' => 'America / Belem',
    'America/Belize' => 'Amérique / Belize',
    'America/Blanc-Sablon' => 'America / Blanc-Sablon',
    'America/Boa_Vista' => 'America / Boa_Vista',
    'America/Bogota' => 'America / Bogota',
    'America/Boise' => 'America / Boise',
    'America/Cambridge_Bay' => 'America / Cambridge_Bay',
    'America/Campo_Grande' => 'America / Campo_Grande',
    'America/Cancun' => 'America / Cancun',
    'America/Caracas' => 'America / Caracas',
    'America/Cayenne' => 'America / Cayenne',
    'America/Cayman' => 'America / Cayman',
    'America/Chicago' => 'America / Chicago',
    'America/Chihuahua' => 'America / Chihuahua',
    'America/Costa_Rica' => 'Amérique / Costa_Rica',
    'America/Creston' => 'America / Creston',
    'America/Cuiaba' => 'America / Cuiaba',
    'America/Curacao' => 'America / Curaçao',
    'America/Danmarkshavn' => 'America / Danmarkshavn',
    'America/Dawson' => 'America / Dawson',
    'America/Dawson_Creek' => 'America / Dawson_Creek',
    'America/Denver' => 'America / Denver',
    'America/Detroit' => 'America / Detroit',
    'America/Dominica' => 'Amérique / Dominique',
    'America/Edmonton' => 'America / Edmonton',
    'America/Eirunepe' => 'America / Eirunepe',
    'America/El_Salvador' => 'America / El_Salvador',
    'America/Fort_Nelson' => 'America / Fort_Nelson',
    'America/Fortaleza' => 'America / Fortaleza',
    'America/Glace_Bay' => 'America / Glace_Bay',
    'America/Godthab' => 'America / Godthab',
    'America/Goose_Bay' => 'America / Goose_Bay',
    'America/Grand_Turk' => 'America / Grand_Turk',
    'America/Grenada' => 'Amérique / Grenade',
    'America/Guadeloupe' => 'Amérique / Guadeloupe',
    'America/Guatemala' => 'Amérique / Guatemala',
    'America/Guayaquil' => 'America / Guayaquil',
    'America/Guyana' => 'America / Guyana',
    'America/Halifax' => 'America / Halifax',
    'America/Havana' => 'America / Havana',
    'America/Hermosillo' => 'America / Hermosillo',
    'America/Indiana/Indianapolis' => 'America / Indiana / Indianapolis',
    'America/Indiana/Knox' => 'America / Indiana / Knox',
    'America/Indiana/Marengo' => 'America / Indiana / Marengo',
    'America/Indiana/Petersburg' => 'America / Indiana / Petersburg',
    'America/Indiana/Tell_City' => 'America / Indiana / Tell_City',
    'America/Indiana/Vevay' => 'America / Indiana / Vevay',
    'America/Indiana/Vincennes' => 'America / Indiana / Vincennes',
    'America/Indiana/Winamac' => 'America / Indiana / Winamac',
    'America/Inuvik' => 'America / Inuvik',
    'America/Iqaluit' => 'America / Iqaluit',
    'America/Jamaica' => 'America / Jamaica',
    'America/Juneau' => 'America / Juneau',
    'America/Kentucky/Louisville' => 'America / Kentucky / Louisville',
    'America/Kentucky/Monticello' => 'America / Kentucky / Monticello',
    'America/Kralendijk' => 'America / Kralendijk',
    'America/La_Paz' => 'America / La_Paz',
    'America/Lima' => 'America / Lima',
    'America/Los_Angeles' => 'America / Los_Angeles',
    'America/Lower_Princes' => 'America / Lower_Princes',
    'America/Maceio' => 'America / Maceio',
    'America/Managua' => 'America / Managua',
    'America/Manaus' => 'America / Manaus',
    'America/Marigot' => 'America / Marigot',
    'America/Martinique' => 'Amérique / Martinique',
    'America/Matamoros' => 'Amérique / Matamoros',
    'America/Mazatlan' => 'America / Mazatlan',
    'America/Menominee' => 'America / Menominee',
    'America/Merida' => 'America / Merida',
    'America/Metlakatla' => 'America / Metlakatla',
    'America/Mexico_City' => 'America / Mexico_City',
    'America/Miquelon' => 'America / Miquelon',
    'America/Moncton' => 'America / Moncton',
    'America/Monterrey' => 'America / Monterrey',
    'America/Montevideo' => 'America / Montevideo',
    'America/Montserrat' => 'America / Montserrat',
    'America/Nassau' => 'America / Nassau',
    'America/New_York' => 'America / New_York',
    'America/Nipigon' => 'America / Nipigon',
    'America/Nome' => 'America / Nome',
    'America/Noronha' => 'America / Noronha',
    'America/North_Dakota/Beulah' => 'Amérique / Dakota du Nord / Beulah',
    'America/North_Dakota' => 'America / North_Dakota',
    'America/Ojinaga' => 'America / Ojinaga',
    'America/Panama' => 'America / Panama',
    'America/Pangnirtung' => 'America / Pangnirtung',
    'America/Paramaribo' => 'America / Paramaribo',
    'America/Phoenix' => 'America / Phoenix',
    'America/Port-au-Prince' => 'America / Port-au-Prince',
    'America/Port_of_Spain' => 'America / Port_of_Spain',
    'America/Porto_Velho' => 'America / Porto_Velho',
    'America/Puerto_Rico' => 'America / Puerto_Rico',
    'America/Punta_Arenas' => 'America / Punta_Arenas',
    'America/Rainy_River' => 'America / Rainy_River',
    'America/Rankin_Inlet' => 'America / Rankin_Inlet',
    'America/Recife' => 'America / Recife',
    'America/Regina' => 'America / Regina',
    'America/Resolute' => 'America / Resolute',
    'America/Rio_Branco' => 'America / Rio_Branco',
    'America/Santarem' => 'America / Santarem',
    'America/Santiago' => 'America / Santiago',
    'America/Santo_Domingo' => 'America / Santo_Domingo',
    'America/Sao_Paulo' => 'America / Sao_Paulo',
    'America/Scoresbysund' => 'America / Scoresbysund',
    'America/Sitka' => 'America / Sitka',
    'America/St_Barthelemy' => 'America / St_Barthelemy',
    'America/St_Johns' => 'America / St_Johns',
    'America/St_Kitts' => 'America / St_Kitts',
    'America/St_Lucia' => 'America / St_Lucia',
    'America/St_Thomas' => 'America / St_Thomas',
    'America/St_Vincent' => 'America / St_Vincent',
    'America/Swift_Current' => 'America / Swift_Current',
    'America/Tegucigalpa' => 'America / Tegucigalpa',
    'America/Thule' => 'America / Thule',
    'America/Thunder_Bay' => 'America / Thunder_Bay',
    'America/Tijuana' => 'America / Tijuana',
    'America/Toronto' => 'America / Toronto',
    'America/Tortola' => 'America / Tortola',
    'America/Vancouver' => 'America / Vancouver',
    'America/Whitehorse' => 'America / Whitehorse',
    'America/Winnipeg' => 'America / Winnipeg',
    'America/Yakutat' => 'America / Yakutat',
    'America/Yellowknife' => 'Amérique / Yellowknife',
    'Antarctica/Casey' => 'Antarctique / Casey',
    'Antarctica/Davis' => 'Antarctique / Davis',
    'Antarctica/DumontDUrville' => 'Antarctique / DumontDUrville',
    'Antarctica/Macquarie' => 'Antarctique / Macquarie',
    'Antarctica/McMurdo' => 'Antarctique / McMurdo',
    'Antarctica/Mawson' => 'Antarctique / Mawson',
    'Antarctica/Palmer' => 'Antarctique / Palmer',
    'Antarctica/Rothera' => 'Antarctique / Rothera',
    'Antarctica/Syowa' => 'Antarctique / Syowa',
    'Antarctica/Troll' => 'Antarctique / Troll',
    'Antarctica/Vostok' => 'Antarctique / Vostok',
    'Arctic/Longyearbyen' => 'Arctique / Longyearbyen',
    'Asia/Aden' => 'Asia / Aden',
    'Asia/Almaty' => 'Asia / Almaty',
    'Asia/Amman' => 'Asia / Amman',
    'Asia/Anadyr' => 'Asia / Anadyr',
    'Asia/Aqtau' => 'Asia / Aqtau',
    'Asia/Aqtobe' => 'Asia / Aqtobe',
    'Asia/Ashgabat' => 'Asia / Ashgabat',
    'Asia/Atyrau' => 'Asia / Atyrau',
    'Asia/Baghdad' => 'Asia / Bagdad',
    'Asia/Bahrain' => 'Asie / Bahreïn',
    'Asia/Baku' => 'Asia / Baku',
    'Asia/Bangkok' => 'Asia / Bangkok',
    'Asia/Barnaul' => 'Asia / Barnaul',
    'Asia/Beirut' => 'Asie / Beyrouth',
    'Asia/Bishkek' => 'Asia / Bishkek',
    'Asia/Brunei' => 'Asie / Brunei',
    'Asia/Chita' => 'Asia / Chita',
    'Asia/Choibalsan' => 'Asia / Choibalsan',
    'Asia/Colombo' => 'Asia / Colombo',
    'Asia/Damascus' => 'Asie / Damas',
    'Asia/Dhaka' => 'Asia / Dhaka',
    'Asia/Dili' => 'Asia / Dili',
    'Asia/Dubai' => 'Asia / Dubai',
    'Asia/Dushanbe' => 'Asia / Douchanbé',
    'Asia/Famagusta' => 'Asia / Famagouste',
    'Asia/Gaza' => 'Asie / Gaza',
    'Asia/Hebron' => 'Asia / Hebron',
    'Asia/Ho_Chi_Minh' => 'Asia / Ho_Chi_Minh',
    'Asia/Hong_Kong' => 'Asie / Hong Kong',
    'Asia/Hovd' => 'Asia / Hovd',
    'Asia/Irkutsk' => 'Asia / Irkutsk',
    'Asia/Jakarta' => 'Asia / Jakarta',
    'Asia/Jayapura' => 'Asia / Jayapura',
    'Asia/Jerusalem' => 'Asie / Jérusalem',
    'Asia/Kabul' => 'Asia / Kaboul',
    'Asia/Kamchatka' => 'Asie / Kamchatka',
    'Asia/Karachi' => 'Asia / Karachi',
    'Asia/Kathmandu' => 'Asia / Kathmandu',
    'Asia/Khandyga' => 'Asia / Khandyga',
    'Asia/Kolkata' => 'Asia / Kolkata',
    'Asia/Krasnoyarsk' => 'Asia / Krasnoyarsk',
    'Asia/Kuala_Lumpur' => 'Asia / Kuala_Lumpur',
    'Asia/Kuching' => 'Asia / Kuching',
    'Asia/Kuwait' => 'Asie / Koweït',
    'Asia/Macau' => 'Asie / Macao',
    'Asia/Magadan' => 'Asia / Magadan',
    'Asia/Makassar' => 'Asia / Makassar',
    'Asia/Manila' => 'Asia / Manila',
    'Asia/Muscat' => 'Asie / Muscat',
    'Asia/Nicosia' => 'Asie / Nicosie',
    'Asia/Novokuznetsk' => 'Asia / Novokuznetsk',
    'Asia/Novosibirsk' => 'Asia / Novosibirsk',
    'Asia/Omsk' => 'Asia / Omsk',
    'Asia/Oral' => 'Asie / Oral',
    'Asia/Phnom_Penh' => 'Asia / Phnom_Penh',
    'Asia/Pontianak' => 'Asia / Pontianak',
    'Asia/Pyongyang' => 'Asia / Pyongyang',
    'Asia/Qatar' => 'Asie / Qatar',
    'Asia/Qostanay' => 'Asia / Qostanay',
    'Asia/Qyzylorda' => 'Asia / Qyzylorda',
    'Asia/Riyadh' => 'Asia / Riyadh',
    'Asia/Sakhalin' => 'Asia / Sakhalin',
    'Asia/Samarkand' => 'Asia / Samarkand',
    'Asia/Seoul' => 'Asia / Seoul',
    'Asia/Shanghai' => 'Asie / Shanghai',
    'Asia/Singapore' => 'Asie / Singapour',
    'Asia/Srednekolymsk' => 'Asia / Srednekolymsk',
    'Asia/Taipei' => 'Asia / Taipei',
    'Asia/Tashkent' => 'Asie / Tachkent',
    'Asia/Tbilisi' => 'Asia / Tbilisi',
    'Asia/Tehran' => 'Asia / Téhéran',
    'Asia/Thimphu' => 'Asia / Thimphu',
    'Asia/Tokyo' => 'Asie / Tokyo',
    'Asia/Tomsk' => 'Asia / Tomsk',
    'Asia/Ulaanbaatar' => 'Asia / Ulaanbaatar',
    'Asia/Urumqi' => 'Asia / Urumqi',
    'Asia/Ust-Nera' => 'Asia / Ust-Nera',
    'Asia/Vientiane' => 'Asia / Vientiane',
    'Asia/Vladivostok' => 'Asia / Vladivostok',
    'Asia/Yakutsk' => 'Asia / Yakutsk',
    'Asia/Yangon' => 'Asia / Yangon',
    'Asia/Yekaterinburg' => 'Asie / Iekaterinbourg',
    'Asia/Yerevan' => 'Asie / Erevan',
    'Atlantic/Azores' => 'Atlantique / Açores',
    'Atlantic/Bermuda' => 'Atlantique / Bermudes',
    'Atlantic/Canary' => 'Atlantique / Canaries',
    'Atlantic/Cape_Verde' => 'Atlantic / Cape_Verde',
    'Atlantic/Faroe' => 'Atlantique / Féroé',
    'Atlantic/Madeira' => 'Atlantique / Madère',
    'Atlantic/Reykjavik' => 'Atlantique / Reykjavik',
    'Atlantic/South_Georgia' => 'Atlantique / Sud_Géorgie',
    'Atlantic/St_Helena' => 'Atlantic / St_Helena',
    'Atlantic/Stanley' => 'Atlantique / Stanley',
    'Australia/Adelaide' => 'Australie / Adélaïde',
    'Australia/Brisbane' => 'Australie / Brisbane',
    'Australia/Broken_Hill' => 'Australie / Broken_Hill',
    'Australia/Currie' => 'Australie / Currie',
    'Australia/Darwin' => 'Australie / Darwin',
    'Australia/Eucla' => 'Australie / Eucla',
    'Australia/Hobart' => 'Australie / Hobart',
    'Australia/Lindeman' => 'Australie / Lindeman',
    'Australia/Lord_Howe' => 'Australie / Lord_Howe',
    'Australia/Melbourne' => 'Australie / Melbourne',
    'Australia/Perth' => 'Australie / Perth',
    'Australia/Sydney' => 'Australie / Sydney',
    'Europe/Amsterdam' => 'Europe / Amsterdam',
    'Europe/Andorra' => 'Europe / Andorre',
    'Europe/Astrakhan' => 'Europe / Astrakhan',
    'Europe/Athens' => 'Europe / Athènes',
    'Europe/Belgrade' => 'Europe / Belgrade',
    'Europe/Berlin' => 'Europe / Berlin',
    'Europe/Bratislava' => 'Europe / Bratislava',
    'Europe/Brussels' => 'Europe / Bruxelles',
    'Europe/Bucharest' => 'Europe / Bucarest',
    'Europe/Budapest' => 'Europe / Budapest',
    'Europe/Busingen' => 'Europe / Busingen',
    'Europe/Chisinau' => 'Europe / Chisinau',
    'Europe/Copenhagen' => 'Europe / Copenhague',
    'Europe/Dublin' => 'Europe / Dublin',
    'Europe/Gibraltar' => 'Europe / Gibraltar',
    'Europe/Guernsey' => 'Europe / Guernesey',
    'Europe/Helsinki' => 'Europe / Helsinki',
    'Europe/Isle_of_Man' => 'Europe / Isle_of_Man',
    'Europe/Istanbul' => 'Europe / Istanbul',
    'Europe/Jersey' => 'Europe / Jersey',
    'Europe/Kaliningrad' => 'Europe / Kaliningrad',
    'Europe/Kiev' => 'Europe / Kiev',
    'Europe/Kirov' => 'Europe / Kirov',
    'Europe/Lisbon' => 'Europe / Lisbonne',
    'Europe/Ljubljana' => 'Europe / Ljubljana',
    'Europe/London' => 'Europe / Londres',
    'Europe/Luxembourg' => 'Europe / Luxembourg',
    'Europe/Madrid' => 'Europe / Madrid',
    'Europe/Malta' => 'Europe / Malte',
    'Europe/Mariehamn' => 'Europe / Mariehamn',
    'Europe/Minsk' => 'Europe / Minsk',
    'Europe/Monaco' => 'Europe / Monaco',
    'Europe/Moscow' => 'Europe / Moscou',
    'Europe/Oslo' => 'Europe / Oslo',
    'Europe/Paris' => 'Europe / Paris',
    'Europe/Podgorica' => 'Europe / Podgorica',
    'Europe/Prague' => 'Europe / Prague',
    'Europe/Riga' => 'Europe / Riga',
    'Europe/Rome' => 'Europe / Rome',
    'Europe/Samara' => 'Europe / Samara',
    'Europe/San_Marino' => 'Europe / San_Marino',
    'Europe/Sarajevo' => 'Europe / Sarajevo',
    'Europe/Saratov' => 'Europe / Saratov',
    'Europe/Simferopol' => 'Europe / Simferopol',
    'Europe/Skopje' => 'Europe / Skopje',
    'Europe/Sofia' => 'Europe / Sofia',
    'Europe/Stockholm' => 'Europe / Stockholm',
    'Europe/Tallinn' => 'Europe / Tallinn',
    'Europe/Tirane' => 'Europe / Tirane',
    'Europe/Ulyanovsk' => 'Europe / Ulyanovsk',
    'Europe/Uzhgorod' => 'Europe / Uzhgorod',
    'Europe/Vaduz' => 'Europe / Vaduz',
    'Europe/Vatican' => 'Europe / Vatican',
    'Europe/Vienna' => 'Europe / Vienne',
    'Europe/Vilnius' => 'Europe / Vilnius',
    'Europe/Volgograd' => 'Europe / Volgograd',
    'Europe/Warsaw' => 'Europe / Varsovie',
    'Europe/Zagreb' => 'Europe / Zagreb',
    'Europe/Zaporozhye' => 'Europe / Zaporozhye',
    'Europe/Zurich' => 'Europe / Zurich',
    'Indian/Antananarivo' => 'Indien / Antananarivo',
    'Indian/Chagos' => 'Indien / Chagos',
    'Indian/Christmas' => 'Indien / Noël',
    'Indian/Cocos' => 'Indien / Cocos',
    'Indian/Comoro' => 'Indien / Comoro',
    'Indian/Kerguelen' => 'Indien / Kerguelen',
    'Indian/Mahe' => 'Indien / Mahe',
    'Indian/Maldives' => 'Indien / Maldives',
    'Indian/Mauritius' => 'Indien / Maurice',
    'Indian/Mayotte' => 'Indien / Mayotte',
    'Indian/Reunion' => 'Indien / Réunion',
    'Pacific/Apia' => 'Pacifique / Apia',
    'Pacific/Auckland' => 'Pacific / Auckland',
    'Pacific/Bougainville' => 'Pacific / Bougainville',
    'Pacific/Chatham' => 'Pacifique / Chatham',
    'Pacific/Chuuk' => 'Pacifique / Chuuk',
    'Pacific/Easter' => 'Pacifique / Pâques',
    'Pacific/Efate' => 'Pacifique / Efate',
    'Pacific/Enderbury' => 'Pacific / Enderbury',
    'Pacific/Fakaofo' => 'Pacifique / Fakaofo',
    'Pacific/Fiji' => 'Pacifique / Fidji',
    'Pacific/Funafuti' => 'Pacific / Funafuti',
    'Pacific/Galapagos' => 'Pacifique / Galapagos',
    'Pacific/Gambier' => 'Pacific / Gambier',
    'Pacific/Guadalcanal' => 'Pacifique / Guadalcanal',
    'Pacific/Guam' => 'Pacifique / Guam',
    'Pacific/Honolulu' => 'Pacific / Honolulu',
    'Pacific/Kiritimati' => 'Pacifique / Kiritimati',
    'Pacific/Kosrae' => 'Pacific / Kosrae',
    'Pacific/Kwajalein' => 'Pacific / Kwajalein',
    'Pacific/Majuro' => 'Pacific / Majuro',
    'Pacific/Marquesas' => 'Pacifique / Marquises',
    'Pacific/Midway' => 'Pacifique / Midway',
    'Pacific/Nauru' => 'Pacifique / Nauru',
    'Pacific/Niue' => 'Pacifique / Niue',
    'Pacific/Norfolk' => 'Pacifique / Norfolk',
    'Pacific/Noumea' => 'Pacifique / Nouméa',
    'Pacific/Pago_Pago' => 'Pacific / Pago_Pago',
    'Pacific/Palau' => 'Pacifique / Palaos',
    'Pacific/Pitcairn' => 'Pacific / Pitcairn',
    'Pacific/Pohnpei' => 'Pacifique / Pohnpei',
    'Pacific/Port_Moresby' => 'Pacific / Port_Moresby',
    'Pacific/Rarotonga' => 'Pacifique / Rarotonga',
    'Pacific/Saipan' => 'Pacifique / Saipan',
    'Pacific/Tahiti' => 'Pacifique / Tahiti',
    'Pacific/Tarawa' => 'Pacific / Tarawa',
    'Pacific/Tongatapu' => 'Pacifique / Tongatapu',
    'Pacific/Wake' => 'Pacifique / Wake',
    'Pacific/Wallis' => 'Pacifique / Wallis',
    'UTC' => 'UTC',
    'Time Format' => 'Format de l\'heure',
    'Choose your default timezone' => 'Choisissez votre fuseau horaire par défaut',
    'Signature' => 'Signature',
    'User signature will be append at the bottom of ticket reply box' => 'La signature de l\'utilisateur sera ajoutée au bas de la boîte de réponse du ticket',
    'Password' => 'Mot de passe',
    'Password will remain same if you are not entering something in this field' => 'Le mot de passe restera le même si vous laissez ce champ vide',
    'Password must contain minimum 8 character length, at least two letters (not case sensitive), one number, one special character(space is not allowed).' => 'Le mot de passe doit contenir au moins 8 caractères, au moins deux lettres (non sensibles à la casse), un chiffre, un caractère spécial (l\'espace n\'est pas autorisé).',
    'Confirm Password' => 'Confirmez le mot de passe',
    'Save Changes' => 'Sauvegarder les modifications',
    'SAVE CHANGES' => 'SAUVEGARDER LES MODIFICATIONS',
    'CREATE TICKET' => 'CREER TICKET',
    'Customer full name' => 'Nom complet du client',
    'Customer email address' => 'Adresse email du client',
    'Select Type' => 'Sélectionner le genre',
    'Support' => 'Soutien',
    'Choose ticket type' => 'Choisissez le type de ticket',
    'Ticket subject' => 'Objet du ticket',
    'Message' => 'Message',
    'Query Message' => 'Message de requête',
    'Add Attachment' => 'Ajouter une pièce jointe',
    'This field is mandatory' => 'Ce champ est obligatoire',
    'General' => 'Général',
    'Designation' => 'La désignation',
    'Contant Number' => '«Numéro de candidat»',
    'User signature will be append in the bottom of ticket reply box' => 'La signature de lutilisateur sera ajoutée au bas de la boîte de réponse du ticket',
    'Account Status' => 'Statut du compte',
    'Account is Active' => 'Le compte est actif',
    'Assigning group(s) to user to view tickets regardless assignment.' => 'Attribuer des groupes à lutilisateur pour quil visualise les tickets, quelle que soit leur affectation.',
    'Default' => 'Défaut',
    'Select All' => 'Tout sélectionner',
    'Remove All' => 'Enlever tout',
    'Assigning team(s) to user to view tickets regardless assignment.' => 'Affecter une ou plusieurs équipes à lutilisateur pour quil visualise les tickets, quelle que soit leur affectation.',
    'No Team added !' => 'Aucune équipe ajoutée!',
    'Permission' => 'Autorisation',
    'Role' => 'Rôle',
    'Administrator' => 'Administrateur',
    'Select agent role' => 'Sélectionnez le rôle de lagent',
    'Add Customer' => 'Ajouter un client',
    'Action' => 'action',
    'Account Owner' => 'Propriétaire du compte',
    'Active' => 'actif',
    'Edit' => 'Modifier',
    'Delete' => 'Effacer',
    'Disabled' => 'désactivé',
    'New Group' => 'Nouveau groupe',
    'Default Privileges' => 'Privilèges par défaut',
    'New Privileges' => 'Nouveaux privilèges',
    'NEW PRIVILEGE' => 'NOUVEAU PRIVILEGE',
    'New Privilege' => 'Nouveau privilège',
    'New Team' => 'Nouvelle équipe',
    'No Record Found' => 'Aucun Enregistrement Trouvé',
    'Order Synchronization' => 'Synchronisation des commandes',
    'Easily integrate different ecommerce platforms with your helpdesk which can then be later used to swiftly integrate ecommerce order details with your support tickets.' => 'Intégrez facilement différentes plates-formes de commerce électronique à votre service dassistance, qui pourra ensuite être utilisé pour intégrer rapidement les détails des commandes de commerce électronique à vos tickets dassistance.',
    'BigCommerce' => 'BigCommerce',
    'No channels have been added.' => 'Aucun canal na été ajouté.',
    'Add BigCommerce Store' => 'Ajouter BigCommerce Store',
    'ADD BIGCOMMERCE STORE' => 'AJOUTER BIGCOMMERCE STORE',
    'Mangento' => 'Mangento',
    'Add Magento Store' => 'Ajouter Magento Store',
    'OpenCart' => 'OpenCart',
    'Add OpenCart Store' => 'Ajouter OpenCart Store',
    'ADD OPENCART STORE' => 'AJOUTER OPENCART STORE',
    'Shopify' => 'Shopify',
    'Add Shopify Store' => 'Ajouter Shopify Store',
    'ADD SHOPIFY STORE' => 'AJOUTER MAGASIN',
    'Integrate a new BigCommerce store' => 'Intégrer un nouveau magasin BigCommerce',
    'Your BigCommerce Store Name' => 'Votre nom de magasin BigCommerce',
    'Your BigCommerce Store Hash' => 'Votre magasin BigCommerce Hash',
    'Your BigCommerce Api Token' => 'Votre jeton BigCommerce Api',
    'Your BigCommerce Api Client ID' => 'Votre identifiant client BigCommerce Api',
    'Enable Channel' => 'Activer le canal',
    'Add Store' => 'Ajouter un magasin',
    'ADD STORE' => 'AJOUTER UN MAGASIN',
    'Integrate a new Magento store' => 'Intégrer un nouveau magasin Magento',
    'Your Magento Api Username' => 'Votre nom dutilisateur Api Magento',
    'Your Magento Api Password' => 'Votre mot de passe Api Magento',
    'Integrate a new OpenCart store' => 'Intégrer un nouveau magasin OpenCart',
    'Your OpenCart Api Key' => 'Votre clé OpenCart Api',
    'Your Shopify Store Name' => 'Votre nom de boutique Shopify',
    'Your Shopify Api Key' => 'Votre clé Shopify Api',
    'Your Shopify Api Password' => 'Votre mot de passe Shopify Api',
    'Easily embed custom form to help generate helpdesk tickets.' => 'Intégrez facilement un formulaire personnalisé pour générer des tickets de support technique.',
    'Form-Builder' => 'Formateur',
    'Add Formbuilder' => 'Ajouter Formbuilder',
    'ADD FORMBUILDER' => 'AJOUTER FORMBUILDER',
    'No FormBuilder have been added.' => 'Aucun FormBuilder na été ajouté.',
    'Create a New Custom Form Below' => 'Créer un nouveau formulaire personnalisé ci-dessous',
    'Form Name' => 'Nom de forme',
    'It will be shown in the list of created forms' => 'Il sera affiché dans la liste des formulaires créés',
    'MANDATORY FIELDS' => 'CHAMPS OBLIGATOIRES',
    'These fields will be visible in form and cant be edited' => 'Ces champs seront visibles dans le formulaire et ne pourront pas être modifiés',
    'Reply' => 'Répondre',
    'OPTIONAL FIELDS' => 'CHAMPS FACULTATIFS',
    'Select These Fields to Add in your Form' => 'Sélectionnez ces champs à ajouter à votre formulaire',
    'GDPR' => 'GDPR',
    'Order' => 'Ordre',
    'Categorybuilder' => 'Catégorie constructeur',
    'File' => 'Fichier',
    'Add Form' => 'Ajouter un formulaire',
    'ADD FORM' => 'ADD FORM',
    'UPDATE FORM' => 'MISE À JOUR DU FORMULAIRE',
    'Update Form' => 'Mise à jour du formulaire',
    'Embed' => 'Intégrer',
    'EMBED' => 'EMBED',
    'EMBED FORMBUILDER' => 'INTÉGRER LE FORMBUILDER',
    'Embed Formbuilder' => 'Intégrer le Formbuilder',
    'Visit' => 'Visite',
    'VISIT' => 'VISITE',
    'Code' => 'Code',
    'Total Ticket(s)' => 'Total Ticket(s)',
    'Ticket Count' => 'Nombre de tickets',
    'SwiftMailer Configurations' => 'Configurations SwiftMailer',
    'No swiftmailer configurations found' => 'Aucune configuration swiftmailer trouvée',
    'CREATE CONFIGURATION' => 'CREATE CONFIGURATION',
    'Add configuration' => 'Ajouter une configuration',
    'Update configuration' => 'Mettre à jour la configuration',
    'Mailer ID' => 'Identifiant de courrier',
    'Mailer ID - Leave blank to automatically create id' => 'Identifiant de courrier - Laissez le champ vide pour créer automatiquement un identifiant',
    'Transport Type' => 'Type de transport',
    'SMTP' => 'SMTP',
    'Enable Delivery' => 'Activer la livraison',
    'Server' => 'Serveur',
    'Port' => 'Port',
    'Encryption Mode' => 'Mode de cryptage',
    'ssl' => 'ssl',
    'tsl' => 'tsl',
    'None' => 'Aucun',
    'Authentication Mode' => 'Mode dauthentification',
    'login' => 'sidentifier',
    'API' => 'API',
    'Plain' => 'Plaine',
    'CRAM-MD5' => 'CRAM-MD5',
    'Sender Address' => 'Adresse de lexpéditeur',
    'Delivery Address' => 'Adresse de livraison',
    'Block Spam' => 'Bloquer le spam',
    'Black list' => 'Liste noire',
    'Comma (,) separated values (Eg. support@example.com, @example.com, 68.98.31.226)' => 'Valeurs séparées par une virgule (,) (Par exemple, support@example.com, @ example.com, 68.98.31.226)',
    'White list' => '«Liste blanche»',
    'Mailbox Settings' => 'Paramètres de boîte aux lettres',
    'No mailbox configurations found' => 'Aucune configuration de boîte aux lettres trouvée',
    'NEW MAILBOX' => 'NOUVELLE BOÎTE AUX LETTRES',
    'New Mailbox' => 'Nouvelle boîte aux lettres',
    'Update Mailbox' => 'Mettre à jour la boîte aux lettres',
    'Add Mailbox' => 'Ajouter une boîte aux lettres',
    'Mailbox ID - Leave blank to automatically create id' => 'ID de boîte aux lettres - Laissez vide pour créer automatiquement un identifiant',
    'Mailbox Name' => 'Nom de la boîte aux lettres',
    'Enable Mailbox' => 'Activer la boîte aux lettres',
    'Incoming Mail (IMAP) Server' => 'Serveur de courrier entrant (IMAP)',
    'Configure your imap settings which will be used to fetch emails from your mailbox.' => 'Configurez vos paramètres dimap qui seront utilisés pour récupérer les courriels de votre boîte aux lettres.',
    'Transport' => 'Transport',
    'IMAP' => 'IMAP',
    'Gmail' => 'Gmail',
    'Yahoo' => 'Yahoo',
    'Host' => 'Hôte',
    'IMAP Host' => 'Hôte IMAP',
    'Email address' => 'Adresse e-mail',
    'Associated Password' => '«Mot de passe associé»',
    'Outgoing Mail (SMTP) Server' => 'Serveur de courrier sortant (SMTP)',
    'Select a valid Swift Mailer configuration which will be used to send emails through your mailbox.' => 'Sélectionnez une configuration valide de Swift Mailer qui sera utilisée pour envoyer des courriels via votre boîte aux lettres.',
    'None Selected' => 'Aucune sélection',
    'Create Mailbox' => 'Créer une boîte aux lettres',
    'CREATE MAILBOX' => 'CREATE MAILBOX',
    'New Template' => 'Nouveau modèle',
    'NEW TEMPLATE' => 'NOUVEAU MODÈLE',
    'Customer Forgot Password' => 'Client oublié mot de passe',
    'Customer Account Created' => 'Compte client créé',
    'Ticket generated success mail to customer' => 'Ticket de succès généré par le courrier au client',
    'Customer Reply To The Agent' => 'Réponse du client à lagent',
    'Ticket Assign' => 'Ticket Assign',
    'Agent Forgot Password' => 'Agent Mot de passe oublié',
    'Agent Account Created' => 'Compte dagent créé',
    'Ticket generated by customer' => 'Ticket généré par le client',
    'Agent Reply To The Customers ticket' => 'Réponse de lagent au ticket du client',
    'Email template name' => 'Nom du modèle de courrier électronique',
    'Email template subject' => 'Objet du modèle de courrier électronique',
    'Template For' => 'Modèle pour',
    'Nothing Selected' => 'Rien de sélectionné',
    'email template will be used for work related with selected option' => 'le modèle de courrier électronique sera utilisé pour les travaux liés à loption sélectionnée',
    'Email template body' => 'Corps du modèle de courrier électronique',
    'Body' => 'Corps',
    'placeholders' => 'espaces réservés',
    'Ticket Subject' => 'Objet du ticket',
    'Ticket Message' => 'Message du ticket',
    'Ticket Attachments' => '«Pièces jointes»',
    'Ticket Tags' => 'Tags du ticket',
    'Ticket Source' => 'Origine du ticket',
    'Ticket Status' => 'Etat du ticket',
    'Ticket Priority' => 'Priorité du ticket',
    'Ticket Group' => '«Groupe de tickets»',
    'Ticket Team' => 'Ticket Team',
    'Ticket Thread Message' => 'Message du fil de discussion',
    'Ticket Customer Name' => 'Nom du client du ticket',
    'Ticket Customer Email' => 'Email du client du ticket',
    'Ticket Agent Name' => 'Nom de lagent de ticket',
    'Ticket Agent Email' => 'Email de lagent de ticket',
    'Ticket Agent Link' => 'Ticket Agent Link',
    'Ticket Customer Link' => 'Ticket Client Link',
    'Last Collaborator Name' => 'Nom du dernier collaborateur',
    'Last Collaborator Email' => 'Dernier courriel de collaborateur',
    'Agent/ Customer Name' => 'Nom de lagent / du client',
    'Account Validation Link' => 'Lien de validation de compte',
    'Password Forgot Link' => 'Mot de passe oublié lien',
    'Company Name' => 'Nom de la compagnie',
    'Company Logo' => 'Logo dentreprise',
    'Company URL' => 'URL de lentreprise',
    'Swiftmailer id (Select from drop down)' => 'Identifiant Swiftmailer (sélection dans le menu déroulant)',
    'SwiftMailer' => 'SwiftMailer',
    'PROCEED' => 'PROCÉDER',
    'Proceed' => 'Procéder',
    'Theme Color' => 'Thème Couleur',
    'Customer Created' => 'Client créé',
    'Agent Created' => 'Agent créé',
    'Ticket Created' => 'Ticket créé',
    'Agent Replied on Ticket' => 'Agent a répondu au ticket',
    'Customer Replied on Ticket' => 'Le client a répondu sur le ticket',
    'Workflow Status' => 'Statut du flux de travail',
    'Workflow is Active' => 'Le flux de travail est actif',
    'Events' => 'Événements',
    'An event automatically triggers to check conditions and perform a respective pre-defined set of actions' => 'Un événement déclenche automatiquement le contrôle des conditions et effectue un ensemble dactions prédéfini respectif',
    'Select an Event' => 'Sélectionnez un événement',
    'Add More' => 'Ajouter plus de',
    'Conditions' => 'Conditions',
    'Conditions are set of rules which checks for specific scenarios and are triggered on specific occasions' => 'Les conditions sont un ensemble de règles qui vérifient des scénarios spécifiques et sont déclenchées à des occasions spécifiques',
    'Subject or Description' => 'Sujet ou description',
    'Actions' => 'Actions',
    'An action not only reduces the workload but also makes it quite easier for ticket automation' => 'Une action réduit non seulement la charge de travail, mais facilite également lautomatisation des tickets',
    'Select an Action' => 'Sélectionnez une action',
    'Add Note' => 'Ajouter une note',
    'Mail to agent' => 'Mail à l\'agent',
    'Mail to customer' => 'Mail au client',
    'Mail to group' => 'Mail au groupe',
    'Mail to last collaborator' => 'Courrier au dernier collaborateur',
    'Mail to team' => 'Mail à l\'équipe',
    'Mark Spam' => 'Marquer comme spam',
    'Assign to agent' => 'Attribuer à l\'agent',
    'Assign to group' => 'Attribuer à un groupe',
    'Set Priority As' => 'Définir la priorité comme',
    'Set Status As' => 'Définir le statut comme',
    'Set Tag As' => 'Définir l\'étiquette comme',
    'Set Label As' => 'Définir l\'étiquette comme',
    'Assign to team' => 'Attribuer à l\'équipe',
    'Set Type As' => 'Définir le type comme',
    'Add Workflow' => 'Ajouter un flux de travail',
    'ADD WORKFLOW' => 'AJOUTER UN FLUX DE TRAVAIL',
    'Ticket Type code' => 'Code de type de ticket',
    'Ticket Type description' => 'Description du type de ticket',
    'Type Status' => 'Type Statut',
    'Type is Active' => 'Le type est actif',
    'Add Save Reply' => 'Ajouter une réponse',
    'Saved reply name' => 'Nom de réponse enregistré',
    'Share saved reply with user(s) in these group(s)' => 'Partager la réponse enregistrée avec lutilisateur ou les utilisateurs de ces groupes',
    'Share saved reply with user(s) in these teams(s)' => 'Partager la réponse enregistrée avec les utilisateurs de ces équipes',
    'Saved reply Body' => 'Corps de réponse enregistré',
    'New Prepared Response' => 'Nouvelle réponse préparée',
    'Prepared Response Status' => 'État de la réponse préparée',
    'Prepared Response is Active' => 'La réponse préparée est active',
    'Share prepared response with user(s) in these group(s)' => 'Partager les réponses préparées avec les utilisateurs de ces groupes',
    'Share prepared response with user(s) in these teams(s)' => 'Partager les réponses préparées avec les utilisateurs de ces équipes',
    'ADD PREPARED RESPONSE' => 'AJOUTER UNE RÉPONSE PRÉPARÉE',
    'Add Prepared Response' => 'Ajouter une réponse préparée',
    'Folder Name is shown upfront at Knowledge Base' => 'Le nom du dossier est affiché dès le départ dans la base de connaissances',
    'A small text about the folder helps user to navigate more easily' => 'Un petit texte sur le dossier aide lutilisateur à naviguer plus facilement',
    'Publish' => 'Publier',
    'Choose appropriate status' => 'Choisissez le statut approprié',
    'Folder Image' => 'Image du dossier',
    'An image is worth a thousands words and makes folder more accessible' => 'Une image vaut mille mots et rend le dossier plus accessible',
    'Add Category' => 'Ajouter une catégorie',
    'Category Name is shown upfront at Knowledge Base' => 'Le nom de la catégorie est affiché dès le départ dans la base de connaissances',
    'A small text about the category helps user to navigate more easily' => 'Un petit texte sur la catégorie aide lutilisateur à naviguer plus facilement',
    'Using Category Order, you can decide which category should display first' => 'En utilisant lordre des catégories, vous pouvez choisir la catégorie à afficher en premier',
    'Sorting' => 'Tri',
    'Ascending Order (A-Z)' => 'Ordre croissant (AZ)',
    'Descending Order (Z-A)' => 'Ordre décroissant (Z-A)',
    'Based on Popularity' => 'Basé sur la popularité',
    'Article of this category will display according to selected option' => 'Larticle de cette catégorie saffichera en fonction de loption sélectionnée',
    'Article' => 'Article',
    'Title' => 'Titre',
    'View' => 'Vue',
    'Make as Starred' => 'Faire comme favori',
    'Yes' => 'Oui',
    'No' => 'Non',
    'Stared' => 'Regardé',
    'Revisions' => 'Révisions',
    'Related Articles' => 'Articles Liés',
    'Delete Article' => 'Supprimer l\'article',
    'Content' => 'Contenu',
    'Slug' => 'Slug',
    'Slug is the url identity of this article.' => 'Le Slug est l\'identité de cet article dans l\'URL.',
    'Meta Title' => 'Meta Title',
    '# Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'Les balises de titre et les méta-descriptions sont des bits de code HTML dans len-tête dune page Web. Ils aident les moteurs de recherche à comprendre le contenu dune page. La balise de titre et la méta description dune page sont généralement affichées chaque fois que cette page apparaît dans les résultats des moteurs de recherche.',
    'Meta Keywords' => 'Meta Keywords',
    'Meta Description' => 'Meta Description',
    'Description' => 'Description',
    'Team Status' => 'Statut de l\'équipe',
    'Team is Active' => 'Equipe active',
    'Edit Privilege' => 'Modifier privilège',
    'Can create ticket' => 'Peut créer un ticket',
    'Can edit ticket' => 'Peut éditer un ticket',
    'Can delete ticket' => 'Peut supprimer un ticket',
    'Can restore trashed ticket' => 'Peut restaurer un ticket détruit',
    'Can assign ticket' => 'Peut attribuer un ticket',
    'Can assign ticket group' => 'Peut affecter un groupe de tickets',
    'Can update ticket status' => 'Peut mettre à jour le statut du ticket',
    'Can update ticket priority' => 'Peut mettre à jour la priorité du ticket',
    'Can update ticket type' => 'Peut mettre à jour le type de ticket',
    'Can add internal notes to ticket' => 'Peut ajouter des notes internes au ticket',
    'Can edit thread/notes' => 'Peut éditer un fil / des notes',
    'Can lock/unlock thread' => 'Peut verrouiller / déverrouiller le fil',
    'Can add collaborator to ticket' => 'Peut ajouter un collaborateur à un ticket',
    'Can delete collaborator from ticket' => 'Peut supprimer un collaborateur du ticket',
    'Can delete thread/notes' => 'Peut supprimer un fil / des notes',
    'Can apply prepared response on ticket' => 'Peut appliquer une réponse préparée sur le ticket',
    'Can add ticket tags' => 'Peut ajouter des étiquettes de ticket',
    'Can delete ticket tags' => 'Peut supprimer les étiquettes de ticket',
    'Can kick other ticket users' => 'Peut donner un coup de pied à dautres utilisateurs de tickets',
    'Can manage email templates' => 'Peut gérer les modèles de courrier électronique',
    'Can manage groups' => 'Peut gérer des groupes',
    'Can manage Sub-Groups/ Teams' => 'Peut gérer des sous-groupes / équipes',
    'Can manage agents' => 'Peut gérer des agents',
    'Can manage agent privileges' => 'Peut gérer les privilèges dagent',
    'Can manage ticket types' => 'Peut gérer les types de tickets',
    'Can manage ticket custom fields' => 'Peut gérer les champs personnalisés de tickets',
    'Can manage customers' => 'Peut gérer les clients',
    'Can manage Prepared Responses' => 'Peut gérer les réponses préparées',
    'Can manage Automatic workflow' => 'Peut gérer le flux de travail automatique',
    'Can manage tags' => 'Peut gérer les tags',
    'Can manage knowledgebase' => 'Peut gérer la base de connaissances',
    'Can manage Groups Saved Reply' => 'Peut gérer la réponse enregistrée du groupe',
    'Add Privilege' => 'Ajouter un privilège',
    'Choose set of privileges which will be available to the agent.' => 'Choisissez un ensemble de privilèges qui seront disponibles pour lagent.',
    'Advanced' => 'Avancé',
    'Privilege Name must have characters only' => 'Le nom de privilège doit comporter uniquement des caractères',
    'Maximum character length is 50' => 'La longueur maximale des caractères est de 50',
    'Open Tickets' => 'Tickets ouverts',
    'New Customer' => 'Nouveau client',
    'New Agent' => '«Nouvel agent»',
    'Total Article(s)' => 'Total article (s)',
    'Please specify a valid email address' => 'Sil vous plaît spécifier une adresse e-mail valide',
    'Please enter the password associated with your email address' => 'Veuillez saisir le mot de passe associé à votre adresse e-mail',
    'Please enter your server host address' => 'Sil vous plaît entrer votre adresse hôte du serveur',
    'Please specify a port number to connect with your mail server' => 'Spécifiez un numéro de port pour vous connecter à votre serveur de messagerie',
    'Success ! Branding details saved successfully.' => 'Succès ! Les détails de la marque ont été enregistrés avec succès.',
    'Success ! Time details saved successfully.' => 'Succès ! Les détails de l\'heure ont été enregistrés avec succès.',
    'Spam setting saved successfully.' => 'Réglage du spam enregistré avec succès.',
    'Please specify a valid name for your mailbox.' => 'Veuillez spécifier un nom valide pour votre boîte aux lettres.',
    'Please select a valid swift-mailer configuration.' => 'Veuillez sélectionner une configuration valide de swift-mailer.',
    'Please specify a valid host address.' => 'Sil vous plaît spécifier une adresse dhôte valide.',
    'Please specify a valid email address.' => 'Sil vous plaît spécifier une adresse e-mail valide.',
    'Please enter the associated account password.' => 'Veuillez saisir le mot de passe du compte associé.',
    'New Saved Reply' => 'Nouvelle réponse enregistrée',
    'New Category' => 'Nouvelle catégorie',
    'Folder' => 'Dossier',
    'Category' => 'Catégorie',
    'Created' => 'Crée le',
    'All Articles' => 'Tous les articles',
    'Viewed' => 'Vu',
    'New Article' => 'Nouvel article',
    'Thank you for your feedback!' => 'Merci pour votre avis !',
    'Was this article helpful?' => 'Cet article a-t-il été utile?',
    'Helpdesk' => 'Centre d\'assistance',
    'Support Center' => 'Centre de support',
    'Mailboxes' => 'Boîtes aux lettres',
    'By' => 'Par',
    'Search Tickets' => 'Rechercher des tickets',
    'Customer Information' => 'Informations client',
    'Total Replies' => 'Total des réponses',
    'Filter With' => 'Filtrer avec',
    'Type email to add' => 'Tapez l\'email à ajouter',
    'Collaborators' => 'Collaborateurs',
    'Labels' => 'Étiquettes',
    'Group' => 'Groupe',
    'group' => 'groupe',
    'Contact Team' => 'Contacter l\'équipe',
    'Stay on ticket' => 'Rester sur le ticket',
    'Redirect to list' => 'Rediriger vers la liste',
    'Nothing interesting here...' => 'Rien d\'intéressant ici',
    'Previous Ticket' => 'Ticket précédent',
    'Next Ticket' => 'Prochain ticket',
    'Forward' => 'Transférer',
    'Note' => 'Remarque',
    'Write a reply' => 'Écrire une réponse',
    'Created Ticket' => 'Ticket créé',
    'All Threads' => 'Toutes les discussions',
    'Forwards' => 'Transferts',
    'Notes' => 'Remarques',
    'Pinned' => 'Épinglé',
    'Edit Ticket' => 'Editer le ticket',
    'Print Ticket' => 'Imprimer le ticket',
    'Mark as Spam' => 'Marquer comme spam',
    'Mark as Closed' => 'Marquer comme fermé',
    'Delete Ticket' => 'Supprimer le ticket',
    'View order details from different eCommerce channels' => 'Afficher les détails de la commande de différents canaux de commerce électronique',
    'ECOMMERCE CHANNELS' => 'Chaînes commerciales',
    'Select channel' => 'Sélectionner une chaîne',
    'Order Id' => 'Numéro de commande',
    'Fetch Order' => 'Fetch Order',
    'No orders have been integrated to this ticket yet.' => 'Aucune commande na encore été intégrée à ce ticket.',
    'Enter your credentials below to gain access to your helpdesk account.' => 'Saisissez vos identifiants ci-dessous pour accéder à votre compte de support.',
    'Keep me logged in' => 'Rester connecté',
    'Forgot Password?' => 'Mot de passe oublié ?',
    'Log in to your' => 'Connectez-vous à votre',
    'Sign In' => 'Se connecter',
    'Edit Customer' => 'Modifier le client',
    'Update' => 'Mettre à jour',
    'Discard' => 'Ignorer',
    'Cancel' => 'Annuler',
    'Not Assigned' => 'Non assigné',
    'Submit' => 'Envoyer',
    'Submit And Open' => 'Envoyer et ouvrir',
    'Submit And Pending' => 'Envoyer et en attente',
    'Submit And Answered' => 'Envoyer et répondu',
    'Submit And Resolved' => 'Envoyer et résolu',
    'Submit And Closed' => 'Envoyer et fermé',
    'Choose a Color' => 'Choisir une couleur',
    'Create' => 'Créer',
    'Edit Label' => 'Modifier l\'étiquette',
    'Add Label' => 'Ajouter une étiquette',
    'To' => 'À',
    'Ticket' => 'Ticket',
    'Your browser does not support JavaScript or You disabled JavaScript, Please enable those !' => 'Votre navigateur ne supporte pas JavaScript ou Vous avez désactivé JavaScript, activez-les!',
    'Confirm Action' => 'Confirmer laction',
    'Confirm' => 'Confirmer',
    'No result found' => 'Aucun résultat trouvé',
    'ticket delivery status' => 'état de livraison du ticket',
    'Warning! Select valid image file.' => 'Attention! Sélectionnez un fichier image valide. ',
    'Error' => 'Erreur',
    'Save' => 'Sauver',
    'SEO' => 'SEO',
    'Edit Saved Filter' => 'Modifier le filtre enregistré',
    'Type atleast 2 letters' => 'Tapez au moins 2 lettres',
    'Remove Label' => 'Supprimer l\'étiquette',
    'New Saved Filter' => 'Nouveau filtre enregistré',
    'Is Default' => 'Est-ce par défaut',
    'Remove Saved Filter' => 'Supprimer le filtre enregistré',
    'Ticket Info' => 'Ticket Info',
    'Last Replied Agent' => 'Dernier agent répondu',
    'created Ticket' => 'a crée le ticket',
    'Uploaded Files' => 'Fichiers téléchargés',
    'Download (as .zip)' => 'Télécharger comme ZIP)',
    'made last reply' => 'fait la dernière réponse',
    'N/A' => 'N / A',
    'Unassigned' => 'Non attribué',
    'Label' => 'Étiquette',
    'Assigned to me' => 'Assigné à moi',
    'Search Query' => 'Requête de recherche',
    'Searching' => 'Recherche',
    'Saved Filter' => 'Filtre enregistré',
    'No Label Created' => 'Aucune étiquette créé',
    'Label with same name already exist.' => 'Des étiquettes portant le même nom existent déjà.',
    'Create New' => 'Créer un nouveau',
    'Mail status' => 'Statut du courrier',
    'replied' => 'a répondu',
    'added note' => 'note ajoutée',
    'forwarded' => 'transféré',
    'TO' => 'À',
    'CC' => 'Copie à',
    'BCC' => 'Copie caché à',
    'Locked' => 'Verouiller',
    'Edit Thread' => 'Editer le fil',
    'Delete Thread' => 'Supprimer le fil',
    'Unpin Thread' => 'Désépingler le fil',
    'Pin Thread' => 'Fil à broche',
    'Unlock Thread' => 'Déverrouiller le fil',
    'Lock Thread' => 'Verrouiller le fil',
    'Translate Thread' => 'Traduire le fil',
    'Language' => 'Langue',
    'English' => 'Anglais',
    'French' => 'Français',
    'Italian' => 'Italien',
    'Arabic' => 'Arabe',
    'German' => 'Allemand',
    'Spanish' => 'Espagnol',
    'Turkish' => 'Turc',
    'Danish' => 'Danois',
    'Chinese' => 'CHINOIS',
    'Polish' => 'POLONAIS',
    'Hebrew' => 'Hébreu',
    'Portuguese' => 'Portugais',
    'System' => 'Système',
    'Open in Files' => 'Ouvrir dans les fichiers',
    'Email address is invalid' => 'Adresse email invalide',
    'Tag with same name already exist' => 'Les balises avec le même nom existent déjà',
    'Text length should be less than 20 charactors' => 'La longueur du texte doit être inférieure à 20 caractères',
    'Label with same name already exist' => 'Des étiquettes portant le même nom existent déjà',
    'Agent Name' => 'Nom dagent',
    'Agent Email' => 'Email de lagent',
    'open' => 'ouvert',
    'Currently active agents on ticket' => 'Agents actuellement actifs sur le ticket',
    'Edit Customer Information' => 'Modifier les informations client',
    'Restore' => 'Restaurer',
    'Delete Forever' => 'Supprimer définitivement',
    'Add Team' => 'Ajouter une équipe',
    'delete' => 'supprimer',
    'You didnt have any folder for current filter(s).' => 'Vous navez pas de dossier pour le (s) filtre (s) actuel (s).',
    'Add Folder' => 'Ajouter le dossier',
    'This field must have valid characters only' => 'Ce champ doit contenir uniquement des caractères valides',
    'Can edit task' => 'Peut éditer une tâche',
    'Can create task' => 'Peut créer une tâche',
    'Can delete task' => 'Peut supprimer une tâche',
    'Can add member to task' => 'Peut ajouter un membre à une tâche',
    'Can remove member from task' => 'Peut retirer un membre de la tâche',
    'Agent Privileges' => '«Privilèges d\'agent»',
    'Agent Privilege represents overall permissions in System.' => 'Les privilèges de lagent représentent les autorisations globales dans le système.',
    'Ticket View' => 'Ticket View',
    'User can view tickets based on selected scope.' => 'Lutilisateur peut afficher les tickets en fonction de la portée sélectionnée.',
    'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) he belongs to and so on' => 'Si un accès individuel est disponible, lutilisateur peut uniquement afficher les tickets attribués. Si laccès aux équipes, il peut afficher tous les tickets de léquipe à laquelle il appartient et ainsi de suite',
    'Global Access' => 'Accès global',
    'Group Access' => 'Accès groupe',
    'Team Access' => 'Team Access',
    'Individual Access' => 'Accès individuel',
    'This field must have characters only' => 'Ce champ doit contenir uniquement des caractères',
    'Maximum character length is 40' => 'La longueur maximale des caractères est de 40',
    'This is not a valid email address' => 'Cette adresse email nest pas valide',
    'Password must contains 8 Characters' => 'Le mot de passe doit contenir 8 caractères',
    'The passwords does not match' => 'Les mots de passe ne correspondent pas',
    'Enabled' => 'Activée',
    'Create Configuration' => 'Créer une configuration',
    'Swift Mailer Settings' => 'Paramètres Swift Mailer',
    'Username' => 'Nom dutilisateur',
    'Please select a swiftmailer id' => 'Veuillez sélectionner un identifiant swiftmailer',
    'Please enter a valid e-mail id' => 'Veuillez saisir un identifiant de messagerie valide',
    'Please enter a mailer id' => 'Sil vous plaît entrer un identifiant de messagerie',
    'Email Id' => 'Email Id',
    'Are you sure? You want to perform this action.' => 'Êtes-vous sûr? Vous voulez effectuer cette action.',
    'Reorder' => 'Réorganiser',
    'New Workflow' => 'Nouveau flux de travail',
    'OR' => 'OU',
    'AND' => 'ET',
    'Please enter a valid name.' => 'Merci dentrer un nom valide.',
    'Please select a value.' => 'Sil vous plaît sélectionnez une valeur.',
    'Please add a value.' => 'Sil vous plaît ajouter une valeur.',
    'This field is required' => 'Ce champ est requis',
    'or' => 'ou',
    'and' => 'et',
    'Select a Condition' => 'Sélectionnez une condition',
    'Loading...' => 'Chargement...',
    'Select Option' => 'Sélectionnez une option',
    'Inactive' => 'Inactif',
    'New Type' => 'Nouveau genre',
    'Placeholders' => 'Placeholders',
    'Ticket Link' => 'Ticket Link',
    'Id' => 'Id',
    'Preview' => 'Aperçu',
    'Sort Order' => 'Ordre de tri',
    'This field must be a number' => 'Ce champ doit être un nombre',
    'User' => 'Utilisateur',
    'Edit Group' => 'Modifier le groupe',
    'Group Status' => 'Statut du groupe',
    'Group is Active' => 'Le groupe est actif',
    'Add Group' => 'Ajouter un groupe',
    'Contact number is invalid' => 'Le numéro de contact est invalide',
    'Edit Agent' => 'Edit Agent',
    'No Privilege added, Please add Privilege(s) first !' => 'Aucun privilège ajouté, veuillez ajouter les privilèges en premier!',
    'Edit Email Template' => 'Modifier le modèle de-mail',
    'Edit Workflow' => 'Modifier le flux de travail',
    'Save Workflow' => 'Enregistrer le flux de travail',
    'Edit Ticket Type' => 'Modifier le type de ticket',
    'Add Ticket Type' => 'Ajouter un type de ticket',
    'Date Released' => 'Date de sortie',
    'Free' => 'Libre',
    'Premium' => 'Prime',
    'Installed' => 'Installée',
    'Installed Applications' => 'Applications installées',
    'Apps Dashboard' => 'Tableau de bord des applications',
    'Dashboard' => 'Tableau de bord',
    'Nothing Interesting here' => 'Rien dintéressant ici',
    'No Categories Added' => 'Aucune catégorie ajoutée',
    'ticket' => 'ticket',
    'Add Email Template' => 'Ajouter un modèle de courrier électronique',
    'This field contain 100 characters only' => 'Ce champ contient 100 caractères seulement',
    'This field contain characters only' => 'Ce champ contient uniquement des caractères',
    'Name length must not be greater than 200 !!' => 'La longueur du nom ne doit pas dépasser 200 !!',
    'Warning! Correct all field values first!' => 'Attention! Corrigez toutes les valeurs de champ en premier! ',
    'Warning ! This is not a valid request' => 'Attention ! Ce nest pas une demande valide ',
    'Success ! Tag removed successfully.' => 'Succès ! La balise a bien été supprimée. ',
    'Success ! Tags Saved successfully.' => 'Succès ! Tags enregistrés avec succès. ',
    'Success ! Revision restored successfully.' => 'Succès ! Révision restaurée avec succès. ',
    'Success ! Categories updated successfully.' => 'Succès ! Les catégories ont été mises à jour avec succès. ',
    'Success ! Article Related removed successfully.' => 'Succès ! Article connexe supprimé avec succès. ',
    'Success ! Article Related is already added.' => 'Succès ! Article Related est déjà ajouté. ',
    'Success ! Cannot add self as relative article.' => 'Succès ! Impossible de sajouter comme article relatif. ',
    'Success ! Article Related updated successfully.' => 'Succès ! Article connexe mis à jour avec succès. ',
    'Success ! Articles removed successfully.' => 'Succès ! Articles supprimés avec succès. ',
    'Success ! Article status updated successfully.' => 'Succès ! Le statut de larticle a été mis à jour avec succès. ',
    'Success ! Article star updated successfully.' => 'Succès ! Article star mis à jour avec succès. ',
    'Success! Article updated successfully' => 'Succès! Article mis à jour avec succès ',
    'Success ! Category sort  order updated successfully.' => 'Succès ! Lordre de tri des catégories a été mis à jour avec succès.',
    'Success ! Category status updated successfully.' => 'Succès ! Le statut de la catégorie a été mis à jour avec succès. ',
    'Success ! Folders updated successfully.' => 'Succès ! Les dossiers ont été mis à jour avec succès. ',
    'Success ! Categories removed successfully.' => 'Succès ! Catégories supprimées avec succès. ',
    'Success ! Category updated successfully.' => 'Succès ! Catégorie mise à jour avec succès. ',
    'Error ! Category is not exist.' => 'Erreur ! La catégorie n\'existe pas. ',
    'Warning ! Customer Login disabled by admin.' => 'Attention ! Connexion client désactivée par admin. ',
    'This Email is not registered with us.' => 'Cet email n\'est pas enregistré chez nous nous.',
    'Your password has been updated successfully.' => 'Votre mot de passe a été mis à jour avec succès.',
    'Password dont match.' => 'Le mot de passe ne correspond pas.',
    'Error ! Profile image is not valid, please upload a valid format' => 'Erreur ! L\'image de profil n\'est pas valide, veuillez télécharger un format valide',
    'Success! Folder has been added successfully.' => 'Succès! Le dossier a été ajouté avec succès. ',
    'Folder updated successfully.' => 'Dossier mis à jour avec succès.',
    'Success ! Folder status updated successfully.' => 'Succès ! Le statut du dossier a été mis à jour avec succès. ',
    'Error ! Folder is not exist.' => 'Erreur ! Le dossier n’existe pas.',
    'Success ! Folder updated successfully.' => 'Succès ! Le dossier a été mis à jour avec succès. ',
    'Error ! Folder does not exist.' => 'Erreur ! Le dossier nexiste pas.',
    'Success ! Folder deleted successfully.' => 'Succès ! Le dossier a été supprimé avec succès. ',
    'Warning ! Folder doesnt exists!' => 'Attention ! Le dossier n\'existe pas!',
    'Warning ! Cannot create ticket, given email is blocked by admin.' => 'Attention ! Impossible de créer un ticket, l\'email étant bloqué par l\'administrateur.',
    'Success ! Ticket has been created successfully.' => 'Succès ! Le ticket a été créé avec succès. ',
    'Warning ! Can not create ticket, invalid details.' => 'Attention ! Impossible de créer un ticket, informations non valides. ',
    'Warning ! Post size can not exceed 25MB' => 'Attention ! La taille du message ne doit pas dépasser 25 Mo',
    'Create Ticket Request' => 'Créer une demande de ticket',
    'Success ! Reply added successfully.' => 'Succès ! Réponse ajoutée avec succès.',
    'Warning ! Reply field can not be blank.' => 'Attention ! Le champ de réponse ne peut pas être vide.',
    'Success ! Rating has been successfully added.' => 'Succès ! La note a été ajoutée avec succès. ',
    'Warning ! Invalid rating.' => 'Attention ! Classement non valide. ',
    'Error ! Can not add customer as a collaborator.' => 'Erreur ! Impossible dajouter un client en tant que collaborateur. ',
    'Success ! Collaborator added successfully.' => 'Succès ! Collaborateur ajouté avec succès. ',
    'Error ! Collaborator is already added.' => 'Erreur ! Le collaborateur est déjà ajouté. ',
    'Success ! Collaborator removed successfully.' => 'Succès ! Collaborateur supprimé avec succès. ',
    'Error ! Invalid Collaborator.' => 'Erreur ! Collaborateur invalide. ',
    'An unexpected error occurred. Please try again later.' => 'Une erreur inattendue est apparue. Veuillez réessayer plus tard.',
    'Feedback saved successfully.' => 'Commentaires enregistrés avec succès.',
    'Feedback updated successfully.' => 'Commentaires mis à jour avec succès.',
    'Invalid feedback provided.' => 'Commentaires non valides fournis.',
    'Article not found.' => 'Article non trouvé.',
    'You need to login to your account before can perform this action.' => 'Vous devez vous connecter à votre compte avant de pouvoir effectuer cette action.',
    'Warning! Please add valid Actions!' => 'Attention! Sil vous plaît ajouter des actions valides! ',
    'Warning! In Free Plan you can not change Events!' => 'Attention ! Dans Free Plan, vous ne pouvez pas modifier les événements! ',
    'Success! Prepared Response has been updated successfully.' => 'Succès ! La réponse préparée a été mise à jour avec succès. ',
    'Success! Prepared Response has been added successfully.' => 'Succès ! La réponse préparée a été ajoutée avec succès. ',
    'Warning  This is not a valid request' => 'Warning Ceci nest pas une requête valide',
    'Use Default Colors' => 'Utiliser les couleurs par défaut',
    'Masonry' => 'Maçonnerie',
    'Popular Article' => 'Article populaire',
    'Manage Ticket Custom Fields' => 'Gérer les champs personnalisés du ticket',
    'You dont have premission to edit this Prepared response' => 'Vous navez pas la permission de modifier cette réponse préparée',
    'Save Prepared Response' => 'Enregistrer la réponse préparée',
    'Success ! Prepared response removed successfully.' => 'Succès ! Réponse préparée supprimée avec succès. ',
    'Warning! You are not allowed to perform this action.' => 'Attention! Vous nêtes pas autorisé à effectuer cette action. ',
    'Success! Workflow has been updated successfully.' => 'Succès ! Le workflow a été mis à jour avec succès. ',
    'Success! Workflow has been added successfully.' => 'Succès ! Le flux de travail a été ajouté avec succès. ',
    'Success! Order has been updated successfully.' => 'Succès ! La commande a été mise à jour avec succès. ',
    'Success! Workflow has been removed successfully.' => 'Succès ! Le workflow a été supprimé avec succès. ',
    'Mailbox successfully created.' => 'Boîte aux lettres créée avec succès.',
    'Mailbox successfully updated.' => 'Boîte aux lettres mise à jour avec succès.',
    'Warning ! Bad request !' => 'Attention ! Mauvaise Demande !',
    'Error! Given current password is incorrect.' => 'Erreur! Le mot de passe actuel est incorrect. ',
    'Success ! Profile update successfully.' => 'Succès ! Profil mis à jour avec succès. ',
    'Error ! User with same email is already exist.' => 'Erreur ! email déjà utilisée. ',
    'Success ! Agent updated successfully.' => 'Succès ! Agent mis à jour avec succès. ',
    'Success ! Agent removed successfully.' => 'Succès ! Agent supprimé avec succès. ',
    'Warning ! You are allowed to remove account owners account.' => 'Attention! Vous êtes autorisé à supprimer le compte du propriétaire du compte.',
    'Error ! Invalid user id.' => 'Erreur! Identifiant dutilisateur non valide.',
    'Success ! Filter has been saved successfully.' => 'Succès! Le filtre a été enregistré avec succès.',
    'Success ! Filter has been updated successfully.' => 'Succès! Le filtre a été mis à jour avec succès.',
    'Success ! Filter has been removed successfully.' => 'Succès! Le filtre a été supprimé avec succès.',
    'Please check your mail for password update.' => 'Veuillez vérifier votre courrier pour la mise à jour du mot de passe.',
    'This Email address is not registered with us.' => 'Cette adresse e-mail nest pas enregistrée avec nous.',
    'Success ! Customer saved successfully.' => 'Succès! Le client a été enregistré avec succès.',
    'Error ! User with same email already exist.' => 'Erreur ! email déjà utilisé.',
    'Success ! Customer information updated successfully.' => 'Succès ! Les informations client ont été mises à jour avec succès.',
    'Success ! Customer updated successfully.' => 'Succès! Client mis à jour avec succès.',
    'Error ! Customer with same email already exist.' => 'Erreur ! email déjà utilisé.',
    'unstarred Action Completed successfully' => 'Action sans succès terminée avec succès',
    'starred Action Completed successfully' => 'Action sélectionnée terminée avec succès',
    'Success ! Customer removed successfully.' => 'Succès ! Le client a été supprimé avec succès.',
    'Error ! Invalid customer id.' => 'Erreur! Identifiant client invalide.',
    'Success! Template has been updated successfully.' => 'Succès ! Le modèle a été mis à jour avec succès.',
    'Success! Template has been added successfully.' => 'Succès ! Template a été ajouté avec succès.',
    'Success! Template has been deleted successfully.' => 'Succès ! Le modèle a été supprimé avec succès.',
    'Warning! resource not found.' => 'Avertissement! Ressource non trouvée.',
    'Warning! You can not remove predefined email template which is being used in workflow(s).' => 'Attention! Vous ne pouvez pas supprimer le modèle de courrier électronique prédéfini utilisé dans les flux de travail.',
    'Success ! Email settings are updated successfully.' => 'Succès ! Les paramètres de messagerie sont mis à jour avec succès.',
    'Success ! Group information updated successfully.' => 'Succès ! Les informations du groupe ont été mises à jour avec succès.',
    'Success ! Group information saved successfully.' => 'Succès ! Les informations de groupe ont été enregistrées avec succès.',
    'Support Group removed successfully.' => 'Support Group supprimé avec succès.',
    'Success ! Privilege information saved successfully.' => 'Succès ! Les informations de privilège ont été enregistrées avec succès.',
    'Privilege updated successfully.' => 'Le privilège a été mis à jour avec succès.',
    'Support Privilege removed successfully.' => 'Support Privilege supprimé avec succès.',
    'Success! Reply has been updated successfully.' => 'Succès ! Reply a été mis à jour avec succès.',
    'Success! Reply has been added successfully.' => 'Succès ! Reply a été ajouté avec succès.',
    'Success! Saved Reply has been deleted successfully' => 'Succès ! La réponse enregistrée a été supprimée avec succès',
    'SwiftMailer configuration updated successfully.' => 'La configuration de SwiftMailer a été mise à jour avec succès.',
    'Swiftmailer configuration removed successfully.' => 'La configuration de Swiftmailer a été supprimée avec succès.',
    'Success ! Team information saved successfully.' => 'Succès ! Les informations de léquipe ont été enregistrées avec succès.',
    'Success ! Team information updated successfully.' => 'Succès ! Les informations de léquipe ont été mises à jour avec succès.',
    'Support Team removed successfully.' => 'Léquipe dassistance a été supprimée avec succès.',
    'Success! Reply has been added successfully' => 'Succès ! Reply a été ajouté avec succès',
    'Success ! Thread updated successfully.' => 'Succès ! Le fil a été mis à jour avec succès.',
    'Error ! Reply field can not be blank.' => 'Erreur ! Le champ de réponse ne peut pas être vide.',
    'Success ! Thread removed successfully.' => 'Succès ! Le fil a été supprimé avec succès.',
    'Success ! Thread locked successfully' => 'Succès ! Fil bloqué avec succès',
    'Success ! Thread unlocked successfully' => 'Succès ! Fil déverrouillé avec succès',
    'Success ! Thread pinned successfully' => 'Succès ! Sujet épinglé avec succès',
    'Error ! Invalid thread.' => 'Erreur ! Fil non valide.',
    'Could not create ticket, invalid details.' => 'Impossible de créer un ticket, détails non valides.',
    'Success ! Tag updated successfully.' => 'Succès ! Le tag a été mis à jour avec succès.',
    'Error ! Customer can not be added as collaborator.' => 'Erreur ! Le client ne peut pas être ajouté en tant que collaborateur.',
    'Success ! Tag unassigned successfully.' => 'Succès ! Tag retiré avec succès.',
    'Success ! Tag added successfully.' => 'Succès ! Tag ajouté avec succès.',
    'Please enter tag name.' => 'Sil vous plaît entrer le nom de la balise.',
    'Error ! Invalid tag.' => 'Erreur! Balise invalide.',
    'Success ! Type removed successfully.' => 'Succès ! Type supprimé avec succès.',
    'Success ! Ticket to label removed successfully.' => 'Succès ! Etiquette du ticket supprimée avec succès.',
    'Unable to retrieve support team details' => 'Impossible de récupérer les détails de léquipe de support',
    'Ticket support group updated successfully' => 'Le groupe de support de ticket a été mis à jour avec succès',
    'Unable to retrieve status details' => 'Impossible de récupérer les détails du statut',
    'Insufficient details provided.' => 'Détails insuffisants.',
    'Error! Subject field is mandatory' => 'Erreur ! Le champ sujet est obligatoire',
    'Error! Reply field is mandatory' => 'Erreur ! Le champ de réponse est obligatoire',
    'Success ! Ticket has been updated successfully.' => 'Succès ! Le ticket a été mis à jour avec succès.',
    'Success ! Label updated successfully.' => 'Succès ! Etiquette mise à jour avec succès.',
    'Error ! Invalid label id.' => 'Erreur ! Identifiant d\'étiquette invalide.',
    'Success ! Label removed successfully.' => 'Succès ! Etiquette enlevée avec succès.',
    'Success ! Label created successfully.' => 'Succès ! Etiquette créé avec succès.',
    'Error ! Label name can not be blank.' => 'Erreur ! Le nom de létiquette ne peut pas être vide.',
    'Success ! Ticket moved to trash successfully.' => 'Succès ! Ticket déplacé avec succès dans la corbeille.',
    'Success! Ticket type saved successfully.' => 'Succès ! Le type de ticket a été enregistré avec succès.',
    'Success! Ticket type updated successfully.' => 'Succès ! Le type de ticket a été mis à jour avec succès.',
    'Error! Ticket type with same name already exist' => 'Erreur! Le type de ticket portant le même nom existe déjà',
    'SAVE' => 'ENREGISTRER',
    '# Save' => 'ENREGISTRER',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'Les balises de titre et les méta-descriptions sont des bits de code HTML dans len-tête dune page Web. Ils aident les moteurs de recherche à comprendre le contenu dune page. La balise de titre et la méta-description dune page sont généralement affichées chaque fois que cette page apparaît dans les résultats des moteurs de recherche.',
    'Ticket is already assigned to agent' => 'Le ticket est déjà attribué à l\'agent',
    'Success ! Agent assigned successfully.' => 'Succès ! Agent attribué avec succès.',
    'Ticket status is already set' => 'Le statut du ticket est déjà défini',
    'Success ! Tickets status updated successfully.' => 'Succès ! Statut des tickets mis à jour avec succès.',
    'Ticket priority is already set' => 'La priorité des tickets est déjà définie',
    'Success ! Tickets priority updated successfully.' => 'Succès ! Priorité des tickets mise à jour avec succès.',
    'Ticket group is updated successfully' => 'Le groupe de tickets est mis à jour avec succès',
    'Ticket is already assigned to group' => 'Le ticket est déjà attribué au groupe',
    'Success ! Tickets group updated successfully.' => 'Succès ! Groupe de tickets mis à jour avec succès.',
    'Ticket team is updated successfully' => 'L\'équipe de tickets est mise à jour avec succès',
    'Ticket is already assigned to team' => 'Le ticket est déjà attribué à l\'équipe',
    'Success ! Tickets team updated successfully.' => 'Succès ! L\'équipe des tickets a été mise à jour avec succès.',
    'Ticket type is already set' => 'Le type de billet est déjà défini',
    'Success ! Tickets type updated successfully.' => 'Succès ! Type de ticket mis à jour avec succès.',
    'Success ! Tickets label updated successfully.' => 'Succès ! L\'étiquette des billets a été mise à jour avec succès.',
    'Success ! Tickets added to label successfully.' => 'Succès ! Tickets ajoutés au libellé avec succès.',
    'Success ! Tickets moved to trashed successfully.' => 'Succès ! Les tickets ont été placés dans la corbeille avec succès.',
    'Success ! Tickets removed successfully.' => 'Succès ! Tickets supprimés avec succès.',
    'Success ! Tickets restored successfully.' => 'Succès ! Les tickets ont été restaurés avec succès.',
    'Unable to retrieve group details' => 'Impossible de récupérer les détails du groupe',
    'Unable to retrieve team details' => 'Impossible de récupérer les détails de l\'équipe',
    'Tickets details have been updated successfully' => 'Les détails des billets ont été mis à jour avec succès',
    'Label added to ticket successfully' => 'Libellé ajouté au ticket avec succès',
    'Label already added to ticket' => 'Libellé déjà ajouté au ticket',
    'New Ticket Request' => 'Nouvelle demande de ticket',
    'Ticket Requests' => 'Demandes de tickets',
    'Tickets have been updated successfully' => 'Les tickets ont été mis à jour avec succès ',
    'Please check your mail for password update' => 'Veuillez vérifier votre courrier pour la mise à jour du mot de passe',
    'This email address is not registered with us' => 'Cette adresse e-mail n\'est pas enregistrée chez nous',
    'You have already update password using this link if you wish to change password again click on forget password link here from login page' => 'Vous avez déjà mis à jour le mot de passe en utilisant ce lien si vous souhaitez changer de mot de passe à nouveau cliquez sur le lien oublier le mot de passe ici depuis la page de connexion',
    'Your password has been successfully updated. Login using updated password' => 'Votre mot de passe a été modifié avec succès. Connectez-vous en utilisant un mot de passe mis à jour',
    'Please try again, The passwords do not match' => 'Veuillez réessayer, les mots de passe ne correspondent pas',
    'Support Privilege removed successfully' => 'Support Privilege supprimé avec succès',
    'Success! Saved Reply has been deleted successfully.' => 'Succès! La réponse enregistrée a été supprimée avec succès.',
    'SwiftMailer configuration created successfully.' => 'La configuration de SwiftMailer a été créée avec succès.',
    'No swiftmailer configurations found for mailer id:' => 'Aucune configuration swiftmailer trouvée pour l\'identifiant de l\'expéditeur',
    'Reply content cannot be left blank.' => 'Le contenu de la réponse ne peut pas être laissé vide.',
    'Reply added to the ticket and forwarded successfully.' => 'Réponse ajoutée au ticket et transférée avec succès.',
    'Success ! Thread pinned successfully.' => 'Succès ! Sujet épinglé avec succès.',
    'Success ! unpinned removed successfully.' => 'Succès ! épingle supprimée avec succès.',
    'Unable to retrieve priority details' => 'Impossible de récupérer les détails de priorité',
    'Ticket support team updated successfully' => 'L\'équipe d\'assistance aux tickets a été mise à jour avec succès',
    'Ticket assigned to support group ' => 'Ticket attribué au groupe de support',
    'Mailbox configuration removed successfully.' => 'La configuration de la boîte aux lettres a bien été supprimée.',
    'visit our website' => 'visitez notre site Internet',
    'Cookie Usage Policy' => 'Politique d\'utilisation des cookies',
    'cookie' => 'cookie',
    'cookies' => 'cookies',
    'HELP' => 'AIDEZ-MOI',
    'Home' => 'Accueil',
    'Cookie Policy' => 'Politique de cookies',
    'Prev' => 'Précédent',
    'Ticket query message' => 'Message du ticket',
    'Select type' => 'Sélectionnez le type',
    'Search KnowledgeBase' => 'Rechercher dans la base de connaissances',
    'You cant merge an account with itself.' => 'Vous ne pouvez pas fusionner un compte avec lui-même.',
    'Edit Profile' => 'Editer le profil',
    'Customer Login' => 'Login client',
    'Contact Us' => 'Contactez-nous',
    'If you have ever contacted our support previously, your account would have already been created.' => 'Si vous avez contacté notre service d\'assistance par le passé, votre compte a déjà été créé.',
    'support' => 'support',
    'HelpDesk' => 'Centre de support',
    'Enter search keyword' => 'Entrez le mot clé de la recherche',
    'Browse via Folders' => 'Parcourir via les dossiers',
    'Looking for something that is queried generally? Choose a relevant folder from below to explore possible solutions' => 'Vous cherchez quelque chose qui fait l\'objet d\'une demande générale ? Choisissez un dossier pertinent parmi les suivants pour explorer les solutions possibles',
    'Unable to find an answer?' => 'Impossible de trouver une réponse ?',
    'Looking for anything specific article which resides in general queries? Just browse the various relevant folders and categories and then you will find the desired article.' => 'Vous recherchez un article spécifique qui réside dans des requêtes générales? Il suffit de parcourir les différents dossiers et catégories pertinents pour trouver l’article souhaité.',
    'Popular Articles ' => 'Articles populaires',
    'Here are some of the most popular articles, which helped number of users to get their queries and questions resolved. ' => 'Voici quelques-uns des articles les plus populaires, qui ont aidé nombre dutilisateurs à résoudre leurs requêtes et questions.',
    'Browse via Categories' => 'Parcourir les catégories',
    'Looking for something specific? Choose a relevant category from below to explore possible solutions' => 'Vous cherchez quelque chose de spécifique ? Choisissez une catégorie pertinente ci-dessous pour explorer les solutions possibles',
    'No Categories Found!' => 'Aucune catégorie trouvée',
    'Powered by' => 'Alimenté par',
    'Powered by %uvdesk%, an open-source project by %webkul%.' => 'Propulsé par %uvdesk%, un projet open source de %webkul%.',
    'Forgot Password' => 'Mot de passe oublié',
    'Enter your email address and we will send you an email with instructions to update your login credentials.' => 'Entrez votre adresse e-mail et nous vous enverrons un e-mail avec les instructions pour mettre à jour vos informations de connexion.',
    'Send Mail' => 'Envoyer un email',
    'Status:' => 'Statut:',
    'Sign In to %websitename%' => 'Connectez-vous à %websitename%',
    'Enter your name' => 'Entrez votre nom',
    'Enter your email' => 'Entrer votre Email',
    'Learn more about %deliveryStatus%.' => 'En savoir plus sur  %deliveryStatus%.',
    'To know more about how our privacy policy works, please %websiteLink%.' => 'Pour en savoir plus sur le fonctionnement de notre politique de confidentialité, veuillez %websiteLink%.',
    'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.' => 'Certaines de nos pages de site utilisent %cookies% et d’autres technologies de suivi. Un %cookie% est un petit fichier texte pouvant être utilisé, par exemple, pour collecter des informations sur lactivité du site. Certains cookies et autres technologies peuvent servir à rappeler des informations personnelles précédemment indiquées par un utilisateur du site. Vous pouvez bloquer les cookies ou supprimer des cookies existants en ajustant les paramètres appropriés de votre navigateur. Veuillez consulter le menu %help% de votre navigateur pour savoir comment procéder. Si vous bloquez ou supprimez %cookies%, vous constaterez peut-être que lutilité de notre site est compromise.',
    'This field contain maximum 40 charectures.' => 'Ce champ contient au maximum 40 caractères.',
    'This field contain maximum 50 charectures.' => 'Ce champ contient au maximum 50 caractères.',
    'Time' => 'Temps',
    'Links' => 'Liens',
    'Broadcast Message' => 'Message de diffusion',
    'Wide Logo' => 'Logo large',
    'Upload an Image (200px x 48px) in</br> PNG or JPG Format' => 'Télécharger une image (200px x 48px) au format </br> PNG ou JPG',
    'It will be shown as Logo on Knowledgebase and Helpdesk' => 'Il sera affiché sous forme de logo dans la base de connaissances et le Helpdesk',
    'Website Status' => 'Statut du site',
    'Enable front end website and knowledgebase for customer(s)' => 'Activer le site Web frontal et la base de connaissances pour le (s) client (s)',
    'Brand Color' => 'Couleur de la marque',
    'Page Background Color' => 'Couleur de fond de la page',
    'Header Background Color' => 'Couleur de fond de len-tête',
    'Banner Background Color' => 'Couleur de fond de la bannière',
    'Page Link Color' => 'Couleur du lien de page',
    'Page Link Hover Color' => 'Couleur de survol de lien de page',
    'Article Text Color' => 'Couleur du texte de larticle',
    'Tag Line' => 'Tag line',
    'Hi! how can we help?' => 'Salut! Comment pouvons-nous vous aider?',
    'Layout' => 'Disposition',
    'Ticket Create Option' => 'Option de création de ticket',
    'Login Required To Create Tickets' => 'Connexion requise pour créer des tickets',
    'Remove Customer Login/Signin Button' => 'Supprimer le login / le bouton de connexion',
    'Disable Customer Login' => 'Désactiver la connexion client',
    'Meta Description (Recommended)' => 'Meta Description (Recommandé)',
    'Meta Keywords (Recommended)' => 'Meta Keywords (Recommandé)',
    'Header Link' => 'Lien den-tête',
    'URL (with http":/"/ or https":/"/)' => 'URL (avec http": "// ou https": "//)',
    'Footer Link' => 'Lien de pied de page',
    'Custom CSS (Optional)' => 'CSS personnalisé (facultatif)',
    'It will be add to the frontend knowledgebase only' => 'Il sera ajouté à la base de connaissances frontale uniquement',
    'Custom Javascript (Optional)' => 'Javascript personnalisé (facultatif)',
    'Broadcast message content to show on helpdesk' => 'Diffuser le contenu du message à afficher sur le support technique',
    'From' => 'De',
    'Time duration between which message will be displayed(if applicable)' => 'Durée pendant laquelle le message sera affiché (si applicable)',
    'Broadcasting Status' => 'Statut de diffusion',
    'Broadcasting is Active' => 'La diffusion est active',
    'Choose a default company timezone' => 'Choisir le fuseau horaire dune entreprise par défaut',
    'Date Time Format' => 'Format date-heure',
    'Choose a format to convert date to specified date time format' => 'Choisissez un format pour convertir la date au format de date / heure spécifié',
    'An empty file is not allowed.' => 'Un fichier vide nest pas autorisé.',
    'File size must not be greater than 200KB !!' => 'La taille du fichier ne doit pas dépasser 200 Ko !!',
    'comma "," separated' => 'séparées par des virgules',
    'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!' => 'Merci de télécharger un fichier image valide (JPEG, JPG, PNG uniquement) !!',
    'Provide a valid url(with protocol)' => 'Fournir une URL valide (avec protocole)',
    'Low' => 'Faible',
    'Medium' => 'Moyen',
    'High' => 'Haut',
    'Urgent' => 'Urgent',
    'Reset Password' => 'Réinitialiser le mot de passe',
    'Enter your new password below to update your login credentials' => 'Entrez votre nouveau mot de passe ci-dessous pour mettre à jour vos informations de connexion',
    'Save Password' => 'Enregistrer le mot de passe',
    'Rate Support' => 'Assistance tarifaire',
    'I am very Sad' => 'Je suis très déçu',
    'I am Sad' => 'Je suis déçu',
    'I am Neutral' => 'je suis neutre',
    'I am Happy' => 'Je suis content',
    'I am Very Happy' => 'Je suis très heureux',
    'Kudos' => 'Appréciations',
    'kudos' => 'Appréciations',
    'Very Sad' => 'Très déçu',
    'Sad' => 'Déçu',
    'Neutral' => 'Neutre',
    'Happy' => 'Heureux',
    'Very Happy' => 'Très heureux',
    'Star(s)' => 'Étoile(s)',
    'Warning ! Swiftmailer not working. An error has occurred while sending emails!' => 'Avertissement ! Swiftmailer ne fonctionne pas. Une erreur s\'est produite lors de l\'envoi des e-mails !',
    'Invalid credentials.' => 'Informations d\'identification invalides.',
    'Success ! Project cache cleared successfully.' => 'Succès ! Cache du projet effacé avec succès.',
    'clear cache' => 'vider le cache',
    'Last Updated' => 'Dernière mise à jour',
    'Error! Something went wrong.' => 'Erreur! Quelque chose s\'est mal passé.',
    'We were not able to find the page you are looking for.' => 'Nous n\'avons pas pu trouver la page que vous recherchez.',
    'Page not found' => 'Page non trouvée',
    'Forbidden' => 'Interdit',
    'You don’t have the necessary permissions to access this Web page :(' => 'Vous n\'avez pas les autorisations nécessaires pour accéder à cette page Web :(',
    'Internal server error' => 'Erreur Interne du Serveur',
    'Our system has goofed up for a while, but good part is it won\'t last long' => 'Notre système a gaffé pendant un certain temps, mais la bonne nouvelle est que ça ne durera pas longtemps',
    'Unknown Error' => 'Erreur inconnue',
    'We are quite confused about how did you land here:/' => 'Nous sommes assez confus quant à la façon dont vous avez atterri ici :/',
    'Few of the links which may help you to get back on the track -' => 'Quelques liens qui peuvent vous aider à vous remettre sur la bonne voie -',
    'Microsoft Apps' => 'Applications Microsoft',
    'Add a Microsoft app' => 'Ajouter une application Microsoft',
    'Enable' => 'Activée',
    'App Name' => 'Nom de l\'application',
    'Tenant Id' => 'Identifiant du locataire',
    'Client Id' => 'Identité du client',
    'Client Secret' => 'Clé secrète du client',
    'NEW APP:' => 'NOUVELLE APPLICATION',
    'UPDATE APP' => 'MISE À JOUR DE L\'APPLICATION',
    'Guide on creating a new app in Azure Active Directory:' => 'Guide sur la création d\'une nouvelle application dans Azure Active Directory :',
    'To add a new Microsoft App to your azure active directory, follow the steps as given below:' => 'Pour ajouter une nouvelle application Microsoft à votre répertoire actif Azure, suivez les étapes ci-dessous :',
    'Go to Azure Active Directory -> App registerations' => 'Accédez à Azure Active Directory -> Enregistrements d\'applications',
    'Disable' => 'Désactiver',
    'Please enter a valid name for your app.' => 'Veuillez saisir un nom valide pour votre application.',
    'Please enter a valid tenant id.' => 'Veuillez entrer un identifiant de locataire valide.',
    'Please enter a valid client id.' => 'Veuillez saisir un identifiant client valide.',
    'Please enter a valid client secret.' => 'Veuillez entrer un secret client valide.',
    'Microsoft app settings' => 'Paramètres de l\'application Microsoft',
    'Unverified' => 'Non vérifié',
    'Microsoft app has been updated successfully.' => 'L\'application Microsoft a été mise à jour avec succès.',
    'No microsoft apps found' => 'Aucune application Microsoft trouvée',
    'Microsoft app settings could not be verifired successfully. Please check your settings and try again later.' => 'Les paramètres de l\'application Microsoft n\'ont pas pu être vérifiés avec succès. Veuillez vérifier vos paramètres et réessayer plus tard.',
    'Microsoft app has been integrated successfully.' => 'L\'application Microsoft a été supprimée avec succès.',
    'Microsoft app has been deleted successfully.' => 'L\'application Microsoft a été intégrée avec succès.',
    'Verified' => 'Vérifié',
    'Create a New Registration' => 'Créer un nouvel enregistrement',
    'Enter your app details as following:' => 'Entrez les détails de votre application comme suit :',
    'App Name: Enter an app name to easily help you identify its purpose' => 'Nom de l\'application : entrez un nom d\'application pour vous aider à identifier facilement son objectif',
    'Supported Account Types: Select whichever option works the best for you (Recommended: Accounts in any organizational directory and personal Microsoft accounts)' => 'Types de comptes pris en charge : sélectionnez l\'option qui vous convient le mieux (recommandé : comptes dans n\'importe quel répertoire organisationnel et comptes Microsoft personnels)',
    'Redirect URI:' => 'URI de redirection:',
    'Select Platform: Web' => 'Sélectionnez la plate-forme : Web',
    'Enter the following redirect uri:' => 'Saisissez l\'URI de redirection suivante:',
    'Proceed to create your application' => 'Procédez à la création de votre application',
    'Once your app has been created, in your app overview section, continue with adding a client credential by clicking on "Add a certificate or secret"' => 'Une fois votre application créée, dans la section de présentation de votre application, continuez avec l\'ajout d\'un identifiant client en cliquant sur Ajouter un certificat ou un secret',
    'Create a new client secret' => 'Créer un nouveau secret client',
    'Enter a description as per your preference to help identify the purpose of this client secret' => 'Entrez une description selon vos préférences pour aider à identifier l\'objectif de ce secret client',
    'Choose an expiration time as per your preference' => 'Choisissez un délai d\'expiration selon vos préférences',
    'Proceed to add your client secret' => 'Continuez pour ajouter votre secret client',
    'Copy the client secret value which will be needed later and cannot be viewed again' => 'Copiez la valeur du secret client qui sera nécessaire plus tard et ne pourra plus être visualisée',
    'Navigate to API permissions' => 'Accédez aux autorisations de l\'API',
    'Click on "Add a permission" to add a new api permission. Add the following delegated permissions by selecting Microsoft APIs > Microsoft Graph > Delegate Permissions' => 'Cliquez sur Ajouter une autorisation pour ajouter une nouvelle autorisation API. Ajoutez les autorisations déléguées suivantes en sélectionnant API Microsoft > Microsoft Graph > Autorisations déléguées',
    'Navigate to your app overview section' => 'Accédez à la section de présentation de votre application',
    'Copy the Application (Client) Id' => 'Copiez l\'identifiant de l\'application (client)',
    'Copy the Directory (Tenant) Id' => 'Copiez l\'identifiant de l\'annuaire (locataire)',
    'Enter your client id, tenant id, and client secret in settings above as required.' => 'Entrez votre identifiant client, votre identifiant de locataire et votre secret client dans les paramètres ci-dessus, selon les besoins.',
    'offline_access' => 'accès_hors ligne',
    'openid' => 'ID ouvert',
    'profile' => 'profil',
    'User.Read' => 'Utilisateur.Lire',
    'IMAP.AccessAsUser.All' => 'IMAP.AccessAsUser.All',
    'SMTP.Send' => 'SMTP.Envoyer',
    'POP.AccessAsUser.All' => 'POP.AccessAsUser.All',
    'Mail.Read' => 'Courrier.Lire',
    'Mail.ReadBasic' => 'Mail.ReadBasic',
    'Mail.Send' => 'Courrier.Envoyer',
    'Mail.Send.Shared' => 'Courrier.Envoyer.Partagé',
    'Add App' => 'Ajouter une application',
    'New App' => 'Nouvelle application',
    'Disable email delivery' => 'Désactiver la livraison des e-mails',
    'Use as default mailbox for sending emails' => 'Utiliser comme boîte aux lettres par défaut pour envoyer des e-mails',
    'Inbound Emails' => 'E-mails entrants',
    'Manage how you wish to retrieve and process emails from your mailbox.' => 'Gérez la manière dont vous souhaitez récupérer et traiter les e-mails de votre boîte aux lettres.',
    'Outbound Emails' => 'E-mails sortants',
    'Manage how you wish to send emails from your mailbox.' => 'Gérez la façon dont vous souhaitez envoyer des e-mails depuis votre boîte aux lettres.',
    'Marketing Modules' => 'Modules de marketing',
    'New Marketing Module' => 'Nouveau module marketing',
    'Marketing Module' => 'Module Marketing',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This value is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This value is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This value is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This value is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This value should be a valid expression.' => 'This value should be a valid expression.',
    'This value is not a valid CSS color.' => 'This value is not a valid CSS color.',
    'This value is not a valid CIDR notation.' => 'This value is not a valid CIDR notation.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'The value of the netmask should be between {{ min }} and {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.',
    'The password strength is too low. Please use a stronger password.' => 'The password strength is too low. Please use a stronger password.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'This value contains characters that are not allowed by the current restriction-level.',
    'Using invisible characters is not allowed.' => 'Using invisible characters is not allowed.',
    'Mixing numbers from different scripts is not allowed.' => 'Mixing numbers from different scripts is not allowed.',
    'Using hidden overlay characters is not allowed.' => 'Using hidden overlay characters is not allowed.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.',
    'This value is not a valid MAC address.' => 'This value is not a valid MAC address.',
    'This URL is missing a top-level domain.' => 'This URL is missing a top-level domain.',
    'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.' => 'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.',
    'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.' => 'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.',
    'This value does not represent a valid week in the ISO 8601 format.' => 'This value does not represent a valid week in the ISO 8601 format.',
    'This value is not a valid week.' => 'This value is not a valid week.',
    'This value should not be before week "{{ min }}".' => 'This value should not be before week "{{ min }}".',
    'This value should not be after week "{{ max }}".' => 'This value should not be after week "{{ max }}".',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Too many failed login attempts, please try again in %minutes% minute.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Too many failed login attempts, please try again in %minutes% minutes.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Previous',
    'label_next' => 'Next',
    'filter_searchword' => 'Searchword...',
  ),
  'messages' => 
  array (
    'Signed in as' => 'Signed in as',
    'Your Profile' => 'Your Profile',
    'Create Ticket' => 'Create Ticket',
    'Create Agent' => 'Create Agent',
    'Create Customer' => 'Create Customer',
    'Sign Out' => 'Sign Out',
    'Default Language (Optional)' => 'Default Language (Optional)',
    'Username/Email' => 'Username/Email',
    'create new' => 'create new',
    'Ticket Information' => 'Ticket Information',
    'CC/BCC' => 'CC/BCC',
    'Success! Label created successfully.' => 'Success! Label created successfully.',
    'Success! Label removed successfully.' => 'Success! Label removed successfully.',
    'Reports' => 'Reports',
    'Rating' => 'Rating',
    'Kudos Rating' => 'Kudos Rating',
    'Remove profile picture' => 'Remove profile picture',
    'Success ! Profile updated successfully.' => 'Success ! Profile updated successfully.',
    'Howdy' => 'Howdy',
    'Form successfully updated.' => 'Form successfully updated.',
    'NEW FORM' => 'NEW FORM',
    'Text Box' => 'Text Box',
    'Text Area' => 'Text Area',
    'Select' => 'Select',
    'Radio' => 'Radio',
    'Checkbox' => 'Checkbox',
    'Date' => 'Date',
    'Both Date and Time' => 'Both Date and Time',
    'Choose a status' => 'Choose a status',
    'Choose a group' => 'Choose a group',
    'Choose your default timeformat' => 'Choose your default timeformat',
    'Can manage Group\'s Saved Reply' => 'Can manage Group\'s Saved Reply',
    'Can manage agent activity' => 'Can manage agent activity',
    'Slug is the url identity of this article. We will help you to create valid slug at time of typing.' => 'Slug is the url identity of this article. We will help you to create valid slug at time of typing.',
    'The URL for this article' => 'The URL for this article',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A page\'s title tag and meta description are usually shown whenever that page appears in search engine results' => 'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A page\'s title tag and meta description are usually shown whenever that page appears in search engine results',
    'comma separated (,)' => 'comma separated (,)',
    'Article Title' => 'Article Title',
    'Start typing few charactors and add set of relevant article from the list' => 'Start typing few charactors and add set of relevant article from the list',
    'Success! Announcement data saved successfully.' => 'Success! Announcement data saved successfully.',
    'Success! Category has been added successfully.' => 'Success! Category has been added successfully.',
    'Success ! Agent added successfully.' => 'Success ! Agent added successfully.',
    'Success! Privilege information saved successfully.' => 'Success! Privilege information saved successfully.',
    'Edit Prepared Response' => 'Edit Prepared Response',
    'Success! Type removed successfully.' => 'Success! Type removed successfully.',
    'No results available' => 'No results available',
    'Success ! Prepared Response applied successfully.' => 'Success ! Prepared Response applied successfully.',
    'Note added to ticket successfully.' => 'Note added to ticket successfully.',
    'Ticket status update to Spam' => 'Ticket status update to Spam',
    'Ticket status update to Closed' => 'Ticket status update to Closed',
    'Success! Label updated successfully.' => 'Success! Label updated successfully.',
    'Success ! Helpdesk details saved successfully' => 'Success ! Helpdesk details saved successfully',
    'Can manage marketing announcement' => 'Can manage marketing announcement',
    'User Forgot Password' => 'User Forgot Password',
    'Agent Deleted' => 'Agent Deleted',
    'Agent Update' => 'Agent Update',
    'Customer Update' => 'Customer Update',
    'Customer Deleted' => 'Customer Deleted',
    'Agent Updated' => 'Agent Updated',
    'Agent Reply' => 'Agent Reply',
    'Collaborator Added' => 'Collaborator Added',
    'Collaborator Reply' => 'Collaborator Reply',
    'Customer Reply' => 'Customer Reply',
    'Ticket Deleted' => 'Ticket Deleted',
    'Group Updated' => 'Group Updated',
    'Note Added' => 'Note Added',
    'Priority Updated' => 'Priority Updated',
    'Status Updated' => 'Status Updated',
    'Team Updated' => 'Team Updated',
    'Thread Updated' => 'Thread Updated',
    'Type Updated' => 'Type Updated',
    'From Email' => 'From Email',
    'To Email' => 'To Email',
    'Is Equal To' => 'Is Equal To',
    'Is Not Equal To' => 'Is Not Equal To',
    'Contains' => 'Contains',
    'Does Not Contain' => 'Does Not Contain',
    'Starts With' => 'Starts With',
    'Ends With' => 'Ends With',
    'Before On' => 'Before On',
    'After On' => 'After On',
    'Mail To User' => 'Mail To User',
    'Transfer Tickets' => 'Transfer Tickets',
    'Mail To Customer' => 'Mail To Customer',
    'Permanently delete from Inbox' => 'Permanently delete from Inbox',
    'Agent Activity' => 'Agent Activity',
    'Report From' => 'Report From',
    'Search Agent' => 'Search Agent',
    'Agent Last Reply' => 'Agent Last Reply',
    'View analytics and insights to serve a better experience for your customers' => 'Analytics and insight regarding your workflow',
    'Marketing Announcement' => 'Marketing Announcement',
    'Advertisement' => 'Advertisement',
    'Announcement' => 'Announcement',
    'New Announcement' => 'New Announcement',
    'Add Announcement' => 'Add Announcement',
    'Edit Announcement' => 'Edit Announcement',
    'Promo Text' => 'Promo Text',
    'Promo Tag' => 'Promo Tag',
    'Choose a promo tag' => 'Choose a promo tag',
    'Tag-Color' => 'Tag-Color',
    'Tag background color' => 'Tag background color',
    'Link Text' => 'Link Text',
    'Link URL' => 'Link URL',
    'Apps' => 'Apps',
    'Integrate apps as per your needs to get things done faster than ever' => 'Install new custom apps to boost your productivity - <a href=\'https://store.webkul.com/UVdesk/UVdesk-Open-Source.html\' style=\'font-weight: bold\' target=\'_blank\'>Explore Now</a>',
    'Explore Apps' => 'Explore Apps',
    'Form Builder' => 'Form Builder',
    'Knowledgebase' => 'Knowledgebase',
    'Knowledgebase is a source of rigid and complex information which helps Customers to help themselves' => 'Help your customers help themselves! Save time on support by building your knowledge base.',
    'Articles' => 'Articles',
    'Categories' => 'Categories',
    'Folders' => 'Folders',
    'FOLDERS' => 'FOLDERS',
    'Productivity' => 'Productivity',
    'Automate your processes by creating set of rules and presets to respond faster to the tickets' => 'Create automation rules to speed up your workflow.',
    'Prepared Responses' => 'Prepared Responses',
    'Saved Replies' => 'Saved Replies',
    'Edit Saved Reply' => 'Edit Saved Reply',
    'Ticket Types' => 'Ticket Types',
    'Workflows' => 'Workflows',
    'Settings' => 'Settings',
    'Manage your Brand Identity, Company Information and other details at a glance' => 'Manage your Brand Identity, Company Information and other details at a glance',
    'Branding' => 'Branding',
    'Custom Fields' => 'Custom Fields',
    'Email Settings' => 'Email Settings',
    'Email Templates' => 'Email Templates',
    'Mailbox' => 'Mailbox',
    'Spam Settings' => 'Spam Settings',
    'Swift Mailer' => 'Swift Mailer',
    'Tags' => 'Tags',
    'Users' => 'Users',
    'Control your Groups, Teams, Agents and Customers' => 'Manage your Groups, Teams, Agents and Customers',
    'Agents' => 'Agents',
    'Customers' => 'Customers',
    'Groups' => 'Groups',
    'Privileges' => 'Privileges',
    'Teams' => 'Teams',
    'Applications' => 'Applications',
    'ECommerce Order Syncronization' => 'eCommerce Order Syncronization',
    'Import ecommerce order details to your support tickets from different available platforms' => 'Import eCommerce order details to your support tickets from different available platforms',
    'Search' => 'Search',
    'Sort By' => 'Sort By',
    'Sort By:' => 'Sort By:',
    'Status' => 'Status',
    'Created At' => 'Created At',
    'Name' => 'Name',
    'All' => 'All',
    'Published' => 'Published',
    'Draft' => 'Draft',
    'New Folder' => 'New Folder',
    'Create Knowledgebase Folder' => 'Create Knowledgebase Folder',
    'You did not add any folder to your Knowledgebase yet, Create your first Folder and start adding Categories/Articles to make your customers help themselves.' => 'You don\'t have any folders yet! Create your first folder and start adding articles.',
    'Clear Filters' => 'Clear Filters',
    'Back' => 'Back',
    'Open' => 'Open',
    'Pending' => 'Pending',
    'Answered' => 'Answered',
    'Resolved' => 'Resolved',
    'Closed' => 'Closed',
    'Spam' => 'Spam',
    'New' => 'New',
    'UnAssigned' => 'Unassigned',
    'UnAnswered' => 'Unanswered',
    'My Tickets' => 'My Tickets',
    'Starred' => 'Starred',
    'Trashed' => 'Trashed',
    'New Label' => 'New Label',
    'Tickets' => 'Tickets',
    'Ticket Id' => 'Ticket Id',
    'Last Replied' => 'Last Replied',
    'Assign To' => 'Assign To',
    'After Reply' => 'After Reply',
    'Customer Email' => 'Customer Email',
    'Customer Name' => 'Customer Name',
    'Assets Visibility' => 'Assets Visibility',
    'Channel/Source' => 'Channel/Source',
    'Channel' => 'Channel',
    'Website' => 'Website',
    'Timestamp' => 'Timestamp',
    'TimeStamp' => 'TimeStamp',
    'Team' => 'Team',
    'Type' => 'Type',
    'Replies' => 'Replies',
    'Agent' => 'Agent',
    'ID' => 'ID',
    'Subject' => 'Subject',
    'Last Reply' => 'Last Reply',
    'Filter View' => 'Filter View',
    'Please select CAPTCHA' => 'Please select CAPTCHA',
    'Warning ! Please select correct CAPTCHA !' => 'CAPTCHA Failed, please try again',
    'reCAPTCHA Setting' => 'reCAPTCHA Setting',
    'reCAPTCHA Site Key' => 'reCAPTCHA Site Key',
    'reCAPTCHA Secret key' => 'reCAPTCHA Secret key',
    'reCAPTCHA Status' => 'reCAPTCHA Status',
    'reCAPTCHA is Active' => 'reCAPTCHA is Active',
    'Save set of filters as a preset to stay more productive' => 'Save filters as preset',
    'Saved Filters' => 'Saved Filters',
    'No saved filter created' => 'No saved filter created',
    'Customer' => 'Customer',
    'Priority' => 'Priority',
    'Tag' => 'Tag',
    'Source' => 'Source',
    'Before' => 'Before',
    'After' => 'After',
    'Replies less than' => 'Replies less than',
    'Replies more than' => 'Replies more than',
    'Clear All' => 'Clear All',
    'Account' => 'Account',
    'Profile' => 'Profile',
    'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format' => 'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format',
    'First Name' => 'First Name',
    'Last Name' => 'Last Name',
    'Email' => 'Email',
    'Contact Number' => 'Contact Number',
    'Timezone' => 'Timezone',
    'Africa/Abidjan' => 'Africa/Abidjan',
    'Africa/Accra' => 'Africa/Accra',
    'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
    'Africa/Algiers' => 'Africa/Algiers',
    'Africa/Asmara' => 'Africa/Asmara',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Bangui' => 'Africa/Bangui',
    'Africa/Banjul' => 'Africa/Banjul',
    'Africa/Bissau' => 'Africa/Bissau',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Brazzaville' => 'Africa/Brazzaville',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Cairo' => 'Africa/Cairo',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Africa/Conakry' => 'Africa/Conakry',
    'Africa/Dakar' => 'Africa/Dakar',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Djibouti' => 'Africa/Djibouti',
    'Africa/Douala' => 'Africa/Douala',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Gaborone' => 'Africa/Gaborone',
    'Africa/Harare' => 'Africa/Harare',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Juba' => 'Africa/Juba',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Kigali' => 'Africa/Kigali',
    'Africa/Kinshasa' => 'Africa/Kinshasa',
    'Africa/Lagos' => 'Africa/Lagos',
    'Africa/Libreville' => 'Africa/Libreville',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Luanda' => 'Africa/Luanda',
    'Africa/Lubumbashi' => 'Africa/Lubumbashi',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Malabo' => 'Africa/Malabo',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Ndjamena' => 'Africa/Ndjamena',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Porto-Novo' => 'Africa/Porto-Novo',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'America/Adak' => 'America/Adak',
    'America/Anchorage' => 'America/Anchorage',
    'America/Anguilla' => 'America/Anguilla',
    'America/Antigua' => 'America/Antigua',
    'America/Araguaina' => 'America/Araguaina',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Salta' => 'America/Argentina/Salta',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/San_Luis' => 'America/Argentina/San_Luis',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/Asuncion' => 'America/Asuncion',
    'America/Atikokan' => 'America/Atikokan',
    'America/Bahia' => 'America/Bahia',
    'America/Bahia_Banderas' => 'America/Bahia_Banderas',
    'America/Barbados' => 'America/Barbados',
    'America/Belem' => 'America/Belem',
    'America/Belize' => 'America/Belize',
    'America/Blanc-Sablon' => 'America/Blanc-Sablon',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Bogota' => 'America/Bogota',
    'America/Boise' => 'America/Boise',
    'America/Cambridge_Bay' => 'America/Cambridge_Bay',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cancun' => 'America/Cancun',
    'America/Caracas' => 'America/Caracas',
    'America/Cayenne' => 'America/Cayenne',
    'America/Cayman' => 'America/Cayman',
    'America/Chicago' => 'America/Chicago',
    'America/Chihuahua' => 'America/Chihuahua',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Creston' => 'America/Creston',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Curacao' => 'America/Curacao',
    'America/Danmarkshavn' => 'America/Danmarkshavn',
    'America/Dawson' => 'America/Dawson',
    'America/Dawson_Creek' => 'America/Dawson_Creek',
    'America/Denver' => 'America/Denver',
    'America/Detroit' => 'America/Detroit',
    'America/Dominica' => 'America/Dominica',
    'America/Edmonton' => 'America/Edmonton',
    'America/Eirunepe' => 'America/Eirunepe',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Fort_Nelson' => 'America/Fort_Nelson',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Glace_Bay' => 'America/Glace_Bay',
    'America/Godthab' => 'America/Godthab',
    'America/Goose_Bay' => 'America/Goose_Bay',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Guayaquil' => 'America/Guayaquil',
    'America/Guyana' => 'America/Guyana',
    'America/Halifax' => 'America/Halifax',
    'America/Havana' => 'America/Havana',
    'America/Hermosillo' => 'America/Hermosillo',
    'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
    'America/Indiana/Knox' => 'America/Indiana/Knox',
    'America/Indiana/Marengo' => 'America/Indiana/Marengo',
    'America/Indiana/Petersburg' => 'America/Indiana/Petersburg',
    'America/Indiana/Tell_City' => 'America/Indiana/Tell_City',
    'America/Indiana/Vevay' => 'America/Indiana/Vevay',
    'America/Indiana/Vincennes' => 'America/Indiana/Vincennes',
    'America/Indiana/Winamac' => 'America/Indiana/Winamac',
    'America/Inuvik' => 'America/Inuvik',
    'America/Iqaluit' => 'America/Iqaluit',
    'America/Jamaica' => 'America/Jamaica',
    'America/Juneau' => 'America/Juneau',
    'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
    'America/Kralendijk' => 'America/Kralendijk',
    'America/La_Paz' => 'America/La_Paz',
    'America/Lima' => 'America/Lima',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Lower_Princes' => 'America/Lower_Princes',
    'America/Maceio' => 'America/Maceio',
    'America/Managua' => 'America/Managua',
    'America/Manaus' => 'America/Manaus',
    'America/Marigot' => 'America/Marigot',
    'America/Martinique' => 'America/Martinique',
    'America/Matamoros' => 'America/Matamoros',
    'America/Mazatlan' => 'America/Mazatlan',
    'America/Menominee' => 'America/Menominee',
    'America/Merida' => 'America/Merida',
    'America/Metlakatla' => 'America/Metlakatla',
    'America/Mexico_City' => 'America/Mexico_City',
    'America/Miquelon' => 'America/Miquelon',
    'America/Moncton' => 'America/Moncton',
    'America/Monterrey' => 'America/Monterrey',
    'America/Montevideo' => 'America/Montevideo',
    'America/Montserrat' => 'America/Montserrat',
    'America/Nassau' => 'America/Nassau',
    'America/New_York' => 'America/New_York',
    'America/Nipigon' => 'America/Nipigon',
    'America/Nome' => 'America/Nome',
    'America/Noronha' => 'America/Noronha',
    'America/North_Dakota/Beulah' => 'America/North_Dakota/Beulah',
    'America/North_Dakota' => 'America/North_Dakota',
    'America/Ojinaga' => 'America/Ojinaga',
    'America/Panama' => 'America/Panama',
    'America/Pangnirtung' => 'America/Pangnirtung',
    'America/Paramaribo' => 'America/Paramaribo',
    'America/Phoenix' => 'America/Phoenix',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Port_of_Spain' => 'America/Port_of_Spain',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/Punta_Arenas' => 'America/Punta_Arenas',
    'America/Rainy_River' => 'America/Rainy_River',
    'America/Rankin_Inlet' => 'America/Rankin_Inlet',
    'America/Recife' => 'America/Recife',
    'America/Regina' => 'America/Regina',
    'America/Resolute' => 'America/Resolute',
    'America/Rio_Branco' => 'America/Rio_Branco',
    'America/Santarem' => 'America/Santarem',
    'America/Santiago' => 'America/Santiago',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Scoresbysund' => 'America/Scoresbysund',
    'America/Sitka' => 'America/Sitka',
    'America/St_Barthelemy' => 'America/St_Barthelemy',
    'America/St_Johns' => 'America/St_Johns',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Swift_Current' => 'America/Swift_Current',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Thule' => 'America/Thule',
    'America/Thunder_Bay' => 'America/Thunder_Bay',
    'America/Tijuana' => 'America/Tijuana',
    'America/Toronto' => 'America/Toronto',
    'America/Tortola' => 'America/Tortola',
    'America/Vancouver' => 'America/Vancouver',
    'America/Whitehorse' => 'America/Whitehorse',
    'America/Winnipeg' => 'America/Winnipeg',
    'America/Yakutat' => 'America/Yakutat',
    'America/Yellowknife' => 'America/Yellowknife',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Macquarie' => 'Antarctica/Macquarie',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Troll' => 'Antarctica/Troll',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Arctic/Longyearbyen' => 'Arctic/Longyearbyen',
    'Asia/Aden' => 'Asia/Aden',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Atyrau' => 'Asia/Atyrau',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Barnaul' => 'Asia/Barnaul',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Chita' => 'Asia/Chita',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Famagusta' => 'Asia/Famagusta',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Hebron' => 'Asia/Hebron',
    'Asia/Ho_Chi_Minh' => 'Asia/Ho_Chi_Minh',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Jerusalem' => 'Asia/Jerusalem',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Kathmandu' => 'Asia/Kathmandu',
    'Asia/Khandyga' => 'Asia/Khandyga',
    'Asia/Kolkata' => 'Asia/Kolkata',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Novokuznetsk' => 'Asia/Novokuznetsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Qostanay' => 'Asia/Qostanay',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Srednekolymsk' => 'Asia/Srednekolymsk',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Tomsk' => 'Asia/Tomsk',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Ust-Nera' => 'Asia/Ust-Nera',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Yangon' => 'Asia/Yangon',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Atlantic/Faroe' => 'Atlantic/Faroe',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Eucla' => 'Australia/Eucla',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Lord_Howe' => 'Australia/Lord_Howe',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Sydney' => 'Australia/Sydney',
    'Europe/Amsterdam' => 'Europe/Amsterdam',
    'Europe/Andorra' => 'Europe/Andorra',
    'Europe/Astrakhan' => 'Europe/Astrakhan',
    'Europe/Athens' => 'Europe/Athens',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Berlin' => 'Europe/Berlin',
    'Europe/Bratislava' => 'Europe/Bratislava',
    'Europe/Brussels' => 'Europe/Brussels',
    'Europe/Bucharest' => 'Europe/Bucharest',
    'Europe/Budapest' => 'Europe/Budapest',
    'Europe/Busingen' => 'Europe/Busingen',
    'Europe/Chisinau' => 'Europe/Chisinau',
    'Europe/Copenhagen' => 'Europe/Copenhagen',
    'Europe/Dublin' => 'Europe/Dublin',
    'Europe/Gibraltar' => 'Europe/Gibraltar',
    'Europe/Guernsey' => 'Europe/Guernsey',
    'Europe/Helsinki' => 'Europe/Helsinki',
    'Europe/Isle_of_Man' => 'Europe/Isle_of_Man',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Jersey' => 'Europe/Jersey',
    'Europe/Kaliningrad' => 'Europe/Kaliningrad',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Kirov' => 'Europe/Kirov',
    'Europe/Lisbon' => 'Europe/Lisbon',
    'Europe/Ljubljana' => 'Europe/Ljubljana',
    'Europe/London' => 'Europe/London',
    'Europe/Luxembourg' => 'Europe/Luxembourg',
    'Europe/Madrid' => 'Europe/Madrid',
    'Europe/Malta' => 'Europe/Malta',
    'Europe/Mariehamn' => 'Europe/Mariehamn',
    'Europe/Minsk' => 'Europe/Minsk',
    'Europe/Monaco' => 'Europe/Monaco',
    'Europe/Moscow' => 'Europe/Moscow',
    'Europe/Oslo' => 'Europe/Oslo',
    'Europe/Paris' => 'Europe/Paris',
    'Europe/Podgorica' => 'Europe/Podgorica',
    'Europe/Prague' => 'Europe/Prague',
    'Europe/Riga' => 'Europe/Riga',
    'Europe/Rome' => 'Europe/Rome',
    'Europe/Samara' => 'Europe/Samara',
    'Europe/San_Marino' => 'Europe/San_Marino',
    'Europe/Sarajevo' => 'Europe/Sarajevo',
    'Europe/Saratov' => 'Europe/Saratov',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'Europe/Skopje' => 'Europe/Skopje',
    'Europe/Sofia' => 'Europe/Sofia',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Tallinn' => 'Europe/Tallinn',
    'Europe/Tirane' => 'Europe/Tirane',
    'Europe/Ulyanovsk' => 'Europe/Ulyanovsk',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Vaduz' => 'Europe/Vaduz',
    'Europe/Vatican' => 'Europe/Vatican',
    'Europe/Vienna' => 'Europe/Vienna',
    'Europe/Vilnius' => 'Europe/Vilnius',
    'Europe/Volgograd' => 'Europe/Volgograd',
    'Europe/Warsaw' => 'Europe/Warsaw',
    'Europe/Zagreb' => 'Europe/Zagreb',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Zurich' => 'Europe/Zurich',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Indian/Chagos' => 'Indian/Chagos',
    'Indian/Christmas' => 'Indian/Christmas',
    'Indian/Cocos' => 'Indian/Cocos',
    'Indian/Comoro' => 'Indian/Comoro',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Indian/Mahe' => 'Indian/Mahe',
    'Indian/Maldives' => 'Indian/Maldives',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Indian/Reunion' => 'Indian/Reunion',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Bougainville' => 'Pacific/Bougainville',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Chuuk' => 'Pacific/Chuuk',
    'Pacific/Easter' => 'Pacific/Easter',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pohnpei' => 'Pacific/Pohnpei',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'UTC' => 'UTC',
    'Time Format' => 'Time Format',
    'Choose your default timezone' => 'Choose your default timezone',
    'Signature' => 'Signature',
    'User signature will be append at the bottom of ticket reply box' => 'Your signature will be appended to the bottom of every ticket reply you create.',
    'Password' => 'Password',
    'Password will remain same if you are not entering something in this field' => 'Password not changed!',
    'Confirm Password' => 'Confirm Password',
    'Password must contain minimum 8 character length, at least two letters (not case sensitive), one number, one special character(space is not allowed).' => 'Password must be at least 8 characters, two letters (not case-sensitive), one number, and one special character (space is not allowed).',
    'Save Changes' => 'Save Changes',
    'SAVE CHANGES' => 'SAVE CHANGES',
    'CREATE TICKET' => 'CREATE TICKET',
    'Customer full name' => 'Customer full name',
    'Customer email address' => 'Customer email address',
    'Select Type' => 'Select Type',
    'Support' => 'Support',
    'Choose ticket type' => 'Choose ticket type',
    'Ticket subject' => 'Ticket subject',
    'Message' => 'Message',
    'Query Message' => 'Query Message',
    'Add Attachment' => 'Add Attachment',
    'This field is mandatory' => 'This field is mandatory',
    'General' => 'General',
    'Designation' => 'Designation',
    'Contant Number' => 'Content Number',
    'User signature will be append in the bottom of ticket reply box' => 'Your signature will be appended to the bottom of every ticket reply you create.',
    'Account Status' => 'Account Status',
    'Account is Active' => 'Account is Active',
    'Assigning group(s) to user to view tickets regardless assignment.' => 'Add user to group to view tickets regardless of owner.',
    'Default' => 'Default',
    'Select All' => 'Select All',
    'Remove All' => 'Remove All',
    'Assigning team(s) to user to view tickets regardless assignment.' => 'Add user to team to view tickets regardless of owner.',
    'No Team added !' => 'No Team added!',
    'Permission' => 'Permission',
    'Role' => 'Role',
    'Administrator' => 'Administrator',
    'Select agent role' => 'Select agent role',
    'Add Customer' => 'Add Customer',
    'Action' => 'Action',
    'Account Owner' => 'Account Owner',
    'Active' => 'Active',
    'Edit' => 'Edit',
    'Delete' => 'Delete',
    'Disabled' => 'Disabled',
    'New Group' => 'New Group',
    'Default Privileges' => 'Default Privileges',
    'New Privileges' => 'New Privileges',
    'NEW PRIVILEGE' => 'NEW PRIVILEGE',
    'New Privilege' => 'New Privilege',
    'New Team' => 'New Team',
    'No Record Found' => 'No Record Found',
    'Order Synchronization' => 'Order Synchronization',
    'Easily integrate different ecommerce platforms with your helpdesk which can then be later used to swiftly integrate ecommerce order details with your support tickets.' => 'Easily integrate different eCommerce platforms with your helpdesk to show order details within support tickets.',
    'BigCommerce' => 'BigCommerce',
    'No channels have been added.' => 'No channels have been added.',
    'Add BigCommerce Store' => 'Add BigCommerce Store',
    'ADD BIGCOMMERCE STORE' => 'ADD BIGCOMMERCE STORE',
    'Mangento' => 'Mangento',
    'Add Magento Store' => 'Add Magento Store',
    'OpenCart' => 'OpenCart',
    'Add OpenCart Store' => 'Add OpenCart Store',
    'ADD OPENCART STORE' => 'ADD OPENCART STORE',
    'Shopify' => 'Shopify',
    'Add Shopify Store' => 'Add Shopify Store',
    'ADD SHOPIFY STORE' => 'ADD SHOPIFY STORE',
    'Integrate a new BigCommerce store' => 'Integrate a new BigCommerce store',
    'Your BigCommerce Store Name' => 'Your BigCommerce Store Name',
    'Your BigCommerce Store Hash' => 'Your BigCommerce Store Hash',
    'Your BigCommerce Api Token' => 'Your BigCommerce Api Token',
    'Your BigCommerce Api Client ID' => 'Your BigCommerce Api Client ID',
    'Enable Channel' => 'Enable Channel',
    'Add Store' => 'Add Store',
    'ADD STORE' => 'ADD STORE',
    'Integrate a new Magento store' => 'Integrate a new Magento store',
    'Your Magento Api Username' => 'Your Magento Api Username',
    'Your Magento Api Password' => 'Your Magento Api Password',
    'Integrate a new OpenCart store' => 'Integrate a new OpenCart store',
    'Your OpenCart Api Key' => 'Your OpenCart Api Key',
    'Your Shopify Store Name' => 'Your Shopify Store Name',
    'Your Shopify Api Key' => 'Your Shopify Api Key',
    'Your Shopify Api Password' => 'Your Shopify Api Password',
    'Easily embed custom form to help generate helpdesk tickets.' => 'Easily embed custom forms for creating helpdesk tickets.',
    'Form-Builder' => 'Form-Builder',
    'Add Formbuilder' => 'Add Formbuilder',
    'ADD FORMBUILDER' => 'ADD FORMBUILDER',
    'No FormBuilder have been added.' => 'No FormBuilder was added.',
    'Create a New Custom Form Below' => 'Create a New Custom Form Below',
    'Form Name' => 'Form Name',
    'It will be shown in the list of created forms' => 'Displayed in the list of created forms',
    'MANDATORY FIELDS' => 'MANDATORY FIELDS',
    'These fields will be visible in form and cant be edited' => 'These fields will be visible in this form and can\'t be edited',
    'Reply' => 'Reply',
    'OPTIONAL FIELDS' => 'OPTIONAL FIELDS',
    'Select These Fields to Add in your Form' => 'Select fields to add',
    'GDPR' => 'GDPR',
    'Order' => 'Order',
    'Categorybuilder' => 'Categorybuilder',
    'File' => 'File',
    'Add Form' => 'Add Form',
    'ADD FORM' => 'ADD FORM',
    'UPDATE FORM' => 'UPDATE FORM',
    'Update Form' => 'Update Form',
    'Embed' => 'Embed',
    'EMBED' => 'EMBED',
    'EMBED FORMBUILDER' => 'EMBED FORMBUILDER',
    'Embed Formbuilder' => 'Embed Formbuilder',
    'Visit' => 'Visit',
    'VISIT' => 'VISIT',
    'Code' => 'Code',
    'Total Ticket(s)' => 'Total Ticket(s)',
    'Ticket Count' => 'Ticket Count',
    'SwiftMailer Configurations' => 'SwiftMailer Configurations',
    'No swiftmailer configurations found' => 'No SwiftMailer configurations found',
    'CREATE CONFIGURATION' => 'CREATE CONFIGURATION',
    'Add configuration' => 'Add configuration',
    'Update configuration' => 'Update configuration',
    'Mailer ID' => 'Mailer ID',
    'Mailer ID - Leave blank to automatically create id' => 'Mailer ID - Leave blank to automatically create id',
    'Transport Type' => 'Transport Type',
    'SMTP' => 'SMTP',
    'Enable Delivery' => 'Enable Delivery',
    'Server' => 'Server',
    'Port' => 'Port',
    'Encryption Mode' => 'Encryption Mode',
    'ssl' => 'ssl',
    'tsl' => 'tsl',
    'None' => 'None',
    'Authentication Mode' => 'Authentication Mode',
    'login' => 'login',
    'API' => 'API',
    'Plain' => 'Plain',
    'CRAM-MD5' => 'CRAM-MD5',
    'Sender Address' => 'Sender Address',
    'Delivery Address' => 'Delivery Address',
    'Block Spam' => 'Block Spam',
    'Black list' => 'Black list',
    'Comma (,) separated values (Eg. support@example.com, @example.com, 68.98.31.226)' => 'Comma separated values (Eg. support@example.com, @example.com, 68.98.31.226)',
    'White list' => 'White list',
    'Mailbox Settings' => 'Mailbox Settings',
    'No mailbox configurations found' => 'No mailbox configurations found',
    'NEW MAILBOX' => 'NEW MAILBOX',
    'New Mailbox' => 'New Mailbox',
    'Update Mailbox' => 'Update Mailbox',
    'Add Mailbox' => 'Add Mailbox',
    'Mailbox ID - Leave blank to automatically create id' => 'Mailbox ID - Leave blank to automatically create id',
    'Mailbox Name' => 'Mailbox Name',
    'Enable Mailbox' => 'Enable Mailbox',
    'Incoming Mail (IMAP) Server' => 'Incoming Mail (IMAP) Server',
    'Configure your imap settings which will be used to fetch emails from your mailbox.' => 'Configure your imap settings in order to fetch new mail from your inbox.',
    'Transport' => 'Transport',
    'IMAP' => 'IMAP',
    'Gmail' => 'Gmail',
    'Yahoo' => 'Yahoo',
    'Host' => 'Host',
    'IMAP Host' => 'IMAP Host',
    'Email address' => 'Email address',
    'Associated Password' => 'Associated Password',
    'Outgoing Mail (SMTP) Server' => 'Outgoing Mail (SMTP) Server',
    'Select a valid Swift Mailer configuration which will be used to send emails through your mailbox.' => 'Select the SwiftMailer config to use for sending emails through your account.',
    'Swift Mailer ID' => 'Swift Mailer ID',
    'None Selected' => 'None Selected',
    'Create Mailbox' => 'Create Mailbox',
    'CREATE MAILBOX' => 'CREATE MAILBOX',
    'New Template' => 'New Template',
    'NEW TEMPLATE' => 'NEW TEMPLATE',
    'Customer Forgot Password' => 'Customer Forgot Password',
    'Customer Account Created' => 'Customer Account Created',
    'Ticket generated success mail to customer' => 'Ticket successfully generated and sent to customer',
    'Customer Reply To The Agent' => 'Customer reply',
    'Ticket Assign' => 'Ticket Assign',
    'Agent Forgot Password' => 'Agent Forgot Password',
    'Agent Account Created' => 'Agent Account Created',
    'Ticket generated by customer' => 'Ticket generated by customer',
    'Agent Reply To The Customers ticket' => 'Agent reply',
    'Email template name' => 'Email template name',
    'Email template subject' => 'Email template subject',
    'Template For' => 'Template For',
    'Nothing Selected' => 'Nothing Selected',
    'email template will be used for work related with selected option' => 'email template will be used for selected option',
    'Email template body' => 'Email template body',
    'Body' => 'Body',
    'placeholders' => 'placeholders',
    'Ticket Subject' => 'Ticket Subject',
    'Ticket Message' => 'Ticket Message',
    'Ticket Attachments' => 'Ticket Attachments',
    'Ticket Tags' => 'Ticket Tags',
    'Ticket Source' => 'Ticket Source',
    'Ticket Status' => 'Ticket Status',
    'Ticket Priority' => 'Ticket Priority',
    'Ticket Group' => 'Ticket Group',
    'Ticket Team' => 'Ticket Team',
    'Ticket Thread Message' => 'Ticket Thread Message',
    'Ticket Customer Name' => 'Ticket Customer Name',
    'Ticket Customer Email' => 'Ticket Customer Email',
    'Ticket Agent Name' => 'Ticket Agent Name',
    'Ticket Agent Email' => 'Ticket Agent Email',
    'Ticket Agent Link' => 'Ticket Agent Link',
    'Ticket Customer Link' => 'Ticket Customer Link',
    'Last Collaborator Name' => 'Last Collaborator Name',
    'Last Collaborator Email' => 'Last Collaborator Email',
    'Agent/ Customer Name' => 'Agent/ Customer Name',
    'Account Validation Link' => 'Account Validation Link',
    'Password Forgot Link' => 'Password Forgot Link',
    'Company Name' => 'Company Name',
    'Company Logo' => 'Company Logo',
    'Company URL' => 'Company URL',
    'Swiftmailer id (Select from drop down)' => 'Swiftmailer id (Select from drop down)',
    'SwiftMailer' => 'SwiftMailer',
    'PROCEED' => 'PROCEED',
    'Proceed' => 'Proceed',
    'Theme Color' => 'Theme Color',
    'Customer Created' => 'Customer Created',
    'Agent Created' => 'Agent Created',
    'Ticket Created' => 'Ticket Created',
    'Agent Replied on Ticket' => 'Agent replied to ticket',
    'Customer Replied on Ticket' => 'Customer replied to ticket',
    'Workflow Status' => 'Workflow status',
    'Workflow is Active' => 'Workflow is active',
    'Events' => 'Events',
    'An event automatically triggers to check conditions and perform a respective pre-defined set of actions' => 'An event automatically triggers to check conditions and perform a set of pre-defined actions',
    'Select an Event' => 'Select an Event',
    'Add More' => 'Add More',
    'Conditions' => 'Conditions',
    'Conditions are set of rules which checks for specific scenarios and are triggered on specific occasions' => 'Conditions are sets of rules which check for specific scenarios.',
    'Subject or Description' => 'Subject or description',
    'Actions' => 'Actions',
    'An action not only reduces the workload but also makes it quite easier for ticket automation' => 'Actions help you automate tickets',
    'Select an Action' => 'Select an action',
    'Add Note' => 'Add note',
    'Mail to agent' => 'Mail to agent',
    'Mail to customer' => 'Mail to customer',
    'Mail to group' => 'Mail to group',
    'Mail to last collaborator' => 'Mail to last collaborator',
    'Mail to team' => 'Mail to team',
    'Mark Spam' => 'Mark spam',
    'Assign to agent' => 'Assign to agent',
    'Assign to group' => 'Assign to group',
    'Set Priority As' => 'Set Priority As',
    'Set Status As' => 'Set Status As',
    'Set Tag As' => 'Set Tag As',
    'Set Label As' => 'Set Label As',
    'Assign to team' => 'Assign to team',
    'Set Type As' => 'Set Type As',
    'Add Workflow' => 'Add Workflow',
    'ADD WORKFLOW' => 'ADD WORKFLOW',
    'Ticket Type code' => 'Ticket Type code',
    'Ticket Type description' => 'Ticket Type description',
    'Type Status' => 'Type Status',
    'Type is Active' => 'Type is Active',
    'Add Save Reply' => 'Add Save Reply',
    'Saved reply name' => 'Saved reply name',
    'Share saved reply with user(s) in these group(s)' => 'Share saved reply with user(s) in these group(s)',
    'Share saved reply with user(s) in these teams(s)' => 'Share saved reply with user(s) in these teams(s)',
    'Saved reply Body' => 'Saved reply body',
    'New Prepared Response' => 'New Prepared Response',
    'Prepared Response Status' => 'Prepared Response Status',
    'Prepared Response is Active' => 'Prepared Response is Active',
    'Share prepared response with user(s) in these group(s)' => 'Share prepared response with user(s) in these group(s)',
    'Share prepared response with user(s) in these teams(s)' => 'Share prepared response with user(s) in these teams(s)',
    'ADD PREPARED RESPONSE' => 'ADD PREPARED RESPONSE',
    'Add Prepared Response' => 'Add Prepared Response',
    'Folder Name is shown upfront at Knowledge Base' => 'The folder name to show in the knowledge base',
    'A small text about the folder helps user to navigate more easily' => 'A bit more info about this folder',
    'Publish' => 'Publish',
    'Choose appropriate status' => 'Choose appropriate status',
    'Folder Image' => 'Folder Image',
    'An image is worth a thousands words and makes folder more accessible' => 'Help users identify the proper folder with a recognizable image.',
    'Add Category' => 'Add Category',
    'Category Name is shown upfront at Knowledge Base' => 'The category name to show in the knowledge base',
    'A small text about the category helps user to navigate more easily' => 'A bit more info about this category',
    'Using Category Order, you can decide which category should display first' => 'Using Category Order, you can decide which category should display first',
    'Sorting' => 'Sorting',
    'Ascending Order (A-Z)' => 'Ascending Order (A-Z)',
    'Descending Order (Z-A)' => 'Descending Order (Z-A)',
    'Based on Popularity' => 'Based on Popularity',
    'Article of this category will display according to selected option' => 'Articles in this category will display depending on selected option',
    'Article' => 'Article',
    'Title' => 'Title',
    'View' => 'View',
    'Make as Starred' => 'Mark as Starred',
    'Yes' => 'Yes',
    'No' => 'No',
    'Stared' => 'Stared',
    'Revisions' => 'Revisions',
    'Related Articles' => 'Related Articles',
    'Delete Article' => 'Delete Article',
    'Content' => 'Content',
    'Slug' => 'Slug',
    'Slug is the url identity of this article.' => 'The URL for this article',
    'Meta Title' => 'Meta Title',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. The title tag and meta description are usually shown in search engine results for the page.',
    'Meta Keywords' => 'Meta Keywords',
    'Meta Description' => 'Meta Description',
    'Description' => 'Description',
    'Team Status' => 'Team Status',
    'Team is Active' => 'Team is Active',
    'Edit Privilege' => 'Edit Privilege',
    'Can create ticket' => 'Can create ticket',
    'Can edit ticket' => 'Can edit ticket',
    'Can delete ticket' => 'Can delete ticket',
    'Can restore trashed ticket' => 'Can restore trashed ticket',
    'Can assign ticket' => 'Can assign ticket',
    'Can assign ticket group' => 'Can assign ticket group',
    'Can update ticket status' => 'Can update ticket status',
    'Can update ticket priority' => 'Can update ticket priority',
    'Can update ticket type' => 'Can update ticket type',
    'Can add internal notes to ticket' => 'Can add internal notes to ticket',
    'Can edit thread/notes' => 'Can edit thread/notes',
    'Can lock/unlock thread' => 'Can lock/unlock thread',
    'Can add collaborator to ticket' => 'Can add collaborator to ticket',
    'Can delete collaborator from ticket' => 'Can delete collaborator from ticket',
    'Can delete thread/notes' => 'Can delete thread/notes',
    'Can apply prepared response on ticket' => 'Can apply prepared response on ticket',
    'Can add ticket tags' => 'Can add ticket tags',
    'Can delete ticket tags' => 'Can delete ticket tags',
    'Can kick other ticket users' => 'Can kick other ticket users',
    'Can manage email templates' => 'Can manage email templates',
    'Can manage groups' => 'Can manage groups',
    'Can manage Sub-Groups/ Teams' => 'Can manage Sub-Groups/ Teams',
    'Can manage agents' => 'Can manage agents',
    'Can manage agent privileges' => 'Can manage agent privileges',
    'Can manage ticket types' => 'Can manage ticket types',
    'Can manage ticket custom fields' => 'Can manage ticket custom fields',
    'Can manage customers' => 'Can manage customers',
    'Can manage Prepared Responses' => 'Can manage Prepared Responses',
    'Can manage Automatic workflow' => 'Can manage Automatic workflow',
    'Can manage tags' => 'Can manage tags',
    'Can manage knowledgebase' => 'Can manage knowledgebase',
    'Can manage Groups Saved Reply' => 'Can manage Groups Saved Reply',
    'Add Privilege' => 'Add Privilege',
    'Choose set of privileges which will be available to the agent.' => 'Choose set of privileges which will be available to the agent.',
    'Advanced' => 'Advanced',
    'Privilege Name must have characters only' => 'Privilege Name must have characters only',
    'Maximum character length is 50' => 'Maximum character length is 50',
    'Open Tickets' => 'Open Tickets',
    'New Customer' => 'New Customer',
    'New Agent' => 'New Agent',
    'Total Article(s)' => 'Total Article(s)',
    'Please specify a valid email address' => 'Please specify a valid email address',
    'Please enter the password associated with your email address' => 'Please enter the password associated with your email address',
    'Please enter your server host address' => 'Please enter your server host address',
    'Please specify a port number to connect with your mail server' => 'Please specify the port number for your mail server',
    'Success ! Branding details saved successfully.' => 'Success! Branding details saved successfully.',
    'Success ! Time details saved successfully.' => 'Success! Time details saved successfully.',
    'Spam setting saved successfully.' => 'Spam setting saved successfully.',
    'Please specify a valid name for your mailbox.' => 'Please specify a valid name for your mailbox.',
    'Please select a valid swift-mailer configuration.' => 'Please select a valid swift-mailer configuration.',
    'Please specify a valid host address.' => 'Please specify a valid host address.',
    'Please specify a valid email address.' => 'Please specify a valid email address.',
    'Please enter the associated account password.' => 'Please enter the associated account password.',
    'New Saved Reply' => 'New Saved Reply',
    'New Category' => 'New Category',
    'Folder' => 'Folder',
    'Category' => 'Category',
    'Created' => 'Created',
    'All Articles' => 'All Articles',
    'Viewed' => 'Viewed',
    'New Article' => 'New Article',
    'Thank you for your feedback!' => 'Thank you for your feedback!',
    'Was this article helpful?' => 'Was this article helpful?',
    'Helpdesk' => 'Helpdesk',
    'Support Center' => 'Support Center',
    'Mailboxes' => 'Mailboxes',
    'By' => 'By',
    'Search Tickets' => 'Search Tickets',
    'Customer Information' => 'Customer Information',
    'Total Replies' => 'Total Replies',
    'Filter With' => 'Filter With',
    'Type email to add' => 'Type email to add',
    'Collaborators' => 'Collaborators',
    'Labels' => 'Labels',
    'Group' => 'Group',
    'group' => 'group',
    'Contact Team' => 'Contact Team',
    'Stay on ticket' => 'Stay on ticket',
    'Redirect to list' => 'Redirect to list',
    'Nothing interesting here...' => 'Nothing interesting here',
    'Previous Ticket' => 'Previous Ticket',
    'Next Ticket' => 'Next Ticket',
    'Forward' => 'Forward',
    'Note' => 'Note',
    'Write a reply' => 'Write a reply',
    'Created Ticket' => 'Created Ticket',
    'All Threads' => 'All Threads',
    'Forwards' => 'Forwards',
    'Notes' => 'Notes',
    'Pinned' => 'Pinned',
    'Edit Ticket' => 'Edit Ticket',
    'Print Ticket' => 'Print Ticket',
    'Mark as Spam' => 'Mark as Spam',
    'Mark as Closed' => 'Mark as Closed',
    'Delete Ticket' => 'Delete Ticket',
    'View order details from different eCommerce channels' => 'View order details from different eCommerce channels',
    'ECOMMERCE CHANNELS' => 'ECOMMERCE CHANNELS',
    'Select channel' => 'Select channel',
    'Order Id' => 'Order Id',
    'Fetch Order' => 'Fetch Order',
    'No orders have been integrated to this ticket yet.' => 'No orders have been associated with this ticket yet.',
    'Enter your credentials below to gain access to your helpdesk account.' => 'Enter your credentials below to sign in',
    'Keep me logged in' => 'Keep me logged in',
    'Forgot Password?' => 'Forgot Password?',
    'Log in to your' => 'Log in to your',
    'Sign In' => 'Sign In',
    'Edit Customer' => 'Edit Customer',
    'Update' => 'Update',
    'Discard' => 'Discard',
    'Cancel' => 'Cancel',
    'Not Assigned' => 'Not Assigned',
    'Submit' => 'Submit',
    'Submit And Open' => 'Submit And Open',
    'Submit And Pending' => 'Submit And Pending',
    'Submit And Answered' => 'Submit And Answered',
    'Submit And Resolved' => 'Submit And Resolved',
    'Submit And Closed' => 'Submit And Closed',
    'Choose a Color' => 'Choose a Color',
    'Create' => 'Create',
    'Edit Label' => 'Edit Label',
    'Add Label' => 'Add Label',
    'To' => 'To',
    'Ticket' => 'Ticket',
    'Your browser does not support JavaScript or You disabled JavaScript, Please enable those !' => 'Your browser does not support Javascript or Javascript is disabled. Please correct this!',
    'Confirm Action' => 'Confirm Action',
    'Confirm' => 'Confirm',
    'No result found' => 'No result found',
    'ticket delivery status' => 'ticket delivery status',
    'Warning! Select valid image file.' => 'Warning! Select valid image file.',
    'Error' => 'Error',
    'Save' => 'Save',
    'SEO' => 'SEO',
    'Edit Saved Filter' => 'Edit Saved Filter',
    'Type atleast 2 letters' => 'Type at least 2 letters',
    'Remove Label' => 'Remove Label',
    'New Saved Filter' => 'New Saved Filter',
    'Is Default' => 'Is Default',
    'Remove Saved Filter' => 'Remove Saved Filter',
    'Ticket Info' => 'Ticket Info',
    'Last Replied Agent' => 'Last Replied Agent',
    'created Ticket' => 'created Ticket',
    'Uploaded Files' => 'Uploaded Files',
    'Download (as .zip)' => 'Download ( as .zip)',
    'made last reply' => 'last reply',
    'N/A' => 'N/A',
    'Unassigned' => 'Unassigned',
    'Label' => 'Label',
    'Assigned to me' => 'Assigned to me',
    'Search Query' => 'Search Query',
    'Searching' => 'Searching',
    'Saved Filter' => 'Saved Filter',
    'No Label Created' => 'No Label Created',
    'Label with same name already exist.' => 'Label with same name already exists',
    'Create New' => 'Create New',
    'Mail status' => 'Mail status',
    'replied' => 'replied',
    'added note' => 'added note',
    'forwarded' => 'forwarded',
    'TO' => 'TO',
    'CC' => 'CC',
    'BCC' => 'BCC',
    'Locked' => 'Locked',
    'Edit Thread' => 'Edit Thread',
    'Delete Thread' => 'Delete Thread',
    'Unpin Thread' => 'Unpin Thread',
    'Pin Thread' => 'Pin Thread',
    'Unlock Thread' => 'Unlock Thread',
    'Lock Thread' => 'Lock Thread',
    'Translate Thread' => 'Translate Thread',
    'Language' => 'Language',
    'English' => 'English',
    'French' => 'French',
    'Italian' => 'Italian',
    'Arabic' => 'Arabic',
    'German' => 'German',
    'Spanish' => 'Spanish',
    'Turkish' => 'Turkish',
    'Danish' => 'Danish',
    'Chinese' => 'Chinese',
    'Polish' => 'Polish',
    'Hebrew' => 'Hebrew',
    'Portuguese' => 'Portuguese',
    'System' => 'System',
    'Open in Files' => 'Open in Files',
    'Email address is invalid' => 'Email address is invalid',
    'Tag with same name already exist' => 'Tag with this name already exist',
    'Text length should be less than 20 charactors' => 'Must be less than 20 characters',
    'Label with same name already exist' => 'Label with same name already exist',
    'Agent Name' => 'Agent Name',
    'Agent Email' => 'Agent Email',
    'open' => 'open',
    'Currently active agents on ticket' => 'Currently active agents on ticket',
    'Edit Customer Information' => 'Edit Customer Information',
    'Restore' => 'Restore',
    'Delete Forever' => 'Delete Forever',
    'Add Team' => 'Add Team',
    'delete' => 'delete',
    'You didnt have any folder for current filter(s).' => 'No folders match current filter(s).',
    'Add Folder' => 'Add Folder',
    'This field must have valid characters only' => 'This field must have valid characters only',
    'Can edit task' => 'Can edit task',
    'Can create task' => 'Can create task',
    'Can delete task' => 'Can delete task',
    'Can add member to task' => 'Can add member to task',
    'Can remove member from task' => 'Can remove member from task',
    'Agent Privileges' => 'Agent Privileges',
    'Agent Privilege represents overall permissions in System.' => 'Agent privilege represents overall permissions in your helpdesk.',
    'Ticket View' => 'Ticket View',
    'User can view tickets based on selected scope.' => 'User can view tickets based on selected scope.',
    'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) he belongs to and so on' => 'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) they belongs to, etc.',
    'Global Access' => 'Global Access',
    'Group Access' => 'Group Access',
    'Team Access' => 'Team Access',
    'Individual Access' => 'Individual Access',
    'This field must have characters only' => 'This field must have characters only',
    'Maximum character length is 40' => 'Maximum character length is 40',
    'This is not a valid email address' => 'This is not a valid email address',
    'Password must contains 8 Characters' => 'Password must contains 8 Characters',
    'The passwords does not match' => 'The passwords do not match',
    'Enabled' => 'Enabled',
    'Create Configuration' => 'Create Configuration',
    'Swift Mailer Settings' => 'Swift Mailer Settings',
    'Username' => 'Username',
    'Please select a swiftmailer id' => 'Please select a swiftmailer id',
    'Please enter a valid e-mail id' => 'Please enter a valid e-mail id',
    'Please enter a mailer id' => 'Please enter a mailer id',
    'Email Id' => 'Email Id',
    'Are you sure? You want to perform this action.' => 'Are you sure you want to perform this action?',
    'Reorder' => 'Reorder',
    'New Workflow' => 'New Workflow',
    'OR' => 'OR',
    'AND' => 'AND',
    'Please enter a valid name.' => 'Please enter a valid name.',
    'Please select a value.' => 'Please select a value.',
    'Please add a value.' => 'Please add a value.',
    'This field is required' => 'This field is required',
    'or' => 'or',
    'and' => 'and',
    'Select a Condition' => 'Select a Condition',
    'Loading...' => 'Loading...',
    'Select Option' => 'Select Option',
    'Inactive' => 'Inactive',
    'New Type' => 'New Type',
    'Placeholders' => 'Placeholders',
    'Ticket Link' => 'Ticket Link',
    'Id' => 'Id',
    'Preview' => 'Preview',
    'Sort Order' => 'Sort Order',
    'This field must be a number' => 'This field must be a number',
    'User' => 'User',
    'Edit Group' => 'Edit Group',
    'Group Status' => 'Group Status',
    'Group is Active' => 'Group is Active',
    'Add Group' => 'Add Group',
    'Contact number is invalid' => 'Contact number is invalid',
    'Edit Agent' => 'Edit Agent',
    'No Privilege added, Please add Privilege(s) first !' => 'No privilege added, please add privilege(s) first!',
    'Edit Email Template' => 'Edit Email Template',
    'Edit Workflow' => 'Edit Workflow',
    'Save Workflow' => 'Save Workflow',
    'Edit Ticket Type' => 'Edit Ticket Type',
    'Add Ticket Type' => 'Add Ticket Type',
    'Date Released' => '	Date Released',
    'Free' => 'Free',
    'Premium' => 'Premium',
    'Installed' => 'Installed',
    'Installed Applications' => 'Installed Applications',
    'Apps Dashboard' => 'Apps Dashboard',
    'Dashboard' => 'Dashboard',
    'Nothing Interesting here' => 'Nothing interesting here',
    'No Categories Added' => 'No Categories Added',
    'Error : Something went wrong, please try again later' => 'Error: Something went wrong, please try again later',
    'ticket' => 'ticket',
    'Add Email Template' => 'Add Email Template',
    'This field contain 100 characters only' => 'Max 100 characters',
    'This field contain characters only' => 'This field may contain characters only',
    'Name length must not be greater than 200 !!' => 'Name length must not be greater than 200!',
    'Warning! Correct all field values first!' => 'Warning! Correct all field values first!',
    'Warning ! This is not a valid request' => 'Warning! This is not a valid request',
    'Success ! Tag removed successfully.' => 'Success! Tag removed successfully.',
    'Success ! Tags Saved successfully.' => 'Success! Tags Saved successfully.',
    'Success ! Revision restored successfully.' => 'Success! Revision restored successfully.',
    'Success ! Categories updated successfully.' => 'Success! Categories updated successfully.',
    'Success ! Article Related removed successfully.' => 'Success! Related article removed successfully.',
    'Success ! Article Related is already added.' => 'Success! Related article added.',
    'Success ! Cannot add self as relative article.' => 'Success! Cannot add self as relative article.',
    'Success ! Article Related updated successfully.' => 'Success! Related article updated successfully.',
    'Success ! Articles removed successfully.' => 'Success! Articles removed successfully.',
    'Success ! Article status updated successfully.' => 'Success! Article status updated successfully.',
    'Success ! Article star updated successfully.' => 'Success! Article star updated successfully.',
    'Success! Article updated successfully' => 'Success! Article updated successfully',
    'Success ! Category sort  order updated successfully.' => 'Success! Category sort order updated successfully.',
    'Success ! Category status updated successfully.' => 'Success! Category status updated successfully.',
    'Success ! Folders updated successfully.' => 'Success! Folders updated successfully.',
    'Success ! Categories removed successfully.' => 'Success! Categories removed successfully.',
    'Success ! Category updated successfully.' => 'Success! Category updated successfully.',
    'Error ! Category is not exist.' => 'Error! Category does not exist.',
    'Warning ! Customer Login disabled by admin.' => 'Warning! Customer Login disabled by admin.',
    'This Email is not registered with us.' => 'This email is not registered with us.',
    'Your password has been updated successfully.' => 'Your password has been updated successfully.',
    'Password dont match.' => 'Password doesn\'t match.',
    'Error ! Profile image is not valid, please upload a valid format' => 'Error! Profile image is not valid, please upload a valid format',
    'Warning! Provide valid image file. (Recommened": "PNG, JPG or GIF Format).' => 'Warning! invalid image file. (Recommened": "PNG, JPG or GIF Format).',
    'Success! Folder has been added successfully.' => 'Success! Folder has been added successfully.',
    'Folder updated successfully.' => 'Folder updated successfully.',
    'Success ! Folder status updated successfully.' => 'Success! Folder status updated successfully.',
    'Error ! Folder is not exist.' => 'Error! Folder does not exist.',
    'Success ! Folder updated successfully.' => 'Success! Folder updated successfully.',
    'Error ! Folder does not exist.' => 'Error! Folder does not exist.',
    'Success ! Folder deleted successfully.' => 'Success! Folder deleted successfully.',
    'Warning ! Folder doesnt exists!' => 'Warning! Folder doesn\'t exists!',
    'Warning ! Cannot create ticket, given email is blocked by admin.' => 'Warning! Can\'t create ticket, given email is blocked by admin.',
    'Success ! Ticket has been created successfully.' => 'Success! Ticket has been created successfully.',
    'Warning ! Can not create ticket, invalid details.' => 'Warning! Can not create ticket, invalid details.',
    'Warning ! Post size can not exceed 25MB' => 'Warning! attachmment size can not exceed 25MB',
    'Create Ticket Request' => 'Create Ticket Request',
    'Success ! Reply added successfully.' => 'Success! Reply added successfully.',
    'Warning ! Reply field can not be blank.' => 'Warning! Reply field can not be blank.',
    'Success ! Rating has been successfully added.' => 'Success! Rating has been successfully added.',
    'Warning ! Invalid rating.' => 'Warning! Invalid rating.',
    'Error ! Can not add customer as a collaborator.' => 'Error! Can not add customer as a collaborator.',
    'Success ! Collaborator added successfully.' => 'Success! Collaborator added successfully.',
    'Error ! Collaborator is already added.' => 'Error! Collaborator is already added.',
    'Success ! Collaborator removed successfully.' => 'Success! Collaborator removed successfully.',
    'Error ! Invalid Collaborator.' => 'Error! Invalid Collaborator.',
    'An unexpected error occurred. Please try again later.' => 'An unexpected error occurred. Please try again later.',
    'Feedback saved successfully.' => 'Feedback saved successfully.',
    'Feedback updated successfully.' => 'Feedback updated successfully.',
    'Invalid feedback provided.' => 'Invalid feedback provided.',
    'Article not found.' => 'Article not found.',
    'You need to login to your account before can perform this action.' => 'You need to log in to your account before can perform this action.',
    'Warning! Please add valid Actions!' => 'Warning! Please add valid actions!',
    'Warning! In Free Plan you can not change Events!' => 'Warning! In free plan you can not change events!',
    'Success! Prepared Response has been updated successfully.' => 'Success! Prepared response has been updated successfully.',
    'Success! Prepared Response has been added successfully.' => 'Success! Prepared response has been added successfully.',
    'Warning  This is not a valid request' => 'Warning! This is not a valid request',
    'Use Default Colors' => 'Use Default Colors',
    'Masonry' => 'Masonry',
    'Popular Article' => 'Popular Article',
    'Manage Ticket Custom Fields' => 'Manage Ticket Custom Fields',
    'Mail status:' => 'Mail status:',
    'You dont have premission to edit this Prepared response' => 'You don\'t have premission to edit this prepared response',
    'Save Prepared Response' => 'Save prepared response',
    'Success ! Prepared response removed successfully.' => 'Success! Prepared response removed successfully.',
    'Warning! You are not allowed to perform this action.' => 'Warning! You are not allowed to perform this action.',
    'Success! Workflow has been updated successfully.' => 'Success! Workflow has been updated successfully.',
    'Success! Workflow has been added successfully.' => 'Success! Workflow has been added successfully.',
    'Success! Order has been updated successfully.' => 'Success! Order has been updated successfully.',
    'Success! Workflow has been removed successfully.' => 'Success! Workflow has been removed successfully.',
    'Mailbox successfully created.' => 'Mailbox successfully created.',
    'Mailbox successfully updated.' => 'Mailbox successfully updated.',
    'Warning ! Bad request !' => 'Warning! Bad request!',
    'Error! Given current password is incorrect.' => 'Error! Password is incorrect.',
    'Success ! Profile update successfully.' => 'Success! Profile update successfully.',
    'Error ! User with same email is already exist.' => 'Error! User with same email already exists.',
    'Success ! Agent updated successfully.' => 'Success! Agent updated successfully.',
    'Success ! Agent removed successfully.' => 'Success! Agent removed successfully.',
    'Warning ! You are allowed to remove account owners account.' => 'Warning! You are allowed to remove this account.',
    'Error ! Invalid user id.' => 'Error! Invalid user id.',
    'Success ! Filter has been saved successfully.' => 'Success! Filter has been saved successfully.',
    'Success ! Filter has been updated successfully.' => 'Success! Filter has been updated successfully.',
    'Success ! Filter has been removed successfully.' => 'Success! Filter has been removed successfully.',
    'Please check your mail for password update.' => 'Please check your inbox for a new password.',
    'This Email address is not registered with us.' => 'This email address is not registered with us.',
    'Success ! Customer saved successfully.' => 'Success! Customer saved successfully.',
    'Error ! User with same email already exist.' => 'Error! User with same email already exists.',
    'Success ! Customer information updated successfully.' => 'Success! Customer information updated successfully.',
    'Success ! Customer updated successfully.' => 'Success! Customer updated successfully.',
    'Error ! Customer with same email already exist.' => 'Error! Customer with same email already exists.',
    'unstarred Action Completed successfully' => 'unstarred action completed successfully',
    'starred Action Completed successfully' => 'starred action completed successfully',
    'Success ! Customer removed successfully.' => 'Success! Customer removed successfully.',
    'Error ! Invalid customer id.' => 'Error! Invalid customer id.',
    'Success! Template has been updated successfully.' => 'Success! Template has been updated successfully.',
    'Success! Template has been added successfully.' => 'Success! Template has been added successfully.',
    'Success! Template has been deleted successfully.' => 'Success! Template has been deleted successfully.',
    'Warning! resource not found.' => 'Warning! resource not found.',
    'Warning! You can not remove predefined email template which is being used in workflow(s).' => 'Warning! You can not remove an email template which is being used in workflow(s).',
    'Success ! Email settings are updated successfully.' => 'Success! Email settings successfully updated.',
    'Success ! Group information updated successfully.' => 'Success! Group information updated successfully.',
    'Success ! Group information saved successfully.' => 'Success! Group information saved successfully.',
    'Support Group removed successfully.' => 'Support Group removed successfully.',
    'Success ! Privilege information saved successfully.' => 'Success! Privilege information saved successfully.',
    'Privilege updated successfully.' => 'Privilege updated successfully.',
    'Support Privilege removed successfully.' => 'Support privilege removed successfully.',
    'Success! Reply has been updated successfully.' => 'Success! Reply has been updated successfully.',
    'Success! Reply has been added successfully.' => 'Success! Reply has been added successfully.',
    'Success! Saved Reply has been deleted successfully' => 'Success! Saved Reply has been deleted successfully',
    'SwiftMailer configuration updated successfully.' => 'SwiftMailer configuration updated successfully.',
    'Swiftmailer configuration removed successfully.' => 'Swiftmailer configuration removed successfully.',
    'Success ! Team information saved successfully.' => 'Success! Team information saved successfully.',
    'Success ! Team information updated successfully.' => 'Success! Team information updated successfully.',
    'Support Team removed successfully.' => 'Support Team removed successfully.',
    'Success! Reply has been added successfully' => 'Success! Reply has been added successfully',
    'Success ! Thread updated successfully.' => 'Success! Thread updated successfully.',
    'Error ! Reply field can not be blank.' => 'Error  Reply field can not be blank.',
    'Success ! Thread removed successfully.' => 'Success! Thread removed successfully.',
    'Success ! Thread locked successfully' => 'Success! Thread locked successfully',
    'Success ! Thread unlocked successfully' => 'Success! Thread unlocked successfully',
    'Success ! Thread pinned successfully' => 'Success! Thread unpinned successfully',
    'Error ! Invalid thread.' => 'Error! Invalid thread.',
    'Could not create ticket, invalid details.' => 'Could not create ticket, invalid details.',
    'Success ! Tag updated successfully.' => 'Success! Tag updated successfully.',
    'Error ! Customer can not be added as collaborator.' => 'Error! Customer can not be added as collaborator.',
    'Success ! Tag unassigned successfully.' => 'Success! Tag unassigned successfully.',
    'Success ! Tag added successfully.' => 'Success! Tag added successfully.',
    'Please enter tag name.' => 'Please enter tag name.',
    'Error ! Invalid tag.' => 'Error! Invalid tag.',
    'Success ! Type removed successfully.' => 'Success! Type removed successfully.',
    'Success ! Ticket to label removed successfully.' => 'Success! Ticket label removed successfully.',
    'Unable to retrieve support team details' => 'Unable to retrieve support team details',
    'Ticket support group updated successfully' => 'Ticket support group updated successfully',
    'Unable to retrieve status details' => 'Unable to retrieve status details',
    'Insufficient details provided.' => 'Insufficient details provided.',
    'Error! Subject field is mandatory' => 'Error! Subject field is mandatory',
    'Error! Reply field is mandatory' => 'Error! Reply field is mandatory',
    'Success ! Ticket has been updated successfully.' => 'Success! Ticket has been updated successfully.',
    'Success ! Label updated successfully.' => 'Success! Label updated successfully.',
    'Error ! Invalid label id.' => 'Error! Invalid label id.',
    'Success ! Label removed successfully.' => 'Success! Label removed successfully.',
    'Success ! Label created successfully.' => 'Success! Label created successfully.',
    'Error ! Label name can not be blank.' => 'Error! Label name can not be blank.',
    'Success ! Ticket moved to trash successfully.' => 'Success! Ticket moved to trash successfully.',
    'Success! Ticket type saved successfully.' => 'Success! Ticket type saved successfully.',
    'Success! Ticket type updated successfully.' => 'Success! Ticket type updated successfully.',
    'Error! Ticket type with same name already exist' => 'Error! Ticket type with same name already exist',
    'SAVE' => 'SAVE',
    'Ticket is already assigned to agent' => 'Ticket is already assigned to agent',
    'Success ! Agent assigned successfully.' => 'Success ! Agent assigned successfully.',
    'Ticket status is already set' => 'Ticket status is already set',
    'Success ! Tickets status updated successfully.' => 'Success ! Tickets status updated successfully.',
    'Ticket priority is already set' => 'Ticket priority is already set',
    'Success ! Tickets priority updated successfully.' => 'Success ! Tickets priority updated successfully.',
    'Ticket group is updated successfully' => 'Ticket group is updated successfully',
    'Ticket is already assigned to group' => 'Ticket is already assigned to group',
    'Success ! Tickets group updated successfully.' => 'Success ! Tickets group updated successfully.',
    'Ticket team is updated successfully' => 'Ticket team is updated successfully',
    'Ticket is already assigned to team' => 'Ticket is already assigned to team',
    'Success ! Tickets team updated successfully.' => 'Success ! Tickets team updated successfully.',
    'Ticket type is already set' => 'Ticket type is already set',
    'Success ! Tickets type updated successfully.' => 'Success ! Tickets type updated successfully.',
    'Success ! Tickets label updated successfully.' => 'Success ! Tickets label updated successfully.',
    'Success ! Tickets added to label successfully.' => 'Success ! Tickets added to label successfully.',
    'Success ! Tickets moved to trashed successfully.' => 'Success ! Tickets moved to trashed successfully.',
    'Success ! Tickets removed successfully.' => 'Success ! Tickets removed successfully.',
    'Success ! Tickets restored successfully.' => 'Success ! Tickets restored successfully.',
    'Unable to retrieve group details' => 'Unable to retrieve group details',
    'Unable to retrieve team details' => 'Unable to retrieve team details',
    'Tickets details have been updated successfully' => 'Tickets details have been updated successfully',
    'Label added to ticket successfully' => 'Label added to ticket successfully',
    'Label already added to ticket' => 'Label already added to ticket',
    'Howdy!' => 'Howdy!',
    'New Ticket Request' => 'New Ticket Request',
    'Ticket Requests' => 'Ticket Requests',
    'Tickets have been updated successfully' => 'Tickets have been updated successfully',
    'Please check your mail for password update' => 'Please check your inbox for a new password',
    'This email address is not registered with us' => 'This email address is not registered with us',
    'You have already update password using this link if you wish to change password again click on forget password link here from login page' => 'You have already updated your password using this link. If you wish to change your password again click on the forget password link on the login page.',
    'Your password has been successfully updated. Login using updated password' => 'Your password has been successfully updated. Please log in using your new password.',
    'Please try again, The passwords do not match' => 'Please try again, The passwords do not match',
    'Support Privilege removed successfully' => 'Support Privilege removed successfully',
    'Success! Saved Reply has been deleted successfully.' => 'Success! Saved Reply has been deleted successfully.',
    'SwiftMailer configuration created successfully.' => 'SwiftMailer configuration created successfully.',
    'No swiftmailer configurations found for mailer id:' => 'No swiftmailer configurations found for mailer id:',
    'Reply content cannot be left blank.' => 'Reply content cannot be left blank.',
    'Reply added to the ticket and forwarded successfully.' => 'Reply added to the ticket and forwarded successfully.',
    'Success ! Thread pinned successfully.' => 'Success! Thread pinned successfully.',
    'Success ! unpinned removed successfully.' => 'Success! Thread unpinned successfully.',
    'Unable to retrieve priority details' => 'Unable to retrieve priority details',
    'Ticket support team updated successfully' => 'Ticket support team updated successfully',
    'Ticket assigned to support group ' => 'Ticket assigned to support group ',
    'Mailbox configuration removed successfully.' => 'Mailbox configuration removed successfully.',
    'visit our website' => 'visit our website',
    'Cookie Usage Policy' => 'Cookie Usage Policy',
    'cookie' => 'cookie',
    'cookies' => 'cookies',
    'HELP' => 'HELP',
    'Home' => 'Home',
    'Cookie Policy' => 'Cookie Policy',
    'Prev' => 'Prev',
    'Ticket query message' => 'Ticket content',
    'Select type' => 'Select type',
    'Search KnowledgeBase' => 'Search KnowledgeBase',
    'You cant merge an account with itself.' => 'You can\'t merge an account with itself.',
    'Edit Profile' => 'Edit Profile',
    'Customer Login' => 'Customer Login',
    'Contact Us' => 'Contact Us',
    'If you have ever contacted our support previously, your account would have already been created.' => 'If you have ever contacted us previously, your account is more than likely already created.',
    'support' => 'support',
    'HelpDesk' => 'HelpDesk',
    'Enter search keyword' => 'Enter search keyword',
    'Browse via Folders' => 'Explore the knowledge base',
    'Looking for something that is queried generally? Choose a relevant folder from below to explore possible solutions' => 'Check out our knowledge base to see if your question has already been answered.',
    'Unable to find an answer?' => 'Contact Our Team',
    'Looking for anything specific article which resides in general queries? Just browse the various relevant folders and categories and then you will find the desired article.' => 'If you still can\'t find an answer to what you\'re looking for, or you have a specific question, open a new ticket and we\'d be happy to help!',
    'Popular Articles' => 'Popular Articles',
    'Here are some of the most popular articles, which helped number of users to get their queries and questions resolved.' => 'Some of the more popular articles in our knowledge base that have helped other customers.',
    'Browse via Categories' => 'Browse via Categories',
    'Looking for something specific? Choose a relevant category from below to explore possible solutions' => 'Choose a category from the list below to view articles.',
    'No Categories Found!' => 'No Categories Found!',
    'Powered by' => 'Powered by',
    'Powered by %uvdesk%, an open-source project by %webkul%.' => 'Powered by %uvdesk%, an open-source project by %webkul%.',
    'Forgot Password' => 'Forgot Password',
    'Enter your email address and we will send you an email with instructions to update your login credentials.' => 'Enter your email address and we will send you a message to update your login credentials.',
    'Send Mail' => 'Send Mail',
    'Sign In to %websitename%' => 'Sign In to %websitename%',
    'Enter your name' => 'Enter your name',
    'Enter your email' => 'Enter your email',
    'Learn more about %deliveryStatus%.' => 'Learn more about %deliveryStatus%.',
    'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.' => 'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.',
    'To know more about how our privacy policy works, please %websiteLink%.' => 'To know more about our privacy policy, please visit %websiteLink%.',
    'This field contain maximum 40 charectures.' => 'This field contain maximum 40 charectures.',
    'This field contain maximum 50 charectures.' => 'This field contain maximum 50 charectures.',
    'Time' => 'Time',
    'Links' => 'Links',
    'Broadcast Message' => 'Broadcast Message',
    'Wide Logo' => 'Wide Logo',
    'Upload an Image (200px x 48px) in</br> PNG or JPG Format' => 'Upload an Image (200px x 48px) in</br> PNG or JPG Format',
    'It will be shown as Logo on Knowledgebase and Helpdesk' => 'Your knowledge base / helpdesk logo',
    'Website Status' => 'Website Status',
    'Enable front end website and knowledgebase for customer(s)' => 'Enable front end website and knowledgebase for customer(s)',
    'Brand Color' => 'Brand Color',
    'Page Background Color' => 'Page Background Color',
    'Header Background Color' => 'Header Background Color',
    'Banner Background Color' => 'Banner Background Color',
    'Page Link Color' => 'Page Link Color',
    'Page Link Hover Color' => 'Page Link Hover Color',
    'Article Text Color' => 'Article Text Color',
    'Tag Line' => 'Tag Line',
    'Hi! how can we help?' => 'Hi! how can we help?',
    'Layout' => 'Layout',
    'Ticket Create Option' => 'Ticket Create Option',
    'Login Required To Create Tickets' => 'Login required To create tickets',
    'Remove Customer Login/Signin Button' => 'Remove customer log in / sign in button',
    'Disable Customer Login' => 'Disable Customer Login',
    'Meta Description (Recommended)' => 'Meta Description (Recommended)',
    'Meta Keywords (Recommended)' => 'Meta Keywords (Recommended)',
    'Header Link' => 'Header Link',
    'URL (with http":/"/ or https":/"/)' => 'URL (with http":/"/ or https":/"/)',
    'Footer Link' => 'Footer Link',
    'Custom CSS (Optional)' => 'Custom CSS (Optional)',
    'It will be add to the frontend knowledgebase only' => 'Displayed only in front end knowledge base',
    'Custom Javascript (Optional)' => 'Custom Javascript (Optional)',
    'Broadcast message content to show on helpdesk' => 'Broadcast message content to show on helpdesk',
    'From' => 'From',
    'Time duration between which message will be displayed(if applicable)' => 'How long should the message be displayed?',
    'Broadcasting Status' => 'Broadcasting Status',
    'Broadcasting is Active' => 'Broadcasting is Active',
    'Choose a default company timezone' => 'Choose a default companys timezone',
    'Date Time Format' => 'Date Time Format',
    'Choose a format to convert date to specified date time format' => 'Choose a format to convert date to specified date time format',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'File size must not be greater than 200KB !!' => 'File size must not be greater than 200KB!',
    'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!' => 'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!',
    'Provide a valid url(with protocol)' => 'Provide a valid url (with protocol)',
    'ticket.message.placeHolders.info' => 'ticket.message.placeHolders.info',
    'ticket.attachments.placeHolders.info' => '	ticket.attachments.placeHolders.info',
    'ticket.threadMessage.placeHolders.info' => 'ticket.threadMessage.placeHolders.info',
    'ticket.tags.placeHolders.info' => 'ticket.tags.placeHolders.info',
    'ticket.source.placeHolders.info' => 'ticket.source.placeHolders.info',
    'ticket.collaborator.name.placeHolders.info' => 'ticket.collaborator.name.placeHolders.info',
    'ticket.collaborator.email.placeHolders.info' => 'ticket.collaborator.email.placeHolders.info',
    'user.name.info' => 'user.name.info',
    'user.email.info' => 'user.email.info',
    'user.account.validate.link.info' => 'user.account.validate.link.info',
    'user.password.forgot.link.info' => 'user.password.forgot.link.info',
    'global.companyName' => 'global.companyName',
    'global.companyLogo' => 'global.companyLogo',
    'global.companyUrl' => 'global.companyUrl',
    'ticket.priority.placeHolders.info' => '	ticket.priority.placeHolders.info',
    'ticket.group.placeHolders.info' => 'ticket.group.placeHolders.info',
    'ticket.team.placeHolders.info' => 'ticket.team.placeHolders.info',
    'ticket.customerName.placeHolders.info' => '	ticket.customerName.placeHolders.info',
    'ticket.customerEmail.placeHolders.info' => '	ticket.customerEmail.placeHolders.info',
    'ticket.agentName.placeHolders.info' => 'ticket.agentName.placeHolders.info',
    'ticket.agentEmail.placeHolders.info' => 'ticket.agentEmail.placeHolders.info',
    'ticket.link.placeHolders.info' => '	ticket.link.placeHolders.info ',
    'ticket.id.placeHolders.info' => 'ticket.id.placeHolders.info',
    'ticket.subject.placeHolders.info' => '	ticket.subject.placeHolders.info',
    'ticket.status.placeHolders.info' => 'ticket.status.placeHolders.info',
    'comma "," separated' => 'comma separated (,)',
    'Low' => 'Low',
    'Medium' => 'Medium',
    'High' => 'High',
    'Urgent' => 'Urgent',
    'Reset Password' => 'Reset Password',
    'Enter your new password below to update your login credentials' => 'Enter your new password below to update your login credentials',
    'Save Password' => 'Save Password',
    'Rate Support' => 'Rate Support',
    'I am very Sad' => 'I am very disappointed',
    'I am Sad' => 'I am disappointed',
    'I am Neutral' => 'I am satisfied',
    'I am Happy' => 'I am happy',
    'I am Very Happy' => 'I am very happy',
    'Kudos' => 'Kudos',
    'kudos' => 'Kudos',
    'Very Sad' => 'Very disappointed',
    'Sad' => 'Disappointed',
    'Neutral' => 'Satisfied',
    'Happy' => 'Happy',
    'Very Happy' => 'Very Happy',
    'Star(s)' => 'Star(s)',
    'Warning ! Swiftmailer not working. An error has occurred while sending emails!' => 'Warning ! Swiftmailer not working. An error has occurred while sending emails!',
    'Invalid credentials.' => 'Invalid credentials',
    'Success ! Project cache cleared successfully.' => 'Success! Project cache cleared successfully.',
    'clear cache' => 'clear cache',
    'Last Updated' => 'Last Updated',
    'Error! Something went wrong.' => 'Error! Something went wrong.',
    'We were not able to find the page you are looking for.' => 'We were not able to find the page you are looking for.',
    'Page not found' => 'Page not found',
    'Forbidden' => 'Forbidden',
    'You don’t have the necessary permissions to access this Web page :(' => 'You don’t have the necessary permissions to access this Web page :(',
    'Internal server error' => 'Internal server error',
    'Our system has goofed up for a while, but good part is it won\'t last long' => 'Our system has goofed up for a while, but good part is it won\'t last long',
    'Unknown Error' => 'Unknown Error',
    'We are quite confused about how did you land here:/' => 'We are quite confused about how did you land here :/',
    'Few of the links which may help you to get back on the track -' => 'Few of the links which may help you to get back on the track -',
    'Microsoft Apps' => 'Microsoft Apps',
    'Add a Microsoft app' => 'Add a Microsoft app',
    'Enable' => 'Enable',
    'App Name' => 'App Name',
    'Tenant Id' => 'Tenant Id',
    'Client Id' => 'Client Id',
    'Client Secret' => 'Client Secret',
    'NEW APP:' => 'NEW APP:',
    'UPDATE APP' => 'UPDATE APP',
    'Guide on creating a new app in Azure Active Directory:' => 'Guide on creating a new app in Azure Active Directory:',
    'To add a new Microsoft App to your azure active directory, follow the steps as given below:' => 'To add a new Microsoft App to your azure active directory, follow the steps as given below:',
    'Go to Azure Active Directory -> App registerations' => 'Go to Azure Active Directory -> App registerations',
    'Disable' => 'Disable',
    'Please enter a valid name for your app.' => 'Please enter a valid name for your app.',
    'Please enter a valid tenant id.' => 'Please enter a valid tenant id.',
    'Please enter a valid client id.' => 'Please enter a valid client id.',
    'Please enter a valid client secret.' => 'Please enter a valid client secret.',
    'Microsoft app settings' => 'Microsoft app settings',
    'Unverified' => 'Unverified',
    'Microsoft app has been updated successfully.' => 'Microsoft app has been updated successfully.',
    'No microsoft apps found' => 'No microsoft apps found',
    'Microsoft app settings could not be verifired successfully. Please check your settings and try again later.' => 'Microsoft app settings could not be verifired successfully. Please check your settings and try again later.',
    'Microsoft app has been integrated successfully.' => 'Microsoft app has been integrated successfully.',
    'Microsoft app has been deleted successfully.' => 'Microsoft app has been deleted successfully.',
    'Verified' => 'Verified',
    'Create a New Registration' => 'Create a New Registration',
    'Enter your app details as following:' => 'Enter your app details as following:',
    'App Name: Enter an app name to easily help you identify its purpose' => 'App Name: Enter an app name to easily help you identify its purpose',
    'Supported Account Types: Select whichever option works the best for you (Recommended: Accounts in any organizational directory and personal Microsoft accounts)' => 'Supported Account Types: Select whichever option works the best for you (Recommended: Accounts in any organizational directory and personal Microsoft accounts)',
    'Redirect URI:' => 'Redirect URI:',
    'Select Platform: Web' => 'Select Platform: Web',
    'Enter the following redirect uri:' => 'Enter the following redirect uri:',
    'Proceed to create your application' => 'Proceed to create your application',
    'Once your app has been created, in your app overview section, continue with adding a client credential by clicking on "Add a certificate or secret"' => 'Once your app has been created, in your app overview section, continue with adding a client credential by clicking on "Add a certificate or secret"',
    'Create a new client secret' => 'Create a new client secret',
    'Enter a description as per your preference to help identify the purpose of this client secret' => 'Enter a description as per your preference to help identify the purpose of this client secret',
    'Choose an expiration time as per your preference' => 'Choose an expiration time as per your preference',
    'Proceed to add your client secret' => 'Proceed to add your client secret',
    'Copy the client secret value which will be needed later and cannot be viewed again' => 'Copy the client secret value which will be needed later and cannot be viewed again',
    'Navigate to API permissions' => 'Navigate to API permissions',
    'Click on "Add a permission" to add a new api permission. Add the following delegated permissions by selecting Microsoft APIs > Microsoft Graph > Delegate Permissions' => 'Click on "Add a permission" to add a new api permission. Add the following delegated permissions by selecting Microsoft APIs > Microsoft Graph > Delegate Permissions',
    'Navigate to your app overview section' => 'Navigate to your app overview section',
    'Copy the Application (Client) Id' => 'Copy the Application (Client) Id',
    'Copy the Directory (Tenant) Id' => 'Copy the Directory (Tenant) Id',
    'Enter your client id, tenant id, and client secret in settings above as required.' => 'Enter your client id, tenant id, and client secret in settings above as required.',
    'offline_access' => 'offline_access',
    'openid' => 'openid',
    'profile' => 'profile',
    'User.Read' => 'User.Read',
    'IMAP.AccessAsUser.All' => 'IMAP.AccessAsUser.All',
    'SMTP.Send' => 'SMTP.Send',
    'POP.AccessAsUser.All' => 'POP.AccessAsUser.All',
    'Mail.Read' => 'Mail.Read',
    'Mail.ReadBasic' => 'Mail.ReadBasic',
    'Mail.Send' => 'Mail.Send',
    'Mail.Send.Shared' => 'Mail.Send.Shared',
    'Add App' => 'Add App',
    'New App' => 'New App',
    'Disable email delivery' => 'Disable email delivery',
    'Use as default mailbox for sending emails' => 'Use as default mailbox for sending emails',
    'Inbound Emails' => 'Inbound Emails',
    'Manage how you wish to retrieve and process emails from your mailbox.' => 'Manage how you wish to retrieve and process emails from your mailbox.',
    'Outbound Emails' => 'Outbound Emails',
    'Manage how you wish to send emails from your mailbox.' => 'Manage how you wish to send emails from your mailbox.',
    'Marketing Modules' => 'Marketing Modules',
    'New Marketing Module' => 'New Marketing Module',
    'Marketing Module' => 'Marketing Module',
    'Status:' => 'Status:',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
