<?php

namespace ContainerPhWH9sz;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\InvalidArgumentException;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class App_KernelDevDebugContainer extends Container
{
    protected $containerDir;
    protected $targetDir;
    protected $parameters = [];
    private $buildParameters;
    protected $getService;

    public function __construct(array $buildParameters = [], $containerDir = __DIR__)
    {
        $this->getService = \Closure::fromCallable([$this, 'getService']);
        $this->buildParameters = $buildParameters;
        $this->containerDir = $containerDir;
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'kernel' => true,
        ];
        $this->methodMap = [
            '.container.private.profiler' => 'get_Container_Private_ProfilerService',
            '.container.private.security.authorization_checker' => 'get_Container_Private_Security_AuthorizationCheckerService',
            '.container.private.security.csrf.token_manager' => 'get_Container_Private_Security_Csrf_TokenManagerService',
            '.container.private.security.token_storage' => 'get_Container_Private_Security_TokenStorageService',
            '.container.private.session' => 'get_Container_Private_SessionService',
            '.container.private.twig' => 'get_Container_Private_TwigService',
            '.container.private.validator' => 'get_Container_Private_ValidatorService',
            'cache.app' => 'getCache_AppService',
            'cache.system' => 'getCache_SystemService',
            'cache.validator_expression_language' => 'getCache_ValidatorExpressionLanguageService',
            'data_collector.dump' => 'getDataCollector_DumpService',
            'doctrine' => 'getDoctrineService',
            'doctrine.dbal.default_connection' => 'getDoctrine_Dbal_DefaultConnectionService',
            'doctrine.orm.default_entity_manager' => 'getDoctrine_Orm_DefaultEntityManagerService',
            'email.service' => 'getEmail_ServiceService',
            'event_dispatcher' => 'getEventDispatcherService',
            'http_kernel' => 'getHttpKernelService',
            'monolog.logger.deprecation' => 'getMonolog_Logger_DeprecationService',
            'recaptcha.service' => 'getRecaptcha_ServiceService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
            'swiftmailer.service' => 'getSwiftmailer_ServiceService',
            'ticket.service' => 'getTicket_ServiceService',
            'translator' => 'getTranslatorService',
            'user.service' => 'getUser_ServiceService',
            'uvdesk.automations' => 'getUvdesk_AutomationsService',
            'uvdesk.core.file_system.service' => 'getUvdesk_Core_FileSystem_ServiceService',
            'uvdesk.extensibles' => 'getUvdesk_ExtensiblesService',
            'uvdesk.service' => 'getUvdesk_ServiceService',
            'uvdesk_extension.assets_manager' => 'getUvdeskExtension_AssetsManagerService',
            'uvdesk_extension.twig_loader' => 'getUvdeskExtension_TwigLoaderService',
            'var_dumper.cloner' => 'getVarDumper_ClonerService',
            'cache_clearer' => 'getCacheClearerService',
            'filesystem' => 'getFilesystemService',
            'serializer' => 'getSerializerService',
            'security.csrf.token_manager' => 'getSecurity_Csrf_TokenManagerService',
            'form.factory' => 'getForm_FactoryService',
            'form.type.file' => 'getForm_Type_FileService',
            'profiler' => 'getProfilerService',
            'twig' => 'getTwigService',
            'security.authorization_checker' => 'getSecurity_AuthorizationCheckerService',
            'security.token_storage' => 'getSecurity_TokenStorageService',
            'security.password_encoder' => 'getSecurity_PasswordEncoderService',
            'session' => 'getSessionService',
            'validator' => 'getValidatorService',
        ];
        $this->fileMap = [
            '.container.private.cache_clearer' => 'get_Container_Private_CacheClearerService',
            '.container.private.filesystem' => 'get_Container_Private_FilesystemService',
            '.container.private.form.factory' => 'get_Container_Private_Form_FactoryService',
            '.container.private.form.type.file' => 'get_Container_Private_Form_Type_FileService',
            '.container.private.security.password_encoder' => 'get_Container_Private_Security_PasswordEncoderService',
            '.container.private.serializer' => 'get_Container_Private_SerializerService',
            'App\\Controller\\BaseController' => 'getBaseControllerService',
            'App\\Controller\\ConfigureHelpdesk' => 'getConfigureHelpdeskService',
            'App\\Controller\\ImageCache\\ImageCacheController' => 'getImageCacheControllerService',
            'App\\Controller\\ImageCache\\ImageManager' => 'getImageManagerService',
            'Doctrine\\Bundle\\DoctrineBundle\\Controller\\ProfilerController' => 'getProfilerControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateControllerService',
            'Webkul\\UVDesk\\ApiBundle\\API\\Agents' => 'getAgentsService',
            'Webkul\\UVDesk\\ApiBundle\\API\\Customers' => 'getCustomersService',
            'Webkul\\UVDesk\\ApiBundle\\API\\Group' => 'getGroupService',
            'Webkul\\UVDesk\\ApiBundle\\API\\Me' => 'getMeService',
            'Webkul\\UVDesk\\ApiBundle\\API\\Sessions' => 'getSessionsService',
            'Webkul\\UVDesk\\ApiBundle\\API\\Team' => 'getTeamService',
            'Webkul\\UVDesk\\ApiBundle\\API\\Threads' => 'getThreadsService',
            'Webkul\\UVDesk\\ApiBundle\\API\\TicketTypes' => 'getTicketTypesService',
            'Webkul\\UVDesk\\ApiBundle\\API\\Tickets' => 'getTicketsService',
            'Webkul\\UVDesk\\ApiBundle\\Controller\\ApiSettings' => 'getApiSettingsService',
            'Webkul\\UVDesk\\AutomationBundle\\Controller\\Automations\\PreparedResponse' => 'getPreparedResponseService',
            'Webkul\\UVDesk\\AutomationBundle\\Controller\\Automations\\PreparedResponseXHR' => 'getPreparedResponseXHRService',
            'Webkul\\UVDesk\\AutomationBundle\\Controller\\Automations\\Workflow' => 'getWorkflowService',
            'Webkul\\UVDesk\\AutomationBundle\\Controller\\Automations\\WorkflowXHR' => 'getWorkflowXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Account' => 'getAccountService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\AccountXHR' => 'getAccountXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Authentication' => 'getAuthenticationService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Customer' => 'getCustomerService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\CustomerXHR' => 'getCustomerXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Email' => 'getEmailService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\EmailSettings' => 'getEmailSettingsService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\EmailSettingsXHR' => 'getEmailSettingsXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Group' => 'getGroup2Service',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\GroupXHR' => 'getGroupXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Microsoft\\MicrosoftApps' => 'getMicrosoftAppsService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Microsoft\\MicrosoftAppsXHR' => 'getMicrosoftAppsXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Privilege' => 'getPrivilegeService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\PrivilegeXHR' => 'getPrivilegeXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Report' => 'getReportService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\SavedReplies' => 'getSavedRepliesService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Session' => 'getSession2Service',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\SwiftMailer' => 'getSwiftMailerService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\SwiftMailerXHR' => 'getSwiftMailerXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Team' => 'getTeam2Service',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\TeamXHR' => 'getTeamXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Theme' => 'getThemeService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Thread' => 'getThreadService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\ThreadXHR' => 'getThreadXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\Ticket' => 'getTicketService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Controller\\TicketXHR' => 'getTicketXHRService',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\FileSystem\\UploadManagers\\Localhost' => 'getLocalhostService',
            'Webkul\\UVDesk\\ExtensionFrameworkBundle\\Controller\\Application' => 'getApplicationService',
            'Webkul\\UVDesk\\ExtensionFrameworkBundle\\Controller\\Dashboard' => 'getDashboardService',
            'Webkul\\UVDesk\\MailboxBundle\\Controller\\MailboxChannel' => 'getMailboxChannelService',
            'Webkul\\UVDesk\\MailboxBundle\\Controller\\MailboxChannelXHR' => 'getMailboxChannelXHRService',
            'Webkul\\UVDesk\\SupportCenterBundle\\Controller\\Announcement' => 'getAnnouncementService',
            'Webkul\\UVDesk\\SupportCenterBundle\\Controller\\Article' => 'getArticleService',
            'Webkul\\UVDesk\\SupportCenterBundle\\Controller\\Branding' => 'getBrandingService',
            'Webkul\\UVDesk\\SupportCenterBundle\\Controller\\Category' => 'getCategoryService',
            'Webkul\\UVDesk\\SupportCenterBundle\\Controller\\Customer' => 'getCustomer2Service',
            'Webkul\\UVDesk\\SupportCenterBundle\\Controller\\Folder' => 'getFolderService',
            'Webkul\\UVDesk\\SupportCenterBundle\\Controller\\KnowledgebaseXHR' => 'getKnowledgebaseXHRService',
            'Webkul\\UVDesk\\SupportCenterBundle\\Controller\\MarketingModule' => 'getMarketingModuleService',
            'Webkul\\UVDesk\\SupportCenterBundle\\Controller\\Ticket' => 'getTicket2Service',
            'Webkul\\UVDesk\\SupportCenterBundle\\Controller\\Website' => 'getWebsiteService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache_warmer' => 'getCacheWarmerService',
            'console.command.public_alias.App\\Console\\EnvironmentVariables' => 'getEnvironmentVariablesService',
            'console.command.public_alias.App\\Console\\Wizard\\ConfigureHelpdesk' => 'getConfigureHelpdesk2Service',
            'console.command.public_alias.App\\Console\\Wizard\\DefaultUser' => 'getDefaultUserService',
            'console.command.public_alias.App\\Console\\Wizard\\MigrateDatabase' => 'getMigrateDatabaseService',
            'console.command.public_alias.Webkul\\UVDesk\\CoreFrameworkBundle\\Guides\\BootstrappingProject' => 'getBootstrappingProjectService',
            'console.command.public_alias.Webkul\\UVDesk\\ExtensionFrameworkBundle\\Console\\BuildExtensions' => 'getBuildExtensionsService',
            'console.command.public_alias.Webkul\\UVDesk\\MailboxBundle\\Console\\RefreshMailboxCommand' => 'getRefreshMailboxCommandService',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'error_controller' => 'getErrorControllerService',
            'knp_paginator' => 'getKnpPaginatorService',
            'report.service' => 'getReport_ServiceService',
            'routing.loader' => 'getRouting_LoaderService',
            'services_resetter' => 'getServicesResetterService',
            'swiftmailer.mailer.mailer_8488' => 'getSwiftmailer_Mailer_Mailer8488Service',
            'swiftmailer.mailer.mailer_8488.plugin.messagelogger' => 'getSwiftmailer_Mailer_Mailer8488_Plugin_MessageloggerService',
            'swiftmailer.mailer.mailer_8488.transport' => 'getSwiftmailer_Mailer_Mailer8488_TransportService',
            'user.provider' => 'getUser_ProviderService',
            'uvdesk.automations.prepared_responses' => 'getUvdesk_Automations_PreparedResponsesService',
            'uvdesk.automations.workflows' => 'getUvdesk_Automations_WorkflowsService',
            'uvdesk.core.event_dispatcher' => 'getUvdesk_Core_EventDispatcherService',
            'uvdesk.mailbox' => 'getUvdesk_MailboxService',
            'validation.service' => 'getValidation_ServiceService',
            'web_profiler.controller.exception_panel' => 'getWebProfiler_Controller_ExceptionPanelService',
            'web_profiler.controller.profiler' => 'getWebProfiler_Controller_ProfilerService',
            'web_profiler.controller.router' => 'getWebProfiler_Controller_RouterService',
        ];
        $this->aliases = [
            'App\\Kernel' => 'kernel',
            'database_connection' => 'doctrine.dbal.default_connection',
            'doctrine.orm.entity_manager' => 'doctrine.orm.default_entity_manager',
            'mailer' => 'swiftmailer.mailer.mailer_8488',
            'swiftmailer.transport' => 'swiftmailer.mailer.mailer_8488.transport',
        ];

        $this->privates['service_container'] = function () {
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpKernelInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/KernelInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/RebootableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/TerminableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Kernel.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Kernel/MicroKernelTrait.php';
            include_once \dirname(__DIR__, 4).'/src/Kernel.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Framework/ExtendableComponentInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/DashboardTemplate.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/EventListener/SessionLifetime.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Security.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/container/src/ContainerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceLocatorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ServiceLocator.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/FileSystem/FileUploadServiceInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/FileSystem/UploadManagers/Localhost.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Services/FileUploadService.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Services/MicrosoftIntegration.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Tickets/QuickActionButtonCollection.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Tickets/QuickActionButtonInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Ticket/QuickActionButtons/SavedReplies.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/UIComponents/Ticket/QuickActionButtons/PreparedResponses.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/Services/AutomationService.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/extension-framework/Definition/MappingResource.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/extension-framework/EventListener/Kernel.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/mailbox-component/Services/MailboxService.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/api-bundle/EventListeners/API/KernelRequest.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/LocaleListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ErrorListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/RunnerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/Runner/Symfony/HttpKernelRunner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/Runner/Symfony/ResponseRunner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/RuntimeInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/GenericRuntime.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/SymfonyRuntime.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpKernel.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ControllerResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/TraceableControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/TraceableArgumentResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/RequestStack.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/ConfigCacheFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/ResourceCheckerConfigCacheFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/cache/src/CacheItemPoolInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/AdapterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/CacheInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/PruneableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ResetInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/ResettableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/TraceableAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/LoggerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/LoggerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/AbstractAdapterTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/CacheTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/ContractsTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/AbstractAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/FilesystemCommonTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/FilesystemTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/FilesystemAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Marshaller/MarshallerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Marshaller/DefaultMarshaller.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/mailer/EventListener/MessageLoggerListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/TranslatorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/TranslatorBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/LocaleAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/MessageFormatterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/IntlFormatterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/MessageFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/TranslatorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/IdentityTranslator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/src/LoggerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/ResettableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Logger.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Log/DebugLoggerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Logger.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Debug/FileLinkFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/stopwatch/Stopwatch.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Processor/DebugProcessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RequestContext.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/expression-language/ExpressionFunctionProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/RouterListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Reader.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/PsrCachedReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/ProxyTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/PhpArrayAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyTypeExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyDescriptionExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyAccessExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyListExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInitializableExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInfoExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/web-link/EventListener/AddLinkHeaderListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/SessionFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/SessionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Storage/SessionStorageFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Storage/NativeSessionStorageFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Storage/Handler/AbstractSessionHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Storage/Handler/StrictSessionHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/SessionBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Storage/MetadataBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/AbstractSessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/SessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenStorage/ClearableTokenStorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenStorage/SessionTokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ValidatorBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Validation.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ConstraintValidatorFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ContainerConstraintValidatorFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ObjectInitializerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/Validator/DoctrineInitializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/AutoMappingTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/PropertyInfoLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/Validator/DoctrineLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/notifier/EventListener/NotificationLoggerListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ProfilerListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/DataCollectorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/DataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/LateDataCollectorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/RequestDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/RouterDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/DataCollector/RouterDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/form/Extension/DataCollector/FormDataCollectorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/form/Extension/DataCollector/FormDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/form/Extension/DataCollector/FormDataExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/form/Extension/DataCollector/FormDataExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/ConnectionRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/ManagerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/AbstractManagerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/ManagerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Registry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/event-manager/src/EventManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/ContainerAwareEventManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Connection.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/ConnectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Configuration.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Schema/SchemaManagerFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Schema/LegacySchemaManagerFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Dbal/SchemaAssetsFilterManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Driver/Middleware.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Logging/Middleware.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Middleware/ConnectionNameAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Middleware/DebugMiddleware.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Tools/DsnParser.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/Middleware/Debug/DebugDataHolder.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Middleware/BacktraceDebugDataHolder.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/MappingDriver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/Driver/CompatibilityAnnotationDriver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/ColocatedMappingDriver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/Driver/ReflectionBasedDriver.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/Driver/AnnotationDriver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/ArrayAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/src/Subscriber/SlidingPaginationSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/ControllerListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/ParamConverterListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Request/ParamConverter/ParamConverterManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Request/ParamConverter/ParamConverterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Request/ParamConverter/DoctrineParamConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/expression-language/ExpressionLanguage.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Request/ParamConverter/DateTimeParamConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/TemplateListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Templating/TemplateGuesser.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/HttpCacheListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/SecurityListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/ExpressionLanguage.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Security/ExpressionLanguage.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/IsGrantedListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Request/ArgumentNameConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Profiler/Profile.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/web-profiler-bundle/Csp/ContentSecurityPolicyHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/web-profiler-bundle/Csp/NonceGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/web-profiler-bundle/EventListener/WebDebugToolbarListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/Handler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Dumper/DataDumperInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/DumpDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Cloner/ClonerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Cloner/AbstractCloner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Cloner/VarCloner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Cloner/DumperInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Dumper/AbstractDumper.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Dumper/CliDumper.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Dumper/HtmlDumper.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Server/Connection.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Dumper/ContextProvider/ContextProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Dumper/ContextProvider/SourceContextProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Dumper/ContextProvider/RequestContextProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/var-dumper/Dumper/ContextProvider/CliContextProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-migrations-bundle/src/EventListener/SchemaFilterListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Role/RoleHierarchyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Role/RoleHierarchy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/FirewallMapInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Security/FirewallMap.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Logout/LogoutUrlGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/RememberMe/ResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/TraceableAccessDecisionManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AccessDecisionManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Firewall.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/EventListener/FirewallListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Debug/TraceableFirewallListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-client-contracts/HttpClientInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-client/TraceableHttpClient.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-client/HttpClient.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Services/UVDeskService.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Services/UserService.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Services/EmailService.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Services/TicketService.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Services/ReCaptchaService.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/FileSystem/FileSystem.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/SwiftMailer/SwiftMailer.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Framework/ExtendableComponentManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/AsideTemplate.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/Segments/PanelSidebarInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Sidebars/Account.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Sidebars/Apps.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Sidebars/Branding.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Sidebars/Productivity.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Sidebars/Reports.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Sidebars/Settings.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Sidebars/Users.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Panel/Sidebars/Knowledgebase.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/Segments/PanelSidebarItemInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Account/Profile.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Productivity/SavedReplies.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Productivity/Tags.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Productivity/TicketTypes.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Reports/AgentActivity.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Reports/Kudos.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Settings/Branding.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Settings/EmailSettings.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Settings/EmailTemplates.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Settings/MicrosoftApps.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Settings/SwiftMailer.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Themes/Helpdesk.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Users/Agents.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Users/Customers.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Users/Groups.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Users/Privileges.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Panel/Items/Users/Teams.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/UIComponents/Dashboard/Panel/Items/Productivity/PreparedResponses.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/UIComponents/Dashboard/Panel/Items/Productivity/Workflows.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/mailbox-component/UIComponents/Dashboard/Panel/Items/Settings/Mailboxes.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Panel/Items/Knowledgebase/Announcement.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Panel/Items/Knowledgebase/Articles.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Panel/Items/Knowledgebase/Categories.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Panel/Items/Knowledgebase/Folders.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Panel/Items/Knowledgebase/MarketingModule.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Panel/Items/Settings/BlockSpam.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Panel/Items/Themes/SupportCenter.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/api-bundle/UIComponents/Dashboard/Panel/Items/Settings/ApiSettings.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/Dashboard.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/NavigationTemplate.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/HomepageTemplate.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/Segments/NavigationInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Navigation/Home.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Navigation/Reports.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Navigation/Ticket.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/extension-framework/UIComponents/Dashboard/Navigation/Apps.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Navigation/Knowledgebase.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/Segments/HomepageSectionInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/Segments/HomepageSection.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Sections/Productivity.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Sections/Reports.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Sections/Settings.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Sections/Users.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/extension-framework/UIComponents/Dashboard/Homepage/Sections/Apps.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Homepage/Sections/Knowledgebase.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/Segments/HomepageSectionItemInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/Segments/HomepageSectionItem.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/AgentActivity.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/Agents.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/Branding.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/Customers.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/EmailSettings.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/EmailTemplates.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/Groups.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/Kudos.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/MicrosoftApps.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/Privileges.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/SavedReplies.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/SwiftMailer.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/Tags.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/Teams.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Homepage/Items/TicketTypes.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/UIComponents/Dashboard/Homepage/Items/PreparedResponses.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/UIComponents/Dashboard/Homepage/Items/Workflows.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/extension-framework/UIComponents/Dashboard/Homepage/Items/ExploreApps.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/mailbox-component/UIComponents/Dashboard/Homepage/Items/Mailbox.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Homepage/Items/Announcement.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Homepage/Items/Articles.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Homepage/Items/Categories.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Homepage/Items/Folders.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Homepage/Items/MarketingModule.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Homepage/Items/SpamSettings.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/api-bundle/UIComponents/Dashboard/Homepage/Items/ApiSettings.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/SearchTemplate.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Dashboard/Segments/SearchItemInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/AgentActivity.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/Agents.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/Apps.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/Branding.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/EmailSettings.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/EmailTemplates.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/Groups.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/Kudos.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/MicrosoftApps.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/Privileges.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/SavedReplies.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/Tags.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/Teams.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/TicketTypes.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/UIComponents/Dashboard/Search/Tickets.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/UIComponents/Dashboard/Search/PreparedResponses.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/UIComponents/Dashboard/Search/Workflows.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/extension-framework/UIComponents/Dashboard/Search/Apps.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/mailbox-component/UIComponents/Dashboard/Search/Mailbox.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/mailbox-component/UIComponents/Dashboard/Search/SwiftMailer.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Search/Announcement.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Search/Articles.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Search/Categories.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Search/Customers.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Search/Folders.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Search/MarketingModule.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/UIComponents/Dashboard/Search/SpamSettings.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/api-bundle/UIComponents/Dashboard/Search/ApiSettings.php';
            include_once \dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Tickets/WidgetCollection.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Loader/FilesystemLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Packages.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/PackageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Package.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/PathPackage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/VersionStrategy/VersionStrategyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/VersionStrategy/EmptyVersionStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Context/ContextInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Context/RequestStackContext.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/DataCollectorTranslator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RequestContextAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/UrlMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Generator/UrlGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RouterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/RequestMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/event-dispatcher/src/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/Debug/TraceableEventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Debug/TraceableEventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/NullHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/CsrfTokenManagerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/CsrfTokenManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Profiler/Profiler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Profiler/ProfilerStorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Profiler/FileProfilerStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/TimeDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/MemoryDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/DataCollector/ValidatorDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/AjaxDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/ExceptionDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/LoggerDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/EventDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/DataCollector/CacheDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/DataCollector/TranslationDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/DataCollector/SecurityDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/DataCollector/TwigDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-client/DataCollector/HttpClientDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/DataCollector/DoctrineDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/DataCollector/DoctrineDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/swiftmailer-bundle/DataCollector/MessageDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/mailer/DataCollector/MessageDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/notifier/DataCollector/NotificationDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/ConfigDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Cache/CacheInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Cache/RemovableCacheInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Cache/FilesystemCache.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/ExtensionInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/LastModifiedExtensionInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/AbstractExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/CoreExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/EscaperExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/OptimizerExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/StagingExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/ExtensionSet.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Template.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/TemplateWrapper.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Environment.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/CsrfExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/ProfilerExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/ProfilerExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/TranslationExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/AssetExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/CodeExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/RoutingExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/YamlExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/StopwatchExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/ExpressionExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/HttpKernelExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/HttpFoundationExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/UrlHelper.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/WebLinkExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/SerializerExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/FormExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/DumpExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/LogoutUrlExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/SecurityExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Impersonate/ImpersonateUrlGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Twig/DoctrineExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/src/Twig/Extension/PaginationExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/src/Helper/Processor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/web-profiler-bundle/Twig/WebProfilerExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/AppVariable.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/RuntimeLoader/RuntimeLoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/RuntimeLoader/ContainerRuntimeLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/extra-bundle/MissingExtensionSuggestor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bundle/DependencyInjection/Configurator/EnvironmentConfigurator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AuthorizationChecker.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/SessionInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Session.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Factory/MetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Validator/ValidatorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Validator/TraceableValidator.php';
        };
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function load($file, $lazyLoad = true)
    {
        if (class_exists($class = __NAMESPACE__.'\\'.$file, false)) {
            return $class::do($this, $lazyLoad);
        }

        if ('.' === $file[-4]) {
            $class = substr($class, 0, -4);
        } else {
            $file .= '.php';
        }

        $service = require $this->containerDir.\DIRECTORY_SEPARATOR.$file;

        return class_exists($class, false) ? $class::do($this, $lazyLoad) : $service;
    }

    protected function createProxy($class, \Closure $factory)
    {
        class_exists($class, false) || require __DIR__.'/'.$class.'.php';

        return $factory();
    }

    /**
     * Gets the public '.container.private.profiler' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Profiler\Profiler
     */
    protected function get_Container_Private_ProfilerService()
    {
        $a = new \Symfony\Bridge\Monolog\Logger('profiler');
        $a->pushProcessor(($this->privates['debug.log_processor'] ?? $this->getDebug_LogProcessorService()));
        $a->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $a->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        \Symfony\Bundle\FrameworkBundle\DependencyInjection\Compiler\AddDebugLogProcessorPass::configureLogger($a);

        $this->services['.container.private.profiler'] = $instance = new \Symfony\Component\HttpKernel\Profiler\Profiler(new \Symfony\Component\HttpKernel\Profiler\FileProfilerStorage(('file:'.$this->targetDir.''.'/profiler')), $a, true);

        $b = ($this->services['kernel'] ?? $this->get('kernel'));
        $c = ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()));
        $d = new \Symfony\Component\Cache\DataCollector\CacheDataCollector();
        $d->addInstance('cache.app', ($this->services['cache.app'] ?? $this->getCache_AppService()));
        $d->addInstance('cache.system', ($this->services['cache.system'] ?? $this->getCache_SystemService()));
        $d->addInstance('cache.validator', ($this->privates['cache.validator'] ?? $this->getCache_ValidatorService()));
        $d->addInstance('cache.serializer', ($this->privates['cache.serializer'] ?? $this->getCache_SerializerService()));
        $d->addInstance('cache.annotations', ($this->privates['cache.annotations'] ?? $this->getCache_AnnotationsService()));
        $d->addInstance('cache.property_info', ($this->privates['cache.property_info'] ?? $this->getCache_PropertyInfoService()));
        $d->addInstance('cache.validator_expression_language', ($this->services['cache.validator_expression_language'] ?? $this->getCache_ValidatorExpressionLanguageService()));
        $d->addInstance('cache.doctrine.orm.default.result', ($this->privates['cache.doctrine.orm.default.result'] ?? $this->getCache_Doctrine_Orm_Default_ResultService()));
        $d->addInstance('cache.doctrine.orm.default.query', ($this->privates['cache.doctrine.orm.default.query'] ?? $this->getCache_Doctrine_Orm_Default_QueryService()));
        $d->addInstance('cache.security_expression_language', ($this->privates['cache.security_expression_language'] ?? $this->getCache_SecurityExpressionLanguageService()));
        $e = new \Symfony\Component\HttpClient\DataCollector\HttpClientDataCollector();
        $e->registerClient('http_client', ($this->privates['.debug.http_client'] ?? $this->get_Debug_HttpClientService()));
        $f = new \Symfony\Component\HttpKernel\DataCollector\ConfigDataCollector();
        if ($this->has('kernel')) {
            $f->setKernel($b);
        }

        $instance->add(($this->privates['data_collector.request'] ?? $this->getDataCollector_RequestService()));
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\TimeDataCollector($b, ($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true)))));
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\MemoryDataCollector());
        $instance->add(new \Symfony\Component\Validator\DataCollector\ValidatorDataCollector(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService())));
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\AjaxDataCollector());
        $instance->add(($this->privates['data_collector.form'] ?? $this->getDataCollector_FormService()));
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\ExceptionDataCollector());
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\LoggerDataCollector($a, ($this->targetDir.''.'/App_KernelDevDebugContainer'), $c));
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\EventDataCollector(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), $c));
        $instance->add(($this->privates['data_collector.router'] ?? ($this->privates['data_collector.router'] = new \Symfony\Bundle\FrameworkBundle\DataCollector\RouterDataCollector())));
        $instance->add($d);
        $instance->add(new \Symfony\Component\Translation\DataCollector\TranslationDataCollector(($this->services['translator'] ?? $this->getTranslatorService())));
        $instance->add(new \Symfony\Bundle\SecurityBundle\DataCollector\SecurityDataCollector(($this->privates['security.untracked_token_storage'] ?? ($this->privates['security.untracked_token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage())), ($this->privates['security.role_hierarchy'] ?? $this->getSecurity_RoleHierarchyService()), ($this->privates['security.logout_url_generator'] ?? $this->getSecurity_LogoutUrlGeneratorService()), ($this->privates['debug.security.access.decision_manager'] ?? $this->getDebug_Security_Access_DecisionManagerService()), ($this->privates['security.firewall.map'] ?? $this->getSecurity_Firewall_MapService()), ($this->privates['debug.security.firewall'] ?? $this->getDebug_Security_FirewallService()), false));
        $instance->add(new \Symfony\Bridge\Twig\DataCollector\TwigDataCollector(($this->privates['twig.profile'] ?? ($this->privates['twig.profile'] = new \Twig\Profiler\Profile())), ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService())));
        $instance->add($e);
        $instance->add(new \Doctrine\Bundle\DoctrineBundle\DataCollector\DoctrineDataCollector(($this->services['doctrine'] ?? $this->getDoctrineService()), true, ($this->privates['doctrine.debug_data_holder'] ?? ($this->privates['doctrine.debug_data_holder'] = new \Doctrine\Bundle\DoctrineBundle\Middleware\BacktraceDebugDataHolder([])))));
        $instance->add(new \Symfony\Bundle\SwiftmailerBundle\DataCollector\MessageDataCollector($this));
        $instance->add(($this->services['data_collector.dump'] ?? $this->getDataCollector_DumpService()));
        $instance->add(new \Symfony\Component\Mailer\DataCollector\MessageDataCollector(($this->privates['mailer.message_logger_listener'] ?? ($this->privates['mailer.message_logger_listener'] = new \Symfony\Component\Mailer\EventListener\MessageLoggerListener()))));
        $instance->add(new \Symfony\Component\Notifier\DataCollector\NotificationDataCollector(($this->privates['notifier.logger_notification_listener'] ?? ($this->privates['notifier.logger_notification_listener'] = new \Symfony\Component\Notifier\EventListener\NotificationLoggerListener()))));
        $instance->add($f);

        return $instance;
    }

    /**
     * Gets the public '.container.private.security.authorization_checker' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\AuthorizationChecker
     */
    protected function get_Container_Private_Security_AuthorizationCheckerService()
    {
        $a = ($this->privates['debug.security.access.decision_manager'] ?? $this->getDebug_Security_Access_DecisionManagerService());

        if (isset($this->services['.container.private.security.authorization_checker'])) {
            return $this->services['.container.private.security.authorization_checker'];
        }

        return $this->services['.container.private.security.authorization_checker'] = new \Symfony\Component\Security\Core\Authorization\AuthorizationChecker(($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService()), $a, false);
    }

    /**
     * Gets the public '.container.private.security.csrf.token_manager' shared service.
     *
     * @return \Symfony\Component\Security\Csrf\CsrfTokenManager
     */
    protected function get_Container_Private_Security_Csrf_TokenManagerService()
    {
        return $this->services['.container.private.security.csrf.token_manager'] = new \Symfony\Component\Security\Csrf\CsrfTokenManager(new \Symfony\Component\Security\Csrf\TokenGenerator\UriSafeTokenGenerator(), ($this->privates['security.csrf.token_storage'] ?? $this->getSecurity_Csrf_TokenStorageService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /**
     * Gets the public '.container.private.security.token_storage' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage
     */
    protected function get_Container_Private_Security_TokenStorageService()
    {
        return $this->services['.container.private.security.token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage(($this->privates['security.untracked_token_storage'] ?? ($this->privates['security.untracked_token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage())), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
        ], [
            'request_stack' => '?',
        ]));
    }

    /**
     * Gets the public '.container.private.session' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\Session\Session
     */
    protected function get_Container_Private_SessionService()
    {
        $a = ($this->privates['session.factory'] ?? $this->getSession_FactoryService());

        if (isset($this->services['.container.private.session'])) {
            return $this->services['.container.private.session'];
        }

        return $this->services['.container.private.session'] = $a->createSession();
    }

    /**
     * Gets the public '.container.private.twig' shared service.
     *
     * @return \Twig\Environment
     */
    protected function get_Container_Private_TwigService()
    {
        $this->services['.container.private.twig'] = $instance = new \Twig\Environment(($this->services['uvdesk_extension.twig_loader'] ?? $this->getUvdeskExtension_TwigLoaderService()), ['debug' => true, 'strict_variables' => true, 'autoescape' => 'name', 'cache' => ($this->targetDir.''.'/twig'), 'charset' => 'UTF-8']);

        $a = ($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true)));
        $b = ($this->services['translator'] ?? $this->getTranslatorService());
        $c = ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService());
        $d = ($this->services['router'] ?? $this->getRouterService());
        $e = ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()));
        $f = ($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService());
        $g = new \Symfony\Component\VarDumper\Dumper\HtmlDumper(NULL, 'UTF-8', 1);
        $g->setDisplayOptions(['maxStringLength' => 4096, 'fileLinkFormat' => $c]);
        $h = new \Symfony\Bridge\Twig\AppVariable();
        $h->setEnvironment('dev');
        $h->setDebug(true);
        if ($this->has('.container.private.security.token_storage')) {
            $h->setTokenStorage($f);
        }
        if ($this->has('request_stack')) {
            $h->setRequestStack($e);
        }
        $i = new \Twig\Extra\TwigExtraBundle\MissingExtensionSuggestor();

        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\CsrfExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\ProfilerExtension(($this->privates['twig.profile'] ?? ($this->privates['twig.profile'] = new \Twig\Profiler\Profile())), $a));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\TranslationExtension($b));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\AssetExtension(($this->services['uvdesk_extension.assets_manager'] ?? $this->getUvdeskExtension_AssetsManagerService())));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\CodeExtension($c, \dirname(__DIR__, 4), 'UTF-8'));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\RoutingExtension($d));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\YamlExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\StopwatchExtension($a, true));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\ExpressionExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\HttpKernelExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\HttpFoundationExtension(new \Symfony\Component\HttpFoundation\UrlHelper($e, $d)));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\WebLinkExtension($e));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\SerializerExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\FormExtension($b));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\DumpExtension(($this->services['var_dumper.cloner'] ?? $this->getVarDumper_ClonerService()), ($this->privates['var_dumper.html_dumper'] ?? $this->getVarDumper_HtmlDumperService())));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\LogoutUrlExtension(($this->privates['security.logout_url_generator'] ?? $this->getSecurity_LogoutUrlGeneratorService())));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\SecurityExtension(($this->services['.container.private.security.authorization_checker'] ?? $this->get_Container_Private_Security_AuthorizationCheckerService()), new \Symfony\Component\Security\Http\Impersonate\ImpersonateUrlGenerator($e, ($this->privates['security.firewall.map'] ?? $this->getSecurity_Firewall_MapService()), $f)));
        $instance->addExtension(new \Doctrine\Bundle\DoctrineBundle\Twig\DoctrineExtension());
        $instance->addExtension(new \Knp\Bundle\PaginatorBundle\Twig\Extension\PaginationExtension(new \Knp\Bundle\PaginatorBundle\Helper\Processor($d, $b)));
        $instance->addExtension(new \Symfony\Bundle\WebProfilerBundle\Twig\WebProfilerExtension($g));
        $instance->addGlobal('app', $h);
        $instance->addRuntimeLoader(new \Twig\RuntimeLoader\ContainerRuntimeLoader(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'Symfony\\Bridge\\Twig\\Extension\\CsrfRuntime' => ['privates', 'twig.runtime.security_csrf', 'getTwig_Runtime_SecurityCsrfService', true],
            'Symfony\\Bridge\\Twig\\Extension\\HttpKernelRuntime' => ['privates', 'twig.runtime.httpkernel', 'getTwig_Runtime_HttpkernelService', true],
            'Symfony\\Bridge\\Twig\\Extension\\SerializerRuntime' => ['privates', 'twig.runtime.serializer', 'getTwig_Runtime_SerializerService', true],
            'Symfony\\Component\\Form\\FormRenderer' => ['privates', 'twig.form.renderer', 'getTwig_Form_RendererService', true],
        ], [
            'Symfony\\Bridge\\Twig\\Extension\\CsrfRuntime' => '?',
            'Symfony\\Bridge\\Twig\\Extension\\HttpKernelRuntime' => '?',
            'Symfony\\Bridge\\Twig\\Extension\\SerializerRuntime' => '?',
            'Symfony\\Component\\Form\\FormRenderer' => '?',
        ])));
        $instance->addGlobal('default_agent_image_path', 'bundles/uvdeskcoreframework/images/uv-avatar-batman.png');
        $instance->addGlobal('default_customer_image_path', 'bundles/uvdeskcoreframework/images/uv-avatar-ironman.png');
        $instance->addGlobal('default_helpdesk_image_path', 'bundles/uvdeskcoreframework/images/uv-avatar-uvdesk.png');
        $instance->addGlobal('max_post_size', 8388608);
        $instance->addGlobal('max_file_uploads', 20);
        $instance->addGlobal('upload_max_filesize', 2097152);
        $instance->addGlobal('user_service', ($this->services['user.service'] ?? $this->getUser_ServiceService()));
        $instance->addGlobal('uvdesk_service', ($this->services['uvdesk.service'] ?? $this->getUvdesk_ServiceService()));
        $instance->addGlobal('recaptcha_service', ($this->services['recaptcha.service'] ?? $this->getRecaptcha_ServiceService()));
        $instance->addGlobal('ticket_service', ($this->services['ticket.service'] ?? $this->getTicket_ServiceService()));
        $instance->addGlobal('csrf_token_generator', ($this->services['.container.private.security.csrf.token_manager'] ?? $this->get_Container_Private_Security_Csrf_TokenManagerService()));
        $instance->addGlobal('email_service', ($this->services['email.service'] ?? $this->getEmail_ServiceService()));
        $instance->addGlobal('uvdesk_extensibles', ($this->services['uvdesk.extensibles'] ?? $this->getUvdesk_ExtensiblesService()));
        $instance->addGlobal('uvdesk_core_file_system', ($this->services['uvdesk.core.file_system.service'] ?? $this->getUvdesk_Core_FileSystem_ServiceService()));
        $instance->addGlobal('uvdesk_automations', ($this->services['uvdesk.automations'] ?? $this->getUvdesk_AutomationsService()));
        $instance->addGlobal('uvdesk_version', 'v1.1.8');
        $instance->addGlobal('uvdesk_core_version', 'v1.1.7');
        $instance->registerUndefinedFilterCallback([0 => $i, 1 => 'suggestFilter']);
        $instance->registerUndefinedFunctionCallback([0 => $i, 1 => 'suggestFunction']);
        $instance->registerUndefinedTokenParserCallback([0 => $i, 1 => 'suggestTag']);
        (new \Symfony\Bundle\TwigBundle\DependencyInjection\Configurator\EnvironmentConfigurator('F j, Y H:i', '%d days', NULL, 0, '.', ','))->configure($instance);

        return $instance;
    }

    /**
     * Gets the public '.container.private.validator' shared service.
     *
     * @return \Symfony\Component\Validator\Validator\TraceableValidator
     */
    protected function get_Container_Private_ValidatorService()
    {
        return $this->services['.container.private.validator'] = new \Symfony\Component\Validator\Validator\TraceableValidator(($this->privates['validator.builder'] ?? $this->getValidator_BuilderService())->getValidator());
    }

    /**
     * Gets the public 'cache.app' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\TraceableAdapter
     */
    protected function getCache_AppService()
    {
        $a = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('bvU+Fd1WnZ', 0, ($this->targetDir.''.'/pools/app'), new \Symfony\Component\Cache\Marshaller\DefaultMarshaller(NULL, true));
        $a->setLogger(($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService()));

        return $this->services['cache.app'] = new \Symfony\Component\Cache\Adapter\TraceableAdapter($a);
    }

    /**
     * Gets the public 'cache.system' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\TraceableAdapter
     */
    protected function getCache_SystemService()
    {
        return $this->services['cache.system'] = new \Symfony\Component\Cache\Adapter\TraceableAdapter(\Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('WNUtQiB0GJ', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService())));
    }

    /**
     * Gets the public 'cache.validator_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\TraceableAdapter
     */
    protected function getCache_ValidatorExpressionLanguageService()
    {
        return $this->services['cache.validator_expression_language'] = new \Symfony\Component\Cache\Adapter\TraceableAdapter(\Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('1XqRNjc7SM', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService())));
    }

    /**
     * Gets the public 'data_collector.dump' shared service.
     *
     * @return \Symfony\Component\HttpKernel\DataCollector\DumpDataCollector
     */
    protected function getDataCollector_DumpService()
    {
        return $this->services['data_collector.dump'] = new \Symfony\Component\HttpKernel\DataCollector\DumpDataCollector(($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true))), ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService()), 'UTF-8', ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['var_dumper.server_connection'] ?? $this->getVarDumper_ServerConnectionService()));
    }

    /**
     * Gets the public 'doctrine' shared service.
     *
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected function getDoctrineService()
    {
        return $this->services['doctrine'] = new \Doctrine\Bundle\DoctrineBundle\Registry($this, $this->parameters['doctrine.connections'], $this->parameters['doctrine.entity_managers'], 'default', 'default');
    }

    /**
     * Gets the public 'doctrine.dbal.default_connection' shared service.
     *
     * @return \Doctrine\DBAL\Connection
     */
    protected function getDoctrine_Dbal_DefaultConnectionService()
    {
        $a = new \Doctrine\DBAL\Configuration();

        $b = new \Symfony\Bridge\Monolog\Logger('doctrine');
        $b->pushProcessor(($this->privates['debug.log_processor'] ?? $this->getDebug_LogProcessorService()));
        $b->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        \Symfony\Bundle\FrameworkBundle\DependencyInjection\Compiler\AddDebugLogProcessorPass::configureLogger($b);
        $c = new \Doctrine\Bundle\DoctrineBundle\Middleware\DebugMiddleware(($this->privates['doctrine.debug_data_holder'] ?? ($this->privates['doctrine.debug_data_holder'] = new \Doctrine\Bundle\DoctrineBundle\Middleware\BacktraceDebugDataHolder([]))), ($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true))));
        $c->setConnectionName('default');

        $a->setSchemaManagerFactory(new \Doctrine\DBAL\Schema\LegacySchemaManagerFactory());
        $a->setSchemaAssetsFilter(new \Doctrine\Bundle\DoctrineBundle\Dbal\SchemaAssetsFilterManager([0 => ($this->privates['doctrine_migrations.schema_filter_listener'] ?? ($this->privates['doctrine_migrations.schema_filter_listener'] = new \Doctrine\Bundle\MigrationsBundle\EventListener\SchemaFilterListener('doctrine_migration_versions')))]));
        $a->setMiddlewares([0 => new \Doctrine\DBAL\Logging\Middleware($b), 1 => $c]);

        return $this->services['doctrine.dbal.default_connection'] = (new \Doctrine\Bundle\DoctrineBundle\ConnectionFactory([], new \Doctrine\DBAL\Tools\DsnParser(['db2' => 'ibm_db2', 'mssql' => 'pdo_sqlsrv', 'mysql' => 'pdo_mysql', 'mysql2' => 'pdo_mysql', 'postgres' => 'pdo_pgsql', 'postgresql' => 'pdo_pgsql', 'pgsql' => 'pdo_pgsql', 'sqlite' => 'pdo_sqlite', 'sqlite3' => 'pdo_sqlite'])))->createConnection(['driver' => 'pdo_mysql', 'charset' => 'utf8mb4', 'url' => $this->getEnv('DATABASE_URL'), 'idle_connection_ttl' => 600, 'host' => 'localhost', 'port' => NULL, 'user' => 'root', 'password' => NULL, 'driverOptions' => [1002 => 'SET sql_mode=(SELECT REPLACE(@@sql_mode, "ONLY_FULL_GROUP_BY", ""))'], 'serverVersion' => '5.7', 'defaultTableOptions' => ['charset' => 'utf8mb4', 'collate' => 'utf8mb4_unicode_ci']], $a, ($this->privates['doctrine.dbal.default_connection.event_manager'] ?? $this->getDoctrine_Dbal_DefaultConnection_EventManagerService()), []);
    }

    /**
     * Gets the public 'doctrine.orm.default_entity_manager' shared service.
     *
     * @return \Doctrine\ORM\EntityManager
     */
    protected function getDoctrine_Orm_DefaultEntityManagerService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['doctrine.orm.default_entity_manager'] = $this->createProxy('EntityManager_9a5be93', function () {
                return \EntityManager_9a5be93::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getDoctrine_Orm_DefaultEntityManagerService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 4).'/vendor/doctrine/common/src/Proxy/Autoloader.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Proxy/Autoloader.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/ObjectManager.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/EntityManagerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/EntityManager.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Configuration.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Mapping/MappingDriver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/persistence/src/Persistence/Mapping/Driver/MappingDriverChain.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/NamingStrategy.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/UnderscoreNamingStrategy.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/QuoteStrategy.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Internal/SQLResultCasing.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/DefaultQuoteStrategy.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/TypedFieldMapper.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/DefaultTypedFieldMapper.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Mapping/EntityListenerResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Mapping/EntityListenerServiceResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Mapping/ContainerEntityListenerResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/orm/src/Repository/RepositoryFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Repository/RepositoryFactoryCompatibility.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Repository/ContainerRepositoryFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/ManagerConfigurator.php';

        $a = new \Doctrine\ORM\Configuration();

        $b = new \Doctrine\Persistence\Mapping\Driver\MappingDriverChain();

        $c = ($this->privates['doctrine.orm.default_annotation_metadata_driver'] ?? $this->getDoctrine_Orm_DefaultAnnotationMetadataDriverService());

        $b->addDriver($c, 'App\\Entity');
        $b->addDriver($c, 'Webkul\\UVDesk\\CoreFrameworkBundle\\Entity');
        $b->addDriver($c, 'Webkul\\UVDesk\\AutomationBundle\\Entity');
        $b->addDriver($c, 'Webkul\\UVDesk\\SupportCenterBundle\\Entity');
        $b->addDriver($c, 'Webkul\\UVDesk\\ApiBundle\\Entity');

        $a->setEntityNamespaces(['App' => 'App\\Entity', 'UVDeskCoreFrameworkBundle' => 'Webkul\\UVDesk\\CoreFrameworkBundle\\Entity', 'UVDeskAutomationBundle' => 'Webkul\\UVDesk\\AutomationBundle\\Entity', 'UVDeskSupportCenterBundle' => 'Webkul\\UVDesk\\SupportCenterBundle\\Entity', 'UVDeskApiBundle' => 'Webkul\\UVDesk\\ApiBundle\\Entity']);
        $a->setMetadataCache(new \Symfony\Component\Cache\Adapter\ArrayAdapter());
        $a->setQueryCache(($this->privates['cache.doctrine.orm.default.query'] ?? $this->getCache_Doctrine_Orm_Default_QueryService()));
        $a->setResultCache(($this->privates['cache.doctrine.orm.default.result'] ?? $this->getCache_Doctrine_Orm_Default_ResultService()));
        $a->setMetadataDriverImpl(new \Doctrine\Bundle\DoctrineBundle\Mapping\MappingDriver($b, new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'doctrine.ulid_generator' => ['privates', 'doctrine.ulid_generator', 'getDoctrine_UlidGeneratorService', true],
            'doctrine.uuid_generator' => ['privates', 'doctrine.uuid_generator', 'getDoctrine_UuidGeneratorService', true],
        ], [
            'doctrine.ulid_generator' => '?',
            'doctrine.uuid_generator' => '?',
        ])));
        $a->setProxyDir(($this->targetDir.''.'/doctrine/orm/Proxies'));
        $a->setProxyNamespace('Proxies');
        $a->setAutoGenerateProxyClasses(true);
        $a->setSchemaIgnoreClasses([]);
        $a->setClassMetadataFactoryName('Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ClassMetadataFactory');
        $a->setDefaultRepositoryClassName('Doctrine\\ORM\\EntityRepository');
        $a->setNamingStrategy(new \Doctrine\ORM\Mapping\UnderscoreNamingStrategy());
        $a->setQuoteStrategy(new \Doctrine\ORM\Mapping\DefaultQuoteStrategy());
        $a->setTypedFieldMapper(new \Doctrine\ORM\Mapping\DefaultTypedFieldMapper());
        $a->setEntityListenerResolver(new \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver($this));
        $a->setLazyGhostObjectEnabled(false);
        $a->setIdentityGenerationPreferences([]);
        $a->setRepositoryFactory(new \Doctrine\Bundle\DoctrineBundle\Repository\ContainerRepositoryFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'Webkul\\UVDesk\\ApiBundle\\Repository\\ApiAccessCredentialRepository' => ['privates', 'Webkul\\UVDesk\\ApiBundle\\Repository\\ApiAccessCredentialRepository', 'getApiAccessCredentialRepositoryService', true],
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\AgentActivityRepository' => ['privates', 'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\AgentActivityRepository', 'getAgentActivityRepositoryService', true],
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\Microsoft\\MicrosoftAccountRepository' => ['privates', 'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\Microsoft\\MicrosoftAccountRepository', 'getMicrosoftAccountRepositoryService', true],
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\Microsoft\\MicrosoftAppRepository' => ['privates', 'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\Microsoft\\MicrosoftAppRepository', 'getMicrosoftAppRepositoryService', true],
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\RecaptchaRepository' => ['privates', 'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\RecaptchaRepository', 'getRecaptchaRepositoryService', true],
            'Webkul\\UVDesk\\SupportCenterBundle\\Repository\\AnnouncementRepository' => ['privates', 'Webkul\\UVDesk\\SupportCenterBundle\\Repository\\AnnouncementRepository', 'getAnnouncementRepositoryService', true],
            'Webkul\\UVDesk\\SupportCenterBundle\\Repository\\MarketingModuleRepository' => ['privates', 'Webkul\\UVDesk\\SupportCenterBundle\\Repository\\MarketingModuleRepository', 'getMarketingModuleRepositoryService', true],
        ], [
            'Webkul\\UVDesk\\ApiBundle\\Repository\\ApiAccessCredentialRepository' => '?',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\AgentActivityRepository' => '?',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\Microsoft\\MicrosoftAccountRepository' => '?',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\Microsoft\\MicrosoftAppRepository' => '?',
            'Webkul\\UVDesk\\CoreFrameworkBundle\\Repository\\RecaptchaRepository' => '?',
            'Webkul\\UVDesk\\SupportCenterBundle\\Repository\\AnnouncementRepository' => '?',
            'Webkul\\UVDesk\\SupportCenterBundle\\Repository\\MarketingModuleRepository' => '?',
        ])));

        $instance = new \Doctrine\ORM\EntityManager(($this->services['doctrine.dbal.default_connection'] ?? $this->getDoctrine_Dbal_DefaultConnectionService()), $a, ($this->privates['doctrine.dbal.default_connection.event_manager'] ?? $this->getDoctrine_Dbal_DefaultConnection_EventManagerService()));

        (new \Doctrine\Bundle\DoctrineBundle\ManagerConfigurator([], []))->configure($instance);

        return $instance;
    }

    /**
     * Gets the public 'email.service' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\Services\EmailService
     */
    protected function getEmail_ServiceService()
    {
        return $this->services['email.service'] = new \Webkul\UVDesk\CoreFrameworkBundle\Services\EmailService($this, ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->services['.container.private.session'] ?? $this->get_Container_Private_SessionService()), ($this->privates['Webkul\\UVDesk\\MailboxBundle\\Services\\MailboxService'] ?? $this->getMailboxServiceService()), ($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Services\\MicrosoftIntegration'] ?? $this->getMicrosoftIntegrationService()));
    }

    /**
     * Gets the public 'event_dispatcher' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Debug\TraceableEventDispatcher
     */
    protected function getEventDispatcherService()
    {
        $a = new \Symfony\Bridge\Monolog\Logger('event');
        $a->pushProcessor(($this->privates['debug.log_processor'] ?? $this->getDebug_LogProcessorService()));
        $a->pushHandler(new \Monolog\Handler\NullHandler());
        \Symfony\Bundle\FrameworkBundle\DependencyInjection\Compiler\AddDebugLogProcessorPass::configureLogger($a);

        $this->services['event_dispatcher'] = $instance = new \Symfony\Component\HttpKernel\Debug\TraceableEventDispatcher(new \Symfony\Component\EventDispatcher\EventDispatcher(), ($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true))), $a, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));

        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\Console\\Console'] ?? $this->load('getConsoleService'));
        }, 1 => 'onConsoleCommand'], 0);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\Console\\Console'] ?? $this->load('getConsoleService'));
        }, 1 => 'onConsoleTerminate'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\Logout'] ?? $this->load('getLogoutService'));
        }, 1 => 'onLogout'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\SessionLifetime'] ?? $this->getSessionLifetimeService());
        }, 1 => 'onKernelRequest'], 0);
        $instance->addListener('uvdesk.automation.prepared_response.execute', [0 => function () {
            return ($this->services['uvdesk.automations.prepared_responses'] ?? $this->load('getUvdesk_Automations_PreparedResponsesService'));
        }, 1 => 'executePreparedResponse'], 0);
        $instance->addListener('uvdesk.automation.workflow.execute', [0 => function () {
            return ($this->services['uvdesk.automations.workflows'] ?? $this->load('getUvdesk_Automations_WorkflowsService'));
        }, 1 => 'executeWorkflow'], 0);
        $instance->addListener('uvdesk.automation.report_app.workflow.execute', [0 => function () {
            return ($this->services['uvdesk.automations.workflows'] ?? $this->load('getUvdesk_Automations_WorkflowsService'));
        }, 1 => 'executeReplyEvent'], 0);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\ExtensionFrameworkBundle\\EventListener\\Console'] ?? $this->load('getConsole2Service'));
        }, 1 => 'onConsoleCommand'], 0);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\ExtensionFrameworkBundle\\EventListener\\Console'] ?? $this->load('getConsole2Service'));
        }, 1 => 'onConsoleTerminate'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\ExtensionFrameworkBundle\\EventListener\\Kernel'] ?? $this->getKernel2Service());
        }, 1 => 'onKernelRequest'], 0);
        $instance->addListener('kernel.controller_arguments', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\ExtensionFrameworkBundle\\EventListener\\Kernel'] ?? $this->getKernel2Service());
        }, 1 => 'onKernelControllerArguments'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\ApiBundle\\EventListeners\\API\\KernelException'] ?? $this->load('getKernelExceptionService'));
        }, 1 => 'onKernelException'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\ApiBundle\\EventListeners\\API\\KernelRequest'] ?? $this->getKernelRequestService());
        }, 1 => 'onKernelRequest'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Webkul\\UVDesk\\ApiBundle\\EventListeners\\API\\KernelRequest'] ?? $this->getKernelRequestService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['data_collector.router'] ?? ($this->privates['data_collector.router'] = new \Symfony\Bundle\FrameworkBundle\DataCollector\RouterDataCollector()));
        }, 1 => 'onKernelController'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['knp_paginator.subscriber.sliding_pagination'] ?? $this->getKnpPaginator_Subscriber_SlidingPaginationService());
        }, 1 => 'onKernelRequest'], 0);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['doctrine_migrations.schema_filter_listener'] ?? ($this->privates['doctrine_migrations.schema_filter_listener'] = new \Doctrine\Bundle\MigrationsBundle\EventListener\SchemaFilterListener('doctrine_migration_versions')));
        }, 1 => 'onConsoleCommand'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['App\\EventListener\\ExceptionSubscriber'] ?? $this->load('getExceptionSubscriberService'));
        }, 1 => 'onKernelException'], 10);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['response_listener'] ?? ($this->privates['response_listener'] = new \Symfony\Component\HttpKernel\EventListener\ResponseListener('UTF-8', false)));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['streamed_response_listener'] ?? ($this->privates['streamed_response_listener'] = new \Symfony\Component\HttpKernel\EventListener\StreamedResponseListener()));
        }, 1 => 'onKernelResponse'], -1024);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListenerService());
        }, 1 => 'setDefaultLocale'], 100);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListenerService());
        }, 1 => 'onKernelRequest'], 16);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListenerService());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['validate_request_listener'] ?? ($this->privates['validate_request_listener'] = new \Symfony\Component\HttpKernel\EventListener\ValidateRequestListener()));
        }, 1 => 'onKernelRequest'], 256);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['disallow_search_engine_index_response_listener'] ?? ($this->privates['disallow_search_engine_index_response_listener'] = new \Symfony\Component\HttpKernel\EventListener\DisallowRobotsIndexingListener()));
        }, 1 => 'onResponse'], -255);
        $instance->addListener('kernel.controller_arguments', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'onControllerArguments'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'logKernelException'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'onKernelException'], -128);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'removeCspHeader'], -128);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_aware_listener'] ?? $this->getLocaleAwareListenerService());
        }, 1 => 'onKernelRequest'], 15);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['locale_aware_listener'] ?? $this->getLocaleAwareListenerService());
        }, 1 => 'onKernelFinishRequest'], -15);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['console.error_listener'] ?? $this->load('getConsole_ErrorListenerService'));
        }, 1 => 'onConsoleError'], -128);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['console.error_listener'] ?? $this->load('getConsole_ErrorListenerService'));
        }, 1 => 'onConsoleTerminate'], -128);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['console.suggest_missing_package_subscriber'] ?? ($this->privates['console.suggest_missing_package_subscriber'] = new \Symfony\Bundle\FrameworkBundle\EventListener\SuggestMissingPackageSubscriber()));
        }, 1 => 'onConsoleError'], 0);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['mailer.envelope_listener'] ?? ($this->privates['mailer.envelope_listener'] = new \Symfony\Component\Mailer\EventListener\EnvelopeListener(NULL, NULL)));
        }, 1 => 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['mailer.message_logger_listener'] ?? ($this->privates['mailer.message_logger_listener'] = new \Symfony\Component\Mailer\EventListener\MessageLoggerListener()));
        }, 1 => 'onMessage'], -255);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['debug.debug_handlers_listener'] ?? $this->getDebug_DebugHandlersListenerService());
        }, 1 => 'configure'], 2048);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['debug.debug_handlers_listener'] ?? $this->getDebug_DebugHandlersListenerService());
        }, 1 => 'configure'], 2048);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['router_listener'] ?? $this->getRouterListenerService());
        }, 1 => 'onKernelRequest'], 32);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['router_listener'] ?? $this->getRouterListenerService());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['router_listener'] ?? $this->getRouterListenerService());
        }, 1 => 'onKernelException'], -64);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['web_link.add_link_header_listener'] ?? ($this->privates['web_link.add_link_header_listener'] = new \Symfony\Component\WebLink\EventListener\AddLinkHeaderListener()));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onKernelRequest'], 128);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onKernelResponse'], -1000);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onFinishRequest'], 0);
        $instance->addListener('Symfony\\Component\\Notifier\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['notifier.logger_notification_listener'] ?? ($this->privates['notifier.logger_notification_listener'] = new \Symfony\Component\Notifier\EventListener\NotificationLoggerListener()));
        }, 1 => 'onNotification'], -255);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['profiler_listener'] ?? $this->getProfilerListenerService());
        }, 1 => 'onKernelResponse'], -100);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['profiler_listener'] ?? $this->getProfilerListenerService());
        }, 1 => 'onKernelException'], 0);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['profiler_listener'] ?? $this->getProfilerListenerService());
        }, 1 => 'onKernelTerminate'], -1024);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['data_collector.request'] ?? $this->getDataCollector_RequestService());
        }, 1 => 'onKernelController'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['data_collector.request'] ?? $this->getDataCollector_RequestService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('knp_pager.before', [0 => function () {
            return ($this->privates['knp_paginator.subscriber.paginate'] ?? ($this->privates['knp_paginator.subscriber.paginate'] = new \Knp\Component\Pager\Event\Subscriber\Paginate\PaginationSubscriber()));
        }, 1 => 'before'], 0);
        $instance->addListener('knp_pager.pagination', [0 => function () {
            return ($this->privates['knp_paginator.subscriber.paginate'] ?? ($this->privates['knp_paginator.subscriber.paginate'] = new \Knp\Component\Pager\Event\Subscriber\Paginate\PaginationSubscriber()));
        }, 1 => 'pagination'], 0);
        $instance->addListener('knp_pager.before', [0 => function () {
            return ($this->privates['knp_paginator.subscriber.sortable'] ?? ($this->privates['knp_paginator.subscriber.sortable'] = new \Knp\Component\Pager\Event\Subscriber\Sortable\SortableSubscriber()));
        }, 1 => 'before'], 1);
        $instance->addListener('knp_pager.before', [0 => function () {
            return ($this->privates['knp_paginator.subscriber.filtration'] ?? ($this->privates['knp_paginator.subscriber.filtration'] = new \Knp\Component\Pager\Event\Subscriber\Filtration\FiltrationSubscriber()));
        }, 1 => 'before'], 1);
        $instance->addListener('knp_pager.pagination', [0 => function () {
            return ($this->privates['knp_paginator.subscriber.sliding_pagination'] ?? $this->getKnpPaginator_Subscriber_SlidingPaginationService());
        }, 1 => 'pagination'], 1);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['sensio_framework_extra.controller.listener'] ?? $this->getSensioFrameworkExtra_Controller_ListenerService());
        }, 1 => 'onKernelController'], 0);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['sensio_framework_extra.converter.listener'] ?? $this->getSensioFrameworkExtra_Converter_ListenerService());
        }, 1 => 'onKernelController'], 0);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['sensio_framework_extra.view.listener'] ?? $this->getSensioFrameworkExtra_View_ListenerService());
        }, 1 => 'onKernelController'], -128);
        $instance->addListener('kernel.view', [0 => function () {
            return ($this->privates['sensio_framework_extra.view.listener'] ?? $this->getSensioFrameworkExtra_View_ListenerService());
        }, 1 => 'onKernelView'], 0);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['sensio_framework_extra.cache.listener'] ?? ($this->privates['sensio_framework_extra.cache.listener'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\HttpCacheListener()));
        }, 1 => 'onKernelController'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['sensio_framework_extra.cache.listener'] ?? ($this->privates['sensio_framework_extra.cache.listener'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\HttpCacheListener()));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.controller_arguments', [0 => function () {
            return ($this->privates['sensio_framework_extra.security.listener'] ?? $this->getSensioFrameworkExtra_Security_ListenerService());
        }, 1 => 'onKernelControllerArguments'], 0);
        $instance->addListener('kernel.controller_arguments', [0 => function () {
            return ($this->privates['framework_extra_bundle.event.is_granted'] ?? $this->getFrameworkExtraBundle_Event_IsGrantedService());
        }, 1 => 'onKernelControllerArguments'], 0);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['twig.mailer.message_listener'] ?? $this->load('getTwig_Mailer_MessageListenerService'));
        }, 1 => 'onMessage'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['web_profiler.debug_toolbar'] ?? $this->getWebProfiler_DebugToolbarService());
        }, 1 => 'onKernelResponse'], -128);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService());
        }, 1 => 'onCommand'], 255);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService());
        }, 1 => 'onTerminate'], -255);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['debug.dump_listener'] ?? $this->load('getDebug_DumpListenerService'));
        }, 1 => 'configure'], 1024);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['maker.console_error_listener'] ?? ($this->privates['maker.console_error_listener'] = new \Symfony\Bundle\MakerBundle\Event\ConsoleErrorSubscriber()));
        }, 1 => 'onConsoleError'], 0);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['maker.console_error_listener'] ?? ($this->privates['maker.console_error_listener'] = new \Symfony\Bundle\MakerBundle\Event\ConsoleErrorSubscriber()));
        }, 1 => 'onConsoleTerminate'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['security.rememberme.response_listener'] ?? ($this->privates['security.rememberme.response_listener'] = new \Symfony\Component\Security\Http\RememberMe\ResponseListener()));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('debug.security.authorization.vote', [0 => function () {
            return ($this->privates['debug.security.voter.vote_listener'] ?? $this->load('getDebug_Security_Voter_VoteListenerService'));
        }, 1 => 'onVoterVote'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['debug.security.firewall'] ?? $this->getDebug_Security_FirewallService());
        }, 1 => 'configureLogoutUrlGenerator'], 8);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['debug.security.firewall'] ?? $this->getDebug_Security_FirewallService());
        }, 1 => 'onKernelRequest'], 8);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['debug.security.firewall'] ?? $this->getDebug_Security_FirewallService());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['swiftmailer.email_sender.listener'] ?? $this->load('getSwiftmailer_EmailSender_ListenerService'));
        }, 1 => 'onException'], 0);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['swiftmailer.email_sender.listener'] ?? $this->load('getSwiftmailer_EmailSender_ListenerService'));
        }, 1 => 'onTerminate'], 0);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['swiftmailer.email_sender.listener'] ?? $this->load('getSwiftmailer_EmailSender_ListenerService'));
        }, 1 => 'onException'], 0);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['swiftmailer.email_sender.listener'] ?? $this->load('getSwiftmailer_EmailSender_ListenerService'));
        }, 1 => 'onTerminate'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [0 => function () {
            return ($this->privates['security.logout.listener.csrf_token_clearing'] ?? $this->load('getSecurity_Logout_Listener_CsrfTokenClearingService'));
        }, 1 => 'onLogout'], 0);

        return $instance;
    }

    /**
     * Gets the public 'http_kernel' shared service.
     *
     * @return \Symfony\Component\HttpKernel\HttpKernel
     */
    protected function getHttpKernelService()
    {
        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['http_kernel'])) {
            return $this->services['http_kernel'];
        }
        $b = ($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true)));

        return $this->services['http_kernel'] = new \Symfony\Component\HttpKernel\HttpKernel($a, new \Symfony\Component\HttpKernel\Controller\TraceableControllerResolver(new \Symfony\Bundle\FrameworkBundle\Controller\ControllerResolver($this, ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService())), $b), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), new \Symfony\Component\HttpKernel\Controller\TraceableArgumentResolver(new \Symfony\Component\HttpKernel\Controller\ArgumentResolver(($this->privates['argument_metadata_factory'] ?? ($this->privates['argument_metadata_factory'] = new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory())), new RewindableGenerator(function () {
            yield 0 => ($this->privates['debug.argument_resolver.request_attribute'] ?? $this->load('getDebug_ArgumentResolver_RequestAttributeService'));
            yield 1 => ($this->privates['debug.argument_resolver.request'] ?? $this->load('getDebug_ArgumentResolver_RequestService'));
            yield 2 => ($this->privates['debug.argument_resolver.session'] ?? $this->load('getDebug_ArgumentResolver_SessionService'));
            yield 3 => ($this->privates['debug.security.user_value_resolver'] ?? $this->load('getDebug_Security_UserValueResolverService'));
            yield 4 => ($this->privates['debug.argument_resolver.service'] ?? $this->load('getDebug_ArgumentResolver_ServiceService'));
            yield 5 => ($this->privates['debug.argument_resolver.default'] ?? $this->load('getDebug_ArgumentResolver_DefaultService'));
            yield 6 => ($this->privates['debug.argument_resolver.variadic'] ?? $this->load('getDebug_ArgumentResolver_VariadicService'));
            yield 7 => ($this->privates['debug.argument_resolver.not_tagged_controller'] ?? $this->load('getDebug_ArgumentResolver_NotTaggedControllerService'));
        }, 8)), $b));
    }

    /**
     * Gets the public 'monolog.logger.deprecation' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_DeprecationService()
    {
        $this->services['monolog.logger.deprecation'] = $instance = new \Symfony\Bridge\Monolog\Logger('deprecation');

        $instance->pushProcessor(($this->privates['debug.log_processor'] ?? $this->getDebug_LogProcessorService()));
        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        \Symfony\Bundle\FrameworkBundle\DependencyInjection\Compiler\AddDebugLogProcessorPass::configureLogger($instance);

        return $instance;
    }

    /**
     * Gets the public 'recaptcha.service' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\Services\ReCaptchaService
     */
    protected function getRecaptcha_ServiceService()
    {
        return $this->services['recaptcha.service'] = new \Webkul\UVDesk\CoreFrameworkBundle\Services\ReCaptchaService(($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $this);
    }

    /**
     * Gets the public 'request_stack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected function getRequestStackService()
    {
        return $this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack();
    }

    /**
     * Gets the public 'router' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Routing\Router
     */
    protected function getRouterService()
    {
        $a = new \Symfony\Bridge\Monolog\Logger('router');
        $a->pushProcessor(($this->privates['debug.log_processor'] ?? $this->getDebug_LogProcessorService()));
        $a->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $a->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        \Symfony\Bundle\FrameworkBundle\DependencyInjection\Compiler\AddDebugLogProcessorPass::configureLogger($a);

        $this->services['router'] = $instance = new \Symfony\Bundle\FrameworkBundle\Routing\Router((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'routing.loader' => ['services', 'routing.loader', 'getRouting_LoaderService', true],
        ], [
            'routing.loader' => 'Symfony\\Component\\Config\\Loader\\LoaderInterface',
        ]))->withContext('router.default', $this), 'kernel::loadRoutes', ['cache_dir' => $this->targetDir.'', 'debug' => true, 'generator_class' => 'Symfony\\Component\\Routing\\Generator\\CompiledUrlGenerator', 'generator_dumper_class' => 'Symfony\\Component\\Routing\\Generator\\Dumper\\CompiledUrlGeneratorDumper', 'matcher_class' => 'Symfony\\Bundle\\FrameworkBundle\\Routing\\RedirectableCompiledUrlMatcher', 'matcher_dumper_class' => 'Symfony\\Component\\Routing\\Matcher\\Dumper\\CompiledUrlMatcherDumper', 'strict_requirements' => true, 'resource_type' => 'service'], ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService()), ($this->privates['parameter_bag'] ?? ($this->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($this))), $a, 'en');

        $instance->setConfigCacheFactory(($this->privates['config_cache_factory'] ?? $this->getConfigCacheFactoryService()));
        $instance->addExpressionLanguageProvider(($this->privates['router.expression_language_provider'] ?? $this->getRouter_ExpressionLanguageProviderService()));

        return $instance;
    }

    /**
     * Gets the public 'swiftmailer.service' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\SwiftMailer\SwiftMailer
     */
    protected function getSwiftmailer_ServiceService()
    {
        return $this->services['swiftmailer.service'] = new \Webkul\UVDesk\CoreFrameworkBundle\SwiftMailer\SwiftMailer($this);
    }

    /**
     * Gets the public 'ticket.service' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\Services\TicketService
     */
    protected function getTicket_ServiceService()
    {
        $a = ($this->services['user.service'] ?? $this->getUser_ServiceService());

        if (isset($this->services['ticket.service'])) {
            return $this->services['ticket.service'];
        }

        return $this->services['ticket.service'] = new \Webkul\UVDesk\CoreFrameworkBundle\Services\TicketService($this, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Services\\FileUploadService'] ?? $this->getFileUploadServiceService()), $a, ($this->privates['Webkul\\UVDesk\\MailboxBundle\\Services\\MailboxService'] ?? $this->getMailboxServiceService()), ($this->services['translator'] ?? $this->getTranslatorService()));
    }

    /**
     * Gets the public 'translator' shared service.
     *
     * @return \Symfony\Component\Translation\DataCollectorTranslator
     */
    protected function getTranslatorService()
    {
        return $this->services['translator'] = new \Symfony\Component\Translation\DataCollectorTranslator(($this->privates['translator.default'] ?? $this->getTranslator_DefaultService()));
    }

    /**
     * Gets the public 'user.service' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\Services\UserService
     */
    protected function getUser_ServiceService()
    {
        $a = ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService());

        if (isset($this->services['user.service'])) {
            return $this->services['user.service'];
        }

        return $this->services['user.service'] = new \Webkul\UVDesk\CoreFrameworkBundle\Services\UserService($this, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), $a);
    }

    /**
     * Gets the public 'uvdesk.automations' shared autowired service.
     *
     * @return \Webkul\UVDesk\AutomationBundle\Services\AutomationService
     */
    protected function getUvdesk_AutomationsService()
    {
        return $this->services['uvdesk.automations'] = new \Webkul\UVDesk\AutomationBundle\Services\AutomationService($this, ($this->services['translator'] ?? $this->getTranslatorService()));
    }

    /**
     * Gets the public 'uvdesk.core.file_system.service' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\FileSystem\FileSystem
     */
    protected function getUvdesk_Core_FileSystem_ServiceService()
    {
        return $this->services['uvdesk.core.file_system.service'] = new \Webkul\UVDesk\CoreFrameworkBundle\FileSystem\FileSystem($this, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /**
     * Gets the public 'uvdesk.extensibles' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\Framework\ExtendableComponentManager
     */
    protected function getUvdesk_ExtensiblesService()
    {
        $this->services['uvdesk.extensibles'] = $instance = new \Webkul\UVDesk\CoreFrameworkBundle\Framework\ExtendableComponentManager($this);

        $a = ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()));
        $b = ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService());
        $c = ($this->services['user.service'] ?? $this->getUser_ServiceService());

        $d = new \Webkul\UVDesk\CoreFrameworkBundle\Dashboard\AsideTemplate($a, $b, $c);
        $d->addPanelSidebar(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Sidebars\Account());
        $d->addPanelSidebar(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Sidebars\Apps());
        $d->addPanelSidebar(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Sidebars\Branding());
        $d->addPanelSidebar(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Sidebars\Productivity());
        $d->addPanelSidebar(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Sidebars\Reports());
        $d->addPanelSidebar(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Sidebars\Settings());
        $d->addPanelSidebar(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Sidebars\Users());
        $d->addPanelSidebar(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Panel\Sidebars\Knowledgebase());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Account\Profile());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Productivity\SavedReplies());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Productivity\Tags());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Productivity\TicketTypes());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Reports\AgentActivity());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Reports\Kudos());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Settings\Branding());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Settings\EmailSettings());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Settings\EmailTemplates());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Settings\MicrosoftApps());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Settings\SwiftMailer());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Themes\Helpdesk());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Users\Agents());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Users\Customers());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Users\Groups());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Users\Privileges());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Panel\Items\Users\Teams());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\AutomationBundle\UIComponents\Dashboard\Panel\Items\Productivity\PreparedResponses());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\AutomationBundle\UIComponents\Dashboard\Panel\Items\Productivity\Workflows());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\MailboxBundle\UIComponents\Dashboard\Panel\Items\Settings\Mailboxes());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Panel\Items\Knowledgebase\Announcement());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Panel\Items\Knowledgebase\Articles());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Panel\Items\Knowledgebase\Categories());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Panel\Items\Knowledgebase\Folders());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Panel\Items\Knowledgebase\MarketingModule());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Panel\Items\Settings\BlockSpam());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Panel\Items\Themes\SupportCenter());
        $d->addPanelSidebarItem(new \Webkul\UVDesk\ApiBundle\UIComponents\Dashboard\Panel\Items\Settings\ApiSettings());
        $e = ($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Dashboard\\DashboardTemplate'] ?? $this->getDashboardTemplateService());
        $f = ($this->services['router'] ?? $this->getRouterService());
        $g = ($this->services['translator'] ?? $this->getTranslatorService());

        $h = new \Webkul\UVDesk\CoreFrameworkBundle\Dashboard\NavigationTemplate($this, $a, $f, $c, $g);
        $i = new \Webkul\UVDesk\CoreFrameworkBundle\Dashboard\HomepageTemplate($f, $c, $g);

        $j = new \Webkul\UVDesk\CoreFrameworkBundle\Dashboard\Dashboard($e, $h, $i);
        $j->appendNavigation(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Navigation\Home());
        $j->appendNavigation(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Navigation\Reports());
        $j->appendNavigation(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Navigation\Ticket());
        $j->appendNavigation(new \Webkul\UVDesk\ExtensionFrameworkBundle\UIComponents\Dashboard\Navigation\Apps());
        $j->appendNavigation(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Navigation\Knowledgebase());
        $j->appendHomepageSection(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Sections\Productivity());
        $j->appendHomepageSection(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Sections\Reports());
        $j->appendHomepageSection(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Sections\Settings());
        $j->appendHomepageSection(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Sections\Users());
        $j->appendHomepageSection(new \Webkul\UVDesk\ExtensionFrameworkBundle\UIComponents\Dashboard\Homepage\Sections\Apps());
        $j->appendHomepageSection(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Homepage\Sections\Knowledgebase());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\AgentActivity());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\Agents());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\Branding());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\Customers());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\EmailSettings());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\EmailTemplates());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\Groups());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\Kudos());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\MicrosoftApps());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\Privileges());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\SavedReplies());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\SwiftMailer());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\Tags());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\Teams());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Homepage\Items\TicketTypes());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\AutomationBundle\UIComponents\Dashboard\Homepage\Items\PreparedResponses());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\AutomationBundle\UIComponents\Dashboard\Homepage\Items\Workflows());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\ExtensionFrameworkBundle\UIComponents\Dashboard\Homepage\Items\ExploreApps());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\MailboxBundle\UIComponents\Dashboard\Homepage\Items\Mailbox());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Homepage\Items\Announcement());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Homepage\Items\Articles());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Homepage\Items\Categories());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Homepage\Items\Folders());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Homepage\Items\MarketingModule());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Homepage\Items\SpamSettings());
        $j->appendHomepageSectionItem(new \Webkul\UVDesk\ApiBundle\UIComponents\Dashboard\Homepage\Items\ApiSettings());
        $k = new \Webkul\UVDesk\CoreFrameworkBundle\Dashboard\SearchTemplate($b, $g, $c);
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\AgentActivity());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\Agents());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\Apps());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\Branding());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\EmailSettings());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\EmailTemplates());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\Groups());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\Kudos());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\MicrosoftApps());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\Privileges());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\SavedReplies());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\Tags());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\Teams());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\TicketTypes());
        $k->appendSearchItem(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Dashboard\Search\Tickets());
        $k->appendSearchItem(new \Webkul\UVDesk\AutomationBundle\UIComponents\Dashboard\Search\PreparedResponses());
        $k->appendSearchItem(new \Webkul\UVDesk\AutomationBundle\UIComponents\Dashboard\Search\Workflows());
        $k->appendSearchItem(new \Webkul\UVDesk\ExtensionFrameworkBundle\UIComponents\Dashboard\Search\Apps());
        $k->appendSearchItem(new \Webkul\UVDesk\MailboxBundle\UIComponents\Dashboard\Search\Mailbox());
        $k->appendSearchItem(new \Webkul\UVDesk\MailboxBundle\UIComponents\Dashboard\Search\SwiftMailer());
        $k->appendSearchItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Search\Announcement());
        $k->appendSearchItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Search\Articles());
        $k->appendSearchItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Search\Categories());
        $k->appendSearchItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Search\Customers());
        $k->appendSearchItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Search\Folders());
        $k->appendSearchItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Search\MarketingModule());
        $k->appendSearchItem(new \Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Search\SpamSettings());
        $k->appendSearchItem(new \Webkul\UVDesk\ApiBundle\UIComponents\Dashboard\Search\ApiSettings());

        $instance->addComponent($d);
        $instance->addComponent($j);
        $instance->addComponent($e);
        $instance->addComponent($i);
        $instance->addComponent($h);
        $instance->addComponent($k);
        $instance->addComponent(($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Tickets\\QuickActionButtonCollection'] ?? $this->getQuickActionButtonCollectionService()));
        $instance->addComponent(new \Webkul\UVDesk\CoreFrameworkBundle\Tickets\WidgetCollection());

        return $instance;
    }

    /**
     * Gets the public 'uvdesk.service' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\Services\UVDeskService
     */
    protected function getUvdesk_ServiceService()
    {
        $a = ($this->services['user.service'] ?? $this->getUser_ServiceService());

        if (isset($this->services['uvdesk.service'])) {
            return $this->services['uvdesk.service'];
        }

        return $this->services['uvdesk.service'] = new \Webkul\UVDesk\CoreFrameworkBundle\Services\UVDeskService($this, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), $a);
    }

    /**
     * Gets the public 'uvdesk_extension.assets_manager' shared service.
     *
     * @return \Symfony\Component\Asset\Packages
     */
    protected function getUvdeskExtension_AssetsManagerService()
    {
        $a = ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService());

        return $this->services['uvdesk_extension.assets_manager'] = new \Symfony\Component\Asset\Packages(new \Symfony\Component\Asset\PathPackage('', new \Symfony\Component\Asset\VersionStrategy\EmptyVersionStrategy(), new \Symfony\Component\Asset\Context\RequestStackContext(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $a->getBaseUrl(), $a->isSecure())), new RewindableGenerator(function () {
            return new \EmptyIterator();
        }, 0));
    }

    /**
     * Gets the public 'uvdesk_extension.twig_loader' shared service.
     *
     * @return \Twig\Loader\FilesystemLoader
     */
    protected function getUvdeskExtension_TwigLoaderService()
    {
        $this->services['uvdesk_extension.twig_loader'] = $instance = new \Twig\Loader\FilesystemLoader([], \dirname(__DIR__, 4));

        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Resources/views'), 'UVDeskCoreFramework');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Resources/views'), '!UVDeskCoreFramework');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/Resources/views'), 'UVDeskAutomation');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/Resources/views'), '!UVDeskAutomation');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/extension-framework/Resources/views'), 'UVDeskExtensionFramework');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/extension-framework/Resources/views'), '!UVDeskExtensionFramework');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/mailbox-component/Resources/views'), 'UVDeskMailbox');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/mailbox-component/Resources/views'), '!UVDeskMailbox');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/Resources/views'), 'UVDeskSupportCenter');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/Resources/views'), '!UVDeskSupportCenter');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/api-bundle/Resources/views'), 'UVDeskApi');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/uvdesk/api-bundle/Resources/views'), '!UVDeskApi');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/templates'), 'Doctrine');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/templates'), '!Doctrine');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/templates'), 'KnpPaginator');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/templates'), '!KnpPaginator');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/web-profiler-bundle/Resources/views'), 'WebProfiler');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/web-profiler-bundle/Resources/views'), '!WebProfiler');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/debug-bundle/Resources/views'), 'Debug');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/debug-bundle/Resources/views'), '!Debug');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-migrations-bundle/templates'), 'DoctrineMigrations');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-migrations-bundle/templates'), '!DoctrineMigrations');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Resources/views'), 'Security');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Resources/views'), '!Security');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/swiftmailer-bundle/Resources/views'), 'Swiftmailer');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/swiftmailer-bundle/Resources/views'), '!Swiftmailer');
        $instance->addPath((\dirname(__DIR__, 4).'/templates'));
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Resources/views/Email'), 'email');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Resources/views/Email'), '!email');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Resources/views/Form'));

        return $instance;
    }

    /**
     * Gets the public 'var_dumper.cloner' shared service.
     *
     * @return \Symfony\Component\VarDumper\Cloner\VarCloner
     */
    protected function getVarDumper_ClonerService()
    {
        $this->services['var_dumper.cloner'] = $instance = new \Symfony\Component\VarDumper\Cloner\VarCloner();

        $instance->setMaxItems(2500);
        $instance->setMinDepth(1);
        $instance->setMaxString(-1);
        $instance->addCasters(['Closure' => 'Symfony\\Component\\VarDumper\\Caster\\ReflectionCaster::unsetClosureFileInfo']);

        return $instance;
    }

    /**
     * Gets the private '.debug.http_client' shared service.
     *
     * @return \Symfony\Component\HttpClient\TraceableHttpClient
     */
    protected function get_Debug_HttpClientService()
    {
        $a = \Symfony\Component\HttpClient\HttpClient::create([], 6);

        $b = new \Symfony\Bridge\Monolog\Logger('http_client');
        $b->pushProcessor(($this->privates['debug.log_processor'] ?? $this->getDebug_LogProcessorService()));
        $b->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $b->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        \Symfony\Bundle\FrameworkBundle\DependencyInjection\Compiler\AddDebugLogProcessorPass::configureLogger($b);

        $a->setLogger($b);

        return $this->privates['.debug.http_client'] = new \Symfony\Component\HttpClient\TraceableHttpClient($a, ($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true))));
    }

    /**
     * Gets the private '.service_locator.Y0rYR9K' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected function get_ServiceLocator_Y0rYR9KService()
    {
        return $this->privates['.service_locator.Y0rYR9K'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'security.firewall.map.context.back_support' => ['privates', 'security.firewall.map.context.back_support', 'getSecurity_Firewall_Map_Context_BackSupportService', true],
            'security.firewall.map.context.customer' => ['privates', 'security.firewall.map.context.customer', 'getSecurity_Firewall_Map_Context_CustomerService', true],
            'security.firewall.map.context.dev' => ['privates', 'security.firewall.map.context.dev', 'getSecurity_Firewall_Map_Context_DevService', true],
            'security.firewall.map.context.uvdesk_api' => ['privates', 'security.firewall.map.context.uvdesk_api', 'getSecurity_Firewall_Map_Context_UvdeskApiService', true],
        ], [
            'security.firewall.map.context.back_support' => '?',
            'security.firewall.map.context.customer' => '?',
            'security.firewall.map.context.dev' => '?',
            'security.firewall.map.context.uvdesk_api' => '?',
        ]);
    }

    /**
     * Gets the private 'Webkul\UVDesk\ApiBundle\EventListeners\API\KernelRequest' shared autowired service.
     *
     * @return \Webkul\UVDesk\ApiBundle\EventListeners\API\KernelRequest
     */
    protected function getKernelRequestService()
    {
        $a = ($this->privates['security.firewall.map'] ?? $this->getSecurity_Firewall_MapService());

        if (isset($this->privates['Webkul\\UVDesk\\ApiBundle\\EventListeners\\API\\KernelRequest'])) {
            return $this->privates['Webkul\\UVDesk\\ApiBundle\\EventListeners\\API\\KernelRequest'];
        }

        return $this->privates['Webkul\\UVDesk\\ApiBundle\\EventListeners\\API\\KernelRequest'] = new \Webkul\UVDesk\ApiBundle\EventListeners\API\KernelRequest($a);
    }

    /**
     * Gets the private 'Webkul\UVDesk\CoreFrameworkBundle\Dashboard\DashboardTemplate' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\Dashboard\DashboardTemplate
     */
    protected function getDashboardTemplateService()
    {
        return $this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Dashboard\\DashboardTemplate'] = new \Webkul\UVDesk\CoreFrameworkBundle\Dashboard\DashboardTemplate($this, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['router'] ?? $this->getRouterService()));
    }

    /**
     * Gets the private 'Webkul\UVDesk\CoreFrameworkBundle\EventListener\SessionLifetime' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\EventListener\SessionLifetime
     */
    protected function getSessionLifetimeService()
    {
        return $this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\SessionLifetime'] = new \Webkul\UVDesk\CoreFrameworkBundle\EventListener\SessionLifetime(new \Symfony\Component\Security\Core\Security(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'security.authorization_checker' => ['services', '.container.private.security.authorization_checker', 'get_Container_Private_Security_AuthorizationCheckerService', false],
            'security.token_storage' => ['services', '.container.private.security.token_storage', 'get_Container_Private_Security_TokenStorageService', false],
        ], [
            'security.authorization_checker' => '?',
            'security.token_storage' => '?',
        ])), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()));
    }

    /**
     * Gets the private 'Webkul\UVDesk\CoreFrameworkBundle\Services\FileUploadService' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\Services\FileUploadService
     */
    protected function getFileUploadServiceService()
    {
        return $this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Services\\FileUploadService'] = new \Webkul\UVDesk\CoreFrameworkBundle\Services\FileUploadService($this, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /**
     * Gets the private 'Webkul\UVDesk\CoreFrameworkBundle\Services\MicrosoftIntegration' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\Services\MicrosoftIntegration
     */
    protected function getMicrosoftIntegrationService()
    {
        return $this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Services\\MicrosoftIntegration'] = new \Webkul\UVDesk\CoreFrameworkBundle\Services\MicrosoftIntegration(($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()));
    }

    /**
     * Gets the private 'Webkul\UVDesk\CoreFrameworkBundle\Tickets\QuickActionButtonCollection' shared autowired service.
     *
     * @return \Webkul\UVDesk\CoreFrameworkBundle\Tickets\QuickActionButtonCollection
     */
    protected function getQuickActionButtonCollectionService()
    {
        $a = ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService());

        if (isset($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Tickets\\QuickActionButtonCollection'])) {
            return $this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Tickets\\QuickActionButtonCollection'];
        }
        $b = ($this->services['user.service'] ?? $this->getUser_ServiceService());

        if (isset($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Tickets\\QuickActionButtonCollection'])) {
            return $this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Tickets\\QuickActionButtonCollection'];
        }

        $this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Tickets\\QuickActionButtonCollection'] = $instance = new \Webkul\UVDesk\CoreFrameworkBundle\Tickets\QuickActionButtonCollection($a, ($this->privates['Webkul\\UVDesk\\CoreFrameworkBundle\\Dashboard\\DashboardTemplate'] ?? $this->getDashboardTemplateService()), $b);

        $instance->add(new \Webkul\UVDesk\CoreFrameworkBundle\UIComponents\Ticket\QuickActionButtons\SavedReplies(), [0 => []]);
        $instance->add(new \Webkul\UVDesk\AutomationBundle\UIComponents\Ticket\QuickActionButtons\PreparedResponses(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()))), [0 => []]);

        return $instance;
    }

    /**
     * Gets the private 'Webkul\UVDesk\ExtensionFrameworkBundle\EventListener\Kernel' shared autowired service.
     *
     * @return \Webkul\UVDesk\ExtensionFrameworkBundle\EventListener\Kernel
     */
    protected function getKernel2Service()
    {
        return $this->privates['Webkul\\UVDesk\\ExtensionFrameworkBundle\\EventListener\\Kernel'] = new \Webkul\UVDesk\ExtensionFrameworkBundle\EventListener\Kernel($this, ($this->privates['Webkul\\UVDesk\\ExtensionFrameworkBundle\\Definition\\MappingResource'] ?? ($this->privates['Webkul\\UVDesk\\ExtensionFrameworkBundle\\Definition\\MappingResource'] = new \Webkul\UVDesk\ExtensionFrameworkBundle\Definition\MappingResource())));
    }

    /**
     * Gets the private 'Webkul\UVDesk\MailboxBundle\Services\MailboxService' shared autowired service.
     *
     * @return \Webkul\UVDesk\MailboxBundle\Services\MailboxService
     */
    protected function getMailboxServiceService()
    {
        return $this->privates['Webkul\\UVDesk\\MailboxBundle\\Services\\MailboxService'] = new \Webkul\UVDesk\MailboxBundle\Services\MailboxService($this, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->services['swiftmailer.service'] ?? ($this->services['swiftmailer.service'] = new \Webkul\UVDesk\CoreFrameworkBundle\SwiftMailer\SwiftMailer($this))));
    }

    /**
     * Gets the private 'annotations.cache_adapter' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\PhpArrayAdapter
     */
    protected function getAnnotations_CacheAdapterService()
    {
        return \Symfony\Component\Cache\Adapter\PhpArrayAdapter::create(($this->targetDir.''.'/annotations.php'), ($this->privates['cache.annotations'] ?? $this->getCache_AnnotationsService()));
    }

    /**
     * Gets the private 'annotations.cached_reader' shared service.
     *
     * @return \Doctrine\Common\Annotations\PsrCachedReader
     */
    protected function getAnnotations_CachedReaderService()
    {
        return $this->privates['annotations.cached_reader'] = new \Doctrine\Common\Annotations\PsrCachedReader(($this->privates['annotations.reader'] ?? $this->getAnnotations_ReaderService()), $this->getAnnotations_CacheAdapterService(), true);
    }

    /**
     * Gets the private 'annotations.reader' shared service.
     *
     * @return \Doctrine\Common\Annotations\AnnotationReader
     */
    protected function getAnnotations_ReaderService()
    {
        $this->privates['annotations.reader'] = $instance = new \Doctrine\Common\Annotations\AnnotationReader();

        $a = new \Doctrine\Common\Annotations\AnnotationRegistry();
        $a->registerUniqueLoader('class_exists');

        $instance->addGlobalIgnoredName('required', $a);

        return $instance;
    }

    /**
     * Gets the private 'cache.annotations' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\TraceableAdapter
     */
    protected function getCache_AnnotationsService()
    {
        return $this->privates['cache.annotations'] = new \Symfony\Component\Cache\Adapter\TraceableAdapter(\Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('osx7Idnyzi', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService())));
    }

    /**
     * Gets the private 'cache.doctrine.orm.default.query' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\TraceableAdapter
     */
    protected function getCache_Doctrine_Orm_Default_QueryService()
    {
        return $this->privates['cache.doctrine.orm.default.query'] = new \Symfony\Component\Cache\Adapter\TraceableAdapter(new \Symfony\Component\Cache\Adapter\ArrayAdapter());
    }

    /**
     * Gets the private 'cache.doctrine.orm.default.result' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\TraceableAdapter
     */
    protected function getCache_Doctrine_Orm_Default_ResultService()
    {
        return $this->privates['cache.doctrine.orm.default.result'] = new \Symfony\Component\Cache\Adapter\TraceableAdapter(new \Symfony\Component\Cache\Adapter\ArrayAdapter());
    }

    /**
     * Gets the private 'cache.property_info' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\TraceableAdapter
     */
    protected function getCache_PropertyInfoService()
    {
        return $this->privates['cache.property_info'] = new \Symfony\Component\Cache\Adapter\TraceableAdapter(\Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('kyuiRwBgqr', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService())));
    }

    /**
     * Gets the private 'cache.security_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\TraceableAdapter
     */
    protected function getCache_SecurityExpressionLanguageService()
    {
        return $this->privates['cache.security_expression_language'] = new \Symfony\Component\Cache\Adapter\TraceableAdapter(\Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('ZMiAMmphb0', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService())));
    }

    /**
     * Gets the private 'cache.serializer' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\TraceableAdapter
     */
    protected function getCache_SerializerService()
    {
        return $this->privates['cache.serializer'] = new \Symfony\Component\Cache\Adapter\TraceableAdapter(\Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('D4F8KF1fOx', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService())));
    }

    /**
     * Gets the private 'cache.validator' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\TraceableAdapter
     */
    protected function getCache_ValidatorService()
    {
        return $this->privates['cache.validator'] = new \Symfony\Component\Cache\Adapter\TraceableAdapter(\Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('XndLNIHxc1', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService())));
    }

    /**
     * Gets the private 'config_cache_factory' shared service.
     *
     * @return \Symfony\Component\Config\ResourceCheckerConfigCacheFactory
     */
    protected function getConfigCacheFactoryService()
    {
        return $this->privates['config_cache_factory'] = new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory(new RewindableGenerator(function () {
            yield 0 => ($this->privates['dependency_injection.config.container_parameters_resource_checker'] ?? ($this->privates['dependency_injection.config.container_parameters_resource_checker'] = new \Symfony\Component\DependencyInjection\Config\ContainerParametersResourceChecker($this)));
            yield 1 => ($this->privates['config.resource.self_checking_resource_checker'] ?? ($this->privates['config.resource.self_checking_resource_checker'] = new \Symfony\Component\Config\Resource\SelfCheckingResourceChecker()));
        }, 2));
    }

    /**
     * Gets the private 'data_collector.form' shared service.
     *
     * @return \Symfony\Component\Form\Extension\DataCollector\FormDataCollector
     */
    protected function getDataCollector_FormService()
    {
        return $this->privates['data_collector.form'] = new \Symfony\Component\Form\Extension\DataCollector\FormDataCollector(new \Symfony\Component\Form\Extension\DataCollector\FormDataExtractor());
    }

    /**
     * Gets the private 'data_collector.request' shared service.
     *
     * @return \Symfony\Component\HttpKernel\DataCollector\RequestDataCollector
     */
    protected function getDataCollector_RequestService()
    {
        return $this->privates['data_collector.request'] = new \Symfony\Component\HttpKernel\DataCollector\RequestDataCollector(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /**
     * Gets the private 'debug.debug_handlers_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener
     */
    protected function getDebug_DebugHandlersListenerService()
    {
        $a = new \Symfony\Bridge\Monolog\Logger('php');
        $a->pushProcessor(($this->privates['debug.log_processor'] ?? $this->getDebug_LogProcessorService()));
        $a->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $a->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        \Symfony\Bundle\FrameworkBundle\DependencyInjection\Compiler\AddDebugLogProcessorPass::configureLogger($a);

        return $this->privates['debug.debug_handlers_listener'] = new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $a, NULL, -1, true, true, ($this->services['monolog.logger.deprecation'] ?? $this->getMonolog_Logger_DeprecationService()));
    }

    /**
     * Gets the private 'debug.file_link_formatter' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Debug\FileLinkFormatter
     */
    protected function getDebug_FileLinkFormatterService()
    {
        return $this->privates['debug.file_link_formatter'] = new \Symfony\Component\HttpKernel\Debug\FileLinkFormatter(NULL, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), \dirname(__DIR__, 4), function () {
            return ($this->privates['debug.file_link_formatter.url_format'] ?? $this->load('getDebug_FileLinkFormatter_UrlFormatService'));
        });
    }

    /**
     * Gets the private 'debug.log_processor' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Processor\DebugProcessor
     */
    protected function getDebug_LogProcessorService()
    {
        return $this->privates['debug.log_processor'] = new \Symfony\Bridge\Monolog\Processor\DebugProcessor(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /**
     * Gets the private 'debug.security.access.decision_manager' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\TraceableAccessDecisionManager
     */
    protected function getDebug_Security_Access_DecisionManagerService()
    {
        return $this->privates['debug.security.access.decision_manager'] = new \Symfony\Component\Security\Core\Authorization\TraceableAccessDecisionManager(new \Symfony\Component\Security\Core\Authorization\AccessDecisionManager(new RewindableGenerator(function () {
            yield 0 => ($this->privates['debug.security.voter.security.access.authenticated_voter'] ?? $this->load('getDebug_Security_Voter_Security_Access_AuthenticatedVoterService'));
            yield 1 => ($this->privates['debug.security.voter.security.access.role_hierarchy_voter'] ?? $this->load('getDebug_Security_Voter_Security_Access_RoleHierarchyVoterService'));
            yield 2 => ($this->privates['debug.security.voter.security.access.expression_voter'] ?? $this->load('getDebug_Security_Voter_Security_Access_ExpressionVoterService'));
            yield 3 => ($this->privates['debug.security.voter.Webkul\\UVDesk\\CoreFrameworkBundle\\Security\\TicketVoter'] ?? $this->load('getTicketVoterService'));
        }, 4), new \Symfony\Component\Security\Core\Authorization\Strategy\AffirmativeStrategy(false)));
    }

    /**
     * Gets the private 'debug.security.firewall' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Debug\TraceableFirewallListener
     */
    protected function getDebug_Security_FirewallService()
    {
        $a = ($this->privates['security.firewall.map'] ?? $this->getSecurity_Firewall_MapService());

        if (isset($this->privates['debug.security.firewall'])) {
            return $this->privates['debug.security.firewall'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->privates['debug.security.firewall'])) {
            return $this->privates['debug.security.firewall'];
        }

        return $this->privates['debug.security.firewall'] = new \Symfony\Bundle\SecurityBundle\Debug\TraceableFirewallListener($a, $b, ($this->privates['security.logout_url_generator'] ?? $this->getSecurity_LogoutUrlGeneratorService()));
    }

    /**
     * Gets the private 'doctrine.dbal.default_connection.event_manager' shared service.
     *
     * @return \Symfony\Bridge\Doctrine\ContainerAwareEventManager
     */
    protected function getDoctrine_Dbal_DefaultConnection_EventManagerService()
    {
        return $this->privates['doctrine.dbal.default_connection.event_manager'] = new \Symfony\Bridge\Doctrine\ContainerAwareEventManager(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\Doctrine\\Lifecycle' => ['privates', 'Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\Doctrine\\Lifecycle', 'getLifecycleService', true],
            'doctrine.orm.default_listeners.attach_entity_listeners' => ['privates', 'doctrine.orm.default_listeners.attach_entity_listeners', 'getDoctrine_Orm_DefaultListeners_AttachEntityListenersService', true],
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_subscriber' => ['privates', 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_subscriber', 'getDoctrine_Orm_Listeners_DoctrineDbalCacheAdapterSchemaSubscriberService', true],
            'doctrine.orm.listeners.doctrine_token_provider_schema_subscriber' => ['privates', 'doctrine.orm.listeners.doctrine_token_provider_schema_subscriber', 'getDoctrine_Orm_Listeners_DoctrineTokenProviderSchemaSubscriberService', true],
            'doctrine.orm.listeners.pdo_cache_adapter_doctrine_schema_subscriber' => ['privates', 'doctrine.orm.listeners.pdo_cache_adapter_doctrine_schema_subscriber', 'getDoctrine_Orm_Listeners_PdoCacheAdapterDoctrineSchemaSubscriberService', true],
        ], [
            'Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\Doctrine\\Lifecycle' => '?',
            'doctrine.orm.default_listeners.attach_entity_listeners' => '?',
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_subscriber' => '?',
            'doctrine.orm.listeners.doctrine_token_provider_schema_subscriber' => '?',
            'doctrine.orm.listeners.pdo_cache_adapter_doctrine_schema_subscriber' => '?',
        ]), [0 => 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_subscriber', 1 => 'doctrine.orm.listeners.pdo_cache_adapter_doctrine_schema_subscriber', 2 => 'doctrine.orm.listeners.doctrine_token_provider_schema_subscriber', 3 => [0 => [0 => 'prePersist'], 1 => 'Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\Doctrine\\Lifecycle'], 4 => [0 => [0 => 'preUpdate'], 1 => 'Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\Doctrine\\Lifecycle'], 5 => [0 => [0 => 'postLoad'], 1 => 'Webkul\\UVDesk\\CoreFrameworkBundle\\EventListener\\Doctrine\\Lifecycle'], 6 => [0 => [0 => 'loadClassMetadata'], 1 => 'doctrine.orm.default_listeners.attach_entity_listeners']]);
    }

    /**
     * Gets the private 'doctrine.orm.default_annotation_metadata_driver' shared service.
     *
     * @return \Doctrine\ORM\Mapping\Driver\AnnotationDriver
     */
    protected function getDoctrine_Orm_DefaultAnnotationMetadataDriverService()
    {
        return $this->privates['doctrine.orm.default_annotation_metadata_driver'] = new \Doctrine\ORM\Mapping\Driver\AnnotationDriver(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()), [0 => (\dirname(__DIR__, 4).'/src/Entity'), 1 => (\dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Entity'), 2 => (\dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/Entity'), 3 => (\dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/Entity'), 4 => (\dirname(__DIR__, 4).'/vendor/uvdesk/api-bundle/Entity')], false);
    }

    /**
     * Gets the private 'exception_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ErrorListener
     */
    protected function getExceptionListenerService()
    {
        return $this->privates['exception_listener'] = new \Symfony\Component\HttpKernel\EventListener\ErrorListener('error_controller', ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService()), true, []);
    }

    /**
     * Gets the private 'framework_extra_bundle.argument_name_convertor' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\Request\ArgumentNameConverter
     */
    protected function getFrameworkExtraBundle_ArgumentNameConvertorService()
    {
        return $this->privates['framework_extra_bundle.argument_name_convertor'] = new \Sensio\Bundle\FrameworkExtraBundle\Request\ArgumentNameConverter(($this->privates['argument_metadata_factory'] ?? ($this->privates['argument_metadata_factory'] = new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory())));
    }

    /**
     * Gets the private 'framework_extra_bundle.event.is_granted' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\EventListener\IsGrantedListener
     */
    protected function getFrameworkExtraBundle_Event_IsGrantedService()
    {
        $a = ($this->services['.container.private.security.authorization_checker'] ?? $this->get_Container_Private_Security_AuthorizationCheckerService());

        if (isset($this->privates['framework_extra_bundle.event.is_granted'])) {
            return $this->privates['framework_extra_bundle.event.is_granted'];
        }

        return $this->privates['framework_extra_bundle.event.is_granted'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\IsGrantedListener(($this->privates['framework_extra_bundle.argument_name_convertor'] ?? $this->getFrameworkExtraBundle_ArgumentNameConvertorService()), $a);
    }

    /**
     * Gets the private 'knp_paginator.subscriber.sliding_pagination' shared service.
     *
     * @return \Knp\Bundle\PaginatorBundle\Subscriber\SlidingPaginationSubscriber
     */
    protected function getKnpPaginator_Subscriber_SlidingPaginationService()
    {
        return $this->privates['knp_paginator.subscriber.sliding_pagination'] = new \Knp\Bundle\PaginatorBundle\Subscriber\SlidingPaginationSubscriber(['defaultPaginationTemplate' => '@KnpPaginator/Pagination/sliding.html.twig', 'defaultSortableTemplate' => '@KnpPaginator/Pagination/sortable_link.html.twig', 'defaultFiltrationTemplate' => '@KnpPaginator/Pagination/filtration.html.twig', 'defaultPageRange' => 5, 'defaultPageLimit' => NULL]);
    }

    /**
     * Gets the private 'locale_aware_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener
     */
    protected function getLocaleAwareListenerService()
    {
        return $this->privates['locale_aware_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener(new RewindableGenerator(function () {
            yield 0 => ($this->privates['slugger'] ?? ($this->privates['slugger'] = new \Symfony\Component\String\Slugger\AsciiSlugger('en')));
            yield 1 => ($this->privates['translator.default'] ?? $this->getTranslator_DefaultService());
        }, 2), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /**
     * Gets the private 'locale_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleListener
     */
    protected function getLocaleListenerService()
    {
        return $this->privates['locale_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleListener(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), 'en', ($this->services['router'] ?? $this->getRouterService()), false, []);
    }

    /**
     * Gets the private 'monolog.handler.console' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Handler\ConsoleHandler
     */
    protected function getMonolog_Handler_ConsoleService()
    {
        return $this->privates['monolog.handler.console'] = new \Symfony\Bridge\Monolog\Handler\ConsoleHandler(NULL, true, [], []);
    }

    /**
     * Gets the private 'monolog.handler.main' shared service.
     *
     * @return \Monolog\Handler\StreamHandler
     */
    protected function getMonolog_Handler_MainService()
    {
        $this->privates['monolog.handler.main'] = $instance = new \Monolog\Handler\StreamHandler((\dirname(__DIR__, 3).'/log/dev.log'), 'debug', true, NULL, false);

        $instance->pushProcessor(new \Monolog\Processor\PsrLogMessageProcessor());

        return $instance;
    }

    /**
     * Gets the private 'monolog.logger' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_LoggerService()
    {
        $this->privates['monolog.logger'] = $instance = new \Symfony\Bridge\Monolog\Logger('app');

        $instance->pushProcessor(($this->privates['debug.log_processor'] ?? $this->getDebug_LogProcessorService()));
        $instance->useMicrosecondTimestamps(true);
        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        \Symfony\Bundle\FrameworkBundle\DependencyInjection\Compiler\AddDebugLogProcessorPass::configureLogger($instance);

        return $instance;
    }

    /**
     * Gets the private 'monolog.logger.cache' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_CacheService()
    {
        $this->privates['monolog.logger.cache'] = $instance = new \Symfony\Bridge\Monolog\Logger('cache');

        $instance->pushProcessor(($this->privates['debug.log_processor'] ?? $this->getDebug_LogProcessorService()));
        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        \Symfony\Bundle\FrameworkBundle\DependencyInjection\Compiler\AddDebugLogProcessorPass::configureLogger($instance);

        return $instance;
    }

    /**
     * Gets the private 'monolog.logger.request' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_RequestService()
    {
        $this->privates['monolog.logger.request'] = $instance = new \Symfony\Bridge\Monolog\Logger('request');

        $instance->pushProcessor(($this->privates['debug.log_processor'] ?? $this->getDebug_LogProcessorService()));
        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        \Symfony\Bundle\FrameworkBundle\DependencyInjection\Compiler\AddDebugLogProcessorPass::configureLogger($instance);

        return $instance;
    }

    /**
     * Gets the private 'parameter_bag' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag
     */
    protected function getParameterBagService()
    {
        return $this->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($this);
    }

    /**
     * Gets the private 'profiler_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ProfilerListener
     */
    protected function getProfilerListenerService()
    {
        $a = ($this->services['.container.private.profiler'] ?? $this->get_Container_Private_ProfilerService());

        if (isset($this->privates['profiler_listener'])) {
            return $this->privates['profiler_listener'];
        }

        return $this->privates['profiler_listener'] = new \Symfony\Component\HttpKernel\EventListener\ProfilerListener($a, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), NULL, false, false, NULL);
    }

    /**
     * Gets the private 'property_info' shared service.
     *
     * @return \Symfony\Component\PropertyInfo\PropertyInfoExtractor
     */
    protected function getPropertyInfoService()
    {
        return $this->privates['property_info'] = new \Symfony\Component\PropertyInfo\PropertyInfoExtractor(new RewindableGenerator(function () {
            yield 0 => ($this->privates['property_info.serializer_extractor'] ?? $this->load('getPropertyInfo_SerializerExtractorService'));
            yield 1 => ($this->privates['property_info.reflection_extractor'] ?? ($this->privates['property_info.reflection_extractor'] = new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor()));
            yield 2 => ($this->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $this->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
        }, 3), new RewindableGenerator(function () {
            yield 0 => ($this->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $this->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
            yield 1 => ($this->privates['property_info.phpstan_extractor'] ?? ($this->privates['property_info.phpstan_extractor'] = new \Symfony\Component\PropertyInfo\Extractor\PhpStanExtractor()));
            yield 2 => ($this->privates['property_info.php_doc_extractor'] ?? ($this->privates['property_info.php_doc_extractor'] = new \Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor()));
            yield 3 => ($this->privates['property_info.reflection_extractor'] ?? ($this->privates['property_info.reflection_extractor'] = new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor()));
        }, 4), new RewindableGenerator(function () {
            yield 0 => ($this->privates['property_info.php_doc_extractor'] ?? ($this->privates['property_info.php_doc_extractor'] = new \Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor()));
        }, 1), new RewindableGenerator(function () {
            yield 0 => ($this->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $this->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
            yield 1 => ($this->privates['property_info.reflection_extractor'] ?? ($this->privates['property_info.reflection_extractor'] = new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor()));
        }, 2), new RewindableGenerator(function () {
            yield 0 => ($this->privates['property_info.reflection_extractor'] ?? ($this->privates['property_info.reflection_extractor'] = new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor()));
        }, 1));
    }

    /**
     * Gets the private 'router.expression_language_provider' shared service.
     *
     * @return \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider
     */
    protected function getRouter_ExpressionLanguageProviderService()
    {
        return $this->privates['router.expression_language_provider'] = new \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'env' => ['privates', 'container.getenv', 'getContainer_GetenvService', true],
        ], [
            'env' => 'Closure',
        ]));
    }

    /**
     * Gets the private 'router.request_context' shared service.
     *
     * @return \Symfony\Component\Routing\RequestContext
     */
    protected function getRouter_RequestContextService()
    {
        $this->privates['router.request_context'] = $instance = \Symfony\Component\Routing\RequestContext::fromUri('', 'localhost', 'http', 80, 443);

        $instance->setParameter('_functions', ($this->privates['router.expression_language_provider'] ?? $this->getRouter_ExpressionLanguageProviderService()));

        return $instance;
    }

    /**
     * Gets the private 'router_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\RouterListener
     */
    protected function getRouterListenerService()
    {
        return $this->privates['router_listener'] = new \Symfony\Component\HttpKernel\EventListener\RouterListener(($this->services['router'] ?? $this->getRouterService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService()), ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService()), \dirname(__DIR__, 4), true);
    }

    /**
     * Gets the private 'security.csrf.token_storage' shared service.
     *
     * @return \Symfony\Component\Security\Csrf\TokenStorage\SessionTokenStorage
     */
    protected function getSecurity_Csrf_TokenStorageService()
    {
        return $this->privates['security.csrf.token_storage'] = new \Symfony\Component\Security\Csrf\TokenStorage\SessionTokenStorage(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /**
     * Gets the private 'security.firewall.map' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Security\FirewallMap
     */
    protected function getSecurity_Firewall_MapService()
    {
        $a = ($this->privates['.service_locator.Y0rYR9K'] ?? $this->get_ServiceLocator_Y0rYR9KService());

        if (isset($this->privates['security.firewall.map'])) {
            return $this->privates['security.firewall.map'];
        }

        return $this->privates['security.firewall.map'] = new \Symfony\Bundle\SecurityBundle\Security\FirewallMap($a, new RewindableGenerator(function () {
            yield 'security.firewall.map.context.dev' => ($this->privates['.security.request_matcher.Iy.T22O'] ?? ($this->privates['.security.request_matcher.Iy.T22O'] = new \Symfony\Component\HttpFoundation\RequestMatcher('^/(_(profiler|wdt)|css|images|js)/')));
            yield 'security.firewall.map.context.back_support' => ($this->privates['.security.request_matcher.BTcX6BX'] ?? ($this->privates['.security.request_matcher.BTcX6BX'] = new \Symfony\Component\HttpFoundation\RequestMatcher('/staff')));
            yield 'security.firewall.map.context.uvdesk_api' => ($this->privates['.security.request_matcher.p4VlLPC'] ?? ($this->privates['.security.request_matcher.p4VlLPC'] = new \Symfony\Component\HttpFoundation\RequestMatcher('^/api')));
            yield 'security.firewall.map.context.customer' => ($this->privates['.security.request_matcher.01Y6ZVJ'] ?? ($this->privates['.security.request_matcher.01Y6ZVJ'] = new \Symfony\Component\HttpFoundation\RequestMatcher('/')));
        }, 4));
    }

    /**
     * Gets the private 'security.logout_url_generator' shared service.
     *
     * @return \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator
     */
    protected function getSecurity_LogoutUrlGeneratorService()
    {
        $this->privates['security.logout_url_generator'] = $instance = new \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['router'] ?? $this->getRouterService()), ($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService()));

        $instance->registerListener('back_support', 'helpdesk_member_handle_logout', 'logout', '_csrf_token', NULL, NULL);
        $instance->registerListener('customer', 'helpdesk_customer_logout', 'logout', '_csrf_token', NULL, NULL);

        return $instance;
    }

    /**
     * Gets the private 'security.role_hierarchy' shared service.
     *
     * @return \Symfony\Component\Security\Core\Role\RoleHierarchy
     */
    protected function getSecurity_RoleHierarchyService()
    {
        return $this->privates['security.role_hierarchy'] = new \Symfony\Component\Security\Core\Role\RoleHierarchy($this->parameters['security.role_hierarchy.roles']);
    }

    /**
     * Gets the private 'sensio_framework_extra.controller.listener' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\EventListener\ControllerListener
     */
    protected function getSensioFrameworkExtra_Controller_ListenerService()
    {
        return $this->privates['sensio_framework_extra.controller.listener'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\ControllerListener(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()));
    }

    /**
     * Gets the private 'sensio_framework_extra.converter.listener' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\EventListener\ParamConverterListener
     */
    protected function getSensioFrameworkExtra_Converter_ListenerService()
    {
        $a = new \Sensio\Bundle\FrameworkExtraBundle\Request\ParamConverter\ParamConverterManager();
        $a->add(new \Sensio\Bundle\FrameworkExtraBundle\Request\ParamConverter\DoctrineParamConverter(($this->services['doctrine'] ?? $this->getDoctrineService()), new \Symfony\Component\ExpressionLanguage\ExpressionLanguage()), 0, 'doctrine.orm');
        $a->add(new \Sensio\Bundle\FrameworkExtraBundle\Request\ParamConverter\DateTimeParamConverter(), 0, 'datetime');

        return $this->privates['sensio_framework_extra.converter.listener'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\ParamConverterListener($a, true);
    }

    /**
     * Gets the private 'sensio_framework_extra.security.listener' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\EventListener\SecurityListener
     */
    protected function getSensioFrameworkExtra_Security_ListenerService()
    {
        $a = ($this->services['.container.private.security.authorization_checker'] ?? $this->get_Container_Private_Security_AuthorizationCheckerService());

        if (isset($this->privates['sensio_framework_extra.security.listener'])) {
            return $this->privates['sensio_framework_extra.security.listener'];
        }

        return $this->privates['sensio_framework_extra.security.listener'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\SecurityListener(($this->privates['framework_extra_bundle.argument_name_convertor'] ?? $this->getFrameworkExtraBundle_ArgumentNameConvertorService()), new \Sensio\Bundle\FrameworkExtraBundle\Security\ExpressionLanguage(), ($this->privates['security.authentication.trust_resolver'] ?? ($this->privates['security.authentication.trust_resolver'] = new \Symfony\Component\Security\Core\Authentication\AuthenticationTrustResolver())), ($this->privates['security.role_hierarchy'] ?? $this->getSecurity_RoleHierarchyService()), ($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService()), $a, ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()));
    }

    /**
     * Gets the private 'sensio_framework_extra.view.listener' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\EventListener\TemplateListener
     */
    protected function getSensioFrameworkExtra_View_ListenerService()
    {
        $this->privates['sensio_framework_extra.view.listener'] = $instance = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\TemplateListener(new \Sensio\Bundle\FrameworkExtraBundle\Templating\TemplateGuesser(($this->services['kernel'] ?? $this->get('kernel', 1))));

        $instance->setContainer((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'twig' => ['services', '.container.private.twig', 'get_Container_Private_TwigService', false],
        ], [
            'twig' => '?',
        ]))->withContext('sensio_framework_extra.view.listener', $this));

        return $instance;
    }

    /**
     * Gets the private 'session.factory' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\Session\SessionFactory
     */
    protected function getSession_FactoryService()
    {
        $a = ($this->privates['session_listener'] ?? $this->getSessionListenerService());

        if (isset($this->privates['session.factory'])) {
            return $this->privates['session.factory'];
        }

        return $this->privates['session.factory'] = new \Symfony\Component\HttpFoundation\Session\SessionFactory(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), new \Symfony\Component\HttpFoundation\Session\Storage\NativeSessionStorageFactory($this->getParameter('session.storage.options'), new \Symfony\Component\HttpFoundation\Session\Storage\Handler\StrictSessionHandler(new \SessionHandler()), new \Symfony\Component\HttpFoundation\Session\Storage\MetadataBag('_sf2_meta', 0), true), [0 => $a, 1 => 'onSessionUsage']);
    }

    /**
     * Gets the private 'session_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\SessionListener
     */
    protected function getSessionListenerService()
    {
        return $this->privates['session_listener'] = new \Symfony\Component\HttpKernel\EventListener\SessionListener(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'initialized_session' => ['services', '.container.private.session', NULL, false],
            'logger' => ['privates', 'monolog.logger', 'getMonolog_LoggerService', false],
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
            'session' => ['services', '.container.private.session', 'get_Container_Private_SessionService', false],
            'session_collector' => ['privates', 'data_collector.request.session_collector', 'getDataCollector_Request_SessionCollectorService', true],
            'session_factory' => ['privates', 'session.factory', 'getSession_FactoryService', false],
        ], [
            'initialized_session' => '?',
            'logger' => '?',
            'request_stack' => '?',
            'session' => '?',
            'session_collector' => '?',
            'session_factory' => '?',
        ]), true, $this->getParameter('session.storage.options'));
    }

    /**
     * Gets the private 'translator.default' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Translation\Translator
     */
    protected function getTranslator_DefaultService()
    {
        $this->privates['translator.default'] = $instance = new \Symfony\Bundle\FrameworkBundle\Translation\Translator(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'translation.loader.csv' => ['privates', 'translation.loader.csv', 'getTranslation_Loader_CsvService', true],
            'translation.loader.dat' => ['privates', 'translation.loader.dat', 'getTranslation_Loader_DatService', true],
            'translation.loader.ini' => ['privates', 'translation.loader.ini', 'getTranslation_Loader_IniService', true],
            'translation.loader.json' => ['privates', 'translation.loader.json', 'getTranslation_Loader_JsonService', true],
            'translation.loader.mo' => ['privates', 'translation.loader.mo', 'getTranslation_Loader_MoService', true],
            'translation.loader.php' => ['privates', 'translation.loader.php', 'getTranslation_Loader_PhpService', true],
            'translation.loader.po' => ['privates', 'translation.loader.po', 'getTranslation_Loader_PoService', true],
            'translation.loader.qt' => ['privates', 'translation.loader.qt', 'getTranslation_Loader_QtService', true],
            'translation.loader.res' => ['privates', 'translation.loader.res', 'getTranslation_Loader_ResService', true],
            'translation.loader.xliff' => ['privates', 'translation.loader.xliff', 'getTranslation_Loader_XliffService', true],
            'translation.loader.yml' => ['privates', 'translation.loader.yml', 'getTranslation_Loader_YmlService', true],
        ], [
            'translation.loader.csv' => '?',
            'translation.loader.dat' => '?',
            'translation.loader.ini' => '?',
            'translation.loader.json' => '?',
            'translation.loader.mo' => '?',
            'translation.loader.php' => '?',
            'translation.loader.po' => '?',
            'translation.loader.qt' => '?',
            'translation.loader.res' => '?',
            'translation.loader.xliff' => '?',
            'translation.loader.yml' => '?',
        ]), new \Symfony\Component\Translation\Formatter\MessageFormatter(new \Symfony\Component\Translation\IdentityTranslator()), 'en', ['translation.loader.php' => [0 => 'php'], 'translation.loader.yml' => [0 => 'yaml', 1 => 'yml'], 'translation.loader.xliff' => [0 => 'xlf', 1 => 'xliff'], 'translation.loader.po' => [0 => 'po'], 'translation.loader.mo' => [0 => 'mo'], 'translation.loader.qt' => [0 => 'ts'], 'translation.loader.csv' => [0 => 'csv'], 'translation.loader.res' => [0 => 'res'], 'translation.loader.dat' => [0 => 'dat'], 'translation.loader.ini' => [0 => 'ini'], 'translation.loader.json' => [0 => 'json']], ['cache_dir' => ($this->targetDir.''.'/translations'), 'debug' => true, 'resource_files' => ['af' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.af.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.af.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.af.xlf')], 'ar' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ar.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ar.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ar.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.ar.xliff'), 4 => (\dirname(__DIR__, 4).'/translations/messages.ar.yml')], 'az' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.az.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.az.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.az.xlf')], 'be' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.be.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.be.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.be.xlf')], 'bg' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.bg.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.bg.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.bg.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.bg.xliff')], 'bs' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.bs.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.bs.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.bs.xlf')], 'ca' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ca.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ca.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ca.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.ca.xliff')], 'cs' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.cs.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.cs.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.cs.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.cs.xliff')], 'cy' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.cy.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.cy.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.cy.xlf')], 'da' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.da.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.da.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.da.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.da.xliff'), 4 => (\dirname(__DIR__, 4).'/translations/messages.da.yml')], 'de' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.de.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.de.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.de.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.de.xliff'), 4 => (\dirname(__DIR__, 4).'/translations/messages.de.yml')], 'el' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.el.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.el.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.el.xlf')], 'en' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.en.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.en.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.en.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.en.xliff'), 4 => (\dirname(__DIR__, 4).'/translations/messages.en.yml')], 'es' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.es.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.es.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.es.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.es.xliff'), 4 => (\dirname(__DIR__, 4).'/translations/messages.es.yml')], 'et' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.et.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.et.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.et.xlf')], 'eu' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.eu.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.eu.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.eu.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.eu.xliff')], 'fa' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.fa.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.fa.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.fa.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.fa.xliff')], 'fi' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.fi.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.fi.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.fi.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.fi.xliff')], 'fr' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.fr.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.fr.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.fr.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.fr.xliff'), 4 => (\dirname(__DIR__, 4).'/translations/messages.fr.yml')], 'gl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.gl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.gl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.gl.xlf')], 'he' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.he.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.he.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.he.xlf'), 3 => (\dirname(__DIR__, 4).'/translations/messages.he.yml')], 'hr' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.hr.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.hr.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.hr.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.hr.xliff')], 'hu' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.hu.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.hu.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.hu.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.hu.xliff')], 'hy' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.hy.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.hy.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.hy.xlf')], 'id' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.id.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.id.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.id.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.id.xliff')], 'it' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.it.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.it.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.it.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.it.xliff'), 4 => (\dirname(__DIR__, 4).'/translations/messages.it.yml')], 'ja' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ja.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ja.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ja.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.ja.xliff')], 'lb' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.lb.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.lb.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.lb.xlf')], 'lt' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.lt.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.lt.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.lt.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.lt.xliff')], 'lv' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.lv.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.lv.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.lv.xlf')], 'mk' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.mk.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.mk.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.mk.xlf')], 'mn' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.mn.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.mn.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.mn.xlf')], 'my' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.my.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.my.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.my.xlf')], 'nb' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.nb.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.nb.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.nb.xlf')], 'nl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.nl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.nl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.nl.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.nl.xliff')], 'nn' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.nn.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.nn.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.nn.xlf')], 'no' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.no.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.no.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.no.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.no.xliff')], 'pl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.pl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.pl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.pl.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.pl.xliff'), 4 => (\dirname(__DIR__, 4).'/translations/messages.pl.yml')], 'pt' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.pt.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.pt.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.pt.xlf')], 'pt_BR' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.pt_BR.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.pt_BR.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.pt_BR.xliff'), 4 => (\dirname(__DIR__, 4).'/translations/messages.pt_BR.yml')], 'ro' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ro.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ro.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ro.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.ro.xliff')], 'ru' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ru.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ru.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ru.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Resources/translations/messages.ru.yml'), 4 => (\dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/Resources/translations/messages.ru.yml'), 5 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.ru.xliff')], 'sk' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sk.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sk.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sk.xlf')], 'sl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sl.xlf')], 'sq' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sq.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sq.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sq.xlf')], 'sr_Cyrl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sr_Cyrl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sr_Cyrl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf')], 'sr_Latn' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sr_Latn.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sr_Latn.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf')], 'sv' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sv.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sv.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sv.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.sv.xliff')], 'th' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.th.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.th.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.th.xlf')], 'tl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.tl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.tl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.tl.xlf')], 'tr' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.tr.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.tr.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.tr.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.tr.xliff'), 4 => (\dirname(__DIR__, 4).'/translations/messages.tr.yml')], 'uk' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.uk.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.uk.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.uk.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.uk.xliff')], 'ur' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ur.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ur.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ur.xlf')], 'uz' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.uz.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.uz.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.uz.xlf')], 'vi' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.vi.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.vi.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.vi.xlf')], 'zh_CN' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.zh_CN.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.zh_CN.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf')], 'zh_TW' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.zh_TW.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.zh_TW.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf')], 'ky' => [0 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.ky.xliff')], 'sw' => [0 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations/KnpPaginatorBundle.sw.xliff')], 'zh' => [0 => (\dirname(__DIR__, 4).'/translations/messages.zh.yml')]], 'scanned_directories' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations'), 3 => (\dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Resources/translations'), 4 => (\dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/Resources/translations'), 5 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle/translations'), 6 => (\dirname(__DIR__, 4).'/translations'), 7 => (\dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle/translations'), 8 => (\dirname(__DIR__, 4).'/vendor/uvdesk/extension-framework/translations'), 9 => (\dirname(__DIR__, 4).'/vendor/uvdesk/mailbox-component/translations'), 10 => (\dirname(__DIR__, 4).'/vendor/uvdesk/api-bundle/translations'), 11 => (\dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/translations'), 12 => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/translations'), 13 => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-fixtures-bundle/translations'), 14 => (\dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/translations'), 15 => (\dirname(__DIR__, 4).'/vendor/symfony/twig-bundle/translations'), 16 => (\dirname(__DIR__, 4).'/vendor/symfony/web-profiler-bundle/translations'), 17 => (\dirname(__DIR__, 4).'/vendor/symfony/monolog-bundle/translations'), 18 => (\dirname(__DIR__, 4).'/vendor/symfony/debug-bundle/translations'), 19 => (\dirname(__DIR__, 4).'/vendor/symfony/maker-bundle/src/translations'), 20 => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-migrations-bundle/translations'), 21 => (\dirname(__DIR__, 4).'/vendor/symfony/security-bundle/translations'), 22 => (\dirname(__DIR__, 4).'/vendor/symfony/swiftmailer-bundle/translations'), 23 => (\dirname(__DIR__, 4).'/vendor/twig/extra-bundle/translations')], 'cache_vary' => ['scanned_directories' => [0 => 'vendor/symfony/validator/Resources/translations', 1 => 'vendor/symfony/form/Resources/translations', 2 => 'vendor/symfony/security-core/Resources/translations', 3 => 'vendor/uvdesk/core-framework/Resources/translations', 4 => 'vendor/uvdesk/support-center-bundle/Resources/translations', 5 => 'vendor/knplabs/knp-paginator-bundle/translations', 6 => 'translations', 7 => 'vendor/uvdesk/automation-bundle/translations', 8 => 'vendor/uvdesk/extension-framework/translations', 9 => 'vendor/uvdesk/mailbox-component/translations', 10 => 'vendor/uvdesk/api-bundle/translations', 11 => 'vendor/symfony/framework-bundle/translations', 12 => 'vendor/doctrine/doctrine-bundle/translations', 13 => 'vendor/doctrine/doctrine-fixtures-bundle/translations', 14 => 'vendor/sensio/framework-extra-bundle/src/translations', 15 => 'vendor/symfony/twig-bundle/translations', 16 => 'vendor/symfony/web-profiler-bundle/translations', 17 => 'vendor/symfony/monolog-bundle/translations', 18 => 'vendor/symfony/debug-bundle/translations', 19 => 'vendor/symfony/maker-bundle/src/translations', 20 => 'vendor/doctrine/doctrine-migrations-bundle/translations', 21 => 'vendor/symfony/security-bundle/translations', 22 => 'vendor/symfony/swiftmailer-bundle/translations', 23 => 'vendor/twig/extra-bundle/translations']]], []);

        $instance->setConfigCacheFactory(($this->privates['config_cache_factory'] ?? $this->getConfigCacheFactoryService()));
        $instance->setFallbackLocales([0 => 'en']);

        return $instance;
    }

    /**
     * Gets the private 'validator.builder' shared service.
     *
     * @return \Symfony\Component\Validator\ValidatorBuilder
     */
    protected function getValidator_BuilderService()
    {
        $this->privates['validator.builder'] = $instance = \Symfony\Component\Validator\Validation::createValidatorBuilder();

        $a = ($this->privates['property_info'] ?? $this->getPropertyInfoService());

        $instance->setConstraintValidatorFactory(new \Symfony\Component\Validator\ContainerConstraintValidatorFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => ['privates', 'validator.email', 'getValidator_EmailService', true],
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => ['privates', 'validator.not_compromised_password', 'getValidator_NotCompromisedPasswordService', true],
            'doctrine.orm.validator.unique' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'security.validator.user_password' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'validator.expression' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
        ], [
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => '?',
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => '?',
            'doctrine.orm.validator.unique' => '?',
            'security.validator.user_password' => '?',
            'validator.expression' => '?',
        ])));
        if ($this->has('translator')) {
            $instance->setTranslator(($this->services['translator'] ?? $this->getTranslatorService()));
        }
        $instance->setTranslationDomain('validators');
        $instance->addXmlMappings([0 => (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/config/validation.xml')]);
        $instance->addYamlMappings([0 => (\dirname(__DIR__, 4).'/vendor/uvdesk/core-framework/Resources/config/validation.yaml'), 1 => (\dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle/Resources/config/validation.yaml')]);
        $instance->enableAnnotationMapping(true);
        $instance->setDoctrineAnnotationReader(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()));
        $instance->addMethodMapping('loadValidatorMetadata');
        $instance->addObjectInitializers([0 => new \Symfony\Bridge\Doctrine\Validator\DoctrineInitializer(($this->services['doctrine'] ?? $this->getDoctrineService()))]);
        $instance->addLoader(new \Symfony\Component\Validator\Mapping\Loader\PropertyInfoLoader($a, $a, $a, NULL));
        $instance->addLoader(new \Symfony\Bridge\Doctrine\Validator\DoctrineLoader(($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), NULL));

        return $instance;
    }

    /**
     * Gets the private 'var_dumper.html_dumper' shared service.
     *
     * @return \Symfony\Component\VarDumper\Dumper\HtmlDumper
     */
    protected function getVarDumper_HtmlDumperService()
    {
        $this->privates['var_dumper.html_dumper'] = $instance = new \Symfony\Component\VarDumper\Dumper\HtmlDumper(NULL, 'UTF-8', 0);

        $instance->setDisplayOptions(['fileLinkFormat' => ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService())]);

        return $instance;
    }

    /**
     * Gets the private 'var_dumper.server_connection' shared service.
     *
     * @return \Symfony\Component\VarDumper\Server\Connection
     */
    protected function getVarDumper_ServerConnectionService()
    {
        return $this->privates['var_dumper.server_connection'] = new \Symfony\Component\VarDumper\Server\Connection('tcp://'.$this->getEnv('string:VAR_DUMPER_SERVER'), ['source' => new \Symfony\Component\VarDumper\Dumper\ContextProvider\SourceContextProvider('UTF-8', \dirname(__DIR__, 4), ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService())), 'request' => new \Symfony\Component\VarDumper\Dumper\ContextProvider\RequestContextProvider(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()))), 'cli' => new \Symfony\Component\VarDumper\Dumper\ContextProvider\CliContextProvider()]);
    }

    /**
     * Gets the private 'web_profiler.csp.handler' shared service.
     *
     * @return \Symfony\Bundle\WebProfilerBundle\Csp\ContentSecurityPolicyHandler
     */
    protected function getWebProfiler_Csp_HandlerService()
    {
        return $this->privates['web_profiler.csp.handler'] = new \Symfony\Bundle\WebProfilerBundle\Csp\ContentSecurityPolicyHandler(new \Symfony\Bundle\WebProfilerBundle\Csp\NonceGenerator());
    }

    /**
     * Gets the private 'web_profiler.debug_toolbar' shared service.
     *
     * @return \Symfony\Bundle\WebProfilerBundle\EventListener\WebDebugToolbarListener
     */
    protected function getWebProfiler_DebugToolbarService()
    {
        $a = ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService());

        if (isset($this->privates['web_profiler.debug_toolbar'])) {
            return $this->privates['web_profiler.debug_toolbar'];
        }

        return $this->privates['web_profiler.debug_toolbar'] = new \Symfony\Bundle\WebProfilerBundle\EventListener\WebDebugToolbarListener($a, false, 2, ($this->services['router'] ?? $this->getRouterService()), '^/((index|app(_[\\w]+)?)\\.php/)?_wdt', ($this->privates['web_profiler.csp.handler'] ?? $this->getWebProfiler_Csp_HandlerService()), ($this->services['data_collector.dump'] ?? $this->getDataCollector_DumpService()));
    }

    /**
     * Gets the public 'cache_clearer' alias.
     *
     * @return object The ".container.private.cache_clearer" service.
     */
    protected function getCacheClearerService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "cache_clearer" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.cache_clearer');
    }

    /**
     * Gets the public 'filesystem' alias.
     *
     * @return object The ".container.private.filesystem" service.
     */
    protected function getFilesystemService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "filesystem" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.filesystem');
    }

    /**
     * Gets the public 'serializer' alias.
     *
     * @return object The ".container.private.serializer" service.
     */
    protected function getSerializerService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "serializer" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.serializer');
    }

    /**
     * Gets the public 'security.csrf.token_manager' alias.
     *
     * @return object The ".container.private.security.csrf.token_manager" service.
     */
    protected function getSecurity_Csrf_TokenManagerService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "security.csrf.token_manager" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.security.csrf.token_manager');
    }

    /**
     * Gets the public 'form.factory' alias.
     *
     * @return object The ".container.private.form.factory" service.
     */
    protected function getForm_FactoryService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "form.factory" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.form.factory');
    }

    /**
     * Gets the public 'form.type.file' alias.
     *
     * @return object The ".container.private.form.type.file" service.
     */
    protected function getForm_Type_FileService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "form.type.file" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.form.type.file');
    }

    /**
     * Gets the public 'profiler' alias.
     *
     * @return object The ".container.private.profiler" service.
     */
    protected function getProfilerService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.4', 'Accessing the "profiler" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.profiler');
    }

    /**
     * Gets the public 'twig' alias.
     *
     * @return object The ".container.private.twig" service.
     */
    protected function getTwigService()
    {
        trigger_deprecation('symfony/twig-bundle', '5.2', 'Accessing the "twig" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.twig');
    }

    /**
     * Gets the public 'security.authorization_checker' alias.
     *
     * @return object The ".container.private.security.authorization_checker" service.
     */
    protected function getSecurity_AuthorizationCheckerService()
    {
        trigger_deprecation('symfony/security-bundle', '5.3', 'Accessing the "security.authorization_checker" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.security.authorization_checker');
    }

    /**
     * Gets the public 'security.token_storage' alias.
     *
     * @return object The ".container.private.security.token_storage" service.
     */
    protected function getSecurity_TokenStorageService()
    {
        trigger_deprecation('symfony/security-bundle', '5.3', 'Accessing the "security.token_storage" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.security.token_storage');
    }

    /**
     * Gets the public 'security.password_encoder' alias.
     *
     * @return object The ".container.private.security.password_encoder" service.
     */
    protected function getSecurity_PasswordEncoderService()
    {
        trigger_deprecation('symfony/security-bundle', '5.3', 'Accessing the "security.password_encoder" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.security.password_encoder');
    }

    /**
     * Gets the public 'session' alias.
     *
     * @return object The ".container.private.session" service.
     */
    protected function getSessionService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.3', 'Accessing the "session" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.session');
    }

    /**
     * Gets the public 'validator' alias.
     *
     * @return object The ".container.private.validator" service.
     */
    protected function getValidatorService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "validator" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.validator');
    }

    /**
     * @return array|bool|float|int|string|\UnitEnum|null
     */
    public function getParameter(string $name)
    {
        if (isset($this->buildParameters[$name])) {
            return $this->buildParameters[$name];
        }

        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new InvalidArgumentException(sprintf('The parameter "%s" must be defined.', $name));
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        if (isset($this->buildParameters[$name])) {
            return true;
        }

        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (null === $this->parameterBag) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            foreach ($this->buildParameters as $name => $value) {
                $parameters[$name] = $value;
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'kernel.runtime_environment' => false,
        'kernel.build_dir' => false,
        'kernel.cache_dir' => false,
        'google_recaptcha_site_key' => false,
        'kernel.secret' => false,
        'debug.container.dump' => false,
        'serializer.mapping.cache.file' => false,
        'session.storage.options' => false,
        'validator.mapping.cache.file' => false,
        'profiler.storage.dsn' => false,
        'doctrine.orm.proxy_dir' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        switch ($name) {
            case 'kernel.runtime_environment': $value = $this->getEnv('default:kernel.environment:APP_RUNTIME_ENV'); break;
            case 'kernel.build_dir': $value = $this->targetDir.''; break;
            case 'kernel.cache_dir': $value = $this->targetDir.''; break;
            case 'google_recaptcha_site_key': $value = $this->getEnv('GOOGLE_RECAPTCHA_SITE_KEY'); break;
            case 'kernel.secret': $value = $this->getEnv('APP_SECRET'); break;
            case 'debug.container.dump': $value = ($this->targetDir.''.'/App_KernelDevDebugContainer.xml'); break;
            case 'serializer.mapping.cache.file': $value = ($this->targetDir.''.'/serialization.php'); break;
            case 'session.storage.options': $value = [
                'cache_limiter' => '0',
                'cookie_lifetime' => $this->getEnv('int:UV_SESSION_COOKIE_LIFETIME'),
                'cookie_secure' => 'auto',
                'cookie_httponly' => true,
                'cookie_samesite' => 'lax',
                'gc_maxlifetime' => $this->getEnv('int:UV_SESSION_COOKIE_LIFETIME'),
                'gc_probability' => 1,
            ]; break;
            case 'validator.mapping.cache.file': $value = ($this->targetDir.''.'/validation.php'); break;
            case 'profiler.storage.dsn': $value = ('file:'.$this->targetDir.''.'/profiler'); break;
            case 'doctrine.orm.proxy_dir': $value = ($this->targetDir.''.'/doctrine/orm/Proxies'); break;
            default: throw new InvalidArgumentException(sprintf('The dynamic parameter "%s" must be defined.', $name));
        }
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.project_dir' => \dirname(__DIR__, 4),
            'kernel.environment' => 'dev',
            'kernel.debug' => true,
            'kernel.logs_dir' => (\dirname(__DIR__, 3).'/log'),
            'kernel.bundles' => [
                'UVDeskCoreFrameworkBundle' => 'Webkul\\UVDesk\\CoreFrameworkBundle\\UVDeskCoreFrameworkBundle',
                'UVDeskAutomationBundle' => 'Webkul\\UVDesk\\AutomationBundle\\UVDeskAutomationBundle',
                'UVDeskExtensionFrameworkBundle' => 'Webkul\\UVDesk\\ExtensionFrameworkBundle\\UVDeskExtensionFrameworkBundle',
                'UVDeskMailboxBundle' => 'Webkul\\UVDesk\\MailboxBundle\\UVDeskMailboxBundle',
                'UVDeskSupportCenterBundle' => 'Webkul\\UVDesk\\SupportCenterBundle\\UVDeskSupportCenterBundle',
                'UVDeskApiBundle' => 'Webkul\\UVDesk\\ApiBundle\\UVDeskApiBundle',
                'FrameworkBundle' => 'Symfony\\Bundle\\FrameworkBundle\\FrameworkBundle',
                'DoctrineBundle' => 'Doctrine\\Bundle\\DoctrineBundle\\DoctrineBundle',
                'DoctrineFixturesBundle' => 'Doctrine\\Bundle\\FixturesBundle\\DoctrineFixturesBundle',
                'KnpPaginatorBundle' => 'Knp\\Bundle\\PaginatorBundle\\KnpPaginatorBundle',
                'SensioFrameworkExtraBundle' => 'Sensio\\Bundle\\FrameworkExtraBundle\\SensioFrameworkExtraBundle',
                'TwigBundle' => 'Symfony\\Bundle\\TwigBundle\\TwigBundle',
                'WebProfilerBundle' => 'Symfony\\Bundle\\WebProfilerBundle\\WebProfilerBundle',
                'MonologBundle' => 'Symfony\\Bundle\\MonologBundle\\MonologBundle',
                'DebugBundle' => 'Symfony\\Bundle\\DebugBundle\\DebugBundle',
                'MakerBundle' => 'Symfony\\Bundle\\MakerBundle\\MakerBundle',
                'DoctrineMigrationsBundle' => 'Doctrine\\Bundle\\MigrationsBundle\\DoctrineMigrationsBundle',
                'SecurityBundle' => 'Symfony\\Bundle\\SecurityBundle\\SecurityBundle',
                'SwiftmailerBundle' => 'Symfony\\Bundle\\SwiftmailerBundle\\SwiftmailerBundle',
                'TwigExtraBundle' => 'Twig\\Extra\\TwigExtraBundle\\TwigExtraBundle',
            ],
            'kernel.bundles_metadata' => [
                'UVDeskCoreFrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/uvdesk/core-framework'),
                    'namespace' => 'Webkul\\UVDesk\\CoreFrameworkBundle',
                ],
                'UVDeskAutomationBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/uvdesk/automation-bundle'),
                    'namespace' => 'Webkul\\UVDesk\\AutomationBundle',
                ],
                'UVDeskExtensionFrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/uvdesk/extension-framework'),
                    'namespace' => 'Webkul\\UVDesk\\ExtensionFrameworkBundle',
                ],
                'UVDeskMailboxBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/uvdesk/mailbox-component'),
                    'namespace' => 'Webkul\\UVDesk\\MailboxBundle',
                ],
                'UVDeskSupportCenterBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/uvdesk/support-center-bundle'),
                    'namespace' => 'Webkul\\UVDesk\\SupportCenterBundle',
                ],
                'UVDeskApiBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/uvdesk/api-bundle'),
                    'namespace' => 'Webkul\\UVDesk\\ApiBundle',
                ],
                'FrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/framework-bundle'),
                    'namespace' => 'Symfony\\Bundle\\FrameworkBundle',
                ],
                'DoctrineBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\DoctrineBundle',
                ],
                'DoctrineFixturesBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-fixtures-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\FixturesBundle',
                ],
                'KnpPaginatorBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-paginator-bundle'),
                    'namespace' => 'Knp\\Bundle\\PaginatorBundle',
                ],
                'SensioFrameworkExtraBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src'),
                    'namespace' => 'Sensio\\Bundle\\FrameworkExtraBundle',
                ],
                'TwigBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/twig-bundle'),
                    'namespace' => 'Symfony\\Bundle\\TwigBundle',
                ],
                'WebProfilerBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/web-profiler-bundle'),
                    'namespace' => 'Symfony\\Bundle\\WebProfilerBundle',
                ],
                'MonologBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/monolog-bundle'),
                    'namespace' => 'Symfony\\Bundle\\MonologBundle',
                ],
                'DebugBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/debug-bundle'),
                    'namespace' => 'Symfony\\Bundle\\DebugBundle',
                ],
                'MakerBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/maker-bundle/src'),
                    'namespace' => 'Symfony\\Bundle\\MakerBundle',
                ],
                'DoctrineMigrationsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-migrations-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\MigrationsBundle',
                ],
                'SecurityBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/security-bundle'),
                    'namespace' => 'Symfony\\Bundle\\SecurityBundle',
                ],
                'SwiftmailerBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/swiftmailer-bundle'),
                    'namespace' => 'Symfony\\Bundle\\SwiftmailerBundle',
                ],
                'TwigExtraBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/twig/extra-bundle'),
                    'namespace' => 'Twig\\Extra\\TwigExtraBundle',
                ],
            ],
            'kernel.charset' => 'UTF-8',
            'kernel.container_class' => 'App_KernelDevDebugContainer',
            'env(DATABASE_URL)' => '',
            'app_locales' => 'en|fr|it|de|da|ar|es|tr|zh|pl|he|pt_BR',
            'assets_default_agent_profile_image_path' => 'bundles/uvdeskcoreframework/images/uv-avatar-batman.png',
            'assets_default_customer_profile_image_path' => 'bundles/uvdeskcoreframework/images/uv-avatar-ironman.png',
            'assets_default_helpdesk_profile_image_path' => 'bundles/uvdeskcoreframework/images/uv-avatar-uvdesk.png',
            'uvdesk_site_path.member_prefix' => 'staff',
            'uvdesk_site_path.knowledgebase_customer_prefix' => 'client',
            'max_post_size' => 8388608,
            'max_file_uploads' => 20,
            'upload_max_filesize' => 2097152,
            'locale' => 'en',
            'uvdesk.version' => 'v1.1.8',
            'uvdesk.core.version' => 'v1.1.7',
            'uvdesk.site_url' => 'localhost:8888/uvdesk/public',
            'uvdesk.upload_manager.id' => 'Webkul\\UVDesk\\CoreFrameworkBundle\\FileSystem\\UploadManagers\\Localhost',
            'uvdesk.support_email.id' => 'support@whatif.co.th',
            'uvdesk.support_email.name' => 'UVDesk Community',
            'uvdesk.support_email.mailer_type' => 'swiftmailer_id',
            'uvdesk.support_email.mailer_id' => 'mailer_8488',
            'uvdesk.default.ticket.type' => 'support',
            'uvdesk.default.ticket.status' => 'open',
            'uvdesk.default.ticket.priority' => 'low',
            'uvdesk.default.templates.email' => 'mail.html.twig',
            'uvdesk_extensions.dir' => (\dirname(__DIR__, 4).'/apps'),
            'uvdesk.emails.delimiter' => '<-- Please add content above this line -->',
            'uvdesk.emails.enable_delimiter' => false,
            'uvdesk.mailboxes' => [
                0 => 'mailbox_2213',
            ],
            'uvdesk.mailboxes.mailbox_2213' => [
                'name' => 'au.thawatchai@gmail.com',
                'enabled' => true,
                'disable_outbound_emails' => false,
                'use_strict_mode' => false,
                'imap_server' => [
                    'host' => '{imap.gmail.com:993/imap/ssl}INBOX',
                    'username' => 'au.thawatchai@gmail.com',
                    'password' => 'qlqf+qwwf+jiqz+mwdn',
                ],
                'smtp_swift_mailer_server' => [
                    'mailer_id' => 'mailer_8488',
                ],
                'email' => 'au.thawatchai@gmail.com',
            ],
            'event_dispatcher.event_aliases' => [
                'Symfony\\Component\\Console\\Event\\ConsoleCommandEvent' => 'console.command',
                'Symfony\\Component\\Console\\Event\\ConsoleErrorEvent' => 'console.error',
                'Symfony\\Component\\Console\\Event\\ConsoleSignalEvent' => 'console.signal',
                'Symfony\\Component\\Console\\Event\\ConsoleTerminateEvent' => 'console.terminate',
                'Symfony\\Component\\Form\\Event\\PreSubmitEvent' => 'form.pre_submit',
                'Symfony\\Component\\Form\\Event\\SubmitEvent' => 'form.submit',
                'Symfony\\Component\\Form\\Event\\PostSubmitEvent' => 'form.post_submit',
                'Symfony\\Component\\Form\\Event\\PreSetDataEvent' => 'form.pre_set_data',
                'Symfony\\Component\\Form\\Event\\PostSetDataEvent' => 'form.post_set_data',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerArgumentsEvent' => 'kernel.controller_arguments',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerEvent' => 'kernel.controller',
                'Symfony\\Component\\HttpKernel\\Event\\ResponseEvent' => 'kernel.response',
                'Symfony\\Component\\HttpKernel\\Event\\FinishRequestEvent' => 'kernel.finish_request',
                'Symfony\\Component\\HttpKernel\\Event\\RequestEvent' => 'kernel.request',
                'Symfony\\Component\\HttpKernel\\Event\\ViewEvent' => 'kernel.view',
                'Symfony\\Component\\HttpKernel\\Event\\ExceptionEvent' => 'kernel.exception',
                'Symfony\\Component\\HttpKernel\\Event\\TerminateEvent' => 'kernel.terminate',
                'Symfony\\Component\\Security\\Core\\Event\\AuthenticationSuccessEvent' => 'security.authentication.success',
                'Symfony\\Component\\Security\\Core\\Event\\AuthenticationFailureEvent' => 'security.authentication.failure',
                'Symfony\\Component\\Security\\Http\\Event\\InteractiveLoginEvent' => 'security.interactive_login',
                'Symfony\\Component\\Security\\Http\\Event\\SwitchUserEvent' => 'security.switch_user',
            ],
            'fragment.renderer.hinclude.global_template' => NULL,
            'fragment.path' => '/_fragment',
            'kernel.http_method_override' => false,
            'kernel.trusted_hosts' => [

            ],
            'kernel.default_locale' => 'en',
            'kernel.enabled_locales' => [

            ],
            'kernel.error_controller' => 'error_controller',
            'debug.file_link_format' => NULL,
            'asset.request_context.base_path' => NULL,
            'asset.request_context.secure' => NULL,
            'translator.logging' => false,
            'translator.default_path' => (\dirname(__DIR__, 4).'/translations'),
            'debug.error_handler.throw_at' => -1,
            'router.request_context.host' => 'localhost',
            'router.request_context.scheme' => 'http',
            'router.request_context.base_url' => '',
            'router.resource' => 'kernel::loadRoutes',
            'request_listener.http_port' => 80,
            'request_listener.https_port' => 443,
            'session.metadata.storage_key' => '_sf2_meta',
            'session.save_path' => NULL,
            'session.metadata.update_threshold' => 0,
            'form.type_extension.csrf.enabled' => true,
            'form.type_extension.csrf.field_name' => '_token',
            'validator.translation_domain' => 'validators',
            'profiler_listener.only_exceptions' => false,
            'profiler_listener.only_main_requests' => false,
            'doctrine.dbal.configuration.class' => 'Doctrine\\DBAL\\Configuration',
            'doctrine.data_collector.class' => 'Doctrine\\Bundle\\DoctrineBundle\\DataCollector\\DoctrineDataCollector',
            'doctrine.dbal.connection.event_manager.class' => 'Symfony\\Bridge\\Doctrine\\ContainerAwareEventManager',
            'doctrine.dbal.connection_factory.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ConnectionFactory',
            'doctrine.dbal.events.mysql_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\MysqlSessionInit',
            'doctrine.dbal.events.oracle_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\OracleSessionInit',
            'doctrine.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Registry',
            'doctrine.entity_managers' => [
                'default' => 'doctrine.orm.default_entity_manager',
            ],
            'doctrine.default_entity_manager' => 'default',
            'doctrine.dbal.connection_factory.types' => [

            ],
            'doctrine.connections' => [
                'default' => 'doctrine.dbal.default_connection',
            ],
            'doctrine.default_connection' => 'default',
            'doctrine.orm.configuration.class' => 'Doctrine\\ORM\\Configuration',
            'doctrine.orm.entity_manager.class' => 'Doctrine\\ORM\\EntityManager',
            'doctrine.orm.manager_configurator.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ManagerConfigurator',
            'doctrine.orm.cache.array.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'doctrine.orm.cache.apc.class' => 'Doctrine\\Common\\Cache\\ApcCache',
            'doctrine.orm.cache.memcache.class' => 'Doctrine\\Common\\Cache\\MemcacheCache',
            'doctrine.orm.cache.memcache_host' => 'localhost',
            'doctrine.orm.cache.memcache_port' => 11211,
            'doctrine.orm.cache.memcache_instance.class' => 'Memcache',
            'doctrine.orm.cache.memcached.class' => 'Doctrine\\Common\\Cache\\MemcachedCache',
            'doctrine.orm.cache.memcached_host' => 'localhost',
            'doctrine.orm.cache.memcached_port' => 11211,
            'doctrine.orm.cache.memcached_instance.class' => 'Memcached',
            'doctrine.orm.cache.redis.class' => 'Doctrine\\Common\\Cache\\RedisCache',
            'doctrine.orm.cache.redis_host' => 'localhost',
            'doctrine.orm.cache.redis_port' => 6379,
            'doctrine.orm.cache.redis_instance.class' => 'Redis',
            'doctrine.orm.cache.xcache.class' => 'Doctrine\\Common\\Cache\\XcacheCache',
            'doctrine.orm.cache.wincache.class' => 'Doctrine\\Common\\Cache\\WinCacheCache',
            'doctrine.orm.cache.zenddata.class' => 'Doctrine\\Common\\Cache\\ZendDataCache',
            'doctrine.orm.metadata.driver_chain.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\MappingDriverChain',
            'doctrine.orm.metadata.annotation.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AnnotationDriver',
            'doctrine.orm.metadata.xml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedXmlDriver',
            'doctrine.orm.metadata.yml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedYamlDriver',
            'doctrine.orm.metadata.php.class' => 'Doctrine\\ORM\\Mapping\\Driver\\PHPDriver',
            'doctrine.orm.metadata.staticphp.class' => 'Doctrine\\ORM\\Mapping\\Driver\\StaticPHPDriver',
            'doctrine.orm.metadata.attribute.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AttributeDriver',
            'doctrine.orm.proxy_cache_warmer.class' => 'Symfony\\Bridge\\Doctrine\\CacheWarmer\\ProxyCacheWarmer',
            'form.type_guesser.doctrine.class' => 'Symfony\\Bridge\\Doctrine\\Form\\DoctrineOrmTypeGuesser',
            'doctrine.orm.validator.unique.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator',
            'doctrine.orm.validator_initializer.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\DoctrineInitializer',
            'doctrine.orm.security.user.provider.class' => 'Symfony\\Bridge\\Doctrine\\Security\\User\\EntityUserProvider',
            'doctrine.orm.listeners.resolve_target_entity.class' => 'Doctrine\\ORM\\Tools\\ResolveTargetEntityListener',
            'doctrine.orm.listeners.attach_entity_listeners.class' => 'Doctrine\\ORM\\Tools\\AttachEntityListenersListener',
            'doctrine.orm.naming_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultNamingStrategy',
            'doctrine.orm.naming_strategy.underscore.class' => 'Doctrine\\ORM\\Mapping\\UnderscoreNamingStrategy',
            'doctrine.orm.quote_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultQuoteStrategy',
            'doctrine.orm.quote_strategy.ansi.class' => 'Doctrine\\ORM\\Mapping\\AnsiQuoteStrategy',
            'doctrine.orm.typed_field_mapper.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultTypedFieldMapper',
            'doctrine.orm.entity_listener_resolver.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ContainerEntityListenerResolver',
            'doctrine.orm.second_level_cache.default_cache_factory.class' => 'Doctrine\\ORM\\Cache\\DefaultCacheFactory',
            'doctrine.orm.second_level_cache.default_region.class' => 'Doctrine\\ORM\\Cache\\Region\\DefaultRegion',
            'doctrine.orm.second_level_cache.filelock_region.class' => 'Doctrine\\ORM\\Cache\\Region\\FileLockRegion',
            'doctrine.orm.second_level_cache.logger_chain.class' => 'Doctrine\\ORM\\Cache\\Logging\\CacheLoggerChain',
            'doctrine.orm.second_level_cache.logger_statistics.class' => 'Doctrine\\ORM\\Cache\\Logging\\StatisticsCacheLogger',
            'doctrine.orm.second_level_cache.cache_configuration.class' => 'Doctrine\\ORM\\Cache\\CacheConfiguration',
            'doctrine.orm.second_level_cache.regions_configuration.class' => 'Doctrine\\ORM\\Cache\\RegionsConfiguration',
            'doctrine.orm.auto_generate_proxy_classes' => true,
            'doctrine.orm.enable_lazy_ghost_objects' => false,
            'doctrine.orm.proxy_namespace' => 'Proxies',
            'knp_paginator.template.pagination' => '@KnpPaginator/Pagination/sliding.html.twig',
            'knp_paginator.template.filtration' => '@KnpPaginator/Pagination/filtration.html.twig',
            'knp_paginator.template.sortable' => '@KnpPaginator/Pagination/sortable_link.html.twig',
            'knp_paginator.page_range' => 5,
            'knp_paginator.page_limit' => NULL,
            'twig.form.resources' => [
                0 => 'form_div_layout.html.twig',
            ],
            'twig.default_path' => (\dirname(__DIR__, 4).'/templates'),
            'web_profiler.debug_toolbar.intercept_redirects' => false,
            'web_profiler.debug_toolbar.mode' => 2,
            'monolog.use_microseconds' => true,
            'monolog.swift_mailer.handlers' => [

            ],
            'monolog.handlers_to_channels' => [
                'monolog.handler.console' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                        1 => 'doctrine',
                        2 => 'console',
                    ],
                ],
                'monolog.handler.main' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                    ],
                ],
            ],
            'env(VAR_DUMPER_SERVER)' => '127.0.0.1:9912',
            'doctrine.migrations.preferred_em' => NULL,
            'doctrine.migrations.preferred_connection' => NULL,
            'security.role_hierarchy.roles' => [
                'ROLE_AGENT' => [
                    0 => 'ROLE_AGENT',
                ],
                'ROLE_ADMIN' => [
                    0 => 'ROLE_AGENT',
                    1 => 'ROLE_ADMIN',
                ],
                'ROLE_SUPER_ADMIN' => [
                    0 => 'ROLE_ADMIN',
                    1 => 'ROLE_SUPER_ADMIN',
                ],
                'ROLE_CUSTOMER' => [
                    0 => 'ROLE_CUSTOMER',
                ],
            ],
            'security.access.denied_url' => NULL,
            'security.authentication.manager.erase_credentials' => true,
            'security.authentication.session_strategy.strategy' => 'migrate',
            'security.access.always_authenticate_before_granting' => false,
            'security.authentication.hide_user_not_found' => true,
            'security.firewalls' => [
                0 => 'dev',
                1 => 'back_support',
                2 => 'uvdesk_api',
                3 => 'customer',
            ],
            'security.back_support._indexed_authenticators' => [

            ],
            'security.uvdesk_api._indexed_authenticators' => [

            ],
            'security.customer._indexed_authenticators' => [

            ],
            'swiftmailer.mailer.mailer_8488.transport.name' => 'smtp',
            'swiftmailer.mailer.mailer_8488.transport.smtp.encryption' => 'ssl',
            'swiftmailer.mailer.mailer_8488.transport.smtp.port' => 465,
            'swiftmailer.mailer.mailer_8488.transport.smtp.host' => 'smtp.gmail.com',
            'swiftmailer.mailer.mailer_8488.transport.smtp.username' => 'au.thawatchai@gmail.com',
            'swiftmailer.mailer.mailer_8488.transport.smtp.password' => 'cWxxZiBxd3dmIGppcXogbXdkbg==',
            'swiftmailer.mailer.mailer_8488.transport.smtp.auth_mode' => 'login',
            'swiftmailer.mailer.mailer_8488.transport.smtp.timeout' => 30,
            'swiftmailer.mailer.mailer_8488.transport.smtp.source_ip' => NULL,
            'swiftmailer.mailer.mailer_8488.transport.smtp.local_domain' => NULL,
            'swiftmailer.mailer.mailer_8488.transport.smtp.stream_options' => [

            ],
            'swiftmailer.mailer.mailer_8488.spool.enabled' => false,
            'swiftmailer.mailer.mailer_8488.plugin.impersonate' => NULL,
            'swiftmailer.mailer.mailer_8488.single_address' => NULL,
            'swiftmailer.mailer.mailer_8488.delivery.enabled' => true,
            'swiftmailer.spool.enabled' => false,
            'swiftmailer.delivery.enabled' => true,
            'swiftmailer.single_address' => NULL,
            'swiftmailer.mailers' => [
                'mailer_8488' => 'swiftmailer.mailer.mailer_8488',
            ],
            'swiftmailer.default_mailer' => 'mailer_8488',
            'data_collector.templates' => [
                'data_collector.request' => [
                    0 => 'request',
                    1 => '@WebProfiler/Collector/request.html.twig',
                ],
                'data_collector.time' => [
                    0 => 'time',
                    1 => '@WebProfiler/Collector/time.html.twig',
                ],
                'data_collector.memory' => [
                    0 => 'memory',
                    1 => '@WebProfiler/Collector/memory.html.twig',
                ],
                'data_collector.validator' => [
                    0 => 'validator',
                    1 => '@WebProfiler/Collector/validator.html.twig',
                ],
                'data_collector.ajax' => [
                    0 => 'ajax',
                    1 => '@WebProfiler/Collector/ajax.html.twig',
                ],
                'data_collector.form' => [
                    0 => 'form',
                    1 => '@WebProfiler/Collector/form.html.twig',
                ],
                'data_collector.exception' => [
                    0 => 'exception',
                    1 => '@WebProfiler/Collector/exception.html.twig',
                ],
                'data_collector.logger' => [
                    0 => 'logger',
                    1 => '@WebProfiler/Collector/logger.html.twig',
                ],
                'data_collector.events' => [
                    0 => 'events',
                    1 => '@WebProfiler/Collector/events.html.twig',
                ],
                'data_collector.router' => [
                    0 => 'router',
                    1 => '@WebProfiler/Collector/router.html.twig',
                ],
                'data_collector.cache' => [
                    0 => 'cache',
                    1 => '@WebProfiler/Collector/cache.html.twig',
                ],
                'data_collector.translation' => [
                    0 => 'translation',
                    1 => '@WebProfiler/Collector/translation.html.twig',
                ],
                'data_collector.security' => [
                    0 => 'security',
                    1 => '@Security/Collector/security.html.twig',
                ],
                'data_collector.twig' => [
                    0 => 'twig',
                    1 => '@WebProfiler/Collector/twig.html.twig',
                ],
                'data_collector.http_client' => [
                    0 => 'http_client',
                    1 => '@WebProfiler/Collector/http_client.html.twig',
                ],
                'data_collector.doctrine' => [
                    0 => 'db',
                    1 => '@Doctrine/Collector/db.html.twig',
                ],
                'swiftmailer.data_collector' => [
                    0 => 'swiftmailer',
                    1 => '@Swiftmailer/Collector/swiftmailer.html.twig',
                ],
                'data_collector.dump' => [
                    0 => 'dump',
                    1 => '@Debug/Profiler/dump.html.twig',
                ],
                'mailer.data_collector' => [
                    0 => 'mailer',
                    1 => '@WebProfiler/Collector/mailer.html.twig',
                ],
                'notifier.data_collector' => [
                    0 => 'notifier',
                    1 => '@WebProfiler/Collector/notifier.html.twig',
                ],
                'data_collector.config' => [
                    0 => 'config',
                    1 => '@WebProfiler/Collector/config.html.twig',
                ],
            ],
            'console.command.ids' => [
                0 => 'console.command.public_alias.App\\Console\\EnvironmentVariables',
                1 => 'console.command.public_alias.App\\Console\\Wizard\\ConfigureHelpdesk',
                2 => 'console.command.public_alias.App\\Console\\Wizard\\DefaultUser',
                3 => 'console.command.public_alias.App\\Console\\Wizard\\MigrateDatabase',
                4 => 'console.command.public_alias.Webkul\\UVDesk\\CoreFrameworkBundle\\Guides\\BootstrappingProject',
                5 => 'console.command.public_alias.Webkul\\UVDesk\\ExtensionFrameworkBundle\\Console\\BuildExtensions',
                6 => 'console.command.public_alias.Webkul\\UVDesk\\MailboxBundle\\Console\\RefreshMailboxCommand',
            ],
        ];
    }

    protected function throw($message)
    {
        throw new RuntimeException($message);
    }
}
